/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKeyParameterSpec;

public class GeneralPKCS11KeyParameterSpec
implements PKCS11SecretKeyParameterSpec {
    private String id = null;
    private String label = null;
    private Boolean isToken;
    private Boolean isSensitive;
    private Boolean encrypt;
    private Boolean wrapping;
    private Boolean extractable;
    private int keySizeInBytes;
    private KeyMechanismBuilder mechanismBuilder;

    public GeneralPKCS11KeyParameterSpec(String keyIdentifier, String label, Boolean isToken, Boolean isSensitive, Boolean encryption, Boolean wrapping, Boolean extractable, int keySizeInBytes, String algorithm) {
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
        this.id = keyIdentifier;
        this.label = label;
        if (isToken != null) {
            this.isToken = new Boolean(isToken);
        }
        if (isSensitive != null) {
            this.isSensitive = new Boolean(isSensitive);
        }
        this.encrypt = encryption;
        if (encryption != null) {
            this.encrypt = new Boolean(encryption);
        }
        this.wrapping = wrapping;
        if (wrapping != null) {
            this.wrapping = new Boolean(wrapping);
        }
        this.extractable = extractable;
        if (extractable != null) {
            this.extractable = new Boolean(extractable);
        }
        this.keySizeInBytes = keySizeInBytes;
    }

    public GeneralPKCS11KeyParameterSpec(String keyIdentifier, String label, int keySizeInBytes, String algorithm) {
        this(keyIdentifier, label, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, null, keySizeInBytes, algorithm);
    }

    @Override
    public Integer getKeyType() {
        return this.mechanismBuilder.getKeyType();
    }

    @Override
    public String getKeyID() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken != null) {
            return new Boolean(this.isToken);
        }
        return this.isToken;
    }

    @Override
    public Boolean getSensitive() {
        if (this.isSensitive != null) {
            return new Boolean(this.isSensitive);
        }
        return this.isSensitive;
    }

    @Override
    public Boolean getEncrypt() {
        if (this.encrypt != null) {
            return new Boolean(this.encrypt);
        }
        return this.encrypt;
    }

    @Override
    public Boolean getWrap() {
        if (this.wrapping != null) {
            return new Boolean(this.wrapping);
        }
        return this.wrapping;
    }

    @Override
    public Boolean getExtractable() {
        if (this.extractable != null) {
            return new Boolean(this.extractable);
        }
        return this.extractable;
    }

    public int getKeySizeInBytes() {
        return this.keySizeInBytes;
    }
}

