/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.AttributesItem;
import com.ibm.crypto.pkcs11impl.provider.ConfigParsingException;
import com.ibm.crypto.pkcs11impl.provider.Item;
import com.ibm.crypto.pkcs11impl.provider.ListItem;
import com.ibm.crypto.pkcs11impl.provider.SimpleItem;
import com.ibm.crypto.pkcs11impl.provider.SupportedServices;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Object;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

class Config {
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String LIBRARY = "library";
    private static final String SLOT = "slot";
    private static final String SLOT_LIST_INDEX = "slotlistindex";
    private static final String MECHANISMS = "mechanisms";
    private static final String ENABLED_MECHANISMS = "enabledmechanisms";
    private static final String DISABLED_MECHANISMS = "disabledmechanisms";
    private static final String ATTRIBUTES = "attributes";
    private static final String COMPATIBILITY = "compatibility";
    private static final String TOKENLABEL = "tokenlabel";
    private static final String PUBLICKEYIMPORTONLY = "publickeyimportonly";
    private static final HashMap<String, Integer> OPERATIONS = new HashMap();
    private static final HashMap<String, Integer> KEYTYPE = new HashMap();
    private static final HashMap<String, Integer> ALGORITHMS = new HashMap();
    private static final Integer des_secret_key = new Integer(531);
    private static final AttributesItem des_secret_class = new AttributesItem(des_secret_key);
    private static final Integer des3_secret_key = new Integer(1043);
    private static final AttributesItem des3_secret_class = new AttributesItem(des3_secret_key);
    private static final Integer dsa_private_key = new Integer(75);
    private static final AttributesItem dsa_private_class = new AttributesItem(dsa_private_key);
    private static final Integer dsa_public_key = new Integer(71);
    private static final AttributesItem dsa_public_class = new AttributesItem(dsa_public_key);
    private static final Integer rsa_private_key = new Integer(43);
    private static final AttributesItem rsa_private_class = new AttributesItem(rsa_private_key);
    private static final Integer rsa_public_key = new Integer(39);
    private static final AttributesItem rsa_public_class = new AttributesItem(rsa_public_key);
    private static Debug debug = Debug.getInstance((String)"config");
    private static Debug debugDeriveKey = Debug.getInstance((String)"kdf");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Config";
    private static String info = "IBMPKCS11Impl Provider implements the following:\nSignature algorithms               : SHA1withDSA, SHA1withRSA, MD5withRSA, MD2withRSA \nCipher algorithms                  : AES, DES, TripleDES, RSA,\nKey (pair) generator               : AES, DSA, RSA, DES, TripleDES\nMessage digest                     : MD2, MD5, SHA-1\nAlgorithm parameter generator      : DSA\nAlgorithm parameter                : AES, DSA, DES, TripleDES\nKey factory                        : DSA, RSA\nSecret key factory                 : AES, DES, TripleDES\nCertificate                        : X.509\nSecure random                      : PKCS11DeviceRNG (IBMSecureRandom)\nKey store                          : PKCS11IMPLKS\n";
    private HashMap<String, Item> configMap = new HashMap();
    private Map<Integer, AttributesItem> attributesMap = new LinkedHashMap<Integer, AttributesItem>();
    private ArrayList<Integer> supportedMechanisms = null;

    Config(String configName) {
        if (debug != null) {
            System.out.println("new Config instance");
        }
        this.configMap.put(NAME, null);
        this.configMap.put(LIBRARY, null);
        this.configMap.put(DESCRIPTION, null);
        this.configMap.put(SLOT, null);
        this.configMap.put(SLOT_LIST_INDEX, null);
        this.configMap.put(MECHANISMS, null);
        if (configName != null) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new FileReader(configName));
            }
            catch (IOException io) {
                if (debug != null) {
                    System.out.println(io.getMessage());
                }
                throw new RuntimeException(io.getMessage());
            }
            try {
                this.parse(in);
            }
            catch (Exception e) {
                if (debug != null) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    Config(BufferedReader in) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Config", (Object)in);
        }
        this.configMap.put(NAME, null);
        this.configMap.put(LIBRARY, null);
        this.configMap.put(DESCRIPTION, null);
        this.configMap.put(SLOT, null);
        this.configMap.put(SLOT_LIST_INDEX, null);
        this.configMap.put(MECHANISMS, null);
        if (in != null) {
            try {
                this.parse(in);
            }
            catch (Exception e) {
                if (debug != null) {
                    e.printStackTrace();
                }
                throw new RuntimeException(e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Config");
        }
    }

    private void parse(BufferedReader in) throws Exception {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "parse", (Object)in);
        }
        try {
            String str;
            int lineNum = 0;
            while ((str = in.readLine()) != null) {
                str = str.trim();
                ++lineNum;
                if (str.startsWith("#") || str.length() <= 0) continue;
                if (str.toLowerCase().startsWith(LIBRARY)) {
                    this.processLibrary(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(NAME)) {
                    this.processSimpleItem(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(DESCRIPTION)) {
                    this.processSimpleItem(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(SLOT)) {
                    this.processSlot(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(PUBLICKEYIMPORTONLY)) {
                    this.processPublicKeyImportOnly(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(TOKENLABEL)) {
                    this.processTokenLabel(str);
                    continue;
                }
                if (str.toLowerCase().startsWith(ENABLED_MECHANISMS)) {
                    lineNum = this.processMechanism(ENABLED_MECHANISMS, str, in, lineNum);
                    continue;
                }
                if (str.toLowerCase().startsWith(DISABLED_MECHANISMS)) {
                    lineNum = this.processMechanism(DISABLED_MECHANISMS, str, in, lineNum);
                    continue;
                }
                if (str.toLowerCase().startsWith(ATTRIBUTES)) {
                    lineNum = this.processAttributes(str, in, lineNum);
                    continue;
                }
                String msg = "Unexpected attribute found, please check your config file at line " + lineNum + ": \"" + str.trim() + "\"";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ConfigParsingException(msg);
            }
            in.close();
            if (this.configMap.get(NAME) == null || this.configMap.get(LIBRARY) == null) {
                String msg = "You must specify a provider name and library in your config file.";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ConfigParsingException(msg);
            }
        }
        catch (IOException io) {
            if (debug != null) {
                System.out.println(io.getMessage());
            }
            throw new RuntimeException(io.getMessage());
        }
        catch (ConfigParsingException cpe) {
            if (debug != null) {
                System.out.println(cpe.getMessage());
            }
            throw new RuntimeException(cpe.getMessage());
        }
    }

    private int processAttributes(String str, BufferedReader in, int line) throws IOException, ConfigParsingException {
        if (str.indexOf(40) == -1) {
            String value = str.split("=")[1].trim();
            if (!value.equalsIgnoreCase(COMPATIBILITY)) {
                String msg = "Unexpected attributes value found at line " + line + ": \"" + value + "\".  Please see the PKCS#11 Specification for valid format.";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ConfigParsingException(msg);
            }
            this.attributesMap.put(des_secret_key, des_secret_class);
            this.attributesMap.put(des3_secret_key, des3_secret_class);
            this.attributesMap.put(dsa_private_key, dsa_private_class);
            this.attributesMap.put(dsa_public_key, dsa_public_class);
            this.attributesMap.put(rsa_private_key, rsa_private_class);
            this.attributesMap.put(rsa_public_key, rsa_public_class);
        } else {
            StringBuffer buf = new StringBuffer(str);
            while (!str.endsWith("}")) {
                str = in.readLine();
                if (str == null) {
                    throw new ConfigParsingException("Invalid attribute " + buf);
                }
                str = str.trim();
                ++line;
                if (str.startsWith("#") || str.length() <= 0) continue;
                buf.append(str);
                buf.append(' ');
            }
            if (buf.indexOf("(") < 0 || buf.indexOf(")") < 0) {
                throw new ConfigParsingException("Missing \"(\" or \")\" in: " + buf);
            }
            if (buf.indexOf("=") <= buf.indexOf(")") || buf.indexOf("=") >= buf.indexOf("{")) {
                throw new ConfigParsingException("Missing \"=\" in: " + buf);
            }
            String key = buf.substring(buf.indexOf("(") + 1, buf.indexOf(")"));
            String value = buf.substring(buf.indexOf("{") + 1, buf.indexOf("}")).trim();
            String[] fields = key.split(",");
            if (fields.length != 3) {
                String msg = "Attributes have incorrect format, please check your config file: " + buf;
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ConfigParsingException(msg);
            }
            String operation = fields[0].trim().toUpperCase();
            String keytype = fields[1].trim().toUpperCase();
            String algorithm = fields[2].trim().toUpperCase();
            AttributesItem ai = new AttributesItem(this.getIntRepresentation(operation, keytype, algorithm));
            StringTokenizer st = new StringTokenizer(value, " \t\n\r\f=");
            if (st.countTokens() % 2 != 0) {
                throw new ConfigParsingException("Wrong attributes format " + buf);
            }
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (!name.toUpperCase().startsWith("CKA_")) {
                    String msg = "Unexpected attribute name found: " + name + ". Names must be CKA_xxx constants from the PKCS#11 specification.";
                    if (debug != null) {
                        System.out.println(msg);
                    }
                    throw new ConfigParsingException(msg);
                }
                String val = st.nextToken();
                Object objVal = null;
                try {
                    objVal = val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false") ? new Boolean(val) : (val.equalsIgnoreCase("null") ? null : Integer.decode(val));
                }
                catch (NumberFormatException e) {
                    String msg = "Unexpected format found : " + name + " = " + val + ".\nPlease comment out any empty attribute options and specify values as either boolean, integer in either decimal or hexadecimal form, or as the word null.";
                    if (debug != null) {
                        System.out.println(msg);
                    }
                    throw new ConfigParsingException(msg);
                }
                name = name.substring(4);
                try {
                    Integer nameNum = (Integer)PKCS11Object.class.getField(name).get(null);
                    ai.addItem(nameNum, objVal);
                }
                catch (NoSuchFieldException e) {
                    String msg = "Unexpected attribute name found: " + name + ". Names must be CKA_xxx constants from the PKCS#11 specification.";
                    if (debug != null) {
                        System.out.println(msg);
                    }
                    throw new ConfigParsingException(msg);
                }
                catch (Exception e) {
                    throw new ConfigParsingException(e.getMessage());
                }
            }
            this.attributesMap.put((Integer)ai.getName(), ai);
        }
        return line;
    }

    private Integer getIntRepresentation(String operation, String keytype, String algorithm) throws ConfigParsingException {
        Integer opValue = OPERATIONS.get(operation);
        if (opValue == null) {
            String msg = "Valid values for operation are generate, import or * to match keys created using either a generate or a create operation.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        Integer keyValue = KEYTYPE.get(keytype);
        if (keyValue == null) {
            String msg = "Valid values for keytype are CKO_PUBLIC_KEY, CKO_PRIVATE_KEY, CKO_SECRET_KEY or * to match any type of key.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        Integer algValue = ALGORITHMS.get(algorithm);
        if (algValue == null) {
            String msg = "Unexpected key algorithm found: " + algorithm + ". Algorithms must be CKK_xxx constants from the PKCS#11 specification or a * to match any algorithm.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        return new Integer(opValue | keyValue | algValue);
    }

    private void processSimpleItem(String str) {
        String[] fields = str.split("=");
        SimpleItem si = new SimpleItem(fields[0].trim().toLowerCase(), fields[1].trim());
        this.configMap.put((String)si.getName(), si);
    }

    private void processLibrary(String libraryEntry) throws Exception {
        String[] fields = libraryEntry.split("=");
        String libraryPath = fields[1].trim();
        if (!new File(libraryPath).isAbsolute()) {
            throw new Exception("Absolute path required for library value: " + libraryPath);
        }
        this.processSimpleItem(libraryEntry);
    }

    private void processSlot(String str) throws ConfigParsingException {
        if (this.configMap.get(SLOT) != null || this.configMap.get(SLOT_LIST_INDEX) != null || this.configMap.get(TOKENLABEL) != null) {
            String msg = "slot, slotListIndex and tokenlabel are mutually exclusive, only provide one at the same time.  Please check your config file.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        this.processSimpleItem(str);
    }

    private void processPublicKeyImportOnly(String str) throws ConfigParsingException {
        String[] fields = str.split("=");
        if (!fields[1].trim().equalsIgnoreCase("true") && !fields[1].trim().equalsIgnoreCase("false")) {
            String msg = "Unexpected format found : " + fields[0] + " = " + fields[1] + ".\nPlease specify values as boolean (true, false)";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        SimpleItem si = new SimpleItem(fields[0].trim().toLowerCase(), fields[1].trim().toLowerCase());
        this.configMap.put((String)si.getName(), si);
    }

    private void processTokenLabel(String str) throws ConfigParsingException {
        if (this.configMap.get(SLOT) != null || this.configMap.get(SLOT_LIST_INDEX) != null) {
            String msg = "You cannot provide slot or slotListIndex at the same time with token label. Please check your config file.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        this.processSimpleItem(str);
    }

    private int processMechanism(String key, String str, BufferedReader in, int line) throws ConfigParsingException, IOException {
        if (this.configMap.get(MECHANISMS) != null) {
            String msg = "You cannot provide both enabled and disabled mechanisms at the same time.  Please check your config file.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        StringBuffer buf = new StringBuffer();
        buf.append(str);
        buf.append(" ");
        while (!str.endsWith("}") && (str = in.readLine().trim()) != null) {
            ++line;
            if (str.startsWith("#") || str.length() <= 0) continue;
            buf.append(str);
            buf.append(" ");
        }
        if (str == null) {
            String msg = "Cannot parse the config file in its current format.Please check that mechanisms are declared with '{' and '}' arround the value.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ConfigParsingException(msg);
        }
        if (buf.indexOf("=") < 0) {
            throw new ConfigParsingException("Missing \"=\" in: " + buf);
        }
        String value = buf.substring(buf.indexOf("{") + 1, buf.indexOf("}"));
        if (value != null && value.length() > 0) {
            ListItem li = new ListItem(key);
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                String name = st.nextToken();
                if (name.startsWith("CKM_")) {
                    name = name.substring(4);
                    try {
                        Integer mechanism = (Integer)PKCS11Mechanism.class.getField(name).get(null);
                        li.addItem(mechanism);
                        continue;
                    }
                    catch (NoSuchFieldException nfe) {
                        String msg = "Unexpected mechanism found: " + name + ". Mechanisms must be CKM_xxx and be supported by both the IBMPKCS11Impl provider and PKCS#11 token.";
                        if (debug != null) {
                            System.out.println(msg);
                        }
                        throw new ConfigParsingException(msg);
                    }
                    catch (Exception e) {
                        if (debug == null) continue;
                        debug.text(16384L, (Object)className, "processMechanism", e.getMessage());
                        continue;
                    }
                }
                String msg = "Unexpected mechanism found: " + name + ". Mechanisms must be CKM_xxx and be supported by both the IBMPKCS11Impl provider and PKCS#11 token.";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ConfigParsingException(msg);
            }
            this.configMap.put(MECHANISMS, li);
        }
        return line;
    }

    public static String getProviderNameSuffix(String configName) throws ProviderException {
        String name = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(configName));
            name = Config.getProviderNameSuffix(in);
        }
        catch (Exception io) {
            String msg = "Error reading config file: " + configName + " while trying to retrieve name.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ProviderException(msg);
        }
        return name;
    }

    public static String getProviderNameSuffix(BufferedReader in) throws ProviderException {
        String name = null;
        try {
            in.mark(2000);
            String str = null;
            while ((str = in.readLine()) != null) {
                if (!(str = str.trim()).toLowerCase().startsWith(NAME)) continue;
                String[] fields = str.split("=");
                name = fields[1].trim();
                break;
            }
            in.reset();
        }
        catch (IOException io) {
            String msg = "Error reading config file:  while trying to retrieve name.";
            if (debug != null) {
                System.out.println(msg);
            }
            throw new ProviderException(msg);
        }
        return "-" + name;
    }

    public static String getDescription(String configName) throws ProviderException {
        String description = null;
        if (configName == null) {
            description = info;
        } else {
            try {
                BufferedReader in = new BufferedReader(new FileReader(configName));
                description = Config.getDescription(in);
            }
            catch (Exception io) {
                String msg = "Error reading config file: " + configName + " while trying to retrieve description.";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ProviderException(msg);
            }
        }
        return description;
    }

    public static String getDescription(BufferedReader in) throws ProviderException {
        String description = null;
        if (in == null) {
            description = info;
        } else {
            try {
                in.mark(2000);
                String str = null;
                while ((str = in.readLine()) != null) {
                    if (!(str = str.trim()).toLowerCase().startsWith(DESCRIPTION)) continue;
                    String[] fields = str.split("=");
                    description = fields[1].trim();
                    break;
                }
                in.reset();
            }
            catch (IOException io) {
                String msg = "Error reading config file:  while trying to retrieve description.";
                if (debug != null) {
                    System.out.println(msg);
                }
                throw new ProviderException(msg);
            }
        }
        return description;
    }

    public String getLibraryName() {
        String value = null;
        Item item = this.configMap.get(LIBRARY);
        if (item != null) {
            value = (String)item.getValue();
        }
        return value;
    }

    public String getProviderNameSuffix() {
        String value = null;
        Item item = this.configMap.get(NAME);
        if (item != null) {
            value = "-" + (String)item.getValue();
        }
        return value;
    }

    public String getDescription() {
        String value = info;
        Item desc = this.configMap.get(DESCRIPTION);
        if (desc != null) {
            value = (String)desc.getValue();
        }
        return value;
    }

    public int getSlotIndex() {
        int value = 0;
        Item si = this.configMap.get(SLOT_LIST_INDEX);
        value = si != null ? new Integer((String)si.getValue()) : -1;
        return value;
    }

    public int getSlot() {
        int value = 0;
        Item si = this.configMap.get(SLOT);
        value = si != null ? new Integer((String)si.getValue()) : -1;
        return value;
    }

    public String getTokenLabel() {
        String value = null;
        Item si = this.configMap.get(TOKENLABEL);
        if (si != null) {
            value = (String)si.getValue();
        }
        return value;
    }

    public boolean getPublicKeyImportOnly() {
        boolean value = false;
        Item si = this.configMap.get(PUBLICKEYIMPORTONLY);
        if (si != null) {
            value = new Boolean((String)si.getValue());
        }
        return value;
    }

    public ArrayList<Integer> getEnabledMechanisms() {
        return this.getMechanisms(true);
    }

    public ArrayList<Integer> getDisabledMechanisms() {
        return this.getMechanisms(false);
    }

    private ArrayList<Integer> getMechanisms(boolean enabledMechanism) {
        ArrayList value = null;
        Item li = this.configMap.get(MECHANISMS);
        if (li != null && (li.getName().equals(ENABLED_MECHANISMS) && enabledMechanism || li.getName().equals(DISABLED_MECHANISMS) && !enabledMechanism)) {
            value = (ArrayList)li.getValue();
        }
        return value;
    }

    public HashMap<Integer, Object> getAttributes(String operation, Integer keytype, Integer algorithm) {
        HashMap attrib = new HashMap();
        HashMap<Integer, Object> value = new HashMap<Integer, Object>();
        String op = operation == null ? "*" : operation.toUpperCase();
        String key = keytype == null ? "*" : PKCS11Object.classToString((Integer)keytype);
        String alg = algorithm == null ? "*" : PKCS11Object.keyToString((Integer)algorithm);
        Integer opVal = OPERATIONS.get(op);
        Integer keyVal = KEYTYPE.get(key);
        Integer algVal = ALGORITHMS.get(alg);
        if (opVal == null || keyVal == null || algVal == null) {
            throw new RuntimeException("Invalid arguments: " + op + "," + key + "," + alg);
        }
        int paramVal = opVal | keyVal | algVal;
        for (Map.Entry<Integer, AttributesItem> entry : this.attributesMap.entrySet()) {
            int hmKey = entry.getKey();
            if (paramVal != (paramVal & hmKey)) continue;
            attrib = (HashMap)entry.getValue().getValue();
            for (Map.Entry entry2 : attrib.entrySet()) {
                value.put((Integer)entry2.getKey(), entry2.getValue());
            }
        }
        return value;
    }

    public SupportedServices[] getSupportedServices(int[] mechanismList) {
        ArrayList tokenMechanisms = this.convertToArrayList(mechanismList);
        ListItem li = (ListItem)this.configMap.get(MECHANISMS);
        if (li != null) {
            ArrayList configMechs = (ArrayList)li.getValue();
            if (li.getName().equals(ENABLED_MECHANISMS)) {
                Iterator it = configMechs.iterator();
                while (it.hasNext()) {
                    if (tokenMechanisms.contains(it.next())) continue;
                    it.remove();
                }
                tokenMechanisms = configMechs;
            } else {
                Iterator<Integer> it = tokenMechanisms.iterator();
                while (it.hasNext()) {
                    if (!configMechs.contains(it.next())) continue;
                    it.remove();
                }
            }
        }
        this.supportedMechanisms = tokenMechanisms;
        HashSet<SupportedServices> servicesList = this.getSupportedServicesList(tokenMechanisms);
        return servicesList.toArray(new SupportedServices[0]);
    }

    boolean supportMechanism(int mechanism) {
        return this.supportedMechanisms.contains(mechanism);
    }

    private HashSet<SupportedServices> getSupportedServicesList(ArrayList<Integer> tokenMechanisms) {
        HashSet<SupportedServices> servicesList = new HashSet<SupportedServices>();
        boolean dsa = false;
        boolean rsapkcs = false;
        boolean rsax509 = false;
        boolean md2 = false;
        boolean md5 = false;
        boolean sha = false;
        boolean sha224 = false;
        boolean sha256 = false;
        boolean sha384 = false;
        boolean sha512 = false;
        boolean rsamd2 = false;
        boolean rsamd5 = false;
        boolean dsasha = false;
        boolean rsasha = false;
        boolean rsasha224 = false;
        boolean rsasha256 = false;
        boolean rsasha384 = false;
        boolean rsasha512 = false;
        String[] aliases = null;
        for (Integer i : tokenMechanisms) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "Init", "Mechanism: " + i.toString());
            }
            switch (i) {
                case 17: {
                    dsa = true;
                    aliases = null;
                    servicesList.add(new SupportedServices("Signature", "DSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithDSA", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  DSA signature with caller supplied hash is available on the hardware");
                    break;
                }
                case 6: {
                    rsasha = true;
                    aliases = new String[]{"PKCS11SHA1withRSA", "SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "SHAwithRSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
                    servicesList.add(new SupportedServices("Signature", "SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA1withRSA    is available on the hardware");
                    break;
                }
                case 70: {
                    rsasha224 = true;
                    aliases = new String[]{"SHA224withRSA", "SHA-224withRSA", "SHA-224/RSA", "SHA224/RSA", "OID.1.2.840.113549.1.1.14", "1.2.840.113549.1.1.14"};
                    servicesList.add(new SupportedServices("Signature", "SHA224withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA224withRSA  is available on the hardware");
                    break;
                }
                case 64: {
                    rsasha256 = true;
                    aliases = new String[]{"SHA2withRSA", "SHA2/RSA", "SHA-256withRSA", "SHA-256/RSA", "SHA256/RSA", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
                    servicesList.add(new SupportedServices("Signature", "SHA256withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA256withRSA  is available on the hardware");
                    break;
                }
                case 65: {
                    rsasha384 = true;
                    aliases = new String[]{"SHA3withRSA", "SHA3/RSA", "SHA-384withRSA", "SHA-384/RSA", "SHA384/RSA", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
                    servicesList.add(new SupportedServices("Signature", "SHA384withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA384withRSA  is available on the hardware");
                    break;
                }
                case 66: {
                    rsasha512 = true;
                    aliases = new String[]{"SHA5withRSA", "SHA5/RSA", "SHA-512withRSA", "SHA-512/RSA", "SHA512/RSA", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
                    servicesList.add(new SupportedServices("Signature", "SHA512withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA512withRSA  is available on the hardware");
                    break;
                }
                case 4: {
                    rsamd2 = true;
                    aliases = new String[]{"PKCS11MD2withRSA", "MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
                    servicesList.add(new SupportedServices("Signature", "MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  MD2withRSA     is available on the hardware");
                    break;
                }
                case 5: {
                    rsamd5 = true;
                    aliases = new String[]{"PKCS11MD5withRSA", "MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
                    servicesList.add(new SupportedServices("Signature", "MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  MD5withRSA     is available on the hardware");
                    break;
                }
                case 18: {
                    dsasha = true;
                    aliases = new String[]{"PKCS11SHA1withDSA", "SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHAwithDSA", "DSAwithSHA1", "DSA", "DSS", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
                    servicesList.add(new SupportedServices("Signature", "SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    break;
                }
                case 289: {
                    aliases = new String[]{"DES"};
                    servicesList.add(new SupportedServices("Cipher", "DES/ECB/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11DENP", aliases, i));
                    break;
                }
                case 290: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "DES/CBC/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11DCNP", aliases, i));
                    break;
                }
                case 293: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "DES/CBC/PKCS5Padding", "com.ibm.crypto.pkcs11impl.provider.PKCS11DCP", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "DES/CBC/Pad", "com.ibm.crypto.pkcs11impl.provider.PKCS11DCPAD", aliases, i));
                    break;
                }
                case 306: {
                    aliases = new String[]{"DESede", "TripleDES", "3DES"};
                    servicesList.add(new SupportedServices("Cipher", "DESede/ECB/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11TDENP", aliases, i));
                    break;
                }
                case 307: {
                    aliases = new String[]{"DESede/CBC/NoPadding", "3DES/CBC/NoPadding"};
                    servicesList.add(new SupportedServices("Cipher", "TripleDES/CBC/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11TDCNP", aliases, i));
                    break;
                }
                case 310: {
                    aliases = new String[]{"DESede/CBC/PKCS5Padding", "3DES/CBC/PKCS5Padding"};
                    servicesList.add(new SupportedServices("Cipher", "TripleDES/CBC/PKCS5Padding", "com.ibm.crypto.pkcs11impl.provider.PKCS11TDCP", aliases, i));
                    aliases = new String[]{"DESede/CBC/Pad", "3DES/CBC/Pad"};
                    servicesList.add(new SupportedServices("Cipher", "TripleDES/CBC/Pad", "com.ibm.crypto.pkcs11impl.provider.PKCS11TDCPAD", aliases, i));
                    break;
                }
                case 4225: {
                    aliases = new String[]{"AES"};
                    servicesList.add(new SupportedServices("Cipher", "AES/ECB/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11AENP", aliases, i));
                    break;
                }
                case 4226: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "AES/CBC/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11ACNP", aliases, i));
                    break;
                }
                case 4229: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "AES/CBC/PKCS5Padding", "com.ibm.crypto.pkcs11impl.provider.PKCS11ACP", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "AES/CBC/Pad", "com.ibm.crypto.pkcs11impl.provider.PKCS11ACPAD", aliases, i));
                    break;
                }
                case 4231: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "AES/GCM/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11AGNP", aliases, i));
                    break;
                }
                case 4241: {
                    aliases = new String[]{"Blowfish/CBC/NoPadding"};
                    servicesList.add(new SupportedServices("Cipher", "Blowfish/CBC/NoPadding", "com.ibm.crypto.pkcs11impl.provider.PKCS11BCNP", aliases, i));
                    break;
                }
                case 273: {
                    aliases = new String[]{"ARCFOUR"};
                    servicesList.add(new SupportedServices("Cipher", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Cipher", aliases, i));
                    break;
                }
                case 288: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    servicesList.add(new SupportedServices("AlgorithmParameters", "DES", "com.ibm.crypto.pkcs11impl.provider.DESParameters", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "DES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 272: {
                    aliases = new String[]{"ARCFOUR"};
                    servicesList.add(new SupportedServices("KeyGenerator", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "RC4", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 305: {
                    aliases = new String[]{"TripleDES", "DESede/CBC/NoPadding", "3DES"};
                    servicesList.add(new SupportedServices("KeyGenerator", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    servicesList.add(new SupportedServices("AlgorithmParameters", "DESede", "com.ibm.crypto.pkcs11impl.provider.DESedeParameters", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "DESede", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 4224: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("AlgorithmParameters", "AES", "com.ibm.crypto.pkcs11impl.provider.AESParameters", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("SecretKeyFactory", "AES", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 4240: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("AlgorithmParameters", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.BlowfishParameters", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("SecretKeyFactory", "Blowfish", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 848: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "Generic", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "Generic", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "Mac", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 16: {
                    aliases = new String[]{"OID.1.2.840.10040.4.1", "1.2.840.10040.4.1", "OID.1.3.14.3.2.12", "1.3.14.3.2.12"};
                    servicesList.add(new SupportedServices("KeyPairGenerator", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyPairGenerator", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("AlgorithmParameterGenerator", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameterGenerator", aliases, i));
                    aliases = new String[]{"1.3.14.3.2.12", "1.2.840.10040.4.1"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAParameters", aliases, i));
                    aliases = new String[]{"OID.1.3.14.3.2.12", "1.3.14.3.2.12", "OID.1.2.840.10040.4.1", "1.2.840.10040.4.1"};
                    servicesList.add(new SupportedServices("KeyFactory", "DSA", "com.ibm.crypto.pkcs11impl.provider.DSAPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 33: {
                    aliases = new String[]{"DiffieHellman", "OID.1.2.840.113549.1.3.1", "1.2.840.113549.1.3.1"};
                    servicesList.add(new SupportedServices("KeyAgreement", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyAgreement", aliases, i));
                    aliases = new String[]{"DiffieHellman"};
                    servicesList.add(new SupportedServices("KeyFactory", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 32: {
                    aliases = new String[]{"DiffieHellman"};
                    servicesList.add(new SupportedServices("KeyPairGenerator", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyPairGenerator", aliases, i));
                    break;
                }
                case 8193: {
                    aliases = new String[]{"DiffieHellman"};
                    servicesList.add(new SupportedServices("AlgorithmParameterGenerator", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11ParameterGenerator", aliases, i));
                    aliases = new String[]{"DiffieHellman"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "DH", "com.ibm.crypto.pkcs11impl.provider.DHPKCS11Parameters", aliases, i));
                    break;
                }
                case 0: {
                    aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1"};
                    servicesList.add(new SupportedServices("KeyPairGenerator", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyPairGenerator", aliases, i));
                    aliases = null;
                    servicesList.add(new SupportedServices("AlgorithmParameters", "OAEP", "com.ibm.crypto.pkcs11impl.provider.IBMOAEPParameters", aliases, i));
                    aliases = new String[]{"OID.1.2.5.8.1.1", "1.2.5.8.1.1", "OID.1.2.840.113549.1.1.1", "1.2.840.113549.1.1.1"};
                    servicesList.add(new SupportedServices("KeyFactory", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSAPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 512: {
                    md2 = true;
                    aliases = null;
                    servicesList.add(new SupportedServices("MessageDigest", "MD2", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  MD2            is available on the hardware");
                    break;
                }
                case 528: {
                    md5 = true;
                    aliases = null;
                    servicesList.add(new SupportedServices("MessageDigest", "MD5", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  MD5            is available on the hardware");
                    break;
                }
                case 544: {
                    sha = true;
                    aliases = new String[]{"SHA-1", "SHA1"};
                    servicesList.add(new SupportedServices("MessageDigest", "SHA", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA1           is available on the hardware");
                    break;
                }
                case 597: {
                    sha224 = true;
                    aliases = new String[]{"SHA-224", "SHA224"};
                    servicesList.add(new SupportedServices("MessageDigest", "SHA-224", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA224         is available on the hardware");
                    break;
                }
                case 592: {
                    sha256 = true;
                    aliases = new String[]{"SHA-2", "SHA2", "SHA256", "OID.2.16.840.1.101.3.4.2.1", "2.16.840.1.101.3.4.2.1"};
                    servicesList.add(new SupportedServices("MessageDigest", "SHA-256", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA256         is available on the hardware");
                    break;
                }
                case 608: {
                    sha384 = true;
                    aliases = new String[]{"SHA-3", "SHA3", "SHA384", "OID.2.16.840.1.101.3.4.2.2", "2.16.840.1.101.3.4.2.2"};
                    servicesList.add(new SupportedServices("MessageDigest", "SHA-384", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA384         is available on the hardware");
                    break;
                }
                case 624: {
                    sha512 = true;
                    aliases = new String[]{"SHA-5", "SHA5", "SHA512", "OID.2.16.840.1.101.3.4.2.3", "2.16.840.1.101.3.4.2.3"};
                    servicesList.add(new SupportedServices("MessageDigest", "SHA-512", "com.ibm.crypto.pkcs11impl.provider.GeneralHashing", aliases, i));
                    if (debug == null) break;
                    System.out.println("Config.java:  SHA512         is available on the hardware");
                    break;
                }
                case 529: {
                    aliases = null;
                    servicesList.add(new SupportedServices("Mac", "HmacMD5", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacMD5", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 545: {
                    aliases = new String[]{"HmacSHA-1", "HMACwithSHA1"};
                    servicesList.add(new SupportedServices("Mac", "HmacSHA1", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacSHA1", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 598: {
                    aliases = new String[]{"HMACwithSHA224"};
                    servicesList.add(new SupportedServices("Mac", "HmacSHA224", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacSHA224", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 593: {
                    aliases = new String[]{"HMACwithSHA256"};
                    servicesList.add(new SupportedServices("Mac", "HmacSHA256", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacSHA256", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 609: {
                    aliases = new String[]{"HMACwithSHA384"};
                    servicesList.add(new SupportedServices("Mac", "HmacSHA384", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacSHA384", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 625: {
                    aliases = new String[]{"HMACwithSHA512"};
                    servicesList.add(new SupportedServices("Mac", "HmacSHA512", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11Hmac", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "HmacSHA512", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 1: {
                    if (debug != null) {
                        System.out.println("Config.java:  RSA_PKCS mechanism is available on the hardware.");
                        System.out.println("Config.java:  Adding 'Signature' service for RSA_PKCS");
                    }
                    rsapkcs = true;
                    aliases = null;
                    servicesList.add(new SupportedServices("Signature", "RSAforSSL", "com.ibm.crypto.pkcs11impl.provider.PKCS11SSLHashingwithRSA", aliases, i));
                    if (debug != null) {
                        System.out.println("Config.java:  RSA_PKCS signature mechanism with caller supplied hash is available on the hardware");
                    }
                    if (debug != null) {
                        System.out.println("Config.java:  Adding 'Cipher' service for RSA_PKCS");
                    }
                    aliases = new String[]{"RSAforSSL", "RSA/ECB/PKCS1Padding", "RSA/SSL/PKCS1Padding"};
                    servicesList.add(new SupportedServices("Cipher", "RSA//PKCS1Padding", "com.ibm.crypto.pkcs11impl.provider.RSACipher", aliases, i));
                    break;
                }
                case 3: {
                    if (debug != null) {
                        System.out.println("Config.java:  Adding 'Cipher' service for RSA_X_509");
                    }
                    rsax509 = true;
                    aliases = null;
                    servicesList.add(new SupportedServices("Cipher", "RSA", "com.ibm.crypto.pkcs11impl.provider.RSACipher", aliases, i));
                    break;
                }
                case 880: 
                case 884: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "IBMTlsRsaPremasterSecret", "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsRsaPremasterSecretGenerator", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "TlsRsaPremasterSecret", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 881: 
                case 883: 
                case 885: 
                case 887: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "IBMTlsMasterSecret", "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsMasterSecretGenerator", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "TlsMasterSecret", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 882: 
                case 886: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "IBMTlsKeyMaterial", "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsKeyMaterialGenerator", aliases, i));
                    servicesList.add(new SupportedServices("SecretKeyFactory", "MAC", "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyFactory", aliases, i));
                    break;
                }
                case 888: {
                    aliases = null;
                    servicesList.add(new SupportedServices("KeyGenerator", "IBMTlsPrf", "com.ibm.crypto.pkcs11impl.provider.PKCS11TlsPrfGenerator", aliases, i));
                    break;
                }
                case 4160: {
                    aliases = new String[]{"1.2.840.10045.2.1", "OID.1.2.840.10045.2.1"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "EC", "com.ibm.security.ec.ECParameters", aliases, i));
                    servicesList.add(new SupportedServices("KeyPairGenerator", "EC", "com.ibm.crypto.pkcs11impl.provider.ECPKCS11KeyPairGenerator", null, i));
                    break;
                }
                case 4176: {
                    if (debugDeriveKey != null) {
                        System.out.println("Config.java:  getSupportedServicesList():  ECDH1_DERIVE is available");
                    }
                    servicesList.add(new SupportedServices("KeyAgreement", "ECDH", "com.ibm.crypto.pkcs11impl.provider.ECDHPKCS11KeyAgreement", null, i));
                    aliases = new String[]{"1.2.840.10045.2.1", "OID.1.2.840.10045.2.1"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "EC", "com.ibm.security.ec.ECParameters", aliases, i));
                    servicesList.add(new SupportedServices("KeyFactory", "ECDH", "com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory", null, i));
                    break;
                }
                case 4177: {
                    if (debugDeriveKey != null) {
                        System.out.println("Config.java:  getSupportedServicesList():  ECDH1_COFACTOR_DERIVE is available");
                    }
                    servicesList.add(new SupportedServices("KeyAgreement", "ECDHCofactor", "com.ibm.crypto.pkcs11impl.provider.ECDHCofactorPKCS11KeyAgreement", null, i));
                    aliases = new String[]{"1.2.840.10045.2.1", "OID.1.2.840.10045.2.1"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "EC", "com.ibm.security.ec.ECParameters", aliases, i));
                    servicesList.add(new SupportedServices("KeyFactory", "ECDH", "com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory", null, i));
                    break;
                }
                case 4178: {
                    if (debugDeriveKey == null) break;
                    System.out.println("Config.java:  getSupportedServicesList():  ECMQV_DERIVE is available");
                    break;
                }
                case 4161: {
                    aliases = new String[]{"1.2.840.10045.2.1", "OID.1.2.840.10045.2.1"};
                    servicesList.add(new SupportedServices("AlgorithmParameters", "EC", "com.ibm.security.ec.ECParameters", aliases, i));
                    servicesList.add(new SupportedServices("KeyFactory", "EC", "com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory", aliases, i));
                    aliases = new String[]{"ECDSAforSSL"};
                    servicesList.add(new SupportedServices("Signature", "NONEwithECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    aliases = new String[]{"ECDSA", "EC", "SHAwithECDSA", "SHA-1withECDSA", "SHA/ECDSA", "SHA-1/ECDSA", "OID.1.2.840.10045.4.1", "1.2.840.10045.4.1"};
                    servicesList.add(new SupportedServices("Signature", "SHA1withECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    aliases = new String[]{"SHA224withECDSA", "SHA-224/ECDSA", "OID.1.2.840.10045.4.3.1", "1.2.840.10045.4.3.1"};
                    servicesList.add(new SupportedServices("Signature", "SHA224withECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    aliases = new String[]{"SHA2withECDSA", "SHA2/ECDSA", "SHA-256/ECDSA", "OID.1.2.840.10045.4.3.2", "1.2.840.10045.4.3.2"};
                    servicesList.add(new SupportedServices("Signature", "SHA256withECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    aliases = new String[]{"SHA3withECDSA", "SHA3/ECDSA", "SHA-384/ECDSA", "OID.1.2.840.10045.4.3.3", "1.2.840.10045.4.3.3"};
                    servicesList.add(new SupportedServices("Signature", "SHA384withECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                    aliases = new String[]{"SHA5withECDSA", "SHA5/ECDSA", "SHA-512/ECDSA", "OID.1.2.840.10045.4.3.4", "1.2.840.10045.4.3.4"};
                    servicesList.add(new SupportedServices("Signature", "SHA512withECDSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignature", aliases, i));
                }
            }
        }
        if (!rsamd2 && rsapkcs && !rsax509 && md2 || !rsamd2 && rsapkcs && rsax509 && md2) {
            aliases = new String[]{"PKCS11MD2withRSA", "MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
            servicesList.add(new SupportedServices("Signature", "MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  MD2withRSA     is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  MD2            is     available on the hardware");
            }
        }
        if (!rsamd2 && !rsapkcs && rsax509 && md2) {
            aliases = new String[]{"PKCS11MD2withRSA", "MD2/RSA", "OID.1.2.840.113549.1.1.2", "1.2.840.113549.1.1.2", "OID.1.3.14.3.2.24", "1.3.14.3.2.24"};
            servicesList.add(new SupportedServices("Signature", "MD2withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  MD2withRSA     is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  MD2            is     available on the hardware");
            }
        }
        if (!rsamd5 && rsapkcs && !rsax509 && md5 || !rsamd5 && rsapkcs && rsax509 && md5) {
            aliases = new String[]{"PKCS11MD5withRSA", "MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
            servicesList.add(new SupportedServices("Signature", "MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  MD5withRSA     is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  MD5            is     available on the hardware");
            }
        }
        if (!rsamd5 && !rsapkcs && rsax509 && md5) {
            aliases = new String[]{"PKCS11MD5withRSA", "MD5/RSA", "OID.1.2.840.113549.1.1.4", "1.2.840.113549.1.1.4", "OID.1.3.14.3.2.25", "1.3.14.3.2.25"};
            servicesList.add(new SupportedServices("Signature", "MD5withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  MD5withRSA     is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  MD5            is     available on the hardware");
            }
        }
        if (!rsasha && rsapkcs && !rsax509 && sha || !rsasha && rsapkcs && rsax509 && sha) {
            aliases = new String[]{"PKCS11SHA1withRSA", "SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "SHAwithRSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
            servicesList.add(new SupportedServices("Signature", "SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA1withRSA    is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  SHA1           is     available on the hardware");
            }
        }
        if (!rsasha && !rsapkcs && rsax509 && sha) {
            aliases = new String[]{"PKCS11SHA1withRSA", "SHA-1withRSA", "SHA-1/RSA", "SHA1/RSA", "SHA/RSA", "SHAwithRSA", "RSA", "OID.1.3.14.3.2.26", "1.3.14.3.2.26", "OID.1.2.840.113549.1.1.5", "1.2.840.113549.1.1.5"};
            servicesList.add(new SupportedServices("Signature", "SHA1withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA1withRSA    is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  SHA1           is     available on the hardware");
            }
        }
        if (!rsasha224 && rsapkcs && !rsax509 && sha224 || !rsasha224 && rsapkcs && rsax509 && sha224) {
            aliases = new String[]{"SHA224withRSA", "SHA-224withRSA", "SHA-224/RSA", "SHA224/RSA", "OID.1.2.840.113549.1.1.14", "1.2.840.113549.1.1.14"};
            servicesList.add(new SupportedServices("Signature", "SHA224withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA224withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  SHA224         is     available on the hardware");
            }
        }
        if (!rsasha224 && !rsapkcs && rsax509 && sha224) {
            aliases = new String[]{"SHA224withRSA", "SHA-224withRSA", "SHA-224/RSA", "SHA224/RSA", "OID.1.2.840.113549.1.1.14", "1.2.840.113549.1.1.14"};
            servicesList.add(new SupportedServices("Signature", "SHA224withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA224withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  SHA224         is     available on the hardware");
            }
        }
        if (!rsasha256 && rsapkcs && !rsax509 && sha256 || !rsasha256 && rsapkcs && rsax509 && sha256) {
            aliases = new String[]{"SHA2withRSA", "SHA2/RSA", "SHA-256withRSA", "SHA-256/RSA", "SHA256/RSA", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
            servicesList.add(new SupportedServices("Signature", "SHA256withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA256withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  SHA256         is     available on the hardware");
            }
        }
        if (!rsasha256 && !rsapkcs && rsax509 && sha256) {
            aliases = new String[]{"SHA2withRSA", "SHA2/RSA", "SHA-256withRSA", "SHA-256/RSA", "SHA256/RSA", "OID.1.2.840.113549.1.1.11", "1.2.840.113549.1.1.11"};
            servicesList.add(new SupportedServices("Signature", "SHA256withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA256withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  SHA256         is     available on the hardware");
            }
        }
        if (!rsasha384 && rsapkcs && !rsax509 && sha384 || !rsasha384 && rsapkcs && rsax509 && sha384) {
            aliases = new String[]{"SHA3withRSA", "SHA3/RSA", "SHA-384withRSA", "SHA-384/RSA", "SHA384/RSA", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
            servicesList.add(new SupportedServices("Signature", "SHA384withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA384withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  SHA384         is     available on the hardware");
            }
        }
        if (!rsasha384 && !rsapkcs && rsax509 && sha384) {
            aliases = new String[]{"SHA3withRSA", "SHA3/RSA", "SHA-384withRSA", "SHA-384/RSA", "SHA384/RSA", "OID.1.2.840.113549.1.1.12", "1.2.840.113549.1.1.12"};
            servicesList.add(new SupportedServices("Signature", "SHA384withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA384withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  SHA384         is     available on the hardware");
            }
        }
        if (!rsasha512 && rsapkcs && !rsax509 && sha512 || !rsasha512 && rsapkcs && rsax509 && sha512) {
            aliases = new String[]{"SHA5withRSA", "SHA5/RSA", "SHA-512withRSA", "SHA-512/RSA", "SHA512/RSA", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
            servicesList.add(new SupportedServices("Signature", "SHA512withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 1));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA512withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_PKCS       is     available on the hardware");
                System.out.println("\nConfig.java:  SHA512         is     available on the hardware");
            }
        }
        if (!rsasha512 && !rsapkcs && rsax509 && sha512) {
            aliases = new String[]{"SHA5withRSA", "SHA5/RSA", "SHA-512withRSA", "SHA-512/RSA", "SHA512/RSA", "OID.1.2.840.113549.1.1.13", "1.2.840.113549.1.1.13"};
            servicesList.add(new SupportedServices("Signature", "SHA512withRSA", "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA", aliases, 3));
            if (debug != null) {
                System.out.println("\nConfig.java:  SHA512withRSA  is NOT available on the hardware");
                System.out.println("\nConfig.java:  RSA_X_509      is     available on the hardware");
                System.out.println("\nConfig.java:  SHA512         is     available on the hardware");
            }
        }
        if (!dsasha && dsa && sha) {
            aliases = new String[]{"PKCS11SHA1withDSA", "SHA-1withDSA", "SHA-1/DSA", "SHA1/DSA", "SHA/DSA", "SHAwithDSA", "DSAwithSHA1", "DSA", "DSS", "OID.1.3.14.3.2.13", "1.3.14.3.2.13", "OID.1.2.840.10040.4.3", "1.2.840.10040.4.3", "OID.1.3.14.3.2.27", "1.3.14.3.2.27"};
            servicesList.add(new SupportedServices("Signature", "SHA1withDSA", "com.ibm.crypto.pkcs11impl.provider.PKCS11SHA1withDSASingle", aliases, 17));
        }
        aliases = new String[]{"PKCS11DeviceRNG"};
        servicesList.add(new SupportedServices("SecureRandom", "IBMSecureRandom", "com.ibm.crypto.pkcs11impl.provider.SecureRandom", aliases, -1));
        aliases = new String[]{"X.509"};
        servicesList.add(new SupportedServices("CertificateFactory", "X509", "com.ibm.crypto.pkcs11impl.provider.X509Factory", aliases, -1));
        aliases = null;
        servicesList.add(new SupportedServices("KeyStore", "PKCS11IMPLKS", "com.ibm.crypto.pkcs11impl.provider.PKCS11KeyStore", aliases, -1));
        return servicesList;
    }

    private ArrayList<Integer> convertToArrayList(int[] list) {
        int len = list.length;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            arrayList.add(new Integer(list[i]));
        }
        return arrayList;
    }

    public static void main(String[] args) {
        try {
            String s;
            int i;
            String name = Config.getProviderNameSuffix(args[0]);
            String desc = Config.getDescription(args[0]);
            System.out.println("Testing the static methods");
            System.out.println(name + " " + desc);
            System.out.println("****************************");
            System.out.println("Testing the object methods");
            Config config = new Config(args[0]);
            System.out.println("library = " + config.getLibraryName());
            System.out.println("name = " + config.getProviderNameSuffix());
            System.out.println("description = " + config.getDescription());
            System.out.println("tokenlabel = " + config.getTokenLabel());
            System.out.println("slotindex = " + config.getSlotIndex());
            System.out.println("slot = " + config.getSlot());
            ArrayList<Integer> al = config.getDisabledMechanisms();
            if (al != null) {
                System.out.print("disabledMechanisms = ");
                for (i = 0; i < al.size(); ++i) {
                    s = PKCS11Mechanism.typeToString((int)al.get(i));
                    System.out.print(s + ", ");
                }
                System.out.println("");
            }
            if ((al = config.getEnabledMechanisms()) != null) {
                System.out.print("enabledMechanisms = ");
                for (i = 0; i < al.size(); ++i) {
                    s = PKCS11Mechanism.typeToString((int)al.get(i));
                    System.out.print(s + ", ");
                }
                System.out.println("");
            }
            HashMap<Integer, Object> hm = config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.AES);
            System.out.print("Attributes = ");
            for (Map.Entry<Integer, Object> entry : hm.entrySet()) {
                String key = PKCS11Object.typeToString((int)entry.getKey());
                System.out.print(key + " = " + entry.getValue() + ", ");
            }
            System.out.println();
            System.out.println();
            System.out.println("Testing SupportedServices:");
            int[] tokenMechanisms = new int[]{0, 3, 5, 307, 306, 305, 528, 4160, 4160, 4161, 4162, 4176, 4177, 4178};
            SupportedServices[] services = config.getSupportedServices(tokenMechanisms);
            for (int i2 = 0; i2 < services.length; ++i2) {
                System.out.println("Service[" + i2 + "]:");
                System.out.println("Type:" + services[i2].getType());
                System.out.println("Algorithm:" + services[i2].getAlgorithm());
                System.out.println("ClassName:" + services[i2].getClassName());
                System.out.println("Alaises:");
                String[] myAlaises = services[i2].getAlaises();
                if (myAlaises != null) {
                    for (int ii = 0; ii < myAlaises.length; ++ii) {
                        System.out.println(myAlaises[ii]);
                    }
                    System.out.println("\n\n");
                }
                System.out.println();
            }
            System.out.println("\n. . . done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        OPERATIONS.put("GENERATE", new Integer(1));
        OPERATIONS.put("IMPORT", new Integer(2));
        OPERATIONS.put("*", new Integer(3));
        KEYTYPE.put("CKO_PUBLIC_KEY", new Integer(4));
        KEYTYPE.put("PUBLIC_KEY", new Integer(4));
        KEYTYPE.put("CKO_PRIVATE_KEY", new Integer(8));
        KEYTYPE.put("PRIVATE_KEY", new Integer(8));
        KEYTYPE.put("CKO_SECRET_KEY", new Integer(16));
        KEYTYPE.put("SECRET_KEY", new Integer(16));
        KEYTYPE.put("*", new Integer(28));
        ALGORITHMS.put("CKK_RSA", new Integer(32));
        ALGORITHMS.put("RSA", new Integer(32));
        ALGORITHMS.put("CKK_DSA", new Integer(64));
        ALGORITHMS.put("DSA", new Integer(64));
        ALGORITHMS.put("CKK_DH", new Integer(128));
        ALGORITHMS.put("DH", new Integer(128));
        ALGORITHMS.put("CKK_AES", new Integer(256));
        ALGORITHMS.put("AES", new Integer(256));
        ALGORITHMS.put("CKK_DES", new Integer(512));
        ALGORITHMS.put("DES", new Integer(512));
        ALGORITHMS.put("CKK_DES3", new Integer(1024));
        ALGORITHMS.put("DES3", new Integer(1024));
        ALGORITHMS.put("CKK_RC4", new Integer(2048));
        ALGORITHMS.put("RC4", new Integer(2048));
        ALGORITHMS.put("CKK_BLOWFISH", new Integer(4096));
        ALGORITHMS.put("BLOWFISH", new Integer(4096));
        ALGORITHMS.put("CKK_GENERIC_SECRET", new Integer(8192));
        ALGORITHMS.put("GENERIC_SECRET", new Integer(8192));
        ALGORITHMS.put("CKK_GENERIC_SECRET", new Integer(8192));
        ALGORITHMS.put("MAC", new Integer(8192));
        ALGORITHMS.put("CKK_EC", new Integer(16384));
        ALGORITHMS.put("EC", new Integer(16384));
        ALGORITHMS.put("CKK_ECDSA", new Integer(16384));
        ALGORITHMS.put("ECDSA", new Integer(16384));
        ALGORITHMS.put("*", new Integer(-32));
        des_secret_class.addItem(1, Boolean.FALSE);
        des_secret_class.addItem(259, Boolean.FALSE);
        des_secret_class.addItem(260, Boolean.TRUE);
        des_secret_class.addItem(261, Boolean.TRUE);
        des_secret_class.addItem(262, Boolean.FALSE);
        des_secret_class.addItem(263, Boolean.FALSE);
        des3_secret_class.addItem(1, Boolean.FALSE);
        des3_secret_class.addItem(259, Boolean.FALSE);
        des3_secret_class.addItem(260, Boolean.TRUE);
        des3_secret_class.addItem(261, Boolean.TRUE);
        des3_secret_class.addItem(262, Boolean.FALSE);
        des3_secret_class.addItem(263, Boolean.FALSE);
        dsa_private_class.addItem(2, Boolean.TRUE);
        dsa_private_class.addItem(1, Boolean.FALSE);
        dsa_private_class.addItem(259, Boolean.FALSE);
        dsa_private_class.addItem(264, Boolean.TRUE);
        dsa_public_class.addItem(2, Boolean.FALSE);
        dsa_public_class.addItem(1, Boolean.FALSE);
        dsa_public_class.addItem(266, Boolean.TRUE);
        rsa_private_class.addItem(2, Boolean.TRUE);
        rsa_private_class.addItem(1, Boolean.FALSE);
        rsa_private_class.addItem(259, Boolean.FALSE);
        rsa_private_class.addItem(261, Boolean.TRUE);
        rsa_private_class.addItem(263, Boolean.TRUE);
        rsa_private_class.addItem(264, Boolean.TRUE);
        rsa_public_class.addItem(2, Boolean.FALSE);
        rsa_public_class.addItem(1, Boolean.FALSE);
        rsa_public_class.addItem(266, Boolean.TRUE);
        rsa_public_class.addItem(260, Boolean.TRUE);
        rsa_public_class.addItem(262, Boolean.TRUE);
    }
}

