/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.tools.attach.target.Advertisement;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.TargetDirectory;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

final class OpenJ9VirtualMachineDescriptor
extends VirtualMachineDescriptor {
    private final String replyFile;
    private final String attachSyncFileValue;
    private final long processId;
    private final long uid;

    @Override
    public boolean equals(Object comparand) {
        return super.equals(comparand);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider provider, String id, String displayName) {
        super(provider, id, displayName);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider provider, String id) {
        super(provider, id);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider provider, Advertisement advert) {
        super(provider, advert.getVmId(), advert.getDisplayName());
        this.replyFile = advert.getReplyFile();
        this.attachSyncFileValue = advert.getNotificationSync();
        this.processId = advert.getProcessId();
        this.uid = advert.getUid();
    }

    long getProcessId() {
        return this.processId;
    }

    static OpenJ9VirtualMachineDescriptor fromAdvertisement(AttachProvider provider, File advertFile) {
        Advertisement advert = null;
        try (FileInputStream propStream = new FileInputStream(advertFile);){
            advert = Advertisement.readAdvertisementFile((InputStream)propStream);
        }
        catch (IOException e) {
            IPC.logMessage((String)"could not read advertisement file ", (String)advertFile.getAbsolutePath());
            return null;
        }
        OpenJ9VirtualMachineDescriptor vmd = new OpenJ9VirtualMachineDescriptor(provider, advert);
        return vmd;
    }

    String getReplyFile() {
        return this.replyFile;
    }

    String getAttachSyncFileValue() {
        String asFile = this.attachSyncFileValue;
        if (null == asFile) {
            asFile = TargetDirectory.createSyncFileObject((String)this.id()).getAbsolutePath();
        }
        return asFile;
    }

    long getUid() {
        return this.uid;
    }
}

