/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachine;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachineDescriptor;
import com.ibm.tools.attach.target.Advertisement;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.CommonDirectory;
import com.ibm.tools.attach.target.IPC;
import com.ibm.tools.attach.target.TargetDirectory;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenJ9AttachProvider
extends AttachProvider {
    @Override
    public VirtualMachine attachVirtualMachine(String id) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        try {
            OpenJ9VirtualMachine vm = new OpenJ9VirtualMachine(this, id);
            vm.attachTarget();
            return vm;
        }
        catch (NullPointerException e) {
            AttachNotSupportedException exc = new AttachNotSupportedException(Msg.getString((String)"K0554"));
            exc.initCause(e);
            throw exc;
        }
    }

    @Override
    public VirtualMachine attachVirtualMachine(VirtualMachineDescriptor descriptor) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        if (!(descriptor.provider() instanceof OpenJ9AttachProvider)) {
            throw new AttachNotSupportedException(Msg.getString((String)"K0543"));
        }
        OpenJ9VirtualMachine vm = new OpenJ9VirtualMachine(this, descriptor.id());
        vm.attachTarget();
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        AttachHandler.waitForAttachApiInitialization();
        File commonDir = CommonDirectory.getCommonDirFileObject();
        ArrayList<VirtualMachineDescriptor> descriptors = new ArrayList<VirtualMachineDescriptor>();
        if (null == commonDir) {
            IPC.logMessage((String)"listVirtualMachines() error getting common directory");
            return null;
        }
        if (!commonDir.exists()) {
            IPC.logMessage((String)"listVirtualMachines() common directory is absent");
            return descriptors;
        }
        if (!commonDir.isDirectory()) {
            IPC.logMessage((String)"listVirtualMachines() common directory is mis-configured");
            return null;
        }
        try {
            CommonDirectory.obtainMasterLock();
        }
        catch (IOException e) {
            IPC.logMessage((String)"listVirtualMachines() IOError on master lock : ", (String)e.toString());
            return descriptors;
        }
        try {
            File[] vmDirs = commonDir.listFiles();
            if (vmDirs == null) {
                ArrayList<VirtualMachineDescriptor> arrayList = descriptors;
                return arrayList;
            }
            long myUid = IPC.getUid();
            for (File f : vmDirs) {
                if (!f.isDirectory() || !CommonDirectory.isFileOwnedByUid((File)f, (long)myUid)) continue;
                boolean staleDirectory = true;
                File advertisment = new File(f, Advertisement.getFilename());
                long uid = 0L;
                if (advertisment.exists()) {
                    OpenJ9VirtualMachineDescriptor descriptor = OpenJ9VirtualMachineDescriptor.fromAdvertisement(this, advertisment);
                    if (null != descriptor) {
                        long pid = descriptor.getProcessId();
                        uid = descriptor.getUid();
                        if (0L == pid || IPC.processExists((long)pid)) {
                            descriptors.add(descriptor);
                            staleDirectory = false;
                        }
                    }
                    if (myUid != 0L && 0L == uid) {
                        uid = CommonDirectory.getFileOwner((String)advertisment.getAbsolutePath());
                    }
                }
                if (!staleDirectory || myUid != 0L && uid != myUid) continue;
                IPC.logMessage((String)"listVirtualMachines() removing stale directory : ", (String)f.getName());
                TargetDirectory.deleteTargetDirectory((String)f.getName());
            }
        }
        finally {
            CommonDirectory.releaseMasterLock();
        }
        return descriptors;
    }

    VirtualMachineDescriptor getDescriptor(String id) {
        List<VirtualMachineDescriptor> vmds = this.listVirtualMachines();
        if (null != vmds) {
            for (VirtualMachineDescriptor vmd : vmds) {
                if (!vmd.id().equalsIgnoreCase(id)) continue;
                return vmd;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "IBM";
    }

    @Override
    public String type() {
        return "Java SE";
    }

    private static void checkAttachSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.ATTACH_VM);
        }
    }

    static class Permissions {
        static final AttachPermission ATTACH_VM = new AttachPermission("attachVirtualMachine", null);

        Permissions() {
        }
    }
}

