/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringDataProvider
implements DataProvider {
    private String name;
    private String bucket;
    private String tag;
    private int updateFrequency = 120;
    private int maxSend = -1;
    private boolean available = true;
    private int[] lastGot = new int[1];

    public static native byte[] getData(String var0, int var1, int[] var2);

    public static native void sendMessage(String var0, String var1);

    public static native String getSourceDetails(String var0);

    public MonitoringDataProvider(String name) {
        this.bucket = name;
        this.name = name;
        this.tag = name;
        this.lastGot[0] = 0;
        if (name.equalsIgnoreCase("classhistogram")) {
            this.updateFrequency = 20;
            this.tag = "ClassHistogramSource";
        } else if (name.equalsIgnoreCase("cpu")) {
            this.tag = "CpuSource";
            this.updateFrequency = 2;
        } else if (name.equalsIgnoreCase("environment")) {
            this.updateFrequency = 1200;
            this.tag = "EnvironmentSource";
        } else if (name.equalsIgnoreCase("locking")) {
            this.tag = "JLASource";
        } else if (name.equalsIgnoreCase("logger")) {
            this.available = false;
        } else if (name.equalsIgnoreCase("memory")) {
            this.updateFrequency = 5;
            this.tag = "MemorySource";
        } else if (name.equalsIgnoreCase("memorycounters")) {
            this.updateFrequency = 5;
            this.tag = "MemoryCountersSource";
        } else if (name.equalsIgnoreCase("methoddictionary")) {
            this.tag = "MethodDictionarySource";
            this.updateFrequency = 5;
            this.maxSend = 200000;
        } else if (name.equalsIgnoreCase("rt")) {
            this.available = false;
        } else if (name.equalsIgnoreCase("threads")) {
            this.updateFrequency = 30;
            this.tag = "ThreadsSource";
        } else if (name.equalsIgnoreCase("trace")) {
            this.tag = "TRACESubscriberSource";
            this.maxSend = 100000;
            this.updateFrequency = 5;
        } else if (name.equalsIgnoreCase("tprof")) {
            this.updateFrequency = 2;
        }
    }

    @Override
    public boolean isDataSupported() {
        return this.available;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        String config = MonitoringDataProvider.getSourceDetails(this.bucket);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.tag);
        map.put("version", "3.0");
        map.put("suggested_update_frequency", Integer.toString(this.updateFrequency));
        map.put("max_bytes_to_send", Integer.toString(this.maxSend));
        map.put("state", config);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getJMXData() {
        byte[] data = null;
        String string = this.bucket;
        synchronized (string) {
            data = MonitoringDataProvider.getData(this.bucket, this.maxSend, this.lastGot);
        }
        if (data == null) {
            data = new byte[]{};
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetData() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSession() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    @Override
    public void modify(String command, String ... params) throws ProviderModificationException {
        StringBuffer sb = new StringBuffer();
        sb.append(command);
        for (String param : params) {
            sb.append(',');
            sb.append(param);
        }
        MonitoringDataProvider.sendMessage(this.name, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartProvider() {
        String string = this.bucket;
        synchronized (string) {
            this.lastGot[0] = 0;
        }
    }

    @Override
    public void headlessFileInitialise() {
    }
}

