/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Properties;
import sun.misc.BASE64Encoder;

public class SystemUtils {
    public static final long microTime() {
        if (Config.isJavaVersionAtLeast15()) {
            return System.nanoTime() / 1000L;
        }
        return System.currentTimeMillis() * 1000L;
    }

    public static String getJarPath(Class clazz) {
        String string;
        block6: {
            String string2 = "/" + clazz.getName().replace('.', '/') + ".class";
            URL uRL = Object.class.getResource(string2);
            if (uRL == null) {
                return null;
            }
            string = null;
            if (uRL.getProtocol().equals("jar")) {
                try {
                    URL uRL2 = new URL(uRL.getFile());
                    int n = uRL2.getFile().lastIndexOf("!");
                    if (n != -1) {
                        string = uRL2.getFile().substring(0, n);
                        break block6;
                    }
                    string = uRL2.getFile();
                }
                catch (Exception exception) {
                    string = "SHOULD NEVER HAPPEN";
                }
            } else {
                int n = uRL.getPath().length() - string2.length();
                string = uRL.getPath().substring(0, n);
            }
        }
        return new File(URLDecoder.decode(string)).getPath();
    }

    public static String priviledgedGetSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static boolean priviledgedIsDirectory(final File file) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return file.isDirectory();
            }
        });
        return bl;
    }

    public static boolean isPathFromCache(String string) {
        String string2 = SystemUtils.getCanonicalPath(Config.getCacheDirectory());
        String string3 = SystemUtils.getCanonicalPath(Config.getSystemCacheDirectory());
        String string4 = SystemUtils.getCanonicalPath(string);
        if (string4 != null) {
            return string2 != null && string4.startsWith(string2) || string3 != null && string4.startsWith(string3);
        }
        return false;
    }

    private static String getCanonicalPath(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getSimpleName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getSimpleName();
        }
        catch (Throwable throwable) {
            return clazz.getName();
        }
    }

    public static int getThreadLocalInt(ThreadLocal threadLocal) {
        Integer n = null;
        if (threadLocal.get() instanceof Integer) {
            n = (Integer)threadLocal.get();
        }
        if (n == null) {
            n = SystemUtils.integerValueOf(0);
            threadLocal.set(n);
        }
        return n;
    }

    public static void setThreadLocalInt(ThreadLocal threadLocal, int n) {
        if (Config.isJavaVersionAtLeast15()) {
            threadLocal.set(n);
        } else {
            threadLocal.set(new Integer(n));
        }
    }

    public static Integer integerValueOf(int n) {
        if (Config.isJavaVersionAtLeast15()) {
            return n;
        }
        return new Integer(n);
    }

    public static Long longValueOf(long l) {
        if (Config.isJavaVersionAtLeast15()) {
            return l;
        }
        return new Long(l);
    }

    public static boolean deleteRecursive(File file) throws FileNotFoundException {
        boolean bl = true;
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                bl = bl && SystemUtils.deleteRecursive(fileArray[i]);
            }
        }
        return bl && file.delete();
    }

    public static byte[] readBytes(InputStream inputStream, long l) throws IOException {
        byte[] byArray;
        if (l > 0x100000L) {
            throw new IOException("File too large");
        }
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        if (l <= 0L) {
            l = 10240L;
        }
        byte[] byArray2 = new byte[(int)l];
        int n = 0;
        int n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        while (n2 != -1) {
            if (byArray2.length == (n += n2)) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            n2 = bufferedInputStream.read(byArray2, n, byArray2.length - n);
        }
        bufferedInputStream.close();
        inputStream.close();
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static String encodeString(String string) {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(string.getBytes());
    }

    public static String getChecksum(byte[] byArray, String string) {
        String string2 = null;
        if (string == null) {
            string = "SHA-256";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(byArray, 0, byArray.length);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            string2 = bASE64Encoder.encode(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.ignored(noSuchAlgorithmException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileChecksum(File file, String string) {
        int n;
        String string2 = null;
        BufferedInputStream bufferedInputStream = null;
        if (string == null) {
            string = "SHA-256";
        }
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[8192];
        for (int i = byArray.length; i > 0 && (n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1; i -= n) {
            messageDigest.update(byArray, 0, n);
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        string2 = bASE64Encoder.encode(messageDigest.digest());
        Object var10_11 = null;
        if (bufferedInputStream == null) return string2;
        try {
            bufferedInputStream.close();
            return string2;
        }
        catch (IOException iOException) {}
        return string2;
        {
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.ignored(noSuchAlgorithmException);
                Object var10_12 = null;
                if (bufferedInputStream == null) return string2;
                try {
                    bufferedInputStream.close();
                    return string2;
                }
                catch (IOException iOException) {}
                return string2;
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
                Object var10_13 = null;
                if (bufferedInputStream == null) return string2;
                try {
                    bufferedInputStream.close();
                    return string2;
                }
                catch (IOException iOException2) {}
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void setHttpsProtocols(Properties properties) {
        if (properties.get("https.protocols") == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (Config.isJavaVersionAtLeast17() && Config.getBooleanProperty("deployment.security.TLSv1.2")) {
                stringBuilder.append("TLSv1.2");
            }
            if (Config.isJavaVersionAtLeast17() && Config.getBooleanProperty("deployment.security.TLSv1.1")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("TLSv1.1");
            }
            if (Config.getBooleanProperty("deployment.security.TLSv1")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("TLSv1");
            }
            if (Config.getBooleanProperty("deployment.security.SSLv3")) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("SSLv3");
            }
            properties.put("https.protocols", stringBuilder.toString());
        }
    }

    public static int parsePercent(String string, int n) throws NumberFormatException {
        if (string.endsWith("%")) {
            String string2 = string.substring(0, string.length() - 1);
            int n2 = Integer.parseInt(string2);
            return n * Math.min(n2, 100) / 100;
        }
        return Integer.parseInt(string);
    }

    public static String convertJVMParameterForRelaunch(String string) {
        String[] stringArray;
        if (!Config.getBooleanProperty("deployment.relaunch.increment.debug.port") || !SystemUtils.isJdwpDtSocketServerDebugParam(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split(",")) {
            try {
                if (string2.startsWith("address=")) {
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length == 2) {
                        String[] stringArray3 = stringArray2[1].split(":");
                        int n = Integer.parseInt(stringArray3[stringArray3.length - 1]);
                        int n2 = n + 1;
                        stringArray2[1] = stringArray3.length == 1 ? "" + n2 : stringArray3[0] + ":" + n2;
                    }
                    string2 = stringArray2[0] + "=" + stringArray2[1];
                }
            }
            catch (NumberFormatException numberFormatException) {
                Trace.ignored(numberFormatException);
            }
            stringBuilder.append(string2);
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static boolean isJdwpDtSocketServerDebugParam(String string) {
        return string != null && string.startsWith("-agentlib:jdwp") && string.indexOf("=transport=dt_socket") > 0 && string.indexOf(",server=y") > 0 && string.indexOf(",address=") > 0;
    }
}

