/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;
import sun.net.www.protocol.http.HttpURLConnection;

public class CrossDomainXML {
    static final String ALT_XDOMAIN_FILES = "jnlp.altCrossDomainXMLFiles";
    public static final int CHECK_RESOLVE = -1;
    public static final int CHECK_SET_HOST = -2;
    public static final int CHECK_SUBPATH = -3;
    public static final int CHECK_CONNECT = -4;
    private static final AccessControlContext noPermissionACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, null)});
    private static final AccessControlContext onlyConnectACC;
    private static final ReentrantLock lock;
    private static final Integer NO_ACCESS;
    private static final Integer URL_CONNECTIONS;
    private static final Integer SOCKET_CONNECTIONS;
    private static final Map domains;
    private static final Map allowedURLs;
    private static List alternateURLs;
    private static String POLICY_FILE_PATH;
    private static final String DTD_DOWNLOAD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String DTD_VALIDATION = "http://xml.org/sax/features/validation";
    private static final String EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETERS = "http://xml.org/sax/features/external-parameter-entities";

    private CrossDomainXML() {
    }

    private static boolean isProcessed(String string, int n) {
        return domains.containsKey(CrossDomainXML.getDomainID(string, n));
    }

    private static boolean hasURLLevelAccess(String string, int n) {
        Integer n2 = (Integer)domains.get(CrossDomainXML.getDomainID(string, n));
        return n2 != null && n2 != NO_ACCESS;
    }

    private static boolean hasSocketLevelAccess(String string, int n) {
        return domains.get(CrossDomainXML.getDomainID(string, n)) == SOCKET_CONNECTIONS;
    }

    private static void allowNoAccess(String string, int n) {
        CrossDomainXML.addAccess(string, n, NO_ACCESS);
    }

    private static void allowURLLevelAccess(String string, int n) {
        CrossDomainXML.addAccess(string, n, URL_CONNECTIONS);
    }

    private static void allowSocketLevelAccess(String string, int n) {
        CrossDomainXML.addAccess(string, n, SOCKET_CONNECTIONS);
    }

    private static String getDomainID(String string, int n) {
        if (!(string = string.toLowerCase()).startsWith("[") && string.indexOf(58) != -1) {
            string = "[" + string + "]";
        }
        return string + ":" + n;
    }

    private static void addAccess(String string, int n, Integer n2) {
        String string2;
        InetAddress inetAddress;
        String string3;
        block3: {
            string3 = CrossDomainXML.getDomainID(string, n);
            CrossDomainXML.doAddAccess(string3, n2);
            inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        if (inetAddress != null && !string3.equals(string2 = CrossDomainXML.getDomainID(inetAddress.getHostAddress(), n))) {
            CrossDomainXML.doAddAccess(string2, n2);
        }
    }

    private static void doAddAccess(String string, Integer n) {
        Integer n2 = (Integer)domains.get(string);
        if (n2 == null || n2 < n) {
            domains.put(string, n);
        }
    }

    private static URL getMasterPolicyFileURL(String string, String string2, int n) throws MalformedURLException {
        return new URL(string, string2, n, POLICY_FILE_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean check(Class[] classArray, URL uRL, String string, int n, boolean bl) {
        try {
            block14: {
                boolean bl4;
                lock.lock();
                try {
                    if (CrossDomainXML.quickFullCheck(classArray, uRL, string, n, bl)) {
                        boolean bl2 = true;
                        Object var14_8 = null;
                        lock.unlock();
                        return bl2;
                    }
                    boolean bl3 = false;
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    String string2 = uRL != null ? uRL.getProtocol() : "http";
                    if (!CrossDomainXML.isProcessed(string, n)) {
                        arrayList.add(CrossDomainXML.getMasterPolicyFileURL(string2, string, n));
                    }
                    List list = CrossDomainXML.getAlternatePolicyFilesURLs();
                    for (URL uRL2 : list) {
                        int n2 = uRL2.getPort();
                        if (n2 == -1) {
                            n2 = uRL2.getDefaultPort();
                        }
                        if (!string2.equalsIgnoreCase(uRL2.getProtocol()) || !string.equalsIgnoreCase(uRL2.getHost()) || n != n2) continue;
                        arrayList.add(uRL2);
                    }
                    for (URL uRL2 : arrayList) {
                        if (!CrossDomainXML.check(uRL2)) {
                            CrossDomainXML.allowNoAccess(string, n);
                            continue;
                        }
                        if (uRL2.getPath().equals("/crossdomain.xml")) {
                            CrossDomainXML.allowSocketLevelAccess(string, n);
                        } else {
                            CrossDomainXML.allowURLLevelAccess(string, n);
                        }
                        String string3 = CrossDomainXML.getDomainID(string, n);
                        ArrayList<URL> arrayList2 = (ArrayList<URL>)allowedURLs.get(string3);
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<URL>();
                            arrayList2.add(uRL2);
                            allowedURLs.put(string3, arrayList2);
                        } else {
                            arrayList2.add(uRL2);
                        }
                        bl3 = true;
                    }
                    if (!bl3 || !CrossDomainXML.quickFullCheck(classArray, uRL, string, n, bl)) break block14;
                    bl4 = true;
                }
                catch (Throwable throwable) {
                    Object var14_11 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var14_9 = null;
                lock.unlock();
                return bl4;
            }
            Object var14_10 = null;
            lock.unlock();
            return false;
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
            if (!(throwable instanceof ThreadDeath)) return false;
            throw (ThreadDeath)throwable;
        }
    }

    private static boolean quickFullCheck(Class[] classArray, URL uRL, String string, int n, boolean bl) {
        String string2;
        List list;
        if (CrossDomainXML.quickCheck(classArray, string, n)) {
            return true;
        }
        if (bl) {
            return false;
        }
        if (!CrossDomainXML.hasURLLevelAccess(string, n)) {
            return false;
        }
        if (!CrossDomainXML.checkContext(classArray, HttpURLConnection.class)) {
            return false;
        }
        return uRL == null || CrossDomainXML.checkSubpath(uRL, list = (List)allowedURLs.get(string2 = CrossDomainXML.getDomainID(string, n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean quickCheck(Class[] classArray, String string, int n) {
        block4: {
            if (n == -1 && CrossDomainXML.checkContext(classArray, Socket.class)) {
                return true;
            }
            lock.lock();
            try {
                if (!CrossDomainXML.hasSocketLevelAccess(string, n)) break block4;
                boolean bl = true;
                Object var5_4 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        lock.unlock();
        return false;
    }

    private static boolean checkContext(Class[] classArray, Class clazz) {
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i].getClassLoader() != null) {
                return false;
            }
            if (!clazz.isAssignableFrom(classArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSubpath(URL uRL, List list) {
        String string = uRL.getPath();
        if (string == "") {
            string = "/";
        }
        for (URL uRL2 : list) {
            String string2;
            int n;
            String string3 = uRL2.getPath();
            if (string3 == "") {
                string3 = "/";
            }
            if ((n = string3.lastIndexOf(47)) == -1 || !string.startsWith(string2 = string3.substring(0, n + 1))) continue;
            return true;
        }
        return false;
    }

    private static List getAlternatePolicyFilesURLs() {
        block7: {
            if (alternateURLs == null) {
                alternateURLs = new ArrayList();
                try {
                    String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperty(CrossDomainXML.ALT_XDOMAIN_FILES);
                        }
                    });
                    if (string != null) {
                        String[] stringArray = string.split(",");
                        for (int i = 0; i < stringArray.length; ++i) {
                            String string2 = stringArray[i];
                            if (string2 == null) continue;
                            try {
                                URL uRL = new URL(string2);
                                if (!"http".equalsIgnoreCase(uRL.getProtocol()) && !"https".equalsIgnoreCase(uRL.getProtocol())) continue;
                                alternateURLs.add(uRL);
                                continue;
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        return alternateURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean check(URL uRL) {
        try {
            final Handler handler = new Handler();
            try {
                BufferedInputStream bufferedInputStream;
                URLConnection uRLConnection = uRL.openConnection();
                int n = lock.getHoldCount();
                try {
                    for (int i = 0; i < n; ++i) {
                        lock.unlock();
                    }
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
                try {
                    CrossDomainXML.privilegedConnect(uRLConnection);
                    bufferedInputStream = null;
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    for (int i = 0; i < n; ++i) {
                        lock.lock();
                    }
                    throw throwable;
                }
                for (int i = 0; i < n; ++i) {
                    lock.lock();
                }
                final SAXParser sAXParser = CrossDomainXML.getParser();
                InputStream inputStream = uRLConnection.getInputStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws SAXException, IOException {
                            sAXParser.parse(bufferedInputStream, (DefaultHandler)handler);
                            return null;
                        }
                    }, noPermissionACC);
                    Object var9_17 = null;
                    if (bufferedInputStream == null) return handler.isAllowed();
                }
                catch (Throwable throwable) {
                    Object var9_18 = null;
                    if (bufferedInputStream == null) throw throwable;
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                ((InputStream)bufferedInputStream).close();
                return handler.isAllowed();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return handler.isAllowed();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                if (!Trace.isEnabled()) return handler.isAllowed();
                Trace.msgNetPrintln("CrossDomainXML: cannot parse crossdomain.xml. You may be running in a JRE older than version 6.0");
            }
            return handler.isAllowed();
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            return false;
        }
        catch (Throwable throwable) {
            if (!Trace.isEnabled()) return false;
            throwable.printStackTrace();
        }
        return false;
    }

    private static void privilegedConnect(final URLConnection uRLConnection) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    uRLConnection.connect();
                    return null;
                }
            }, onlyConnectACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new Error(privilegedActionException);
        }
    }

    static SAXParser getParser() throws SAXNotRecognizedException, ParserConfigurationException, SAXNotSupportedException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance("org.apache.xerces.jaxp.SAXParserFactoryImpl", null);
        sAXParserFactory.setFeature(DTD_DOWNLOAD, false);
        sAXParserFactory.setFeature(DTD_VALIDATION, false);
        sAXParserFactory.setFeature(EXTERNAL_ENTITIES, false);
        sAXParserFactory.setFeature(EXTERNAL_PARAMETERS, false);
        return sAXParserFactory.newSAXParser();
    }

    static void resetForUnitTests() {
        domains.clear();
        allowedURLs.clear();
        alternateURLs = null;
    }

    private static boolean checkFile(final String string) {
        block3: {
            try {
                final Handler handler = new Handler();
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block3: {
                            try {
                                SAXParser sAXParser = CrossDomainXML.getParser();
                                sAXParser.parse(new File(string), (DefaultHandler)handler);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                if (!Trace.isEnabled()) break block3;
                                Trace.msgNetPrintln("CrossDomainXML: cannot parse crossdomain.xml. You may be running in a JRE older than version 6.0");
                            }
                        }
                        return null;
                    }
                });
                return handler.isAllowed();
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
            catch (Throwable throwable) {
                if (!Trace.isEnabled()) break block3;
                throwable.printStackTrace();
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i] + ": " + (CrossDomainXML.check(new Class[0], null, stringArray[i], -1, false) ? "Allowed" : "Denied"));
        }
    }

    static {
        Permissions permissions = new Permissions();
        ((PermissionCollection)permissions).add(new SocketPermission("*", "connect"));
        if (Config.isJavaVersionAtLeast18()) {
            ((PermissionCollection)permissions).add(new URLPermission("http:*", "*:*"));
            ((PermissionCollection)permissions).add(new URLPermission("https:*", "*:*"));
        }
        ((PermissionCollection)permissions).add(new RuntimePermission("modifyThread"));
        ((PermissionCollection)permissions).add(new RuntimePermission("modifyThreadGroup"));
        onlyConnectACC = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissions)});
        lock = new ReentrantLock();
        NO_ACCESS = new Integer(0);
        URL_CONNECTIONS = new Integer(1);
        SOCKET_CONNECTIONS = new Integer(2);
        domains = new HashMap();
        allowedURLs = new HashMap();
        POLICY_FILE_PATH = "/crossdomain.xml";
    }

    private static class Handler
    extends DefaultHandler {
        private static final int INITIAL = 0;
        private static final int IN_CROSS_DOMAIN_POLICY = 1;
        private static final int ALLOWED = 2;
        private static final int DENIED = 3;
        private static final int UNKNOWN = 4;
        private int depth = 0;
        private int state = 0;
        private int result = 4;

        private Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ++this.depth;
            switch (this.state) {
                case 0: {
                    if (this.depth != 1 || !string3.equals("cross-domain-policy")) break;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (this.depth != 2) break;
                    if (string3.equals("allow-access-from")) {
                        String string4 = attributes.getValue("domain");
                        if (string4.equals("*") && this.result == 4) {
                            this.result = 2;
                            break;
                        }
                        this.result = 3;
                        break;
                    }
                    if (string3.equals("site-control")) {
                        String string5 = attributes.getValue("permitted-cross-domain-policies");
                        if (string5 == null || string5.equals("none")) {
                            this.result = 3;
                            break;
                        }
                        if (string5.equals("master-only") || string5.equals("by-content-type") || string5.equals("by-ftp-filename") || string5.equals("all")) break;
                        this.result = 3;
                        break;
                    }
                    this.state = 0;
                    break;
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.depth;
        }

        public boolean isAllowed() {
            return this.result == 2;
        }
    }
}

