/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.framework.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.wsspi.channel.framework.ConnectionDescriptor;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.util.HashMap;
import java.util.Map;

public class VirtualConnectionImpl
implements VirtualConnection {
    private static final TraceComponent tc = Tr.register(VirtualConnectionImpl.class, "ChannelFramework", "com.ibm.ws.channel.resources.channelframeworkservice");
    private Map stateStore = null;
    private static int READ_PENDING = 4097;
    private static int READ_WAITING = 4098;
    private static int READ_FINISHING = 4100;
    private static int WRITE_PENDING = 4112;
    private static int WRITE_WAITING = 4128;
    private static int WRITE_FINISHING = 4160;
    private static int CLOSE_PENDING = 4352;
    private static int IN_USE_MASK = 4096;
    private static int IN_USE_MASK_CLEAR_OUT = ~IN_USE_MASK;
    private static int READ_PENDING_CLEAR_OUT = ~(READ_FINISHING | READ_WAITING) | IN_USE_MASK;
    private static int READ_FINISHING_CLEAR_OUT = ~(READ_PENDING | READ_WAITING) | IN_USE_MASK;
    private static int READ_WAITING_CLEAR_OUT = ~(READ_PENDING | READ_FINISHING) | IN_USE_MASK;
    private static int READ_DONE_CLEAR_OUT = ~(READ_PENDING | READ_FINISHING | READ_WAITING) | IN_USE_MASK;
    private static int WRITE_PENDING_CLEAR_OUT = ~(WRITE_FINISHING | WRITE_WAITING) | IN_USE_MASK;
    private static int WRITE_FINISHING_CLEAR_OUT = ~(WRITE_PENDING | WRITE_WAITING) | IN_USE_MASK;
    private static int WRITE_WAITING_CLEAR_OUT = ~(WRITE_PENDING | WRITE_FINISHING) | IN_USE_MASK;
    private static int WRITE_DONE_CLEAR_OUT = ~(WRITE_PENDING | WRITE_FINISHING | WRITE_WAITING) | IN_USE_MASK;
    private static int CLOSE_NOT_ALLOWED_MASK = (READ_PENDING | READ_FINISHING | WRITE_PENDING | WRITE_FINISHING | CLOSE_PENDING) & IN_USE_MASK_CLEAR_OUT;
    private static int FINISH_NOT_ALLOWED_MASK = CLOSE_PENDING & IN_USE_MASK_CLEAR_OUT;
    private static int READ_NOT_ALLOWED_MASK = (CLOSE_PENDING | READ_PENDING | READ_WAITING | READ_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int WRITE_NOT_ALLOWED_MASK = (CLOSE_PENDING | WRITE_PENDING | WRITE_WAITING | WRITE_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int READ_OUTSTANDING = (READ_PENDING | READ_WAITING | READ_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private static int WRITE_OUTSTANDING = (WRITE_PENDING | WRITE_WAITING | WRITE_FINISHING) & IN_USE_MASK_CLEAR_OUT;
    private boolean closeWaiting = false;
    private int currentState = 0;
    private boolean readOutWithClosePending = false;
    private boolean writeOutWithClosePending = false;
    private boolean inetAddressingValid = true;
    private ConnectionDescriptor connDesc = null;
    private int fileChannelCapable = 0;

    protected VirtualConnectionImpl() {
    }

    protected void init() {
        this.stateStore = new HashMap();
        this.fileChannelCapable = 0;
    }

    public void destroy() {
    }

    public Map getStateMap() {
        return this.stateStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPermissionToRead() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & READ_NOT_ALLOWED_MASK) == 0) {
                this.currentState = (this.currentState | READ_PENDING) & READ_PENDING_CLEAR_OUT;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToRead returning true");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic requestPermissionToRead returning false");
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPermissionToWrite() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & WRITE_NOT_ALLOWED_MASK) == 0) {
                this.currentState = (this.currentState | WRITE_PENDING) & WRITE_PENDING_CLEAR_OUT;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToWrite returning true");
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic requestPermissionToWrite returning false");
            }
            return false;
        }
    }

    public boolean isCloseWithReadOutstanding() {
        if (this.currentState == CLOSE_PENDING) {
            return this.readOutWithClosePending;
        }
        return false;
    }

    public boolean isCloseWithWriteOutstanding() {
        if (this.currentState == CLOSE_PENDING) {
            return this.writeOutWithClosePending;
        }
        return false;
    }

    public boolean getCloseWaiting() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "permlogic getCloseWaiting returning: " + this.closeWaiting);
        }
        return this.closeWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPermissionToClose(long l) {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) == 0) {
                this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                this.currentState = CLOSE_PENDING;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToClose returning true");
                }
                return true;
            }
            if (l <= 0L) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToClose returning false");
                }
                return false;
            }
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            try {
                do {
                    this.closeWaiting = true;
                    this.wait(l3);
                    this.closeWaiting = false;
                    if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) != 0) continue;
                    this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                    this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                    this.currentState = CLOSE_PENDING;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "permlogic requestPermissionToClose returning(2) true");
                    }
                    return true;
                } while ((l3 = l2 - System.currentTimeMillis()) > 0L);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToClose returning(2) false");
                }
                return false;
            }
            catch (InterruptedException interruptedException) {
                if ((this.currentState & CLOSE_NOT_ALLOWED_MASK) == 0) {
                    this.readOutWithClosePending = (this.currentState & READ_OUTSTANDING) != 0;
                    this.writeOutWithClosePending = (this.currentState & WRITE_OUTSTANDING) != 0;
                    this.currentState = CLOSE_PENDING;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "permlogic requestPermissionToClose returning(3) true");
                    }
                    return true;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToClose returning(3) false");
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadStateToDone() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            this.currentState &= READ_DONE_CLEAR_OUT;
            if (this.closeWaiting) {
                this.notify();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic setReadStateToDone returning");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteStateToDone() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            this.currentState &= WRITE_DONE_CLEAR_OUT;
            if (this.closeWaiting) {
                this.notify();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic setWriteStateToDone returning");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputStateTrackingOperational() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            return this.currentState != 0;
            {
            }
        }
    }

    public Object getLockObject() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "permlogic setLockObject returning");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPermissionToFinishRead() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & FINISH_NOT_ALLOWED_MASK) != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToFinishRead returning false");
                }
                return false;
            }
            this.currentState = (this.currentState | READ_FINISHING) & READ_FINISHING_CLEAR_OUT;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic requestPermissionToFinishRead returning true");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestPermissionToFinishWrite() {
        VirtualConnectionImpl virtualConnectionImpl = this;
        synchronized (virtualConnectionImpl) {
            if ((this.currentState & FINISH_NOT_ALLOWED_MASK) != 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "permlogic requestPermissionToFinishWrite returning false");
                }
                return false;
            }
            this.currentState = (this.currentState | WRITE_FINISHING) & WRITE_FINISHING_CLEAR_OUT;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "permlogic requestPermissionToFinishWrite returning true");
            }
            return true;
        }
    }

    public void setReadStatetoCloseAllowedNoSync() {
        this.currentState = (this.currentState | READ_WAITING) & READ_WAITING_CLEAR_OUT;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "permlogic setReadStatetoCloseAllowedNoSync returning");
        }
    }

    public void setWriteStatetoCloseAllowedNoSync() {
        this.currentState = (this.currentState | WRITE_WAITING) & WRITE_WAITING_CLEAR_OUT;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "permlogic setWriteStatetoCloseAllowedNoSync returning");
        }
    }

    public void setInetAddressingValid(boolean bl) {
        this.inetAddressingValid = bl;
    }

    public boolean getInetAddressingValid() {
        return this.inetAddressingValid;
    }

    public void setConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        this.connDesc = connectionDescriptor;
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connDesc;
    }

    public int attemptToSetFileChannelCapable(int n) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptToSetFileChannelCapable(int)  desired setting: " + n);
        }
        if (n == 1) {
            this.fileChannelCapable = 1;
        } else if (n == 2 && this.fileChannelCapable == 0) {
            this.fileChannelCapable = 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptToSetFileChannelCapable(int)  set to: " + this.fileChannelCapable);
        }
        return this.fileChannelCapable;
    }

    public int getFileChannelCapable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getFileChannelCapable: returning: " + this.fileChannelCapable);
        }
        return this.fileChannelCapable;
    }
}

