/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc.dom;

import java.security.Key;
import javax.crypto.spec.IvParameterSpec;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLEncryptContext;
import org.w3c.dom.Node;

public class DOMEncryptContext
extends DOMCryptoContext
implements XMLEncryptContext {
    private Node parent;
    private Node nextSibling;
    private EncryptionMethod encMethod;
    private IvParameterSpec ivSpec;

    public DOMEncryptContext(KeySelector ks) {
        if (ks == null) {
            throw new NullPointerException("ks must not be null");
        }
        super.setKeySelector(ks);
    }

    public DOMEncryptContext(Key key) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        super.setKeySelector(KeySelector.singletonKeySelector(key));
    }

    public DOMEncryptContext(KeySelector ks, Node parent) {
        if (ks == null) {
            throw new NullPointerException("ks must not be null");
        }
        if (parent == null) {
            throw new NullPointerException("parant is null");
        }
        super.setKeySelector(ks);
        this.parent = parent;
    }

    public DOMEncryptContext(Key key, Node parent) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        super.setKeySelector(KeySelector.singletonKeySelector(key));
        this.parent = parent;
    }

    public DOMEncryptContext(KeySelector ks, Node parent, Node nextSibling) {
        if (ks == null) {
            throw new NullPointerException("ks must not be null");
        }
        if (parent == null) {
            throw new NullPointerException("parant is null");
        }
        if (nextSibling == null) {
            throw new NullPointerException("nextSibling is null");
        }
        super.setKeySelector(ks);
        this.parent = parent;
        this.nextSibling = nextSibling;
    }

    public DOMEncryptContext(Key key, Node parent, Node nextSibling) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (nextSibling == null) {
            throw new NullPointerException("nextSibling is null");
        }
        super.setKeySelector(KeySelector.singletonKeySelector(key));
        this.parent = parent;
        this.nextSibling = nextSibling;
    }

    @Override
    public IvParameterSpec getIvParameterSpec() {
        return this.ivSpec;
    }

    @Override
    public void setIvParameterSpec(IvParameterSpec ivSpec) {
        this.ivSpec = ivSpec;
    }

    @Override
    public EncryptionMethod getEncryptionMethod() {
        return this.encMethod;
    }

    @Override
    public void setEncryptionMethod(EncryptionMethod encMethod) {
        this.encMethod = encMethod;
    }

    public void setParent(Node parent) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        this.parent = parent;
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }
}

