/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import javax.security.auth.kerberos.KrbDelegationPermissionCollection;

public final class DelegationPermission
extends BasicPermission
implements Serializable {
    private static final long serialVersionUID = 883133252142523922L;
    private transient String subordinate;
    private transient String service;

    public DelegationPermission(String principals) {
        super(principals);
        this.init(principals);
    }

    public DelegationPermission(String principals, String actions) {
        super(principals, actions);
        this.init(principals);
    }

    private void init(String target) {
        StringTokenizer t = null;
        if (!target.startsWith("\"")) {
            throw new IllegalArgumentException("service principal [" + target + "] syntax invalid: " + "improperly quoted");
        }
        t = new StringTokenizer(target, "\"", false);
        this.subordinate = t.nextToken();
        if (t.countTokens() == 2) {
            t.nextToken();
            this.service = t.nextToken();
        } else if (t.countTokens() > 0) {
            throw new IllegalArgumentException("service principal [" + t.nextToken() + "] syntax invalid: " + "improperly quoted");
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission that = (DelegationPermission)p;
        return this.subordinate.equals(that.subordinate) && this.service.equals(that.service);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DelegationPermission)) {
            return false;
        }
        DelegationPermission that = (DelegationPermission)obj;
        return this.implies(that);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new KrbDelegationPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }
}

