/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.gsskerb;

import com.ibm.security.sasl.util.AbstractSaslImpl;
import java.util.Map;
import java.util.logging.Level;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

abstract class GssKrb5Base
extends AbstractSaslImpl {
    private static final String KRB5_OID_STR = "1.2.840.113554.1.2.2";
    protected static Oid KRB5_OID;
    protected static final byte[] EMPTY;
    protected GSSContext secCtx = null;
    protected MessageProp msgProp;
    protected static final int JGSS_QOP = 0;

    protected GssKrb5Base(Map<String, ?> props, String className) throws SaslException {
        super(props, className);
    }

    public String getMechanismName() {
        return "GSSAPI";
    }

    public byte[] unwrap(byte[] incoming, int start, int len) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("GSSAPI authentication not completed");
        }
        if (!this.integrity) {
            throw new IllegalStateException("No security layer negotiated");
        }
        try {
            byte[] answer = this.secCtx.unwrap(incoming, start, len, this.msgProp);
            if (logger.isLoggable(Level.FINEST)) {
                GssKrb5Base.traceOutput(this.myClassName, "KRB501:Unwrap", "incoming: ", incoming, start, len);
                GssKrb5Base.traceOutput(this.myClassName, "KRB502:Unwrap", "unwrapped: ", answer, 0, answer.length);
            }
            return answer;
        }
        catch (GSSException e) {
            throw new SaslException("Problems unwrapping SASL buffer", e);
        }
    }

    public byte[] wrap(byte[] outgoing, int start, int len) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("GSSAPI authentication not completed");
        }
        if (!this.integrity) {
            throw new IllegalStateException("No security layer negotiated");
        }
        try {
            byte[] answer = this.secCtx.wrap(outgoing, start, len, this.msgProp);
            if (logger.isLoggable(Level.FINEST)) {
                GssKrb5Base.traceOutput(this.myClassName, "KRB503:Wrap", "outgoing: ", outgoing, start, len);
                GssKrb5Base.traceOutput(this.myClassName, "KRB504:Wrap", "wrapped: ", answer, 0, answer.length);
            }
            return answer;
        }
        catch (GSSException e) {
            throw new SaslException("Problem performing GSS wrap", e);
        }
    }

    public void dispose() throws SaslException {
        if (this.secCtx != null) {
            try {
                this.secCtx.dispose();
            }
            catch (GSSException e) {
                throw new SaslException("Problem disposing GSS context", e);
            }
            this.secCtx = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    static {
        EMPTY = new byte[0];
        try {
            KRB5_OID = new Oid(KRB5_OID_STR);
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

