/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class Authenticator {
    private int a;
    private PrincipalName b;
    private Checksum c;
    private int d;
    private KerberosTime e;
    private EncryptionKey f;
    private Integer g;
    private AuthorizationData h;

    public Authenticator(Realm realm, PrincipalName principalName, Checksum checksum, int n2, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n3, AuthorizationData authorizationData) {
        this(principalName, checksum, n2, kerberosTime, encryptionKey, n3, authorizationData);
    }

    public Authenticator(PrincipalName principalName, Checksum checksum, int n2, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n3, AuthorizationData authorizationData) {
        this.a = 5;
        this.b = principalName;
        this.c = checksum;
        this.d = n2;
        this.e = kerberosTime;
        this.f = encryptionKey;
        this.g = n3;
        this.h = authorizationData;
    }

    public Authenticator(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.a(new DerValue(byArray));
    }

    public Authenticator(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.a(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 2 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue3.getData().getBigInteger().intValue();
        if (this.a != 5) {
            throw new KrbApErrException(39);
        }
        Realm realm = Realm.parse(derValue2.getData(), (byte)1, false);
        this.b = PrincipalName.parse(derValue2.getData(), (byte)2, false, realm);
        this.c = Checksum.parse(derValue2.getData(), (byte)3, true);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        this.d = derValue3.getData().getBigInteger().intValue();
        this.e = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        if (derValue2.getData().available() > 0) {
            this.f = EncryptionKey.parse(derValue2.getData(), (byte)6, true);
        } else {
            this.f = null;
            this.g = null;
            this.h = null;
        }
        if (derValue2.getData().available() > 0) {
            if ((derValue2.getData().peekByte() & 0x1F) == 7 && ((derValue3 = derValue2.getData().getDerValue()).getTag() & 0x1F) == 7) {
                this.g = new Integer(derValue3.getData().getBigInteger().intValue());
            }
        } else {
            this.g = null;
            this.h = null;
        }
        this.h = derValue2.getData().available() > 0 ? AuthorizationData.parse(derValue2.getData(), (byte)8, true) : null;
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.a));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream.toByteArray()));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.b.getRealm().asn1Encode()));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.b.asn1Encode()));
        if (this.c != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.c.asn1Encode()));
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.d));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), derOutputStream.toByteArray()));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.e.asn1Encode()));
        if (this.f != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.f.asn1Encode()));
        }
        if (this.g != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.g);
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream.toByteArray()));
        }
        if (this.h != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.h.asn1Encode()));
        }
        DerValue[] derValueArray = new DerValue[arrayList.size()];
        arrayList.toArray(derValueArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)2), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final Checksum getChecksum() {
        return this.c;
    }

    public final Integer getSeqNumber() {
        return this.g;
    }

    public final EncryptionKey getSubKey() {
        return this.f;
    }

    public int getVersionNumber() {
        return this.a;
    }

    public Realm getRealm() {
        return null;
    }

    public PrincipalName getClient() {
        return this.b;
    }

    public int getMicroSeconds() {
        return this.d;
    }

    public KerberosTime getTime() {
        return this.e;
    }

    public EncryptionKey getSubsesionKey() {
        return this.f;
    }

    public int getSequenceNumber() {
        if (this.g == null) {
            return -1;
        }
        return this.g;
    }

    public AuthorizationData getAuthzData() {
        return this.h;
    }
}

