/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.capi;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.capi.IBMCAC;
import com.ibm.security.capi.Key;
import com.ibm.security.capi.RSAPrivateKey;
import com.ibm.security.capi.RSAPublicKey;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

abstract class RSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private String messageDigestAlgorithm;
    private boolean needsReset;
    private Key privateKey = null;
    private Key publicKey = null;

    RSASignature() {
        this.messageDigest = null;
        this.messageDigestAlgorithm = null;
    }

    RSASignature(String string) {
        try {
            this.messageDigest = MessageDigest.getInstance(string);
            this.messageDigestAlgorithm = this.messageDigest.getAlgorithm();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof java.security.interfaces.RSAPublicKey)) {
            throw new InvalidKeyException("Key type not supported");
        }
        java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
        if (!(publicKey instanceof RSAPublicKey)) {
            BigInteger bigInteger = rSAPublicKey.getModulus();
            BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
            RSAKeyFactory.checkKeyLengths((int)(bigInteger.bitLength() + 7 & 0xFFFFFFF8), (BigInteger)bigInteger2, (int)-1, (int)16384);
            byte[] byArray = bigInteger.toByteArray();
            byte[] byArray2 = bigInteger2.toByteArray();
            int n = byArray[0] == 0 ? (byArray.length - 1) * 8 : byArray.length * 8;
            byte[] byArray3 = RSASignature.generatePublicKeyBlob(n, byArray, byArray2);
            try {
                this.publicKey = RSASignature.importPublicKey(byArray3, n);
            }
            catch (KeyStoreException keyStoreException) {
                throw new InvalidKeyException(keyStoreException);
            }
        } else {
            this.publicKey = (RSAPublicKey)publicKey;
        }
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineInitSign");
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            if (IBMCAC.debug) {
                System.out.println(IBMCAC.DEBUGHEADER + "ERROR: Key type is not com.ibm.security.capi.RSAPrivateKey");
            }
            throw new InvalidKeyException("Key type not supported");
        }
        this.privateKey = (RSAPrivateKey)privateKey;
        RSAKeyFactory.checkKeyLengths((int)(this.privateKey.length() + 7 & 0xFFFFFFF8), null, (int)512, (int)16384);
        this.publicKey = null;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            this.messageDigest.reset();
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: getDigestValue");
        }
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    protected void setDigestName(String string) {
        this.messageDigestAlgorithm = string;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.messageDigest.update(by);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.messageDigest.update(byArray, n, n2);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineSign");
        }
        byte[] byArray = this.getDigestValue();
        boolean bl = this instanceof Raw;
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: signHash");
            System.out.println("                     noHashOID: " + bl);
            System.out.println("                     hash: " + byArray.toString());
            System.out.println("                     hash.length: " + byArray.length);
            System.out.println("                     messageDigestAlgorithm: " + this.messageDigestAlgorithm);
            System.out.println("                     privateKey: " + this.privateKey.toString());
            System.out.println("                     HCryptProvider: " + this.privateKey.getHCryptProvider());
            System.out.println("                     HCryptKey: " + this.privateKey.getHCryptKey());
        }
        byte[] byArray2 = null;
        try {
            byArray2 = RSASignature.signHash(bl, byArray, byArray.length, this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
        }
        catch (Throwable throwable) {
            if (IBMCAC.debug) {
                throwable.printStackTrace();
                System.out.println();
            }
            throw throwable;
        }
        if (IBMCAC.debug) {
            System.out.println("                     result: " + byArray2.toString());
        }
        return this.convertEndianArray(byArray2);
    }

    private byte[] convertEndianArray(byte[] byArray) {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: convertEndianArray");
        }
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    private static native byte[] signHash(boolean var0, byte[] var1, int var2, String var3, long var4, long var6) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (IBMCAC.debug) {
            System.out.println(IBMCAC.DEBUGHEADER + "RSASignature: engineVerify");
        }
        byte[] byArray2 = this.getDigestValue();
        return RSASignature.verifySignedHash(byArray2, byArray2.length, this.messageDigestAlgorithm, this.convertEndianArray(byArray), byArray.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    static native byte[] generatePublicKeyBlob(int var0, byte[] var1, byte[] var2) throws InvalidKeyException;

    static native RSAPublicKey importPublicKey(byte[] var0, int var1) throws KeyStoreException;

    public static final class MD2
    extends RSASignature {
        public MD2() {
            super("MD2");
        }
    }

    public static final class MD5
    extends RSASignature {
        public MD5() {
            super("MD5");
        }
    }

    public static final class Raw
    extends RSASignature {
        private static final int RAW_RSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = by;
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (n2 > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            System.arraycopy(byArray, n, this.precomputedDigest, this.offset, n2);
            this.offset += n2;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (n > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, n);
            this.offset += n;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            if (this.offset == 20) {
                this.setDigestName("SHA1");
            } else if (this.offset == 36) {
                this.setDigestName("SHA1+MD5");
            } else if (this.offset == 32) {
                this.setDigestName("SHA-256");
            } else if (this.offset == 48) {
                this.setDigestName("SHA-384");
            } else if (this.offset == 64) {
                this.setDigestName("SHA-512");
            } else if (this.offset == 16) {
                this.setDigestName("MD5");
            } else {
                throw new SignatureException("Message digest length is not supported");
            }
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, byArray, 0, this.offset);
            this.offset = 0;
            return byArray;
        }
    }

    public static final class SHA1
    extends RSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class SHA256
    extends RSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA384
    extends RSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA512
    extends RSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }
}

