/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMEncryptionMethod;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.Utils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.enc.EncryptedType;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;
import org.w3c.dom.Element;

public final class DOMKWAES
extends DOMEncryptionMethod {
    private static Debug debug = Debug.getInstance("xmlenc");
    private static byte[] PREFIX = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    private Cipher cipher;
    private boolean padding = false;
    private SecureRandom random = null;
    private String aesAlgo = null;

    public DOMKWAES(String algo, Integer keySize, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        super(algo, keySize, params);
        this.aesAlgo = algo;
    }

    public DOMKWAES(Element smElem, String algo) throws MarshalException {
        super(smElem);
        this.aesAlgo = algo;
    }

    @Override
    protected void checkParams(Integer keySize, EncryptionMethodParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("no parameters should be specified for AES cipher algorithm");
        }
    }

    @Override
    protected EncryptionMethodParameterSpec unmarshalParams(Element paramsElem) throws MarshalException {
        throw new MarshalException("no parameters should be specified for AES cipher algorithm");
    }

    @Override
    protected void marshalParams(Element parent, String dsPrefix) throws MarshalException {
        throw new MarshalException("no parameters should be specified for AES cipher algorithm");
    }

    @Override
    protected boolean paramsEqual(AlgorithmParameterSpec spec) {
        return this.getParameterSpec() == spec;
    }

    @Override
    public byte[] decrypt(Key key, byte[] data) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return this.unwrap(key, data);
    }

    @Override
    public Key decryptKey(Key key, byte[] encryptedKey, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException {
        return this.unwrap(key, encryptedKey, algo);
    }

    @Override
    public byte[] encrypt(Key key, byte[] data, EncryptedType type) throws InvalidKeyException {
        try {
            return this.wrap(key, data);
        }
        catch (IllegalBlockSizeException ex) {
            throw (InvalidKeyException)new InvalidKeyException(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    public byte[] wrap(Key key, Key toBeWrapped) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] keybytes = toBeWrapped.getEncoded();
        return this.wrap(key, keybytes);
    }

    private byte[] wrap(Key key, byte[] keybytes) throws InvalidKeyException, IllegalBlockSizeException {
        if (keybytes.length % 8 != 0) {
            throw new InvalidKeyException("Unsupported wrapping key size : " + keybytes.length);
        }
        byte[] C = new byte[keybytes.length + 8];
        byte[] B = null;
        byte[] tmp = new byte[16];
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("AES/ECB/NoPadding");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException(nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException(nspe.getMessage());
            }
        }
        if (keybytes.length == 8) {
            System.arraycopy(PREFIX, 0, tmp, 0, 8);
            System.arraycopy(keybytes, 0, tmp, 8, 8);
            this.cipher.init(1, key);
            try {
                B = this.cipher.doFinal(tmp);
            }
            catch (BadPaddingException bpe) {
                throw new InvalidKeyException(bpe.getMessage());
            }
            System.arraycopy(B, 0, C, 0, 8);
            System.arraycopy(B, 8, C, 8, 8);
            return C;
        }
        byte[] A = new byte[8];
        System.arraycopy(PREFIX, 0, A, 0, 8);
        byte[] R = new byte[keybytes.length];
        System.arraycopy(keybytes, 0, R, 0, keybytes.length);
        byte[] tBytes = new byte[8];
        int N = keybytes.length / 8;
        for (int j = 0; j < 6; ++j) {
            for (int i = 1; i < N + 1; ++i) {
                int k;
                int t = i + j * N;
                DOMKWAES.int2array(t, tBytes);
                this.cipher.init(1, key);
                System.arraycopy(A, 0, tmp, 0, 8);
                System.arraycopy(R, (i - 1) * 8, tmp, 8, 8);
                try {
                    B = this.cipher.doFinal(tmp);
                }
                catch (BadPaddingException bpe) {
                    throw new InvalidKeyException(bpe.getMessage());
                }
                for (k = 0; k < 8; ++k) {
                    int b = B[k] & 0xFF;
                    int tt = tBytes[k] & 0xFF;
                    A[k] = (byte)(b ^ tt);
                }
                for (k = 0; k < 8; ++k) {
                    R[(i - 1) * 8 + k] = B[8 + k];
                }
            }
        }
        System.arraycopy(A, 0, C, 0, 8);
        System.arraycopy(R, 0, C, 8, R.length);
        return C;
    }

    private static void int2array(int value, byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = 0;
        }
        arr[4] = (byte)(value >>> 24);
        arr[5] = (byte)(value >>> 16);
        arr[6] = (byte)(value >>> 8);
        arr[7] = (byte)value;
    }

    @Override
    public byte[] unwrap(Key key, byte[] encrypted) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (this.cipher == null) {
            try {
                this.cipher = Cipher.getInstance("AES/ECB/NoPadding");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidKeyException(nsae.getMessage());
            }
            catch (NoSuchPaddingException nspe) {
                throw new InvalidKeyException(nspe.getMessage());
            }
        }
        byte[] B = null;
        byte[] result = null;
        if (encrypted.length == 16) {
            this.cipher.init(2, key);
            B = this.cipher.doFinal(encrypted);
            for (int i = 0; i < 8; ++i) {
                if (B[i] == PREFIX[i]) continue;
                throw new InvalidKeyException("Failed to decrypt");
            }
            result = new byte[8];
            System.arraycopy(B, 8, result, 0, 8);
            return result;
        }
        byte[] A = new byte[8];
        System.arraycopy(encrypted, 0, A, 0, 8);
        int N = encrypted.length / 8 - 1;
        byte[] R = new byte[encrypted.length - 8];
        System.arraycopy(encrypted, 8, R, 0, R.length);
        byte[] tBytes = new byte[8];
        byte[] tmp = new byte[16];
        for (int j = 5; j >= 0; --j) {
            for (int i = N; i >= 1; --i) {
                int t = i + j * N;
                DOMKWAES.int2array(t, tBytes);
                for (int k = 0; k < 8; ++k) {
                    int tt = tBytes[k] & 0xFF;
                    int a = A[k] & 0xFF;
                    tmp[k] = (byte)(tt ^ a);
                }
                System.arraycopy(R, (i - 1) * 8, tmp, 8, 8);
                this.cipher.init(2, key);
                B = this.cipher.doFinal(tmp);
                System.arraycopy(B, 0, A, 0, 8);
                System.arraycopy(B, 8, R, (i - 1) * 8, 8);
            }
        }
        for (int i = 0; i < 8; ++i) {
            if (A[i] == -90) continue;
            throw new InvalidKeyException("Invalid A");
        }
        byte[] P = new byte[R.length];
        System.arraycopy(R, 0, P, 0, R.length);
        return P;
    }

    @Override
    public Key unwrap(Key key, byte[] encrypted, AlgorithmMethod algo) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] keybytes = this.unwrap(key, encrypted);
        String algoName = Utils.mapAlgorithm(algo.getAlgorithm());
        return this.genKey(keybytes, algoName);
    }
}

