/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistryOutputChannels
extends OutputStream {
    private List<IOutputChannel> channels;
    private List<Byte> buffer;
    private String charsetName;
    private static ToolsRegistryOutputChannels instance = null;

    public static void initialize(String charsetName) {
        if (instance == null) {
            instance = new ToolsRegistryOutputChannels(charsetName);
        }
    }

    public static void addChannel(IOutputChannel out) {
        ToolsRegistryOutputChannels.instance.channels.add(out);
    }

    public static void removeChannel(IOutputChannel out) {
        if (ToolsRegistryOutputChannels.instance.channels.contains(out)) {
            ToolsRegistryOutputChannels.instance.channels.remove(out);
        }
    }

    public static boolean contains(IOutputChannel out) {
        for (IOutputChannel channel : ToolsRegistryOutputChannels.instance.channels) {
            if (!channel.equals(out)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.add(Integer.valueOf(b).byteValue());
        if (10 == b || 21 == b) {
            this.writeBuffer();
        }
    }

    @Override
    public void close() throws IOException {
        this.writeBuffer();
        for (IOutputChannel channel : this.channels) {
            channel.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writeBuffer();
        for (IOutputChannel channel : this.channels) {
            channel.flush();
        }
    }

    public static PrintStream newPrintStream() {
        return new PrintStream(instance, true);
    }

    private ToolsRegistryOutputChannels(String charsetName) {
        this.charsetName = charsetName;
        this.channels = new ArrayList<IOutputChannel>();
        this.buffer = new ArrayList<Byte>();
    }

    private void writeBuffer() throws IOException {
        if (0 == this.buffer.size()) {
            return;
        }
        byte[] byteArray = new byte[this.buffer.size()];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = this.buffer.get(i);
        }
        for (IOutputChannel out : this.channels) {
            if (this.charsetName == null) {
                out.print(new String(byteArray));
                continue;
            }
            out.print(new String(byteArray, this.charsetName));
        }
        this.buffer = new ArrayList<Byte>();
    }
}

