/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorState;
import com.ibm.jvm.dtfjview.commands.helpers.StateToString;
import com.ibm.jvm.dtfjview.commands.helpers.ThreadData;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoThreadCommand
extends BaseJdmpviewCommand {
    private int _pointerSize;
    private boolean _is_zOS = false;
    private Map<JavaThread, MonitorState> monitors = new HashMap<JavaThread, MonitorState>();
    private long lastRTAddress = 0L;
    private static final String JAVA_LANG_THREAD_CLASS = "java/lang/Thread";

    public InfoThreadCommand() {
        this.addCommand("info thread", "[<native thread ID>|<zOS TCB>|all|*]", "Displays information about Java and native threads");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        try {
            long currentRTAddress = this.ctx.getRuntime().getJavaVM().getAddress();
            if (currentRTAddress != this.lastRTAddress) {
                this.lastRTAddress = currentRTAddress;
                this.monitors = new HashMap<JavaThread, MonitorState>();
            }
        }
        catch (Exception e) {
            this.logger.fine("Error getting address of the JVM, cannot use cached monitor values. No JVM in process?");
            this.logger.log(Level.FINEST, "Error getting address of the JVM", e);
            this.monitors = new HashMap<JavaThread, MonitorState>();
        }
        if (this.monitors.isEmpty() && this.ctx.getRuntime() != null) {
            this.getMonitors(this.ctx.getRuntime());
        }
        this.doCommand(args);
    }

    public void doCommand(String[] args) {
        try {
            this._is_zOS = this.ctx.getImage().getSystemType().toLowerCase().indexOf("z/os") >= 0;
        }
        catch (DataUnavailable e) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        String param = null;
        switch (args.length) {
            case 0: {
                try {
                    ImageThread it = this.ctx.getProcess().getCurrentThread();
                    if (null == it) {
                        this.out.print("\nNo current (failing) thread, try specifying a native thread ID, \"all\" or \"*\"\n");
                        ImageProcess ip = this.ctx.getProcess();
                        if (ip != null) {
                            this.printThreadSummary(ip);
                        }
                        return;
                    }
                    param = it.getID();
                    break;
                }
                catch (CorruptDataException e) {
                    this.out.println("exception encountered while getting information about current thread");
                    return;
                }
            }
            case 1: {
                if (args[0].equalsIgnoreCase("ALL")) {
                    param = "*";
                    break;
                }
                param = args[0];
                break;
            }
            default: {
                this.out.println("\"info thread\" takes at most one parameter, which, if specified, must be a native thread ID or \"all\" or \"*\"");
                return;
            }
        }
        if (param.equals("*")) {
            this.printAddressSpaceInfo(null, this.getJavaThreads(null));
        } else {
            this.printAddressSpaceInfo(param, this.getJavaThreads(param));
        }
    }

    private void printAddressSpaceInfo(String id, Map threads) {
        boolean asnum = false;
        if (id == null) {
            this.out.print("native threads for address space\n");
        }
        this.printProcessInfo(id, threads);
        if (!threads.isEmpty()) {
            this.out.print("\nJava threads not associated with known native threads:\n\n");
            ArrayList ta = (ArrayList)threads.remove(null);
            if (ta != null) {
                for (int i = 0; i < ta.size(); ++i) {
                    ThreadData td = (ThreadData)ta.get(i);
                    this.printJavaThreadInfo(td.getThread(), false);
                }
            }
            if (!threads.isEmpty()) {
                for (ThreadData td : threads.values()) {
                    if (td == null) continue;
                    this.printJavaThreadInfo(td.getThread(), false);
                }
            }
        }
    }

    private void printProcessInfo(String id, Map threads) {
        boolean found = false;
        ImageProcess ip = this.ctx.getProcess();
        this._pointerSize = ip.getPointerSize();
        this.out.print(" process id: ");
        try {
            this.out.print(ip.getID());
        }
        catch (DataUnavailable d) {
            this.out.print(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.print("\n\n");
        found = this.printThreadInfo(id, threads);
        if (!found) {
            this.out.print(" no native threads found with specified id\n");
        }
    }

    private boolean printThreadInfo(String id, Map threads) {
        boolean found = false;
        Iterator itThread = this.ctx.getProcess().getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) {
                this.out.print("\n  <corrupt data>");
                continue;
            }
            ImageThread it = (ImageThread)next;
            String currentTID = null;
            String currentTCB = null;
            try {
                currentTID = it.getID();
                if (this._is_zOS) {
                    currentTCB = it.getProperties().getProperty("TCB");
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
            if (null != id && !id.equalsIgnoreCase(currentTID) && !id.equalsIgnoreCase(currentTCB)) continue;
            this.out.print("  thread id: ");
            this.out.print(currentTID);
            this.out.print("\n");
            this.printRegisters(it);
            this.out.print("   native stack sections:");
            this.out.print("\n");
            Iterator itStackSection = it.getStackSections();
            while (itStackSection.hasNext()) {
                Object nextStackSection = itStackSection.next();
                if (nextStackSection instanceof CorruptData) {
                    this.out.print("    " + Exceptions.getCorruptDataExceptionString() + "\n");
                    continue;
                }
                ImageSection is = (ImageSection)nextStackSection;
                this.printStackSection(is);
            }
            this.printStackFrameInfo(it);
            this.out.print("   properties:");
            this.out.print("\n");
            this.printProperties(it);
            this.out.print("   associated Java thread: ");
            ThreadData td = (ThreadData)threads.remove(currentTID);
            if (null != td) {
                this.out.print("\n");
                this.printJavaThreadInfo(td.getThread(), true);
            } else {
                this.out.print("<no associated Java thread>\n");
            }
            this.out.print("\n");
            found = true;
        }
        return found;
    }

    public void printRegisters(ImageThread it) {
        this.out.print("   registers:");
        int count = 0;
        Iterator itImageRegister = it.getRegisters();
        while (itImageRegister.hasNext()) {
            if (count % 4 == 0) {
                this.out.print("\n ");
            }
            this.out.print("   ");
            ImageRegister ir = (ImageRegister)itImageRegister.next();
            this.printRegisterInfo(ir);
            ++count;
        }
        this.out.print("\n");
    }

    public void printRegisterInfo(ImageRegister ir) {
        this.out.print(Utils.padWithSpaces(ir.getName(), 6) + " = ");
        try {
            BigInteger bigValue;
            int width;
            Number value = ir.getValue();
            if (value instanceof BigInteger && (width = (bigValue = (BigInteger)value).bitLength()) > 64) {
                int paddedBits = (width - 1 | 0x3F) + 1;
                this.out.print("0x" + Utils.padWithZeroes(bigValue.toString(16), paddedBits / 4));
                return;
            }
            long registerValue = value.longValue();
            if (this._pointerSize > 32) {
                this.out.print("0x" + Utils.toFixedWidthHex(registerValue));
            } else if (this._is_zOS) {
                this.out.print("0x" + Utils.toFixedWidthHex((int)(registerValue >> 32)) + "_" + Utils.toFixedWidthHex((int)registerValue));
            } else {
                this.out.print("0x" + Utils.toFixedWidthHex((int)registerValue));
            }
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
    }

    public void printStackSection(ImageSection is) {
        long startAddr = is.getBaseAddress().getAddress();
        long size = is.getSize();
        long endAddr = startAddr + size;
        this.out.print("    ");
        this.out.print(Utils.toHex(startAddr));
        this.out.print(" to ");
        this.out.print(Utils.toHex(endAddr));
        this.out.print(" (length ");
        this.out.print(Utils.toHex(size));
        this.out.print(")\n");
    }

    private void printStackFrameInfo(ImageThread it) {
        Iterator itStackFrame;
        try {
            itStackFrame = it.getStackFrames();
        }
        catch (DataUnavailable d) {
            this.out.print("   native stack frames: " + Exceptions.getDataUnavailableString() + "\n");
            return;
        }
        this.out.print("   native stack frames:");
        this.out.print("\n");
        while (itStackFrame.hasNext()) {
            Object o = itStackFrame.next();
            if (o instanceof CorruptData) {
                this.out.print("    <corrupt stack frame: " + ((CorruptData)o).toString() + ">\n");
                continue;
            }
            ImageStackFrame isf = (ImageStackFrame)o;
            this.out.print("    bp: ");
            try {
                this.out.print(this.toAdjustedHex(isf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                if (this.getArtifactType() == BaseJdmpviewCommand.ArtifactType.javacore) {
                    this.out.print(Exceptions.getDataUnavailableString());
                }
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" pc: ");
            try {
                this.out.print(this.toAdjustedHex(isf.getProcedureAddress().getAddress()));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print(" ");
            try {
                this.out.print(isf.getProcedureName());
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            this.out.print("\n");
        }
    }

    private Map getJavaThreads(String id) {
        HashMap<String, Object> threads = new HashMap<String, Object>();
        JavaRuntime mr = this.ctx.getRuntime();
        if (mr instanceof JavaRuntime) {
            JavaRuntime jr = mr;
            Iterator itThread = jr.getThreads();
            while (itThread.hasNext()) {
                Object next = itThread.next();
                if (next instanceof CorruptData) continue;
                JavaThread jt = (JavaThread)next;
                String currentTID = null;
                String currentTCB = null;
                try {
                    ImageThread it = jt.getImageThread();
                    currentTID = it.getID();
                    if (this._is_zOS) {
                        currentTCB = it.getProperties().getProperty("TCB");
                    }
                }
                catch (DTFJException it) {
                    // empty catch block
                }
                if (null == id) {
                    if (null == currentTID) {
                        ArrayList<ThreadData> ta;
                        if (threads.containsKey(null)) {
                            ta = (ArrayList<ThreadData>)threads.get(null);
                            ta.add(new ThreadData(jt, jr));
                            continue;
                        }
                        ta = new ArrayList<ThreadData>(1);
                        ta.add(new ThreadData(jt, jr));
                        threads.put(null, ta);
                        continue;
                    }
                    threads.put(currentTID, new ThreadData(jt, jr));
                    continue;
                }
                if (!id.equalsIgnoreCase(currentTID) && !id.equalsIgnoreCase(currentTCB)) continue;
                threads.put(currentTID, new ThreadData(jt, jr));
            }
        }
        return threads;
    }

    private void getMonitors(JavaRuntime jr) {
        int corruptThreadCount = 0;
        int corruptMonitorCount = 0;
        Iterator itMonitor = jr.getMonitors();
        while (itMonitor.hasNext()) {
            Object obj = itMonitor.next();
            if (obj instanceof CorruptData) {
                ++corruptMonitorCount;
                continue;
            }
            JavaMonitor jm = (JavaMonitor)obj;
            Iterator itEnterWaiter = jm.getEnterWaiters();
            while (itEnterWaiter.hasNext()) {
                obj = itEnterWaiter.next();
                if (obj instanceof CorruptData) {
                    ++corruptThreadCount;
                    continue;
                }
                JavaThread jt = (JavaThread)obj;
                this.monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_ENTER));
            }
            if (corruptThreadCount > 0) {
                String msg = String.format("Warning : %d corrupt thread(s) were found waiting to enter monitor %s", corruptThreadCount, this.getMonitorName(jm));
                this.logger.fine(msg);
            }
            corruptThreadCount = 0;
            Iterator itNotifyWaiter = jm.getNotifyWaiters();
            while (itNotifyWaiter.hasNext()) {
                obj = itNotifyWaiter.next();
                if (obj instanceof CorruptData) {
                    ++corruptThreadCount;
                    continue;
                }
                JavaThread jt = (JavaThread)obj;
                this.monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_BE_NOTIFIED_ON));
            }
            if (corruptThreadCount <= 0) continue;
            String msg = String.format("Warning : %d corrupt thread(s) were found waiting to be notified on monitor %s", corruptThreadCount, this.getMonitorName(jm));
            this.logger.fine(msg);
        }
        if (corruptMonitorCount > 0) {
            String msg = String.format("Warning : %d corrupt monitor(s) were found", corruptMonitorCount);
            this.logger.fine(msg);
        }
    }

    private String getMonitorName(JavaMonitor monitor) {
        try {
            return monitor.getName();
        }
        catch (CorruptDataException e) {
            return "<corrupt monitor name>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printJavaThreadInfo(JavaThread jt, boolean idPrinted) {
        block28: {
            this.out.print("    name:          ");
            try {
                this.out.print(jt.getName());
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            this.out.print("\n");
            if (!idPrinted) {
                try {
                    if (jt.getImageThread() != null) {
                        this.out.print("    id:            ");
                        this.out.print(jt.getImageThread().getID());
                    }
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                catch (DataUnavailable e) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
                }
                finally {
                    this.out.print("\n");
                }
            }
            this.out.print("    Thread object: ");
            try {
                JavaObject threadObj = jt.getObject();
                if (null == threadObj) {
                    this.out.print("<no associated Thread object>");
                    break block28;
                }
                String threadClassName = null;
                try {
                    JavaClass threadClass = threadObj.getJavaClass();
                    threadClassName = threadClass.getName();
                    if (threadClassName != null) {
                        this.out.print(threadClassName + " @ ");
                    }
                    this.out.print(Utils.toHex(threadObj.getID().getAddress()));
                    while (!JAVA_LANG_THREAD_CLASS.equals(threadClass.getName()) && threadClass != null) {
                        threadClass = threadClass.getSuperclass();
                    }
                    if (threadClass != null) {
                        Iterator itField = threadClass.getDeclaredFields();
                        boolean foundThreadId = false;
                        while (itField.hasNext()) {
                            JavaField jf = (JavaField)itField.next();
                            if (!foundThreadId && (jf.getName().equals("uniqueId") || jf.getName().equals("tid"))) {
                                foundThreadId = true;
                                this.out.print("\n    ID:            " + Utils.getVal(threadObj, jf));
                                continue;
                            }
                            if (!jf.getName().equals("isDaemon")) continue;
                            this.out.print("\n    Daemon:        " + Utils.getVal(threadObj, jf));
                        }
                    }
                }
                catch (CorruptDataException cde) {
                    this.out.print(" <in-flight or corrupt data encountered>");
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
                }
            }
            catch (CorruptDataException cde) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
            }
        }
        this.out.print("\n");
        this.out.print("    Priority:      ");
        try {
            Integer pri = jt.getPriority();
            this.out.print(pri.toString());
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
        }
        this.out.print("\n");
        this.out.print("    Thread.State:  ");
        try {
            this.out.print(StateToString.getThreadStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        this.out.print("\n");
        this.out.print("    JVMTI state:   ");
        try {
            this.out.print(StateToString.getJVMTIStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        this.out.print("\n");
        this.printThreadBlocker(jt);
        this.out.print("    Java stack frames: ");
        this.printJavaStackFrameInfo(jt);
        this.out.print("\n");
    }

    private void printThreadBlocker(JavaThread jt) {
        try {
            if ((jt.getState() & 0x200) != 0) {
                this.out.print("      parked on: ");
                if (jt.getBlockingObject() == null) {
                    this.out.print("<unknown>");
                } else {
                    JavaObject jo = jt.getBlockingObject();
                    String lockID = Long.toHexString(jo.getID().getAddress());
                    this.out.print(jo.getJavaClass().getName() + "@0x" + lockID);
                    String ownerThreadName = "<unknown>";
                    String ownerThreadID = "<null>";
                    this.out.print(" owner name: ");
                    JavaThread lockOwnerThread = Utils.getParkBlockerOwner(jo, this.ctx.getRuntime());
                    if (lockOwnerThread != null) {
                        ownerThreadName = lockOwnerThread.getName();
                        if (lockOwnerThread.getImageThread() != null) {
                            ownerThreadID = lockOwnerThread.getImageThread().getID();
                        }
                    } else {
                        JavaObject lockOwnerObj = Utils.getParkBlockerOwnerObject(jo, this.ctx.getRuntime());
                        if (lockOwnerObj != null) {
                            ownerThreadName = Utils.getThreadNameFromObject(lockOwnerObj, this.ctx.getRuntime(), this.out);
                        }
                    }
                    this.out.print("\"" + ownerThreadName + "\"");
                    this.out.print(" owner id: " + ownerThreadID);
                }
                this.out.print("\n");
            } else if ((jt.getState() & 0x100) != 0) {
                this.out.print("      waiting to be notified on: ");
            } else if ((jt.getState() & 0x400) != 0) {
                this.out.print("      waiting to enter: ");
            }
            if ((jt.getState() & 0x100) != 0 || (jt.getState() & 0x400) != 0) {
                MonitorState ms = this.monitors.get(jt);
                if (ms == null) {
                    this.out.println("<monitor information not available>");
                } else {
                    JavaObject jo = ms.getMonitor().getObject();
                    if (null == jo) {
                        String name = ms.getMonitor().getName();
                        if (name.equals("")) {
                            name = "<unnamed>";
                        }
                        this.out.print("\"" + name + "\"");
                        this.out.print(" with ID ");
                        this.out.print(Utils.toHex(ms.getMonitor().getID().getAddress()));
                    } else {
                        String lockID = Long.toHexString(jo.getID().getAddress());
                        this.out.print(jo.getJavaClass().getName() + "@0x" + lockID);
                    }
                    this.out.print(" owner name: ");
                    if (ms.getMonitor().getOwner() != null) {
                        this.out.print("\"" + ms.getMonitor().getOwner().getName() + "\"");
                        if (ms.getMonitor().getOwner().getImageThread() != null) {
                            this.out.print(" owner id: " + ms.getMonitor().getOwner().getImageThread().getID());
                        }
                    } else {
                        this.out.print("<unowned>");
                    }
                    this.out.print("\n");
                }
            }
        }
        catch (CorruptDataException cde) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), cde);
        }
        catch (DataUnavailable e) {
            this.out.print(Exceptions.getDataUnavailableString());
            this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
        }
        catch (MemoryAccessException e) {
            this.out.print(Exceptions.getMemoryAccessExceptionString());
            this.logger.log(Level.FINEST, Exceptions.getMemoryAccessExceptionString(), e);
        }
    }

    private void printJavaStackFrameInfo(JavaThread jt) {
        Iterator itStackFrame = jt.getStackFrames();
        if (!itStackFrame.hasNext()) {
            this.out.print("<no frames to print>\n");
            return;
        }
        this.out.print("\n");
        while (itStackFrame.hasNext()) {
            JavaLocation jl;
            Object next = itStackFrame.next();
            if (next instanceof CorruptData) {
                this.out.print("     " + Exceptions.getCorruptDataExceptionString() + "\n");
                return;
            }
            JavaStackFrame jsf = (JavaStackFrame)next;
            try {
                jl = jsf.getLocation();
            }
            catch (CorruptDataException e) {
                this.out.print("     " + Exceptions.getCorruptDataExceptionString() + "\n");
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                return;
            }
            this.out.print("     bp: ");
            try {
                this.out.print(this.toAdjustedHex(jsf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            this.out.print("  method: ");
            try {
                String signature = null;
                try {
                    signature = jl.getMethod().getSignature();
                }
                catch (CorruptDataException e) {
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                if (signature == null) {
                    this.out.print(jl.getMethod().getDeclaringClass().getName() + "." + jl.getMethod().getName());
                } else {
                    this.out.print(Utils.getReturnValueName(signature) + " " + jl.getMethod().getDeclaringClass().getName() + "." + jl.getMethod().getName() + Utils.getMethodSignatureName(signature));
                }
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            catch (DataUnavailable e) {
                this.out.print(Exceptions.getDataUnavailableString());
                this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), e);
            }
            boolean isNative = false;
            try {
                isNative = Modifier.isNative(jl.getMethod().getModifiers());
            }
            catch (CorruptDataException e) {
                this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
            }
            if (!isNative) {
                this.out.print("  source: ");
                try {
                    this.out.print(jl.getFilename());
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                this.out.print(":");
                try {
                    this.out.print(Integer.toString(jl.getLineNumber()));
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINE, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
            } else {
                this.out.print("  (Native Method)");
            }
            this.out.print("\n      objects:");
            Iterator itObjectRefs = jsf.getHeapRoots();
            if (!itObjectRefs.hasNext()) {
                this.out.print(" <no objects in this frame>");
            }
            while (itObjectRefs.hasNext()) {
                Object nextRef = itObjectRefs.next();
                if (nextRef instanceof CorruptData) {
                    this.out.print(Exceptions.getCorruptDataExceptionString() + "\n");
                    break;
                }
                JavaReference jr = (JavaReference)nextRef;
                try {
                    if (!jr.isObjectReference()) continue;
                    JavaObject target = (JavaObject)jr.getTarget();
                    this.out.print(" " + Utils.toHex(target.getID().getAddress()));
                }
                catch (DataUnavailable d) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), d);
                }
                catch (CorruptDataException e) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                    this.logger.log(Level.FINEST, Exceptions.getCorruptDataExceptionString(), e);
                }
                catch (NullPointerException n) {
                    this.out.print(Exceptions.getDataUnavailableString());
                    this.logger.log(Level.FINEST, Exceptions.getDataUnavailableString(), n);
                }
            }
            this.out.print("\n");
        }
    }

    private String toAdjustedHex(long l) {
        if (this._pointerSize > 32) {
            return "0x" + Utils.toFixedWidthHex(l);
        }
        if (31 == this._pointerSize) {
            return "0x" + Utils.toFixedWidthHex((int)(l & (1L << this._pointerSize) - 1L));
        }
        return "0x" + Utils.toFixedWidthHex((int)l);
    }

    private void printThreadSummary(ImageProcess ip) {
        int count = 0;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) continue;
            ImageThread it = (ImageThread)next;
            if (count % 8 == 0) {
                if (0 == count) {
                    this.out.print("\n\nNative thread IDs for current process:");
                }
                this.out.print("\n ");
            }
            try {
                this.out.print(Utils.padWithSpaces(it.getID(), 8));
            }
            catch (CorruptDataException e) {
                this.out.print(Exceptions.getCorruptDataExceptionString());
            }
            ++count;
        }
        this.out.print("\n");
    }

    private void printProperties(ImageThread it) {
        Properties jtp = it.getProperties();
        Object[] keys = jtp.keySet().toArray(new String[0]);
        ArrayList<String> table = new ArrayList<String>(keys.length);
        int maxLen = 0;
        Arrays.sort(keys);
        for (Object key : keys) {
            String formatted = String.format("%s=%s", key, jtp.get(key));
            table.add(formatted);
            maxLen = Math.max(maxLen, formatted.length());
        }
        Iterator tableIterator = table.iterator();
        String tableFormatString = "\t%-" + maxLen + "s\t%-" + maxLen + "s\n";
        while (tableIterator.hasNext()) {
            this.out.printf(tableFormatString, tableIterator.next(), tableIterator.hasNext() ? tableIterator.next() : "");
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("Displays information about Java and native threads\n\nParameters: none, native thread ID, zOS TCB address, \"all\", or \"*\"\n\nIf no parameter is supplied, information is printed for the current or failing thread, if any\nIf a native thread ID or zOS TCB address is supplied, information is printed for that specific thread\nIf \"all\", or \"*\" is specified, information is printed for all threads\n\nThe following information is printed for each thread:\n - native thread ID\n - registers\n - native stack sections\n - native stack frames: procedure name and base pointer\n - thread properties\n - associated Java thread (if applicable):\n  - name of Java thread\n  - address of associated java.lang.Thread object\n  - current state according to JVMTI specification\n  - current state relative to java.lang.Thread.State\n  - the Java thread priority\n  - the monitor the thread is waiting to enter or waiting on notify\n  - Java stack frames: base pointer, method, source filename and objects on frame\n\nNote: the \"info proc\" command provides a summary list of native thread IDs\n");
    }
}

