/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoMmapCommand
extends BaseJdmpviewCommand {
    public InfoMmapCommand() {
        this.addCommand("info mmap", "[address] [-verbose] [-sort:<size|address>]", "Outputs a list of all memory segments in the address space");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        boolean verbose = false;
        ImagePointer addressPointer = null;
        Comparator<ImageSection> sortOrder = null;
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        for (String arg : args) {
            if ("-sort:size".equals(arg)) {
                sortOrder = new SizeComparator();
                continue;
            }
            if ("-sort:address".equals(arg)) {
                sortOrder = new AddressComparator();
                continue;
            }
            if ("-verbose".equals(arg)) {
                verbose = true;
                continue;
            }
            Long address = Utils.longFromString(arg);
            if (address == null) {
                out.println("\"info mmap\" -unknown parameter " + arg);
                return;
            }
            addressPointer = this.ctx.getAddressSpace().getPointer(address.longValue());
        }
        LinkedList sortedSections = new LinkedList();
        Iterator imageSections = this.ctx.getAddressSpace().getImageSections();
        while (imageSections.hasNext()) {
            sortedSections.add(imageSections.next());
        }
        if (sortOrder != null) {
            Collections.sort(sortedSections, sortOrder);
        }
        int addrSize = this.ctx.getProcess().getPointerSize() == 64 ? 16 : 8;
        int decWidth = 0;
        int hexWidth = 0;
        if (addrSize == 16) {
            hexWidth = String.format("%016x", Long.MAX_VALUE).length();
            decWidth = String.format("(%,d)", Long.MAX_VALUE).length();
        } else {
            hexWidth = String.format("%08x", Integer.MAX_VALUE).length();
            decWidth = String.format("(%,d)", Integer.MAX_VALUE).length();
        }
        out.printf("%-" + hexWidth + "s\t%-" + hexWidth + "s\t%-" + hexWidth + "s\t%-" + decWidth + "s\tRead/Write/Execute", "Start Address", "End Address", "Size", "Size");
        out.println();
        long totalSize = 0L;
        long totalSizeRwx = 0L;
        for (ImageSection imageSection : sortedSections) {
            if (addressPointer != null && (imageSection.getBaseAddress().getAddress() > addressPointer.getAddress() || imageSection.getBaseAddress().add(imageSection.getSize()).getAddress() <= addressPointer.getAddress())) continue;
            long startAddress = imageSection.getBaseAddress().getAddress();
            long size = imageSection.getSize();
            long endAddress = startAddress + size - 1L;
            totalSize += size;
            String decSize = String.format("(%,d)", size);
            out.printf("0x%0" + hexWidth + "x\t0x%0" + hexWidth + "x\t0x%0" + hexWidth + "x\t%-" + decWidth + "s\t", startAddress, endAddress, size, decSize);
            Properties props = imageSection.getProperties();
            if (props != null) {
                boolean rwx = false;
                if (Boolean.TRUE.toString().equals(props.get("readable"))) {
                    out.print("R");
                    rwx = true;
                }
                if (Boolean.TRUE.toString().equals(props.get("writable"))) {
                    out.print("W");
                    rwx = true;
                }
                if (Boolean.TRUE.toString().equals(props.get("executable"))) {
                    out.print("X");
                    rwx = true;
                }
                if (rwx) {
                    totalSizeRwx += size;
                }
            }
            if (verbose || addressPointer != null) {
                out.println();
                out.println("Name:\t" + imageSection.getName());
                Object[] keys = props.keySet().toArray(new String[0]);
                ArrayList<String> table = new ArrayList<String>(keys.length);
                int maxLen = 0;
                Arrays.sort(keys);
                for (Object key : keys) {
                    String formatted = String.format("%s=%s", key, props.get(key));
                    table.add(formatted);
                    maxLen = Math.max(maxLen, formatted.length());
                }
                Iterator tableIterator = table.iterator();
                String tableFormatString = "\t%-" + maxLen + "s\t%-" + maxLen + "s\n";
                while (tableIterator.hasNext()) {
                    out.printf(tableFormatString, tableIterator.next(), tableIterator.hasNext() ? tableIterator.next() : "");
                }
                out.println();
                continue;
            }
            out.println();
        }
        if (addressPointer == null) {
            if (totalSizeRwx > 0L && totalSize != totalSizeRwx) {
                out.printf("Total size (Readable, Writable or Executable): 0x%1$x (%1$,d) bytes\n", totalSizeRwx);
            }
            out.printf("Total size: 0x%1$x (%1$,d) bytes\n", totalSize);
        }
    }

    private static int cmp(long n1, long n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 > n2) {
            return 1;
        }
        return -1;
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("outputs a list of all memory segments in the address space\n\nparameters: none, an address in memory, sort flags, verbose output\n\nIf no address is specified outputs a list all memory segments (ImageSections) in the address space with start address, size and properties\nThis output may be sorted using the -sort:address,  or -sort:size flags.\nIf -verbose is specified then each memory segment is followed by any further detailed information.If an address is specified then just the memory segment containing that address is output.\n");
    }

    private class AddressComparator
    implements Comparator<ImageSection> {
        private AddressComparator() {
        }

        @Override
        public int compare(ImageSection o1, ImageSection o2) {
            long a1 = o1.getBaseAddress().getAddress();
            long a2 = o2.getBaseAddress().getAddress();
            return InfoMmapCommand.cmp(a1, a2);
        }
    }

    private class SizeComparator
    implements Comparator<ImageSection> {
        private SizeComparator() {
        }

        @Override
        public int compare(ImageSection o1, ImageSection o2) {
            long s1 = o1.getSize();
            long s2 = o2.getSize();
            return InfoMmapCommand.cmp(s1, s2);
        }
    }
}

