/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class ScrollCommand
extends BaseJdmpviewCommand {
    public ScrollCommand() {
        this.addCommand("+", "", "displays the next section of memory in hexdump-like format");
        this.addCommand("-", "", "displays the previous section of memory in hexdump-like format");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        Long currentMemAddress = (Long)this.ctx.getProperties().get("currentMemPtrAddress");
        Integer currentNumBytesToPrint = (Integer)this.ctx.getProperties().get("currentNumBytes");
        if (null == currentMemAddress || null == currentNumBytesToPrint) {
            out.println("ERROR - starting mem address or the number of bytes to print needs to be set by running hexdump command");
            return;
        }
        long newMemAddrss = 0L;
        if (command.equals("+")) {
            newMemAddrss = currentMemAddress + (long)currentNumBytesToPrint.intValue();
        }
        if (command.equals("-")) {
            newMemAddrss = currentMemAddress - (long)currentNumBytesToPrint.intValue();
        }
        this.ctx.getProperties().put("currentMemPtrAddress", (Object)newMemAddrss);
        this.ctx.execute("hexdump", new String[]{Long.toHexString(newMemAddrss), currentNumBytesToPrint.toString()}, out);
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("displays the next section of memory in hexdump-like format\n\nparameters: none\n\nThe + command is used in conjunction with the hexdump command \nto allow easy scrolling forwards through memory. It repeats the \nprevious hexdump command starting from the end of the previous one.\nThe - command is used in conjunction with the hexdump command \nto allow easy scrolling backwards through memory. It repeats \nthe previous hexdump command starting from a position \nbefore the previous one.");
    }
}

