/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class HexdumpCommand
extends BaseJdmpviewCommand {
    public HexdumpCommand() {
        this.addCommand("hexdump", "<hex address>", "outputs a section of memory in hexadecimal, ascii and ebcdic");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        this.doCommand(args);
    }

    public void doCommand(String[] args) {
        long i;
        Long address;
        StringBuffer stringBuffer = new StringBuffer();
        ImageAddressSpace imageAddressSpace = this.ctx.getAddressSpace();
        if (null == imageAddressSpace) {
            this.out.println("Could not find an address space which contains a process in this core file");
            return;
        }
        long addressInDecimal = 0L;
        int numBytesToPrint = 256;
        int asciiIndex = 0;
        if (args.length != 0) {
            address = Utils.longFromString(args[0]);
            if (null == address) {
                this.out.println("Specified address is invalid");
                return;
            }
        } else {
            this.out.println("\"hexdump\" requires at least an address parameter");
            return;
        }
        addressInDecimal = address;
        if (args.length > 1) {
            try {
                numBytesToPrint = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException nfe) {
                this.out.println("Specified length is invalid");
                return;
            }
        }
        ImagePointer imagePointerBase = imageAddressSpace.getPointer(addressInDecimal);
        boolean is_zOSdump = false;
        try {
            is_zOSdump = this.ctx.getImage().getSystemType().toLowerCase().indexOf("z/os") >= 0;
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        String asciiChars = "";
        String ebcdicChars = "";
        for (i = 0L; i < (long)numBytesToPrint; ++i) {
            ImagePointer imagePointer = imagePointerBase.add(i);
            try {
                String fixedHexString;
                byte byteValue = imagePointer.getByteAt(0L);
                asciiIndex = byteValue & 0xFF;
                String rawHexString = Integer.toHexString(asciiIndex);
                String hexText = fixedHexString = this.fixHexStringLength(rawHexString);
                if (0L == i % 4L) {
                    hexText = " " + hexText;
                }
                if (0L == i % 16L) {
                    hexText = "\n" + Long.toHexString(imagePointer.getAddress()) + ":" + hexText;
                    asciiChars = "  |";
                    ebcdicChars = " |";
                }
                stringBuffer.append(hexText);
                asciiChars = asciiChars + "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................".substring(asciiIndex, asciiIndex + 1);
                if (15L == i % 16L && i != 0L) {
                    asciiChars = asciiChars + "|";
                    stringBuffer.append(asciiChars);
                }
                if (!is_zOSdump) continue;
                ebcdicChars = ebcdicChars + ".................................................................................................................................abcdefghi.......jklmnopqr........stuvwxyz.......................ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......".substring(asciiIndex, asciiIndex + 1);
                if (15L != i % 16L || i == 0L) continue;
                ebcdicChars = ebcdicChars + "|";
                stringBuffer.append(ebcdicChars);
                continue;
            }
            catch (MemoryAccessException e) {
                this.out.println("Address not in memory - 0x" + Long.toHexString(imagePointer.getAddress()));
                return;
            }
            catch (CorruptDataException e) {
                this.out.println("Dump data is corrupted");
                return;
            }
        }
        long undisplayedBytes = 16L - i % 16L;
        if (16L != undisplayedBytes) {
            stringBuffer.append(this.padSpace(undisplayedBytes, asciiChars));
            if (is_zOSdump) {
                int j = 0;
                while ((long)j < undisplayedBytes) {
                    ebcdicChars = " " + ebcdicChars;
                    ++j;
                }
                stringBuffer.append(" " + ebcdicChars);
            }
        }
        stringBuffer.append("\n");
        this.out.println(new String(stringBuffer));
        this.ctx.getProperties().put("currentMemPtrAddress", (Object)addressInDecimal);
        this.ctx.getProperties().put("currentNumBytes", (Object)numBytesToPrint);
    }

    private String padSpace(long undisplayedBytes, String asciiChars) {
        int i = 0;
        while ((long)i < 2L * undisplayedBytes + undisplayedBytes / 4L) {
            asciiChars = " " + asciiChars;
            ++i;
        }
        return asciiChars;
    }

    private String fixHexStringLength(String rawHexString) {
        int length = rawHexString.length();
        if (1 == length) {
            return "0" + rawHexString;
        }
        if (2 == length) {
            return rawHexString;
        }
        if (8 == length) {
            return rawHexString.substring(6, 8);
        }
        return "ERROR fixHexStringLength";
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println("outputs a section of memory in hexadecimal, ascii and ebcdic\n\nparameters: <hex_address> <bytes_to_print>\n\noutputs <bytes_to_print> bytes of memory contents starting from <hex_address>, ebcdic output is provided for z/OS dumps");
    }
}

