/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandParser;
import com.ibm.jvm.dtfjview.CombinedContext;
import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.JdmpviewContextManager;
import com.ibm.jvm.dtfjview.JdmpviewInitException;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.OutputChannelRedirector;
import com.ibm.jvm.dtfjview.spi.ICombinedContext;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import com.ibm.jvm.dtfjview.spi.ISession;
import com.ibm.jvm.dtfjview.spi.ISessionContextManager;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.ToolsRegistry;
import com.ibm.jvm.dtfjview.tools.ToolsRegistryOutputChannels;
import com.ibm.jvm.dtfjview.tools.impl.CmdFileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Session
implements ISession {
    public static final String LOGGER_PROPERTY = "com.ibm.jvm.dtfjview.logger";
    private String factoryName;
    private IOutputManager out;
    private static final String PROMPT_FORMAT_DEFAULT = "> ";
    private static final String PROMPT_FORMAT_MULTICONTEXT = "CTX:%d> ";
    public static String prompt = "> ";
    private static final String ARG_CORE = "-core";
    private static final String ARG_ZIP = "-zip";
    private static final String ARG_VERSION = "-version";
    private static final String ARG_VERBOSE = "-verbose";
    private static final String ARG_CMDFILE = "-cmdfile";
    private static final String ARG_CHARSET = "-charset";
    private static final String ARG_OUTFILE = "-outfile";
    private static final String ARG_OVERWRITE = "-overwrite";
    private static final String ARG_APPEND = "-append";
    private static final String ARG_NOEXTRACT = "-notemp";
    private static final String ARG_LEGACYZIP = "-legacyzip";
    private CmdLineParseStateEnum parseState = CmdLineParseStateEnum.PARSE_SCAN;
    private final Map<String, String> args = new HashMap<String, String>();
    private final Set<String> singleargs = new HashSet<String>();
    private final Set<String> pairedargs = new HashSet<String>();
    private final Queue<String> commands = new LinkedList<String>();
    private final Set<String> sessioncommands = new HashSet<String>();
    private boolean isInteractiveSession = false;
    private boolean isVerboseEnabled = false;
    private IOutputChannel defaultOutputChannel = null;
    private FileOutputChannel foc = null;
    private String charsetName = null;
    private CombinedContext ctxroot = null;
    private int ctxid = 0;
    private ICombinedContext currentContext = null;
    private static final String CMD_CONTEXT = "context";
    private static final String CMD_OPEN = "open";
    private static final String CMD_CLOSE = "close";
    private static final String CMD_CD = "cd";
    private static final String CMD_PWD = "pwd";
    private boolean isZOS = false;
    private final HashMap<String, Object> variables = new HashMap();
    private final Logger logger = Logger.getLogger("com.ibm.jvm.dtfjview.logger");
    private final ISessionContextManager ctxmgr = new JdmpviewContextManager();

    public static ISession getInstance(String[] args) {
        return new Session(args);
    }

    private Session(String[] args) {
        this.singleargs.add(ARG_VERBOSE);
        this.singleargs.add(ARG_VERSION);
        this.singleargs.add(ARG_OVERWRITE);
        this.singleargs.add(ARG_APPEND);
        this.singleargs.add(ARG_NOEXTRACT);
        this.singleargs.add(ARG_LEGACYZIP);
        this.pairedargs.add(ARG_CMDFILE);
        this.pairedargs.add(ARG_CORE);
        this.pairedargs.add(ARG_OUTFILE);
        this.pairedargs.add(ARG_CHARSET);
        this.pairedargs.add(ARG_ZIP);
        this.sessioncommands.add(CMD_CLOSE);
        this.sessioncommands.add(CMD_OPEN);
        this.sessioncommands.add(CMD_CD);
        this.sessioncommands.add(CMD_PWD);
        this.sessionInit(args);
    }

    @Override
    public IOutputManager getOutputManager() {
        return this.out;
    }

    public String getCharset() {
        return this.charsetName;
    }

    private void sessionInit(String[] cmdlineargs) {
        this.out = new Output();
        this.defaultOutputChannel = new ConsoleOutputChannel();
        this.out.addChannel(this.defaultOutputChannel);
        this.variables.put(CMD_PWD, new File(System.getProperty("user.dir")));
        this.variables.put(LOGGER_PROPERTY, Logger.getLogger(LOGGER_PROPERTY));
        this.parseCommandLineArgs(cmdlineargs);
        this.variables.put("extract.mode", !this.hasFlagBeenSet(ARG_NOEXTRACT));
        this.variables.put("zip.mode.legacy", this.hasFlagBeenSet(ARG_LEGACYZIP));
        this.isVerboseEnabled = this.hasFlagBeenSet(ARG_VERBOSE);
        this.charsetName = this.args.get(ARG_CHARSET);
        ToolsRegistry.initialize(this);
        ToolsRegistryOutputChannels.addChannel(this.defaultOutputChannel);
        if (this.isVerboseEnabled) {
            this.enableConsoleLogging(this.logger);
            this.enableConsoleLogging(Logger.getLogger("com.ibm.dtfj.log"));
            this.variables.put("verbose.mode", "true");
        }
        this.logCommandLineArgs();
        this.processCommandFile();
        this.processOutfile();
        this.isInteractiveSession = this.args.get(ARG_CMDFILE) == null && this.commands.isEmpty();
        this.ctxroot = new CombinedContext(0, 0, null, null, null, null, -1);
        this.initializeContext(this.ctxroot);
        this.currentContext = this.ctxroot;
        System.setProperty("com.ibm.j9ddr.noextrasearchfornode", "true");
        if (this.args.containsKey(ARG_CORE) || this.args.containsKey(ARG_ZIP) || this.args.containsKey(ARG_VERSION)) {
            this.imageFromCommandLine();
        }
    }

    private void initializeContext(IDTFJContext ctx) {
        ctx.refresh();
        ctx.getProperties().put("session", this);
        for (String key : this.variables.keySet()) {
            ctx.getProperties().put(key, this.variables.get(key));
        }
    }

    private void setPrompt() {
        prompt = this.ctxmgr.hasMultipleContexts() ? String.format(PROMPT_FORMAT_MULTICONTEXT, this.ctxid) : String.format(PROMPT_FORMAT_DEFAULT, new Object[0]);
    }

    @Override
    public ICombinedContext getCurrentContext() {
        return this.currentContext;
    }

    @Override
    public ISessionContextManager getContextManager() {
        return this.ctxmgr;
    }

    @Override
    public void setContext(int id) throws com.ibm.java.diagnostics.utils.commands.CommandException {
        ICombinedContext switchTo = this.ctxmgr.getContext(id);
        if (switchTo == null) {
            throw new com.ibm.java.diagnostics.utils.commands.CommandException("The specified context ID of " + id + " is not valid. Execute \"" + CMD_CONTEXT + "\" to see the list of valid IDs.");
        }
        this.setContext(switchTo);
    }

    @Override
    public void setContext(ICombinedContext switchTo) throws com.ibm.java.diagnostics.utils.commands.CommandException {
        if (switchTo != null) {
            this.ctxid = switchTo.getID();
            this.currentContext = switchTo;
            switchTo.setAsCurrent();
            this.setPrompt();
        }
    }

    @Override
    public void showContexts(boolean shortFormat) {
        this.out.println("Available contexts (* = currently selected context) : ");
        Map<URI, ArrayList<ICombinedContext>> contexts = this.ctxmgr.getContexts();
        if (contexts.size() == 0) {
            this.out.println("\n\tWARNING : no contexts were found");
            return;
        }
        URI currentSource = null;
        for (URI source : contexts.keySet()) {
            if (!source.equals(currentSource)) {
                this.out.println("\nSource : " + source.getScheme() + "://" + source.getPath() + (source.getFragment() != null ? "#" + source.getFragment() : ""));
                currentSource = source;
            }
            for (ICombinedContext context : contexts.get(source)) {
                if (context == this.currentContext) {
                    this.out.print("\t*");
                } else {
                    this.out.print("\t ");
                }
                context.displayContext(this.out, shortFormat);
            }
        }
        this.out.print("\n");
    }

    private void exit(String msg, int exitCode) {
        if (System.getProperty("com.ibm.jvm.dtfjview.nosystemexit") == null) {
            if (msg != null && msg.length() > 0) {
                this.out.println(msg);
            }
            if (exitCode != 0 && exitCode != 4) {
                this.printHelp();
            }
        } else {
            throw new JdmpviewInitException(exitCode, msg);
        }
        System.exit(exitCode);
    }

    private boolean hasFlagBeenSet(String name) {
        if (this.singleargs.contains(name)) {
            String value = this.args.get(name);
            if (value == null) {
                return false;
            }
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    private void parseCommandLineArgs(String[] cmdargs) {
        if (cmdargs.length == 0) {
            this.exit("No parameters were supplied", 1);
        }
        for (int i = 0; i < cmdargs.length; ++i) {
            if (cmdargs[i].contains("'")) {
                if (!cmdargs[i].contains("\"")) {
                    cmdargs[i] = "\"" + cmdargs[i] + "\"";
                    continue;
                }
                this.exit("Ambiguous parameter " + cmdargs[i] + " - mixed ' and \" encountered", 1);
                continue;
            }
            if (cmdargs[i].contains("\"")) {
                if (!cmdargs[i].contains("'")) {
                    cmdargs[i] = "'" + cmdargs[i] + "'";
                    continue;
                }
                this.exit("Ambiguous parameter " + cmdargs[i] + " - mixed ' and \" encountered", 1);
                continue;
            }
            if (!cmdargs[i].matches(".*\\s.+")) continue;
            cmdargs[i] = "\"" + cmdargs[i] + "\"";
        }
        StringBuilder line = new StringBuilder();
        int index = 0;
        block7: while (index < cmdargs.length && this.parseState != CmdLineParseStateEnum.PARSE_COMPLETE) {
            String cmdarg = cmdargs[index].toLowerCase();
            switch (this.parseState) {
                case PARSE_SCAN: {
                    if (cmdarg.charAt(0) == '-') {
                        this.checkArgIsRecognised(cmdargs[index]);
                        if (this.singleargs.contains(cmdarg)) {
                            this.parseState = CmdLineParseStateEnum.PARSE_SINGLE;
                            continue block7;
                        }
                        this.parseState = CmdLineParseStateEnum.PARSE_PAIR;
                        continue block7;
                    }
                    if (index == 0) {
                        this.exit("A core file or zip file needs to be specified", 1);
                        continue block7;
                    }
                    this.parseState = CmdLineParseStateEnum.PARSE_CMDS;
                    continue block7;
                }
                case PARSE_SINGLE: {
                    this.args.put(cmdarg, "true");
                    this.parseState = ++index == cmdargs.length ? CmdLineParseStateEnum.PARSE_COMPLETE : CmdLineParseStateEnum.PARSE_SCAN;
                    continue block7;
                }
                case PARSE_PAIR: {
                    if (++index < cmdargs.length && cmdargs[index].length() > 0 && cmdargs[index].charAt(0) != '-') {
                        this.args.put(cmdarg, cmdargs[index]);
                    } else {
                        this.exit("The parameter " + cmdarg + " requires a value to be set", 1);
                    }
                    this.parseState = ++index == cmdargs.length ? CmdLineParseStateEnum.PARSE_COMPLETE : CmdLineParseStateEnum.PARSE_SCAN;
                    continue block7;
                }
                case PARSE_CMDS: {
                    if (cmdarg.charAt(0) == '-') {
                        this.exit("The startup option " + cmdarg + " occurred in an unexpected position", 1);
                    }
                    line.append(cmdargs[index]);
                    if (++index < cmdargs.length) {
                        line.append(" ");
                        continue block7;
                    }
                    this.commands.add(line.toString());
                    this.parseState = CmdLineParseStateEnum.PARSE_COMPLETE;
                    continue block7;
                }
            }
            this.exit("Internal error occurred an unknown state was reached whilst processing the command line args", 4);
        }
        if (this.parseState != CmdLineParseStateEnum.PARSE_COMPLETE) {
            this.exit("Internal error occurred whilst processing the command line args", 4);
        }
    }

    private void checkArgIsRecognised(String cmdarg) {
        if (this.pairedargs.contains(cmdarg) || this.singleargs.contains(cmdarg)) {
            return;
        }
        this.exit("The command " + cmdarg + " was not recognised", 1);
    }

    private void logCommandLineArgs() {
        if (!this.isVerboseEnabled) {
            return;
        }
        this.out.println("Startup parameters: ");
        for (String key : this.args.keySet()) {
            this.out.print("    " + key);
            if (this.args.get(key) == null) {
                this.out.println(" : not set");
                continue;
            }
            this.out.println(" = " + this.args.get(key));
        }
        this.out.println("Batch mode commands: " + this.commands.toString());
    }

    private void printHelp() {
        String launcher = System.getProperty("com.ibm.jvm.dtfjview.launcher", "dtfjview");
        this.out.print("Usage: \"" + launcher + " -core <core_file> [-verbose]\" or \n       \"" + launcher + " -zip <zip_file> [-verbose]\" or \n       \"" + launcher + " -version\"\n\nTo analyze dumps from DDR-enabled JVMs, " + launcher + " only requires a core file.\n\nThe default ImageFactory is " + this.factoryName + ". To change the ImageFactory use: \n\t -J-D" + "com.ibm.dtfj.image.factoryclass" + "=<classname> \n\n");
        this.out.print(launcher + " can also be used in 'batch mode' whereby commands can be issued without entering an interactive prompt.\nThis processing is controlled via the following command line options :\n        -cmdfile <path to command file> : will read and sequentially execute\n                                          a series of " + launcher + " commands in the specified file\n        -charset <character set name>   : specifies the character set for the commands in -cmdfile.\n        -outfile <path to output file>  : file to store any output generated by commands\n        -overwrite                      : specifies that the file specified by -outfile should be overwritten\n        -append                         : specifies that the file specified by -outfile should be appended.\n\nIt is possible to execute a single command without specifying a command file by appending the command to the end\n of the command line which executes " + launcher + "\ne.g. " + launcher + " -core mycore.dmp info class\n\nFinally, some commands which take the * parameter will need to have that specified on the command line as ALL\nThis is to ensure correct processing by the OS e.g. " + launcher + " -core mycore.dmp info thread ALL\n");
    }

    private void processOutfile() {
        if (!this.args.containsKey(ARG_OUTFILE)) {
            return;
        }
        String name = this.stripQuotesFromFilename(this.args.get(ARG_OUTFILE));
        File file = new File(name);
        boolean append = this.hasFlagBeenSet(ARG_APPEND);
        boolean overwrite = this.hasFlagBeenSet(ARG_OVERWRITE);
        if (append && overwrite) {
            this.exit("Option -append and option -overwrite can not be used at the same time.", 6);
        }
        if (file.exists()) {
            boolean hasBeenDeleted;
            if (this.isVerboseEnabled) {
                this.out.println("Specified output file " + this.args.get(ARG_OUTFILE) + " already exists, checking " + ARG_OVERWRITE + " flag and " + ARG_APPEND + " flag");
            }
            if (!overwrite && !append) {
                this.exit("The output file " + file.getAbsolutePath() + " exists and neither " + ARG_OVERWRITE + " option nor " + ARG_APPEND + " option was specified", 5);
            }
            if (!file.isFile()) {
                this.exit("The output file " + file.getAbsolutePath() + " exists but is not a file", 2);
            }
            if (overwrite && !(hasBeenDeleted = file.delete())) {
                this.exit("The output file " + file.getAbsolutePath() + " exists, and is a file, but could not be deleted", 2);
            }
        }
        try {
            FileWriter writer = null;
            writer = file.exists() && append ? new FileWriter(file, true) : new FileWriter(file);
            this.foc = new FileOutputChannel(writer, file);
            this.out.addChannel(this.foc);
            ToolsRegistryOutputChannels.addChannel(this.foc);
        }
        catch (IOException e) {
            this.logException("Error creating output file", e);
            this.exit("Unexpected error creating the output file " + file.getAbsolutePath(), 4);
        }
    }

    private String stripQuotesFromFilename(String name) {
        if (name.length() > 0 && name.charAt(0) == '\"') {
            name = name.substring(1);
        }
        if (name.length() > 0 && name.charAt(name.length() - 1) == '\"') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    private void processCommandFile() {
        if (!this.args.containsKey(ARG_CMDFILE)) {
            return;
        }
        List<String> cmds = this.parseCommandsFromFile();
        if (cmds != null) {
            this.commands.addAll(cmds);
        }
    }

    private List<String> parseCommandsFromFile() {
        String name = this.stripQuotesFromFilename(this.args.get(ARG_CMDFILE));
        File file = new File(name);
        if (!file.exists() || !file.isFile()) {
            this.exit("The specified command file " + file.getAbsolutePath() + " does not exist or is not a file", 2);
        }
        if (file.length() > Integer.MAX_VALUE) {
            this.exit("The specified command file " + file.getAbsolutePath() + " is too large to be read", 2);
        }
        String charset = null;
        if (this.args.containsKey(ARG_CHARSET)) {
            charset = this.args.get(ARG_CHARSET);
        }
        try {
            return CmdFileTool.parseCmdFile(file, charset);
        }
        catch (UnsupportedEncodingException e) {
            this.exit("The supplied charset " + charset + " for reading the command file is not supported", 1);
            return null;
        }
        catch (IOException e) {
            this.logException("Error reading from command file " + file.getAbsolutePath(), e);
            this.exit("Error reading from command file " + file.getAbsolutePath(), 2);
            return null;
        }
    }

    private void imageFromCommandLine() {
        if (this.hasFlagBeenSet(ARG_VERSION)) {
            this.ctxroot.execute(CMD_OPEN, this.out.getPrintStream());
            this.exit(null, 0);
        }
        String coreFilePath = null;
        if (this.hasFlagBeenSet(ARG_VERBOSE)) {
            Logger.getLogger("j9ddr.view.dtfj").setLevel(Level.WARNING);
        }
        long current = System.currentTimeMillis();
        if (this.args.containsKey(ARG_CORE)) {
            if (this.args.containsKey(ARG_ZIP)) {
                this.exit("-zip and -core cannot be specified at the same time", 1);
            } else {
                coreFilePath = this.args.get(ARG_CORE);
                this.ctxroot.execute("open " + coreFilePath, this.out.getPrintStream());
            }
        } else {
            coreFilePath = this.args.get(ARG_ZIP);
            this.ctxroot.execute("open " + coreFilePath, this.out.getPrintStream());
        }
        this.logger.fine(String.format("Time taken to load image %d ms", System.currentTimeMillis() - current));
        this.variables.put("core_file_path", coreFilePath);
    }

    @Override
    public void findAndSetContextWithJVM() {
        try {
            Collection<ArrayList<ICombinedContext>> sources = this.ctxmgr.getContexts().values();
            if (sources.size() == 0) {
                this.currentContext = this.ctxroot;
                return;
            }
            ICombinedContext defaultContext = null;
            for (ArrayList<ICombinedContext> contexts : sources) {
                for (ICombinedContext context : contexts) {
                    if (defaultContext == null) {
                        defaultContext = context;
                    }
                    if (context.getRuntime() == null) continue;
                    this.setContext(context);
                    return;
                }
            }
            this.setContext(defaultContext);
        }
        catch (com.ibm.java.diagnostics.utils.commands.CommandException e) {
            this.out.print("ERROR : Unable to set current context");
        }
    }

    public void run() {
        if (this.currentContext == null) {
            this.out.println("No current context - exiting");
            return;
        }
        try {
            if (this.isInteractiveSession) {
                this.runInteractive();
            } else {
                this.runBatch();
            }
        }
        catch (Exception e) {
            this.out.println("Unexpected system error, terminating application. Run with -verbose for more information");
            this.logger.log(Level.FINE, "Failed to start the session", e);
        }
        try {
            this.ctxmgr.removeAllContexts();
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "Error closing contexts: ", e);
            this.out.println("Error closing contexts: " + e.getMessage());
        }
    }

    private void runBatch() {
        this.findAndSetContextWithJVM();
        this.showContexts(true);
        String line = null;
        PrintStream printStream = ToolsRegistryOutputChannels.newPrintStream();
        while ((line = this.commands.poll()) != null) {
            printStream.println(prompt + line);
            try {
                ToolsRegistry.recordAndExecute(line);
            }
            catch (CommandException e) {
                this.out.println(e.getMessage());
            }
        }
        this.out.close();
    }

    private void runInteractive() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        String quit = "";
        this.out.println("For a list of commands, type \"help\"; for how to use \"help\", type \"help help\"");
        while (quit == null || !quit.equals("on")) {
            if (this.ctxmgr.hasChanged()) {
                if (this.currentContext instanceof CombinedContext) {
                    int id = this.currentContext.getID();
                    if (this.ctxmgr.getContext(id) == null) {
                        this.findAndSetContextWithJVM();
                    }
                } else {
                    this.findAndSetContextWithJVM();
                }
                this.showContexts(true);
                this.setPrompt();
            }
            this.out.printPrompt(prompt);
            try {
                input = stdin.readLine();
            }
            catch (IOException e) {
                this.out.print("IOException encountered while reading input; exiting program...");
                break;
            }
            if (null == input) {
                this.out.print("End of input stream has been reached; exiting program...");
                break;
            }
            try {
                ToolsRegistry.recordAndExecute(input);
            }
            catch (CommandException e) {
                this.out.println(e.getMessage());
            }
            quit = (String)this.currentContext.getProperties().get("quit");
        }
        this.out.close();
    }

    public void execute(String line, PrintStream redirector) {
        this.out.removeChannel(this.defaultOutputChannel);
        if (this.foc != null) {
            this.out.removeChannel(this.foc);
        }
        OutputChannelRedirector temp = new OutputChannelRedirector(redirector);
        this.out.addChannel(temp);
        this.execute(line);
        this.out.removeChannel(temp);
        if (this.foc != null) {
            this.out.addChannel(this.foc);
        }
        this.out.addChannel(this.defaultOutputChannel);
    }

    @Override
    public void execute(String line) {
        String trimmedInput = line.trim();
        if (!trimmedInput.equals("")) {
            try {
                CommandParser parser = new CommandParser(line);
                String cmd = parser.getCommand();
                if (cmd.equals(CMD_CONTEXT)) {
                    this.switchContext(trimmedInput.toLowerCase());
                } else if (cmd.equals("set") && parser.getArguments().length > 0 && parser.getArguments()[0].equals("logging")) {
                    String[] oldargs = parser.getArguments();
                    String[] newargs = new String[oldargs.length - 1];
                    System.arraycopy(oldargs, 1, newargs, 0, newargs.length);
                    this.ctxroot.execute("set logging", newargs, this.out.getPrintStream());
                } else if (cmd.equals("show") && parser.getArguments().length > 0 && parser.getArguments()[0].equals("logging")) {
                    String[] oldargs = parser.getArguments();
                    String[] newargs = new String[oldargs.length - 1];
                    System.arraycopy(oldargs, 1, newargs, 0, newargs.length);
                    this.ctxroot.execute("show logging", newargs, this.out.getPrintStream());
                } else if (this.sessioncommands.contains(cmd)) {
                    this.ctxroot.execute(parser, this.out.getPrintStream());
                } else {
                    this.currentContext.execute(parser, this.out.getPrintStream());
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINEST, "An error occurred while processing the command: " + line, e);
                this.out.print("An error occurred while processing the command: " + line);
            }
        }
    }

    private void switchContext(String input) {
        String[] args = input.trim().split(" ");
        try {
            switch (args.length) {
                case 1: {
                    this.showContexts(false);
                    return;
                }
                case 2: {
                    int radix = args[1].startsWith("0x") ? 16 : 10;
                    int id = 0;
                    id = radix == 16 ? Integer.parseInt(args[1].substring(2), radix) : Integer.parseInt(args[1], radix);
                    if (radix == 16 && this.isZOS) {
                        if (this.switchContextByASID(args[1])) {
                            return;
                        }
                        this.out.println("The ASID " + args[1] + " was not recognised, context is unchanged");
                        break;
                    }
                    this.setContext(id);
                    break;
                }
                case 3: {
                    if (args[1].equalsIgnoreCase("asid")) {
                        if (this.isZOS) {
                            if (!this.switchContextByASID(args[2])) {
                                this.out.println("The specified context ASID : " + args[2] + " is not a valid ASID");
                            }
                            break;
                        }
                        this.out.println("Switching context by ASID is not supported for this core file");
                        break;
                    }
                    this.out.println("Invalid command parameters, valid parameters are [ID|asid ID]");
                    break;
                }
                default: {
                    this.out.println("Invalid command parameters, valid parameters are [ID|asid ID]");
                    return;
                }
            }
        }
        catch (NumberFormatException e) {
            this.out.println("The specified context ID : " + input + " is not a valid ID");
        }
        catch (Exception e) {
            this.out.println(e.getMessage());
        }
    }

    private boolean switchContextByASID(String asid) throws Exception {
        int radix;
        int n = radix = asid.startsWith("0x") ? 16 : 10;
        if (radix == 16 && this.isZOS) {
            for (ArrayList<ICombinedContext> contexts : this.ctxmgr.getContexts().values()) {
                for (ICombinedContext context : contexts) {
                    if (!context.getAddressSpace().getID().equalsIgnoreCase(asid)) continue;
                    this.setContext(context);
                    return true;
                }
            }
        }
        return false;
    }

    private void enableConsoleLogging(Logger log) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINE);
        SimpleFormatter formatter = new SimpleFormatter();
        handler.setFormatter(formatter);
        log.addHandler(handler);
        log.setLevel(Level.FINE);
        if (this.isVerboseEnabled) {
            this.out.println("Console logging is now enabled for " + log.getName());
        }
    }

    private void logException(String message, Exception e) {
        Object obj = this.variables.get(LOGGER_PROPERTY);
        Logger log = null;
        if (null == obj || !(obj instanceof Logger)) {
            log = Logger.getAnonymousLogger();
            log.fine("Logger not configured or wrong property type, creating an anonymous one");
        } else {
            log = (Logger)obj;
        }
        log.log(Level.FINE, message, e);
    }

    private static enum CmdLineParseStateEnum {
        PARSE_SCAN,
        PARSE_PAIR,
        PARSE_SINGLE,
        PARSE_CMDS,
        PARSE_COMPLETE;

    }
}

