/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29_00.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29_00.pointer.I32Pointer;
import com.ibm.j9ddr.vm29_00.pointer.StructurePointer;
import com.ibm.j9ddr.vm29_00.structure.Header;
import com.ibm.j9ddr.vm29_00.types.I32;
import com.ibm.j9ddr.vm29_00.types.Scalar;
import com.ibm.j9ddr.vm29_00.types.UDATA;

@GeneratedPointerClass(structureClass=Header.class)
public class HeaderPointer
extends StructurePointer {
    public static final HeaderPointer NULL = new HeaderPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected HeaderPointer(long address) {
        super(address);
    }

    public static HeaderPointer cast(AbstractPointer structure) {
        return HeaderPointer.cast(structure.getAddress());
    }

    public static HeaderPointer cast(UDATA udata) {
        return HeaderPointer.cast(udata.longValue());
    }

    public static HeaderPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new HeaderPointer(address);
    }

    @Override
    public HeaderPointer add(long count) {
        return HeaderPointer.cast(this.address + Header.SIZEOF * count);
    }

    @Override
    public HeaderPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public HeaderPointer addOffset(long offset) {
        return HeaderPointer.cast(this.address + offset);
    }

    @Override
    public HeaderPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public HeaderPointer sub(long count) {
        return HeaderPointer.cast(this.address - Header.SIZEOF * count);
    }

    @Override
    public HeaderPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public HeaderPointer subOffset(long offset) {
        return HeaderPointer.cast(this.address - offset);
    }

    @Override
    public HeaderPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public HeaderPointer untag(long mask) {
        return HeaderPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public HeaderPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return Header.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_countOffset_", declaredType="int")
    public I32 count() throws CorruptDataException {
        return new I32(this.getIntAtOffset(Header._countOffset_));
    }

    public I32Pointer countEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)Header._countOffset_);
    }
}

