/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29_00.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29_00.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29_00.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29_00.pointer.VoidPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm29_00.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm29_00.types.UDATA;
import java.util.Arrays;
import java.util.Iterator;

public class GCHeapRegionManager {
    protected static GCHeapRegionManager singleton;
    protected MM_HeapRegionManagerPointer _heapRegionManager;
    GCHeapRegionDescriptor[] _auxRegionDescriptorList;
    protected int _auxRegionCount;
    protected UDATA _regionSize;
    protected UDATA _regionShift;
    protected GCHeapRegionDescriptor[] _regionTable;
    protected int _tableRegionCount;
    protected VoidPointer _lowTableEdge;
    protected VoidPointer _highTableEdge;
    protected UDATA _tableDescriptorSize;
    protected UDATA _totalHeapSize;

    protected GCHeapRegionManager(MM_HeapRegionManagerPointer hrm) throws CorruptDataException {
        this._heapRegionManager = hrm;
        this._auxRegionCount = hrm._auxRegionCount().intValue();
        this._regionSize = hrm._regionSize();
        this._regionShift = hrm._regionShift();
        this._tableRegionCount = hrm._tableRegionCount().intValue();
        this._lowTableEdge = hrm._lowTableEdge();
        this._highTableEdge = hrm._highTableEdge();
        this._tableDescriptorSize = hrm._tableDescriptorSize();
        this._totalHeapSize = hrm._totalHeapSize();
        this.initializeTableRegionDescriptors();
        this.initializeAuxRegionDescriptors();
    }

    public static GCHeapRegionManager fromHeapRegionManager(MM_HeapRegionManagerPointer hrm) throws CorruptDataException {
        if (null != singleton) {
            return singleton;
        }
        singleton = new GCHeapRegionManager(hrm);
        return singleton;
    }

    protected void initializeAuxRegionDescriptors() throws CorruptDataException {
        GCHeapRegionDescriptor[] auxRegions = new GCHeapRegionDescriptor[this._auxRegionCount];
        if (auxRegions.length > 0) {
            MM_HeapRegionDescriptorPointer current = this._heapRegionManager._auxRegionDescriptorList();
            for (int i = 0; i < this._auxRegionCount; ++i) {
                auxRegions[i] = GCHeapRegionDescriptor.fromHeapRegionDescriptor(current);
                current = current._nextRegion();
            }
        }
        this._auxRegionDescriptorList = auxRegions;
    }

    protected void initializeTableRegionDescriptors() throws CorruptDataException {
        GCHeapRegionDescriptor[] table = new GCHeapRegionDescriptor[this._tableRegionCount];
        if (table.length > 0) {
            MM_HeapRegionDescriptorPointer current = this._heapRegionManager._regionTable();
            for (int i = 0; i < this._tableRegionCount; ++i) {
                table[i] = GCHeapRegionDescriptor.fromHeapRegionDescriptor(current);
                current = current.addOffset(this._tableDescriptorSize);
            }
        }
        this._regionTable = table;
    }

    public UDATA getTotalHeapSize() {
        return this._totalHeapSize;
    }

    public UDATA getRegionSize() {
        return this._regionSize;
    }

    public int getTableRegionCount() {
        return this._tableRegionCount;
    }

    public UDATA getHeapSize() {
        return new UDATA(this._highTableEdge.sub(this._lowTableEdge));
    }

    public Iterator<GCHeapRegionDescriptor> getAuxiliaryRegions() throws CorruptDataException {
        return Arrays.asList(this._auxRegionDescriptorList).iterator();
    }

    public Iterator<GCHeapRegionDescriptor> getTableRegions() throws CorruptDataException {
        return Arrays.asList(this._regionTable).iterator();
    }

    public GCHeapRegionDescriptor regionDescriptorForAddress(AbstractPointer heapAddress) {
        GCHeapRegionDescriptor result = null;
        result = heapAddress.gte(this._lowTableEdge) && heapAddress.lt(this._highTableEdge) ? this.tableDescriptorForAddress(heapAddress) : this.auxillaryDescriptorForAddress(heapAddress);
        return result;
    }

    public GCHeapRegionDescriptor auxillaryDescriptorForAddress(AbstractPointer heapAddress) {
        for (int i = 0; i < this._auxRegionCount; ++i) {
            GCHeapRegionDescriptor region = this._auxRegionDescriptorList[i];
            if (!region.isAddressInRegion(heapAddress)) continue;
            return region;
        }
        return null;
    }

    public GCHeapRegionDescriptor tableDescriptorForIndex(int regionIndex) {
        return this._regionTable[regionIndex].getHeadOfSpan();
    }

    public GCHeapRegionDescriptor physicalTableDescriptorForIndex(int regionIndex) {
        return this._regionTable[regionIndex];
    }

    protected int physicalTableDescriptorIndexForAddress(AbstractPointer heapAddress) {
        UDATA heapDelta = UDATA.cast(heapAddress).sub(UDATA.cast(this._regionTable[0].getLowAddress()));
        return heapDelta.rightShift(this._regionShift).intValue();
    }

    public GCHeapRegionDescriptor tableDescriptorForAddress(AbstractPointer heapAddress) {
        int index = this.physicalTableDescriptorIndexForAddress(heapAddress);
        return this.tableDescriptorForIndex(index);
    }
}

