/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.walkers.J9MemTagIterator;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemTagPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9MemTagHelper;
import com.ibm.j9ddr.vm29.structure.J9MemTag;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.commands.WildCard;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class J9MemTagCommands
extends Command
implements IEventListener {
    public static final long SEARCH_SLAB_SIZE = 1024L;
    private final int SORT_TYPE_DEFAULT = 1;
    private final int SORT_TYPE_NAME = 2;
    private final int SORT_TYPE_ALLOCSIZE = 3;
    private final String SORT_TYPE_STRING_NAME = "name";
    private final String SORT_TYPE_STRING_ALLOCSIZE = "allocsize";
    private final String SORT_TYPE_PREFIX = "sort:";
    private static final String[][] commands = new String[][]{{"!findcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite."}, {"!printallcallsites [sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *)."}, {"!printfreedcallsites [sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)"}, {"!findheader", "locate the memory allocation header for the specified address."}, {"!findallcallsites [sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite."}, {"!findfreedcallsites [sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite."}, {"!findfreedcallsite <callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite."}};
    private PrintStream out;

    public J9MemTagCommands() {
        this.addCommand("findcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all allocations for the specified callsite.");
        this.addCommand("printallcallsites", "[sort:<name|allocsize>]", "list all blocks and bytes allocated by each callsite (same as !findcallsite *).");
        this.addCommand("printfreedcallsites", "[sort:<name|allocsize>]", "list all freed blocks and bytes allocated by each callsite. (same as !findfreedcallsite *)");
        this.addCommand("findheader", "", "locate the memory allocation header for the specified address.");
        this.addCommand("findallcallsites", "[sort:<name|allocsize>]", "list a summary of blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsites", "[sort:<name|allocsize>]", "list a summary of all freed blocks and bytes allocated by each callsite.");
        this.addCommand("findfreedcallsite", "<callsite>[,start[,end]] [sort:<name|allocsize>]", "list all freed blocks for the specified callsite.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        command = command.toLowerCase();
        this.out = out;
        EventManager.register(this);
        try {
            if (command.endsWith("findallcallsites")) {
                this.runFindAllCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findfreedcallsites")) {
                this.runFindAllFreedCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findfreedcallsite")) {
                this.runFindFreedCallsite(command, args, context);
                return;
            }
            if (command.endsWith("printallcallsites")) {
                this.runPrintAllCallsites(command, args, context);
                return;
            }
            if (command.endsWith("printfreedcallsites")) {
                this.runPrintAllFreedCallsites(command, args, context);
                return;
            }
            if (command.endsWith("findheader")) {
                this.runFindHeader(command, args, context);
                return;
            }
            if (command.endsWith("findcallsite")) {
                this.runFindCallsite(command, args, context);
                return;
            }
            throw new DDRInteractiveCommandException("Unrecognized command: " + command);
        }
        finally {
            EventManager.unregister(this);
        }
    }

    private void printUsageForFindFreedCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findfreedcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start> [sort:<name:allocsize>]");
        this.out.println("  !findfreedcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindFreedCallsite(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long startAddress = 0L;
        long endAddress = UDATA.MASK;
        int sortType = 1;
        if (0 == args.length) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        String[] realArgs = args[0].split(",");
        String callsiteEnd = realArgs[0];
        if (realArgs.length == 2) {
            startAddress = Long.decode(realArgs[1]);
        } else if (realArgs.length == 3) {
            startAddress = Long.decode(realArgs[1]);
            endAddress = Long.decode(realArgs[2]);
        } else if (realArgs.length > 3 || args.length > 2) {
            this.out.print("Too many args : ");
            for (int i = 0; i < args.length - 1; ++i) {
                this.out.print(args[i]);
            }
            this.out.println(args[args.length - 1]);
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (args.length == 2 && (sortType = this.parseSortType(args[1])) == -1) {
            this.printUsageForFindFreedCallsite();
            return;
        }
        if (Addresses.greaterThan(startAddress, endAddress)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer needleBuffer = new StringBuffer();
        long matchFlags = WildCard.parseWildcard(callsiteEnd, needleBuffer);
        if (matchFlags < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String needle = needleBuffer.toString();
        J9MemTagIterator it = J9MemTagIterator.iterateFreedHeaders(startAddress, endAddress);
        if (J9BuildFlags.env_data64) {
            this.out.println("+------------------------------------------+------------------+-------------------+");
            this.out.println("|          address      |      size        |    org size      | callsite          |");
            this.out.println("+------------------------------------------+------------------+-------------------+");
        } else {
            this.out.println("+--------------------------+----------+-------------------+");
            this.out.println("|      address  |   size   | org size | callsite          |");
            this.out.println("+--------------------------+----------+-------------------+");
        }
        ArrayList<MemTagEntry> freedMemTagEntries = new ArrayList<MemTagEntry>();
        int freedCallSiteCount = 0;
        int corruptedFreedCallSiteCount = 0;
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            if (!this.regexMatches(header, matchFlags, needle)) continue;
            ++freedCallSiteCount;
            try {
                long allocSize = header.allocSize().longValue();
                if (it.isFooterCorrupted()) {
                    ++corruptedFreedCallSiteCount;
                    J9MemTagIterator allocIte = J9MemTagIterator.iterateAllocatedHeaders(header.longValue() + J9MemTag.SIZEOF, header.add(allocSize).longValue() + J9MemTag.SIZEOF);
                    if (allocIte.hasNext()) {
                        J9MemTagPointer nextAllocHeader = allocIte.next();
                        allocSize = nextAllocHeader.longValue() - header.longValue();
                    }
                }
                if (1 != sortType) {
                    freedMemTagEntries.add(new MemTagEntry(header, allocSize));
                    continue;
                }
                this.printMemTagForFindFreedCallSite(new MemTagEntry(header, allocSize));
            }
            catch (CorruptDataException e) {
                e.printStackTrace(this.out);
            }
        }
        if (2 == sortType || 3 == sortType) {
            if (2 == sortType) {
                Collections.sort(freedMemTagEntries, new NameComparator());
            } else {
                Collections.sort(freedMemTagEntries, new AllocSizeComparator());
            }
            for (int i = 0; i < freedMemTagEntries.size(); ++i) {
                MemTagEntry freedMemTagEntry = (MemTagEntry)freedMemTagEntries.get(i);
                this.printMemTagForFindFreedCallSite(freedMemTagEntry);
            }
        }
        this.out.println("Freed call site count = " + freedCallSiteCount);
        this.out.println("Corrupted freed call site count = " + corruptedFreedCallSiteCount);
    }

    private void printMemTagForFindFreedCallSite(MemTagEntry freedMemTagEntry) {
        J9MemTagPointer freedHeader = freedMemTagEntry.getHeader();
        long allocSize = freedMemTagEntry.getAllocSize();
        try {
            String callsite = freedHeader.callSite().getCStringAtOffset(0L);
            if (J9BuildFlags.env_data64) {
                this.out.append(String.format(" !j9x 0x%s ", this.padWith('0', J9MemTagHelper.j9mem_get_memory_base(freedHeader).getHexAddress().substring(2), 16)));
                this.out.append(String.format("0x%s ", this.padWith('0', Long.toHexString(allocSize), 16)));
                if (allocSize == freedHeader.allocSize().longValue()) {
                    this.out.append(String.format("%19s", ""));
                } else {
                    this.out.append(String.format("%s ", freedHeader.allocSize().getHexValue()));
                }
                this.out.append(String.format("%s", callsite));
            } else {
                this.out.append(String.format(" !j9x 0x%s ", this.padWith('0', J9MemTagHelper.j9mem_get_memory_base(freedHeader).getHexAddress().substring(2), 8)));
                this.out.append(String.format("0x%s ", this.padWith('0', Long.toHexString(allocSize), 8)));
                if (allocSize != freedHeader.allocSize().longValue()) {
                    this.out.append(String.format("%13s", ""));
                } else {
                    this.out.append(String.format("%s ", freedHeader.allocSize().getHexValue()));
                }
                this.out.append(String.format("%s", callsite));
            }
            this.out.append('\n');
        }
        catch (CorruptDataException e) {
            e.printStackTrace(this.out);
        }
    }

    private void printUsageForFindCallsite() {
        this.out.println("Usage:");
        this.out.println("  !findcallsite <callsite> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start> [sort:<name|allocsize>]");
        this.out.println("  !findcallsite <callsite>,<start>,<end> [sort:<name|allocsize>]");
    }

    private void runFindCallsite(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long startAddress = 0L;
        long endAddress = UDATA.MASK;
        int sortType = 1;
        if (args.length == 0) {
            this.printUsageForFindCallsite();
            return;
        }
        String[] realArgs = args[0].split(",");
        String callsiteEnd = realArgs[0];
        if (args.length == 2 && (sortType = this.parseSortType(args[1])) == -1) {
            this.printUsageForFindCallsite();
            return;
        }
        if (realArgs.length == 2) {
            startAddress = Long.decode(realArgs[1]);
        } else if (realArgs.length == 3) {
            startAddress = Long.decode(realArgs[1]);
            endAddress = Long.decode(realArgs[2]);
        } else if (realArgs.length > 3 || args.length > 2) {
            this.out.print("Too many args : ");
            for (int i = 0; i < args.length - 1; ++i) {
                this.out.print(args[i]);
            }
            this.out.println(args[args.length - 1]);
            this.printUsageForFindCallsite();
            return;
        }
        if (Addresses.greaterThan(startAddress, endAddress)) {
            this.out.println("Error: start address cannot be greater than end address");
            return;
        }
        StringBuffer needleBuffer = new StringBuffer();
        long matchFlags = WildCard.parseWildcard(callsiteEnd, needleBuffer);
        if (matchFlags < 0L) {
            this.out.println("Error: Invalid wildcard(s) in callsite");
            return;
        }
        String needle = needleBuffer.toString();
        J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders(startAddress, endAddress);
        ArrayList<MemTagEntry> memTagEntries = new ArrayList<MemTagEntry>();
        int callSiteCount = 0;
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            if (!this.regexMatches(header, matchFlags, needle)) continue;
            ++callSiteCount;
            try {
                long allocSize = header.allocSize().longValue();
                if (1 != sortType) {
                    memTagEntries.add(new MemTagEntry(header, allocSize));
                    continue;
                }
                this.printMemTagForFindCallSite(new MemTagEntry(header, allocSize));
            }
            catch (CorruptDataException e) {
                e.printStackTrace(this.out);
            }
        }
        if (2 == sortType || 3 == sortType) {
            if (2 == sortType) {
                Collections.sort(memTagEntries, new NameComparator());
            } else {
                Collections.sort(memTagEntries, new AllocSizeComparator());
            }
            for (int i = 0; i < memTagEntries.size(); ++i) {
                MemTagEntry memTagEntry = (MemTagEntry)memTagEntries.get(i);
                this.printMemTagForFindCallSite(memTagEntry);
            }
        }
        this.out.println("Call site count = " + callSiteCount);
    }

    private void printMemTagForFindCallSite(MemTagEntry memTagEntry) {
        J9MemTagPointer header = memTagEntry.getHeader();
        try {
            String callsite = header.callSite().getCStringAtOffset(0L);
            this.out.println(String.format(" !j9x %s,%s\t%s", J9MemTagHelper.j9mem_get_memory_base(header).getHexAddress(), header.allocSize().getHexValue(), callsite));
        }
        catch (CorruptDataException e) {
            e.printStackTrace(this.out);
        }
    }

    private void runFindHeader(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        long address = 0L;
        J9MemTagPointer header = null;
        if (args.length != 1) {
            this.out.println("Usage: ");
            this.out.println("  !findheader <address> (e.g. !findheader 0xa2b4c6d8)");
            return;
        }
        address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        this.out.println(String.format("Searching memory allocation header for %s", U8Pointer.cast(address).getHexAddress()));
        long searchBase = address - 1024L;
        block8: do {
            J9MemTagPointer potential;
            J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders(searchBase, searchBase + 1024L + 3L);
            while (it.hasNext() && !Addresses.greaterThan((potential = it.next()).getAddress(), address)) {
                VoidPointer end;
                VoidPointer start = J9MemTagHelper.j9mem_get_memory_base(potential);
                try {
                    end = start.addOffset(potential.allocSize().longValue());
                }
                catch (CorruptDataException e) {
                    continue;
                }
                if (!Addresses.greaterThanOrEqual(address, start.getAddress()) || !Addresses.lessThan(address, end.getAddress())) continue;
                header = potential;
                break block8;
            }
            if (Addresses.lessThan(searchBase, 1024L)) {
                searchBase = 0L;
                continue;
            }
            searchBase -= 1024L;
        } while (searchBase != 0L);
        if (header == null) {
            this.out.println("No memory allocation header found");
        } else {
            String categoryName;
            String callsite;
            try {
                callsite = header.callSite().getCStringAtOffset(0L);
            }
            catch (CorruptDataException ex) {
                callsite = "<FAULT> reading callsite string: " + ex.getMessage();
            }
            try {
                categoryName = header.category().name().getCStringAtOffset(0L);
            }
            catch (CorruptDataException ex) {
                categoryName = "<FAULT> reading category name string: " + ex.getMessage();
            }
            try {
                this.out.println(String.format("Found memory allocation header, !j9x %s,0x%#x", J9MemTagHelper.j9mem_get_memory_base(header).getHexAddress(), header.allocSize().longValue()));
                this.out.println(String.format("J9MemTag at %s {", header.getHexAddress()));
                this.out.println(String.format("    U_32 eyeCatcher = 0x%x;", header.eyeCatcher().longValue()));
                this.out.println(String.format("    U_32 sumCheck = 0x%x;", header.sumCheck().longValue()));
                this.out.println(String.format("    UDATA allocSize = 0x%x;", header.allocSize().longValue()));
                this.out.println(String.format("    char* callSite = %s;", callsite));
                this.out.println(String.format("    struct OMRMemCategory* category = !omrmemcategory 0x%x (%s);", header.category().longValue(), categoryName));
                this.out.println("}");
            }
            catch (CorruptDataException ex) {
                this.out.println("CDE formatting J9MemTag at " + header.getHexAddress());
            }
        }
    }

    private int parseSortType(String sortArg) throws DDRInteractiveCommandException {
        if (sortArg.length() > "sort:".length() && sortArg.substring(0, "sort:".length()).equalsIgnoreCase("sort:")) {
            String tmp = sortArg.substring("sort:".length());
            if (tmp.equalsIgnoreCase("name")) {
                return 2;
            }
            if (tmp.equalsIgnoreCase("allocsize")) {
                return 3;
            }
            throw new DDRInteractiveCommandException("Error: Unknown sort type: " + sortArg);
        }
        throw new DDRInteractiveCommandException("Error: Unknown argument: " + sortArg);
    }

    private void runPrintAllCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all memory block callsites...");
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = "*";
        if (args.length == 1) {
            newArgs[1] = args[0];
        }
        this.runFindCallsite("!findcallsite", newArgs, context);
    }

    private void runPrintAllFreedCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        String[] newArgs = new String[args.length + 1];
        newArgs[0] = "*";
        if (args.length == 1) {
            newArgs[1] = args[0];
        }
        this.runFindFreedCallsite("!findfreedcallsite", newArgs, context);
    }

    private void runFindAllCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        int sortType = 3;
        J9MemTagIterator it = J9MemTagIterator.iterateAllocatedHeaders();
        if (args.length == 1) {
            sortType = this.parseSortType(args[0]);
        }
        this.printCallsitesTable(this.buildCallsitesTable(it, true), sortType);
    }

    private void runFindAllFreedCallsites(String command, String[] args, Context context) throws DDRInteractiveCommandException {
        this.out.println("Searching for all freed memory block callsites...");
        int sortType = 3;
        J9MemTagIterator it = J9MemTagIterator.iterateFreedHeaders();
        if (args.length == 1) {
            sortType = this.parseSortType(args[0]);
        }
        this.printCallsitesTable(this.buildCallsitesTable(it, true), sortType);
    }

    public String padWith(char padding, String strToPad, int lengthToPad) {
        String paddingStr = "";
        int strLength = strToPad.length();
        if (strLength >= lengthToPad) {
            return strToPad;
        }
        int padLength = lengthToPad - strLength;
        for (int i = 0; i < padLength; ++i) {
            paddingStr = paddingStr + padding;
        }
        return paddingStr + strToPad;
    }

    private Map<String, J9DbgExtMemStats> buildCallsitesTable(J9MemTagIterator it, boolean lookingForFreedCallSites) {
        TreeMap<String, J9DbgExtMemStats> callSites = new TreeMap<String, J9DbgExtMemStats>();
        while (it.hasNext()) {
            J9MemTagPointer header = it.next();
            try {
                J9MemTagIterator allocIte;
                long allocSize = header.allocSize().longValue();
                if (lookingForFreedCallSites && it.isFooterCorrupted() && (allocIte = J9MemTagIterator.iterateAllocatedHeaders(header.longValue() + J9MemTag.SIZEOF, header.add(allocSize).longValue() + J9MemTag.SIZEOF)).hasNext()) {
                    J9MemTagPointer nextAllocHeader = allocIte.next();
                    allocSize = nextAllocHeader.longValue() - header.longValue();
                }
                String callsite = header.callSite().getCStringAtOffset(0L);
                it.moveCurrentSearchAddress(allocSize);
                if (!callSites.containsKey(callsite)) {
                    callSites.put(callsite, new J9DbgExtMemStats(header.allocSize().longValue()));
                    continue;
                }
                J9DbgExtMemStats memStats = (J9DbgExtMemStats)callSites.get(callsite);
                memStats.incrementTotalBlocksAllocated();
                memStats.addTotalBytesAllocated(header.allocSize().longValue());
            }
            catch (CorruptDataException e) {
                this.out.println("Unexpected CDE reading contents of " + Long.toHexString(header.getAddress()));
                e.printStackTrace(this.out);
            }
        }
        return callSites;
    }

    @Override
    public void corruptData(String message2, CorruptDataException e, boolean fatal) {
        if (e instanceof J9MemTagHelper.J9MemTagCheckError) {
            J9MemTagHelper.J9MemTagCheckError casted = (J9MemTagHelper.J9MemTagCheckError)e;
            this.out.println("J9MemTag check failed at " + Long.toHexString(casted.getAddress()) + ": " + message2 + " :" + e.getMessage());
        } else {
            e.printStackTrace(this.out);
        }
    }

    private void printCallsitesTable(Map<String, J9DbgExtMemStats> callSites, final int sortType) throws DDRInteractiveCommandException {
        this.out.println(" total alloc   | largest");
        this.out.println(" blocks| bytes | bytes | callsite");
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
        if (2 == sortType || 3 == sortType) {
            LinkedList<Map.Entry<String, J9DbgExtMemStats>> entries = new LinkedList<Map.Entry<String, J9DbgExtMemStats>>(callSites.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, J9DbgExtMemStats>>(){

                @Override
                public int compare(Map.Entry<String, J9DbgExtMemStats> o1, Map.Entry<String, J9DbgExtMemStats> o2) {
                    if (2 == sortType) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                    if (o1.getValue().getTotalBytesAllocated() < o2.getValue().getTotalBytesAllocated()) {
                        return 1;
                    }
                    if (o1.getValue().getTotalBytesAllocated() == o2.getValue().getTotalBytesAllocated()) {
                        return 0;
                    }
                    return -1;
                }
            });
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry entry = (Map.Entry)entries.get(i);
                String callSite = (String)entry.getKey();
                J9DbgExtMemStats memStat = (J9DbgExtMemStats)entry.getValue();
                this.out.println(String.format("%7d %7d %7d %s", memStat.getTotalBlocksAllocated(), memStat.getTotalBytesAllocated(), memStat.getLargestBlockAllocated(), callSite));
            }
        } else if (1 == sortType) {
            for (Map.Entry<String, J9DbgExtMemStats> entry : callSites.entrySet()) {
                String callSite = entry.getKey();
                J9DbgExtMemStats memStat = entry.getValue();
                this.out.println(String.format("%7d %7d %7d %s", memStat.getTotalBlocksAllocated(), memStat.getTotalBytesAllocated(), memStat.getLargestBlockAllocated(), callSite));
            }
        } else {
            throw new DDRInteractiveCommandException("Unknown sort type: " + sortType);
        }
        this.out.println("-------+-------+-------+-------+-------+-------+-------+-------+-------+-------");
    }

    private boolean regexMatches(J9MemTagPointer obj, long matchFlags, String needle) {
        String callsite;
        try {
            callsite = obj.callSite().getCStringAtOffset(0L);
        }
        catch (CorruptDataException e) {
            return false;
        }
        return WildCard.wildcardMatch(matchFlags, needle, callsite);
    }

    private class AllocSizeComparator
    implements Comparator<MemTagEntry> {
        private AllocSizeComparator() {
        }

        @Override
        public int compare(MemTagEntry e1, MemTagEntry e2) {
            if (e1.getAllocSize() < e2.getAllocSize()) {
                return 1;
            }
            if (e1.getAllocSize() == e2.getAllocSize()) {
                return 0;
            }
            return -1;
        }
    }

    private class NameComparator
    implements Comparator<MemTagEntry> {
        private NameComparator() {
        }

        @Override
        public int compare(MemTagEntry e1, MemTagEntry e2) {
            String callsite1 = null;
            String callsite2 = null;
            try {
                callsite1 = e1.getHeader().callSite().getCStringAtOffset(0L);
                callsite2 = e2.getHeader().callSite().getCStringAtOffset(0L);
            }
            catch (CorruptDataException e) {
                e.printStackTrace();
            }
            return callsite1.compareTo(callsite2);
        }
    }

    private class MemTagEntry {
        private J9MemTagPointer header;
        private long allocSize;

        public MemTagEntry(J9MemTagPointer header, long allocSize) {
            this.header = header;
            this.allocSize = allocSize;
        }

        public J9MemTagPointer getHeader() {
            return this.header;
        }

        public long getAllocSize() {
            return this.allocSize;
        }
    }

    static class J9DbgExtMemStats {
        private long totalBlocksAllocated;
        private long totalBytesAllocated;
        private long largestBlockAllocated;

        public J9DbgExtMemStats(long totalBytesAllocated) {
            this.totalBytesAllocated = totalBytesAllocated;
            this.totalBlocksAllocated = 1L;
            this.largestBlockAllocated = totalBytesAllocated;
        }

        public void incrementTotalBlocksAllocated() {
            ++this.totalBlocksAllocated;
        }

        public void addTotalBytesAllocated(long byteAmount) {
            this.totalBytesAllocated += byteAmount;
            if (byteAmount > this.largestBlockAllocated) {
                this.largestBlockAllocated = byteAmount;
            }
        }

        public long getTotalBlocksAllocated() {
            return this.totalBlocksAllocated;
        }

        public long getTotalBytesAllocated() {
            return this.totalBytesAllocated;
        }

        public long getLargestBlockAllocated() {
            return this.largestBlockAllocated;
        }
    }
}

