/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.EnumPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.generated.UtDataHeaderPointer;
import com.ibm.j9ddr.vm29.structure.UtProcInfo;
import com.ibm.j9ddr.vm29.structure.UtSubtype;
import com.ibm.j9ddr.vm29.structure.UtTraceCounter;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=UtProcInfo.class)
public class UtProcInfoPointer
extends StructurePointer {
    public static final UtProcInfoPointer NULL = new UtProcInfoPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected UtProcInfoPointer(long address) {
        super(address);
    }

    public static UtProcInfoPointer cast(AbstractPointer structure) {
        return UtProcInfoPointer.cast(structure.getAddress());
    }

    public static UtProcInfoPointer cast(UDATA udata) {
        return UtProcInfoPointer.cast(udata.longValue());
    }

    public static UtProcInfoPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UtProcInfoPointer(address);
    }

    @Override
    public UtProcInfoPointer add(long count) {
        return UtProcInfoPointer.cast(this.address + UtProcInfo.SIZEOF * count);
    }

    @Override
    public UtProcInfoPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public UtProcInfoPointer addOffset(long offset) {
        return UtProcInfoPointer.cast(this.address + offset);
    }

    @Override
    public UtProcInfoPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public UtProcInfoPointer sub(long count) {
        return UtProcInfoPointer.cast(this.address - UtProcInfo.SIZEOF * count);
    }

    @Override
    public UtProcInfoPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public UtProcInfoPointer subOffset(long offset) {
        return UtProcInfoPointer.cast(this.address - offset);
    }

    @Override
    public UtProcInfoPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public UtProcInfoPointer untag(long mask) {
        return UtProcInfoPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UtProcInfoPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return UtProcInfo.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="UtDataHeader")
    public UtDataHeaderPointer header() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UtDataHeaderPointer.cast(this.address + (long)UtProcInfo._headerOffset_);
    }

    public PointerPointer headerEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)UtProcInfo._headerOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_subtypeOffset_", declaredType="UtSubtype")
    public long subtype() throws CorruptDataException {
        if (UtSubtype.SIZEOF == 1L) {
            return this.getByteAtOffset(UtProcInfo._subtypeOffset_);
        }
        if (UtSubtype.SIZEOF == 2L) {
            return this.getShortAtOffset(UtProcInfo._subtypeOffset_);
        }
        if (UtSubtype.SIZEOF == 4L) {
            return this.getIntAtOffset(UtProcInfo._subtypeOffset_);
        }
        if (UtSubtype.SIZEOF == 8L) {
            return this.getLongAtOffset(UtProcInfo._subtypeOffset_);
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    public EnumPointer subtypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return EnumPointer.cast(this.address + (long)UtProcInfo._subtypeOffset_, UtSubtype.class);
    }

    @GeneratedFieldAccessor(offsetFieldName="_traceCounterOffset_", declaredType="UtTraceCounter")
    public long traceCounter() throws CorruptDataException {
        if (UtTraceCounter.SIZEOF == 1L) {
            return this.getByteAtOffset(UtProcInfo._traceCounterOffset_);
        }
        if (UtTraceCounter.SIZEOF == 2L) {
            return this.getShortAtOffset(UtProcInfo._traceCounterOffset_);
        }
        if (UtTraceCounter.SIZEOF == 4L) {
            return this.getIntAtOffset(UtProcInfo._traceCounterOffset_);
        }
        if (UtTraceCounter.SIZEOF == 8L) {
            return this.getLongAtOffset(UtProcInfo._traceCounterOffset_);
        }
        throw new IllegalArgumentException("Unexpected ENUM size in core file");
    }

    public EnumPointer traceCounterEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return EnumPointer.cast(this.address + (long)UtProcInfo._traceCounterOffset_, UtTraceCounter.class);
    }
}

