/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.structure.ShcItem;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ShcItem.class)
public class ShcItemPointer
extends StructurePointer {
    public static final ShcItemPointer NULL = new ShcItemPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ShcItemPointer(long address) {
        super(address);
    }

    public static ShcItemPointer cast(AbstractPointer structure) {
        return ShcItemPointer.cast(structure.getAddress());
    }

    public static ShcItemPointer cast(UDATA udata) {
        return ShcItemPointer.cast(udata.longValue());
    }

    public static ShcItemPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ShcItemPointer(address);
    }

    @Override
    public ShcItemPointer add(long count) {
        return ShcItemPointer.cast(this.address + ShcItem.SIZEOF * count);
    }

    @Override
    public ShcItemPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ShcItemPointer addOffset(long offset) {
        return ShcItemPointer.cast(this.address + offset);
    }

    @Override
    public ShcItemPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public ShcItemPointer sub(long count) {
        return ShcItemPointer.cast(this.address - ShcItem.SIZEOF * count);
    }

    @Override
    public ShcItemPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ShcItemPointer subOffset(long offset) {
        return ShcItemPointer.cast(this.address - offset);
    }

    @Override
    public ShcItemPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ShcItemPointer untag(long mask) {
        return ShcItemPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ShcItemPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ShcItem.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLenOffset_", declaredType="U32")
    public U32 dataLen() throws CorruptDataException {
        return new U32(this.getIntAtOffset(ShcItem._dataLenOffset_));
    }

    public U32Pointer dataLenEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)ShcItem._dataLenOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U16")
    public U16 dataType() throws CorruptDataException {
        return new U16(this.getShortAtOffset(ShcItem._dataTypeOffset_));
    }

    public U16Pointer dataTypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)ShcItem._dataTypeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_jvmIDOffset_", declaredType="U16")
    public U16 jvmID() throws CorruptDataException {
        return new U16(this.getShortAtOffset(ShcItem._jvmIDOffset_));
    }

    public U16Pointer jvmIDEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)ShcItem._jvmIDOffset_);
    }
}

