/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.J9ConfigFlags;
import com.ibm.j9ddr.vm29.j9.JITLook;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.SendSlot;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.FrameCallbackResult;
import com.ibm.j9ddr.vm29.j9.stackwalker.JITRegMap;
import com.ibm.j9ddr.vm29.j9.stackwalker.MethodMetaData;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U64Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9I2JStatePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITDecompilationInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITStackAtlasPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9OSRBufferPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9OSRFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJ2IFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFJITResolveFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFNativeMethodFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SFSpecialFramePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9StackWalkFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9JITFrame;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9SFJ2IFrame;
import com.ibm.j9ddr.vm29.structure.J9SFJITResolveFrame;
import com.ibm.j9ddr.vm29.structure.J9SFNativeMethodFrame;
import com.ibm.j9ddr.vm29.structure.J9SFSpecialFrame;
import com.ibm.j9ddr.vm29.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm29.structure.J9StackWalkState;
import com.ibm.j9ddr.vm29.structure.MethodMetaDataConstants;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.LinkedList;

public class JITStackWalker {
    private static IJITStackWalker impl;
    private static final AlgorithmPicker<IJITStackWalker> picker;

    static FrameCallbackResult jitWalkStackFrames(WalkState walkState) throws CorruptDataException {
        return JITStackWalker.getImpl().jitWalkStackFrames(walkState);
    }

    static void jitPrintRegisterMapArray(WalkState walkState, String description) throws CorruptDataException {
        JITStackWalker.getImpl().jitPrintRegisterMapArray(walkState, description);
    }

    static J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer walkThread, U8Pointer pc) throws CorruptDataException {
        return JITStackWalker.getImpl().jitGetExceptionTableFromPC(walkThread, pc);
    }

    private static IJITStackWalker getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<IJITStackWalker>("ALG_JIT_STACK_WALKER_VERSION"){

            @Override
            protected Iterable<? extends IJITStackWalker> allAlgorithms() {
                LinkedList<JITStackWalker_29_V0> toReturn = new LinkedList<JITStackWalker_29_V0>();
                toReturn.add(new JITStackWalker_29_V0());
                return toReturn;
            }
        };
    }

    private static class JITStackWalker_29_V0
    extends BaseAlgorithm
    implements IJITStackWalker {
        UDATAPointer stackSpillCursor;
        UDATA stackSpillCount;
        UDATA floatRegistersRemaining;
        UDATAPointer pendingSendScanCursor;
        int charIndex;
        private U8 jitDescriptionBits;
        private U8 stackAllocMapBits;
        private U8Pointer jitDescriptionCursor;
        private U8Pointer stackAllocMapCursor;
        private UDATA jitBitsRemaining;
        private UDATA mapBytesRemaining;

        protected JITStackWalker_29_V0() {
            super(90, 0);
        }

        private static U8Pointer MASK_PC(AbstractPointer ptr) {
            if (J9ConfigFlags.arch_s390 && !J9BuildFlags.env_data64) {
                return U8Pointer.cast(UDATA.cast(ptr).bitAnd(Integer.MAX_VALUE));
            }
            return U8Pointer.cast(ptr);
        }

        private static void UPDATE_PC_FROM(WalkState walkState, PointerPointer pcExpressionEA) throws CorruptDataException {
            if (J9BuildFlags.jit_fullSpeedDebug) {
                walkState.pcAddress = pcExpressionEA;
                walkState.pc = JITStackWalker_29_V0.MASK_PC(pcExpressionEA.at(0L));
            } else {
                walkState.pc = JITStackWalker_29_V0.MASK_PC(pcExpressionEA.at(0L));
            }
        }

        private static void SET_A0_CP_METHOD(WalkState walkState) throws CorruptDataException {
            walkState.arg0EA = UDATAPointer.cast(U8Pointer.cast(walkState.bp.add(walkState.jitInfo.slots())).add(J9JITFrame.SIZEOF).sub(UDATA.SIZEOF));
            walkState.method = walkState.jitInfo.ramMethod();
            walkState.constantPool = walkState.jitInfo.constantPool();
            walkState.argCount = new UDATA(walkState.jitInfo.slots());
        }

        @Override
        public FrameCallbackResult jitWalkStackFrames(WalkState walkState) throws CorruptDataException {
            FrameCallbackResult rc = FrameCallbackResult.STOP_ITERATING;
            MethodMetaData.JITMaps maps = new MethodMetaData.JITMaps();
            rc = this.walkTransitionFrame(walkState);
            if (rc != FrameCallbackResult.KEEP_ITERATING) {
                return rc;
            }
            walkState.frameFlags = new UDATA(0L);
            while ((walkState.jitInfo = this.jitGetExceptionTable(walkState)).notNull()) {
                walkState.bp = walkState.unwindSP.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                walkState.sp = J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP ? walkState.unwindSP.sub(walkState.argCount) : walkState.unwindSP;
                walkState.outgoingArgCount = walkState.argCount;
                if ((walkState.flags & J9Consts.J9_STACKWALK_SKIP_INLINES) == 0L && MethodMetaData.getJitInlinedCallInfo(walkState.jitInfo).notNull()) {
                    MethodMetaData.jitGetMapsFromPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), maps);
                    if (maps.inlineMap.notNull()) {
                        VoidPointer inlinedCallSite = MethodMetaData.getFirstInlinedCallSite(walkState.jitInfo, VoidPointer.cast(maps.inlineMap));
                        walkState.arg0EA = UDATAPointer.NULL;
                        if (inlinedCallSite.notNull()) {
                            walkState.inlineDepth = MethodMetaData.getJitInlineDepthFromCallSite(walkState.jitInfo, inlinedCallSite).longValue();
                            walkState.arg0EA = UDATAPointer.NULL;
                            do {
                                J9MethodPointer inlinedMethod;
                                walkState.method = inlinedMethod = J9MethodPointer.cast(MethodMetaData.getInlinedMethod(inlinedCallSite));
                                walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
                                walkState.bytecodePCOffset = U8Pointer.cast(MethodMetaData.getCurrentByteCodeIndexAndIsSameReceiver(walkState.jitInfo, VoidPointer.cast(maps.inlineMap), inlinedCallSite, null));
                                JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT inline");
                                rc = StackWalker.walkFrame(walkState);
                                if (rc != FrameCallbackResult.KEEP_ITERATING) {
                                    return rc;
                                }
                                inlinedCallSite = MethodMetaData.getNextInlinedCallSite(walkState.jitInfo, inlinedCallSite);
                            } while (--walkState.inlineDepth > 0L);
                        }
                    }
                } else if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                    MethodMetaData.jitGetMapsFromPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), maps);
                }
                JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                if ((walkState.flags & J9Consts.J9_STACKWALK_RECORD_BYTECODE_PC_OFFSET) != 0L) {
                    walkState.bytecodePCOffset = maps.inlineMap.isNull() ? U8Pointer.cast(-1L) : U8Pointer.cast(MethodMetaData.getCurrentByteCodeIndexAndIsSameReceiver(walkState.jitInfo, VoidPointer.cast(maps.inlineMap), VoidPointer.NULL, null));
                }
                JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT");
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_METHOD_CLASS_SLOTS) != 0L) {
                    MethodMetaData.markClassesInInlineRanges(walkState.jitInfo, walkState);
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        this.jitWalkFrame(walkState, true, VoidPointer.cast(maps.stackMap));
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", ex);
                    }
                }
                if ((rc = StackWalker.walkFrame(walkState)) != FrameCallbackResult.KEEP_ITERATING) {
                    return rc;
                }
                if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                    try {
                        this.CLEAR_LOCAL_REGISTER_MAP_ENTRIES(walkState);
                        MethodMetaData.jitAddSpilledRegisters(walkState, VoidPointer.cast(maps.stackMap));
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", ex);
                    }
                }
                this.UNWIND_TO_NEXT_FRAME(walkState);
            }
            U8Pointer failedPC = walkState.pc;
            PointerPointer returnTable = PointerPointer.cast(walkState.walkThread.javaVM().jitConfig().i2jReturnTable());
            if (returnTable.notNull()) {
                long i;
                for (i = 0L; i < J9StackWalkConstants.J9SW_JIT_RETURN_TABLE_SIZE && !failedPC.eq(U8Pointer.cast(returnTable.at(i))); ++i) {
                }
                if (i == J9StackWalkConstants.J9SW_JIT_RETURN_TABLE_SIZE) {
                    throw new AddressedCorruptDataException(failedPC.getAddress(), "Invalid JIT return address");
                }
            }
            JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, walkState.i2jState.pcEA());
            walkState.literals = walkState.i2jState.literals();
            walkState.arg0EA = walkState.i2jState.a0();
            UDATAPointer returnSP = walkState.i2jState.returnSP();
            walkState.previousFrameFlags = new UDATA(0L);
            if (returnSP.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_ARGS_ALIGNED)) {
                StackWalkerUtils.swPrintf(walkState, 2, "I2J args were copied for alignment", new Object[0]);
                walkState.previousFrameFlags = new UDATA(J9StackWalkConstants.J9_STACK_FLAGS_JIT_ARGS_ALIGNED);
            }
            walkState.walkSP = returnSP.untag(3L);
            StackWalkerUtils.swPrintf(walkState, 2, "I2J values: PC = {0}, A0 = {1}, walkSP = {2}, literals = {3}, JIT PC = {4}, pcAddress = {5}, decomp = {6}", walkState.pc.getHexAddress(), walkState.arg0EA.getHexAddress(), walkState.walkSP.getHexAddress(), walkState.literals.getHexAddress(), failedPC.getHexAddress(), J9BuildFlags.jit_fullSpeedDebug ? walkState.pcAddress.getHexAddress() : "0", J9BuildFlags.jit_fullSpeedDebug ? walkState.decompilationStack.getHexAddress() : "0");
            return rc;
        }

        private J9JITExceptionTablePointer jitGetExceptionTable(WalkState walkState) throws CorruptDataException {
            if (!J9BuildFlags.jit_fullSpeedDebug) {
                return this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
            }
            J9JITExceptionTablePointer result = this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
            walkState.decompilationRecord = J9JITDecompilationInfoPointer.NULL;
            if (result.notNull()) {
                return result;
            }
            if (walkState.decompilationStack != null && walkState.decompilationStack.notNull()) {
                StackWalkerUtils.swPrintf(walkState, 3, "(ws pcaddr = {0}, dc tos = {1}, pcaddr = {2}, pc = {3})", walkState.pcAddress.getHexAddress(), walkState.decompilationStack.getHexAddress(), walkState.decompilationStack.pcAddress().getHexAddress(), walkState.decompilationStack.pc().getHexAddress());
                if (walkState.pcAddress.eq(walkState.decompilationStack.pcAddress())) {
                    walkState.pc = walkState.decompilationStack.pc();
                    if (walkState.resolveFrameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK).eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                        walkState.pc = walkState.pc.add(1L);
                    }
                    walkState.decompilationRecord = walkState.decompilationStack;
                    walkState.decompilationStack = walkState.decompilationStack.next();
                    return this.jitGetExceptionTableFromPC(walkState.walkThread, walkState.pc);
                }
                J9JITDecompilationInfoPointer stack = walkState.decompilationStack;
                while ((stack = stack.next()).notNull()) {
                    if (walkState.pcAddress != walkState.decompilationStack.pcAddress()) continue;
                    StackWalkerUtils.swPrintf(walkState, 1, "**** decomp found not on TOS! ****", new Object[0]);
                }
            }
            return J9JITExceptionTablePointer.NULL;
        }

        @Override
        public J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer walkThread, U8Pointer pc) throws CorruptDataException {
            J9JITConfigPointer jitConfig = walkThread.javaVM().jitConfig();
            if (jitConfig.isNull()) {
                return J9JITExceptionTablePointer.NULL;
            }
            return JITLook.jit_artifact_search(jitConfig.translationArtifacts(), UDATA.cast(JITStackWalker_29_V0.MASK_PC(pc)));
        }

        private void jitWalkResolveMethodFrame(WalkState walkState) throws CorruptDataException {
            boolean walkStackedReceiver;
            UDATA pendingSendSlots;
            J9UTF8Pointer signature;
            this.stackSpillCount = null;
            this.stackSpillCursor = null;
            this.floatRegistersRemaining = new UDATA(0L);
            if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                this.floatRegistersRemaining = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT);
            }
            UDATA resolveFrameType = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_INTERNAL;
            walkState.slotIndex = -1;
            if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE)) {
                J9ROMMethodPointer romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 1)));
                signature = ROMHelp.J9ROMMETHOD_SIGNATURE(romMethod);
                pendingSendSlots = new UDATA(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod));
                walkStackedReceiver = romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccStatic);
                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                    this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    this.stackSpillCursor = walkState.unwindSP.sub(1L);
                }
                walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitRecompilationResolvePushes());
            } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE)) {
                J9ROMMethodPointer romMethod;
                UDATAPointer interfaceObjectAndISlot = UDATAPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 2));
                J9ClassPointer resolvedClass = J9ClassPointer.cast(interfaceObjectAndISlot.at(0L));
                if (AlgorithmVersion.getVersionOf("ALG_VM_ITABLE_VERSION").getAlgorithmVersion() < 1) {
                    UDATA methodIndex = interfaceObjectAndISlot.at(1L);
                    romMethod = resolvedClass.romClass().romMethods();
                    while (!methodIndex.eq(0L)) {
                        romMethod = ROMHelp.nextROMMethod(romMethod);
                        methodIndex = methodIndex.sub(1L);
                    }
                } else {
                    J9MethodPointer ramMethod;
                    long iTableOffset = interfaceObjectAndISlot.at(1L).longValue();
                    if (0L != (iTableOffset & J9Consts.J9_ITABLE_OFFSET_DIRECT)) {
                        ramMethod = J9MethodPointer.cast(iTableOffset).untag(J9Consts.J9_ITABLE_OFFSET_TAG_BITS);
                    } else if (0L != (iTableOffset & J9Consts.J9_ITABLE_OFFSET_VIRTUAL)) {
                        long vTableOffset = iTableOffset & (J9Consts.J9_ITABLE_OFFSET_TAG_BITS ^ 0xFFFFFFFFFFFFFFFFL);
                        J9JavaVMPointer vm = walkState.walkThread.javaVM();
                        J9ClassPointer clazz = vm.booleanArrayClass();
                        ramMethod = J9MethodPointer.cast(PointerPointer.cast(clazz.longValue() + vTableOffset).at(0L));
                    } else {
                        long methodIndex = (iTableOffset - J9ITable.SIZEOF) / (long)UDATA.SIZEOF;
                        J9ITablePointer allInterfaces = J9ITablePointer.cast(resolvedClass.iTable());
                        while (true) {
                            J9ClassPointer interfaceClass;
                            long methodCount;
                            if (methodIndex < (methodCount = (interfaceClass = allInterfaces.interfaceClass()).romClass().romMethodCount().longValue())) {
                                ramMethod = interfaceClass.ramMethods().add(methodIndex);
                                break;
                            }
                            methodIndex -= methodCount;
                            allInterfaces = allInterfaces.next();
                        }
                    }
                    romMethod = ROMHelp.J9_ROM_METHOD_FROM_RAM_METHOD(ramMethod);
                }
                signature = ROMHelp.J9ROMMETHOD_SIGNATURE(romMethod);
                pendingSendSlots = new UDATA(ROMHelp.J9_ARG_COUNT_FROM_ROM_METHOD(romMethod));
                walkStackedReceiver = true;
                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                    this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                    this.stackSpillCursor = walkState.unwindSP.sub(1L);
                }
                if (J9StackWalkFlags.J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER_DEFINED && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (picBuilder interface saved receiver)", new Object[0]);
                        StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.unwindSP.add(J9StackWalkConstants.J9SW_JIT_LOOKUP_INTERFACE_RESOLVE_OFFSET_TO_SAVED_RECEIVER)));
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", ex);
                    }
                }
                walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitVirtualMethodResolvePushes());
            } else {
                UDATA cpIndex;
                J9ConstantPoolPointer constantPool;
                if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                    throw new CorruptDataException("Induced OSR resolve not handled yet");
                }
                if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE)) {
                    if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.floatRegistersRemaining = new UDATA(0L);
                    }
                    constantPool = J9ConstantPoolPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 2));
                    cpIndex = StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 3);
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitStaticMethodResolvePushes());
                    walkStackedReceiver = resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE);
                    if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.stackSpillCount = new UDATA(0L);
                    }
                } else {
                    UDATAPointer indexAndLiterals = UDATAPointer.cast(StackWalkerUtils.JIT_RESOLVE_PARM(walkState, 1));
                    constantPool = J9ConstantPoolPointer.cast(indexAndLiterals.at(0L));
                    cpIndex = indexAndLiterals.at(1L);
                    walkStackedReceiver = true;
                    if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED) {
                        this.stackSpillCount = new UDATA(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                        walkState.unwindSP = walkState.unwindSP.add(J9StackWalkConstants.J9SW_ARGUMENT_REGISTER_COUNT);
                        this.stackSpillCursor = walkState.unwindSP.sub(1L);
                    }
                    if (J9StackWalkFlags.J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER_DEFINED && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (picBuilder virtual saved receiver)", new Object[0]);
                            StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(walkState.unwindSP.add(J9StackWalkConstants.J9SW_JIT_VIRTUAL_METHOD_RESOLVE_OFFSET_TO_SAVED_RECEIVER)));
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", ex);
                        }
                    }
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitVirtualMethodResolvePushes());
                }
                J9ROMMethodRefPointer romMethodRef = J9ROMMethodRefPointer.cast(constantPool.romConstantPool().add(cpIndex));
                signature = romMethodRef.nameAndSignature().signature();
                pendingSendSlots = SendSlot.getSendSlotsFromSignature(signature).add(walkStackedReceiver ? 1L : 0L);
            }
            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    char sigChar;
                    this.pendingSendScanCursor = walkState.unwindSP.add(pendingSendSlots).sub(1L);
                    StackWalkerUtils.swPrintf(walkState, 3, "\tPending send scan cursor initialized to {0}", this.pendingSendScanCursor.getHexAddress());
                    if (walkStackedReceiver) {
                        if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (receiver in register spill area)", new Object[0]);
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                try {
                                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor));
                                }
                                catch (CorruptDataException ex) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", ex);
                                }
                            }
                            this.stackSpillCount = this.stackSpillCount.sub(1L);
                            this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                        } else {
                            StackWalkerUtils.swPrintf(walkState, 4, "\tObject push (receiver in stack)", new Object[0]);
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                try {
                                    StackWalkerUtils.WALK_O_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor));
                                }
                                catch (CorruptDataException ex) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", ex);
                                }
                            }
                        }
                        this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
                    }
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMethod signature: {0}", J9UTF8Helper.stringValue(signature));
                    this.charIndex = 1;
                    String signatureString = J9UTF8Helper.stringValue(signature);
                    while ((sigChar = this.jitNextSigChar(signatureString)) != ')') {
                        switch (sigChar) {
                            case 'L': {
                                if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                                    if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                        try {
                                            StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                                        }
                                        catch (CorruptDataException ex) {
                                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkMethodFrame", ex);
                                        }
                                    }
                                    this.stackSpillCount = this.stackSpillCount.sub(1L);
                                    this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                                    break;
                                }
                                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) == 0L) break;
                                try {
                                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                                }
                                catch (CorruptDataException ex) {
                                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkMethodFrame", ex);
                                }
                                break;
                            }
                            case 'D': {
                                if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                                    this.jitWalkResolveMethodFrame_walkD(walkState);
                                    break;
                                }
                                this.jitWalkResolveMethodFrame_walkJ(walkState);
                                break;
                            }
                            case 'F': {
                                if (J9StackWalkFlags.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT_DEFINED) {
                                    this.jitWalkResolveMethodFrame_walkF(walkState);
                                    break;
                                }
                                this.jitWalkResolveMethodFrame_walkI(walkState);
                                break;
                            }
                            case 'J': {
                                this.jitWalkResolveMethodFrame_walkJ(walkState);
                                break;
                            }
                            default: {
                                this.jitWalkResolveMethodFrame_walkI(walkState);
                            }
                        }
                        this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
                    }
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame", ex);
                }
            }
            if (J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP) {
                walkState.unwindSP = walkState.unwindSP.add(pendingSendSlots);
            }
            walkState.argCount = pendingSendSlots;
        }

        private char jitNextSigChar(String signatureString) throws CorruptDataException {
            int utfChar = signatureString.charAt(this.charIndex++);
            switch (utfChar) {
                case 91: {
                    while ((utfChar = signatureString.charAt(this.charIndex++)) == 91) {
                    }
                    if (utfChar != 76) {
                        utfChar = 76;
                        break;
                    }
                }
                case 76: {
                    while (signatureString.charAt(this.charIndex++) != ';') {
                    }
                    break;
                }
            }
            return (char)utfChar;
        }

        private U64Pointer jitFPRParmAddress(WalkState walkState, UDATA fpParmNumber) throws CorruptDataException {
            U64Pointer base = U64Pointer.cast(walkState.walkedEntryLocalStorage.jitFPRegisterStorageBase());
            if (J9ConfigFlags.arch_s390) {
                fpParmNumber = fpParmNumber.add(fpParmNumber);
                if (0L != (walkState.walkThread.javaVM().extendedRuntimeFlags().longValue() & J9Consts.J9_EXTENDED_RUNTIME_USE_VECTOR_REGISTERS)) {
                    fpParmNumber = fpParmNumber.add(fpParmNumber).add(16L);
                }
            }
            return base.add(fpParmNumber);
        }

        private void jitWalkResolveMethodFrame_walkI(WalkState walkState) throws CorruptDataException {
            if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkI", ex);
                    }
                }
                this.stackSpillCount = this.stackSpillCount.sub(1L);
                this.stackSpillCursor = this.stackSpillCursor.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkI", ex);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkF(WalkState walkState) throws CorruptDataException {
            if (!this.floatRegistersRemaining.eq(0L)) {
                UDATA fpParmNumber = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT).sub(this.floatRegistersRemaining);
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer fprSave = UDATAPointer.cast(this.jitFPRParmAddress(walkState, fpParmNumber));
                        if (J9StackWalkFlags.J9SW_JIT_FLOATS_PASSED_AS_DOUBLES_DEFINED && !J9BuildFlags.env_data64) {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(fprSave.add(1L)), "JIT-sig-reg-");
                        }
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(fprSave), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkF", ex);
                    }
                }
                this.floatRegistersRemaining = this.floatRegistersRemaining.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkF", ex);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkJ(WalkState walkState) throws CorruptDataException {
            this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
            if (J9StackWalkFlags.J9SW_ARGUMENT_REGISTER_COUNT_DEFINED && !this.stackSpillCount.eq(0L)) {
                try {
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", ex);
                }
                this.stackSpillCount = this.stackSpillCount.sub(1L);
                this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                if (!J9BuildFlags.env_data64) {
                    if (!this.stackSpillCount.eq(0L)) {
                        try {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.stackSpillCursor), "JIT-sig-reg-");
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", ex);
                        }
                        this.stackSpillCount = this.stackSpillCount.sub(1L);
                        this.stackSpillCursor = this.stackSpillCursor.sub(1L);
                    } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                        try {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-stk-");
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", ex);
                        }
                    }
                }
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!J9BuildFlags.env_data64) {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-stk-");
                    }
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkJ", ex);
                }
            }
        }

        private void jitWalkResolveMethodFrame_walkD(WalkState walkState) throws CorruptDataException {
            this.pendingSendScanCursor = this.pendingSendScanCursor.sub(1L);
            if (!this.floatRegistersRemaining.eq(0L)) {
                UDATA fpParmNumber = new UDATA(J9StackWalkConstants.J9SW_JIT_FLOAT_ARGUMENT_REGISTER_COUNT).sub(this.floatRegistersRemaining);
                if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer fprSave = UDATAPointer.cast(this.jitFPRParmAddress(walkState, fpParmNumber));
                        if (!J9BuildFlags.env_data64) {
                            StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(fprSave.add(1L)), "JIT-sig-reg-");
                        }
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(fprSave), "JIT-sig-reg-");
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkD", ex);
                    }
                }
                this.floatRegistersRemaining = this.floatRegistersRemaining.sub(1L);
            } else if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                try {
                    if (!J9BuildFlags.env_data64) {
                        StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor.add(1L)), "JIT-sig-reg-");
                    }
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(this.pendingSendScanCursor), "JIT-sig-stk-");
                }
                catch (CorruptDataException ex) {
                    StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkResolveMethodFrame_walkD", ex);
                }
            }
        }

        private FrameCallbackResult walkTransitionFrame(WalkState walkState) throws CorruptDataException {
            if ((walkState.flags & J9Consts.J9_STACKWALK_START_AT_JIT_FRAME) != 0L) {
                walkState.flags &= J9Consts.J9_STACKWALK_START_AT_JIT_FRAME ^ 0xFFFFFFFFFFFFFFFFL;
                walkState.unwindSP = walkState.walkSP;
                if (J9BuildFlags.jit_fullSpeedDebug) {
                    walkState.pcAddress = PointerPointer.NULL;
                }
                return FrameCallbackResult.KEEP_ITERATING;
            }
            if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RESOLVE_FRAME)) {
                J9SFJITResolveFramePointer resolveFrame = J9SFJITResolveFramePointer.cast(U8Pointer.cast(walkState.bp).sub(J9SFJITResolveFrame.SIZEOF).add(UDATA.SIZEOF));
                UDATA resolveFrameType = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
                if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_GENERIC_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tGeneric resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tStack overflow resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_DATA_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tData resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RUNTIME_HELPER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tRuntime helper resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInterface lookup resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInterface method resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tSpecial method resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tStatic method resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tVirtual method resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tRecompilation resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMonitor enter resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_METHOD_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tMethod monitor enter resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tFailed method monitor enter resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_ALLOCATION_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAllocation resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_BEFORE_ANEWARRAY_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tBefore anewarray resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_BEFORE_MULTIANEWARRAY_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tBefore multianewarray resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tInduce OSR resolve", new Object[0]);
                } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tException catch resolve", new Object[0]);
                } else {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tUnknown resolve type {0}", resolveFrameType.getHexValue());
                }
                if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_EXCEPTION_CATCH_RESOLVE)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAt exception catch - incrementing PC to make map fetching work", new Object[0]);
                    walkState.pc = walkState.pc.add(1L);
                }
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, resolveFrame.returnAddressEA());
                if (J9BuildFlags.jit_fullSpeedDebug) {
                    walkState.resolveFrameFlags = walkState.frameFlags;
                }
                walkState.unwindSP = UDATAPointer.cast(resolveFrame.taggedRegularReturnSP()).untag(3L);
                StackWalkerUtils.swPrintf(walkState, 3, "\tunwindSP initialized to {0}", walkState.unwindSP.getHexAddress());
                if (J9StackWalkFlags.J9SW_JIT_HELPERS_PASS_PARAMETERS_ON_STACK) {
                    walkState.unwindSP = walkState.unwindSP.add(resolveFrame.parmCount());
                    StackWalkerUtils.swPrintf(walkState, 3, "\tAdding {0} slots of pushed resolve parameters", resolveFrame.parmCount());
                }
                if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_DATA_RESOLVE)) {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        MethodMetaData.jitAddSpilledRegistersForDataResolve(walkState);
                    }
                    walkState.unwindSP = walkState.unwindSP.add(MethodMetaData.getJitDataResolvePushes());
                    StackWalkerUtils.swPrintf(walkState, 3, "\tData resolve added {0} slots", MethodMetaData.getJitDataResolvePushes());
                } else {
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        this.jitAddSpilledRegistersForResolve(walkState);
                    }
                    if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_VIRTUAL_METHOD_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INTERFACE_METHOD_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_SPECIAL_METHOD_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STATIC_METHOD_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_LOOKUP_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_RECOMPILATION_RESOLVE) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_INDUCE_OSR_RESOLVE)) {
                        this.jitWalkResolveMethodFrame(walkState);
                    } else if (resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME) || resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FAILED_METHOD_MONITOR_ENTER_RESOLVE)) {
                        boolean inMethodPrologue = resolveFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_STACK_OVERFLOW_RESOLVE_FRAME);
                        walkState.jitInfo = this.jitGetExceptionTable(walkState);
                        walkState.bp = walkState.unwindSP;
                        if (!inMethodPrologue) {
                            walkState.bp = walkState.bp.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                        }
                        walkState.outgoingArgCount = new UDATA(0L);
                        JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                        JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT (hidden)");
                        try {
                            if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                                this.jitWalkFrame(walkState, !inMethodPrologue, VoidPointer.NULL);
                            }
                        }
                        catch (CorruptDataException ex) {
                            StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkTransitionFrame", ex);
                        }
                        if ((walkState.flags & J9Consts.J9_STACKWALK_ITERATE_HIDDEN_JIT_FRAMES) != 0L) {
                            walkState.frameFlags = new UDATA(0L);
                            FrameCallbackResult rc = StackWalker.walkFrame(walkState);
                            if (rc != FrameCallbackResult.KEEP_ITERATING) {
                                return rc;
                            }
                        }
                        if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                            this.CLEAR_LOCAL_REGISTER_MAP_ENTRIES(walkState);
                        }
                        this.UNWIND_TO_NEXT_FRAME(walkState);
                    }
                }
            } else if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_JNI_CALL_OUT_FRAME)) {
                J9SFNativeMethodFramePointer nativeMethodFrame = J9SFNativeMethodFramePointer.cast(walkState.bp.subOffset(J9SFNativeMethodFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, nativeMethodFrame.savedCPEA());
                if (J9BuildFlags.interp_growableStacks && walkState.frameFlags.anyBitsIn(J9Consts.J9_SSF_JNI_REFS_REDIRECTED) && (walkState.flags & J9Consts.J9_STACKWALK_ITERATE_O_SLOTS) != 0L) {
                    try {
                        UDATAPointer currentBP = walkState.bp;
                        walkState.jitInfo = this.jitGetExceptionTable(walkState);
                        walkState.unwindSP = UDATAPointer.cast(nativeMethodFrame.savedPC()).add(1L);
                        walkState.bp = walkState.unwindSP.add(MethodMetaData.getJitTotalFrameSize(walkState.jitInfo));
                        JITStackWalker_29_V0.SET_A0_CP_METHOD(walkState);
                        JITStackWalker_29_V0.jitPrintFrameType(walkState, "JIT (redirected JNI refs)");
                        this.jitWalkFrame(walkState, true, VoidPointer.NULL);
                        walkState.bp = currentBP;
                    }
                    catch (CorruptDataException ex) {
                        StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "walkTransitionFrame", ex);
                    }
                }
                walkState.unwindSP = walkState.bp.add(1L);
            } else if (walkState.frameFlags.anyBitsIn(J9StackWalkConstants.J9_STACK_FLAGS_JIT_CALL_IN_FRAME)) {
                UDATA callInFrameType = walkState.frameFlags.bitAnd(J9StackWalkConstants.J9_STACK_FLAGS_JIT_FRAME_SUB_TYPE_MASK);
                if (callInFrameType.eq(J9StackWalkConstants.J9_STACK_FLAGS_JIT_CALL_IN_TYPE_J2_I)) {
                    J9SFJ2IFramePointer j2iFrame = J9SFJ2IFramePointer.cast(walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                    walkState.i2jState = J9I2JStatePointer.cast(j2iFrame.i2jStateEA());
                    walkState.j2iFrame = j2iFrame.previousJ2iFrame();
                    if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                        this.jitAddSpilledRegistersForJ2I(walkState);
                    }
                    walkState.unwindSP = j2iFrame.taggedReturnSP().untag(3L);
                    JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, j2iFrame.returnAddressEA());
                }
            } else {
                J9SFSpecialFramePointer specialFrame = J9SFSpecialFramePointer.cast(walkState.bp.subOffset(J9SFSpecialFrame.SIZEOF).addOffset(UDATA.SIZEOF));
                if ((walkState.flags & J9Consts.J9_STACKWALK_MAINTAIN_REGISTER_MAP) != 0L) {
                    this.jitAddSpilledRegistersForINL(walkState);
                }
                walkState.unwindSP = J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP ? walkState.arg0EA.add(1L) : specialFrame.savedA0().untag(3L);
                JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, specialFrame.savedCPEA());
            }
            return FrameCallbackResult.KEEP_ITERATING;
        }

        private void jitAddSpilledRegistersForResolve(WalkState walkState) throws CorruptDataException {
            try {
                UDATAPointer slotCursor = walkState.walkedEntryLocalStorage.jitGlobalStorageBase();
                int mapCursor = 0;
                int i = 0;
                while ((long)i < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                    walkState.registerEAs[mapCursor++] = slotCursor;
                    slotCursor = slotCursor.add(1L);
                    ++i;
                }
                this.jitPrintRegisterMapArray(walkState, "Resolve");
            }
            catch (CorruptDataException ex) {
                StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", ex);
            }
        }

        private void jitAddSpilledRegistersForINL(WalkState walkState) throws CorruptDataException {
            UDATAPointer slotCursor = walkState.walkedEntryLocalStorage.jitGlobalStorageBase();
            int i = 0;
            while ((long)i < J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                int regNumber = JITRegMap.jitCalleeSavedRegisterList[i];
                walkState.registerEAs[regNumber] = slotCursor.add(regNumber);
                ++i;
            }
            this.jitPrintRegisterMapArray(walkState, "INL");
        }

        private void jitAddSpilledRegistersForJ2I(WalkState walkState) throws CorruptDataException {
            J9SFJ2IFramePointer j2iFrame = J9SFJ2IFramePointer.cast(walkState.bp.subOffset(J9SFJ2IFrame.SIZEOF).addOffset(UDATA.SIZEOF));
            UDATAPointer slotCursor = UDATAPointer.cast(j2iFrame.previousJ2iFrameEA()).add(1L);
            int i = 0;
            while ((long)i < J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                int regNumber = JITRegMap.jitCalleeSavedRegisterList[i];
                walkState.registerEAs[regNumber] = slotCursor;
                slotCursor = slotCursor.add(1L);
                ++i;
            }
            this.jitPrintRegisterMapArray(walkState, "J2I");
        }

        @Override
        public void jitPrintRegisterMapArray(WalkState walkState, String description) throws CorruptDataException {
            int i = 0;
            while ((long)i < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                UDATAPointer registerSaveAddress = walkState.registerEAs[i];
                if (!registerSaveAddress.eq(UDATAPointer.NULL)) {
                    StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-{0}-RegisterMap[{1}] = {2} ({3})", description, registerSaveAddress.getHexAddress(), registerSaveAddress.at(0L), JITRegMap.jitRegisterNames[i]);
                }
                ++i;
            }
        }

        private void CLEAR_LOCAL_REGISTER_MAP_ENTRIES(WalkState walkState) {
            int clearRegNum = 0;
            while ((long)clearRegNum < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - J9StackWalkConstants.J9SW_JIT_CALLEE_PRESERVED_SIZE) {
                walkState.registerEAs[JITRegMap.jitCalleeDestroyedRegisterList[clearRegNum]] = UDATAPointer.NULL;
                ++clearRegNum;
            }
        }

        private void UNWIND_TO_NEXT_FRAME(WalkState walkState) throws CorruptDataException {
            if (J9StackWalkFlags.J9SW_NEEDS_JIT_2_INTERP_CALLEE_ARG_POP) {
                walkState.unwindSP = UDATAPointer.cast(J9JITFramePointer.cast(walkState.bp).add(1L)).add(walkState.argCount);
                this.COMMON_UNWIND_TO_NEXT_FRAME(walkState);
            } else {
                walkState.unwindSP = UDATAPointer.cast(J9JITFramePointer.cast(walkState.bp).add(1L));
                this.COMMON_UNWIND_TO_NEXT_FRAME(walkState);
            }
        }

        private void COMMON_UNWIND_TO_NEXT_FRAME(WalkState walkState) throws CorruptDataException {
            if (J9BuildFlags.jit_fullSpeedDebug) {
                walkState.resolveFrameFlags = new UDATA(0L);
            }
            JITStackWalker_29_V0.UPDATE_PC_FROM(walkState, J9JITFramePointer.cast(walkState.bp).returnPCEA());
        }

        private void jitWalkFrame(WalkState walkState, boolean walkLocals, VoidPointer stackMap) throws CorruptDataException {
            J9OSRBufferPointer osrBuffer;
            UDATAPointer objectTempScanCursor;
            StackWalkerUtils.WALK_METHOD_CLASS(walkState);
            if (stackMap.isNull() && (stackMap = MethodMetaData.getStackMapFromJitPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc))).isNull()) {
                throw new AddressedCorruptDataException(walkState.jitInfo.getAddress(), "Unable to locate JIT stack map");
            }
            J9JITStackAtlasPointer gcStackAtlas = MethodMetaData.getJitGCStackAtlas(walkState.jitInfo);
            StackWalkerUtils.swPrintf(walkState, 2, "\tstackMap={0}, slots={1} parmBaseOffset={2}, parmSlots={3}, localBaseOffset={4}", stackMap.getHexAddress(), walkState.jitInfo.slots(), gcStackAtlas.parmBaseOffset(), gcStackAtlas.numberOfParmSlots(), gcStackAtlas.localBaseOffset());
            UDATAPointer objectArgScanCursor = MethodMetaData.getObjectArgScanCursor(walkState);
            this.jitBitsRemaining = new UDATA(0L);
            this.mapBytesRemaining = new UDATA(MethodMetaData.getJitNumberOfMapBytes(gcStackAtlas));
            this.jitDescriptionCursor = MethodMetaData.getJitStackSlots(walkState.jitInfo, stackMap);
            this.stackAllocMapCursor = U8Pointer.cast(MethodMetaData.getStackAllocMapFromJitPC(walkState.walkThread.javaVM(), walkState.jitInfo, UDATA.cast(walkState.pc), stackMap));
            this.stackAllocMapBits = new U8(0L);
            walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_METHOD_LOCAL;
            walkState.slotIndex = 0;
            if (!MethodMetaData.getJitNumberOfParmSlots(gcStackAtlas).eq(0L)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tDescribed JIT args starting at {0} for {1} slots", objectArgScanCursor.getHexAddress(), gcStackAtlas.numberOfParmSlots());
                this.walkJITFrameSlots(walkState, objectArgScanCursor, new UDATA(MethodMetaData.getJitNumberOfParmSlots(gcStackAtlas)), stackMap, J9JITStackAtlasPointer.NULL, ": a");
            }
            if (walkLocals && !walkState.bp.sub(UDATA.cast(objectTempScanCursor = MethodMetaData.getObjectTempScanCursor(walkState))).eq(UDATAPointer.NULL)) {
                StackWalkerUtils.swPrintf(walkState, 4, "\tDescribed JIT temps starting at {0} for {1} slots", objectTempScanCursor.getHexAddress(), walkState.bp.sub(objectTempScanCursor));
                this.walkJITFrameSlots(walkState, objectTempScanCursor, new UDATA(walkState.bp.subOffset(UDATA.cast(objectTempScanCursor)).longValue() / (long)UDATA.SIZEOF), stackMap, gcStackAtlas, ": t");
            }
            this.jitWalkRegisterMap(walkState, stackMap, gcStackAtlas);
            J9JITDecompilationInfoPointer decompilationRecord = walkState.decompilationRecord;
            if (!decompilationRecord.isNull() && !(osrBuffer = J9OSRBufferPointer.cast(decompilationRecord.osrBufferEA())).numberOfFrames().eq(0L)) {
                this.jitWalkOSRBuffer(walkState, osrBuffer);
            }
        }

        private void walkJITFrameSlots(WalkState walkState, UDATAPointer scanCursor, UDATA slotsRemaining, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas, String slotDescription) throws CorruptDataException {
            if (gcStackAtlas.notNull() && MethodMetaData.getJitInternalPointerMap(gcStackAtlas).notNull()) {
                MethodMetaData.walkJITFrameSlotsForInternalPointers(walkState, this.jitDescriptionCursor, scanCursor, stackMap, gcStackAtlas);
            }
            while (!slotsRemaining.eq(0L)) {
                String indexedTag;
                if (this.jitBitsRemaining.eq(0L)) {
                    if (!this.mapBytesRemaining.eq(0L)) {
                        this.jitDescriptionBits = MethodMetaData.getNextDescriptionBit(this.jitDescriptionCursor);
                        this.jitDescriptionCursor = this.jitDescriptionCursor.add(1L);
                        if (this.stackAllocMapCursor.notNull()) {
                            this.stackAllocMapBits = MethodMetaData.getNextDescriptionBit(this.stackAllocMapCursor);
                            this.stackAllocMapCursor = this.stackAllocMapCursor.add(1L);
                        }
                        this.mapBytesRemaining = this.mapBytesRemaining.sub(1L);
                    } else {
                        this.jitDescriptionBits = new U8(0L);
                    }
                    this.jitBitsRemaining = new UDATA(8L);
                }
                if (this.jitDescriptionBits.anyBitsIn(1L)) {
                    indexedTag = String.format("O-Slot: %s%d", slotDescription, slotsRemaining.sub(1L).intValue());
                    StackWalkerUtils.WALK_NAMED_O_SLOT(walkState, PointerPointer.cast(scanCursor), indexedTag);
                } else if (this.stackAllocMapBits.anyBitsIn(1L)) {
                    JITStackWalker_29_V0.jitWalkStackAllocatedObject(walkState, J9ObjectPointer.cast(scanCursor));
                } else {
                    indexedTag = String.format("I-Slot: %s%d", slotDescription, slotsRemaining.sub(1L).intValue());
                    StackWalkerUtils.WALK_NAMED_I_SLOT(walkState, PointerPointer.cast(scanCursor), indexedTag);
                }
                ++walkState.slotIndex;
                scanCursor = scanCursor.add(1L);
                this.jitBitsRemaining = this.jitBitsRemaining.sub(1L);
                this.jitDescriptionBits = this.jitDescriptionBits.rightShift(1);
                this.stackAllocMapBits = this.stackAllocMapBits.rightShift(1);
                slotsRemaining = slotsRemaining.sub(1L);
            }
        }

        private static void jitWalkStackAllocatedObject(WalkState walkState, J9ObjectPointer object) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 4, "\t\tSA-Obj[{0}]", Long.toHexString(object.getAddress()));
            GCObjectIterator it = GCObjectIterator.fromJ9Object(object, false);
            while (it.hasNext()) {
                ObjectReferencePointer slot = ObjectReferencePointer.cast(it.nextAddress());
                StackWalkerUtils.swPrintf(walkState, 4, "\t\t\tF-Slot[{0}] = {1}", slot.getHexAddress(), slot.at(0L).getHexAddress());
                if (walkState.callBacks == null) continue;
                walkState.callBacks.fieldSlotWalkFunction(walkState.walkThread, walkState, slot, VoidPointer.cast(slot));
            }
        }

        private static void jitPrintFrameType(WalkState walkState, String frameType) throws CorruptDataException {
            StackWalkerUtils.swPrintf(walkState, 2, "{0} frame: bp = {1}, pc = {2}, unwindSP = {3}, cp = {4}, arg0EA = {5}, jitInfo = {6}", frameType, walkState.bp.getHexAddress(), walkState.pc.getHexAddress(), walkState.unwindSP.getHexAddress(), walkState.constantPool.getHexAddress(), walkState.arg0EA.getHexAddress(), walkState.jitInfo.getHexAddress());
            try {
                StackWalkerUtils.swPrintMethod(walkState);
            }
            catch (CorruptDataException ex) {
                StackWalkerUtils.handleOSlotsCorruption(walkState, "JITStackWalker_29_V0", "jitWalkStackFrames", ex);
            }
            StackWalkerUtils.swPrintf(walkState, 3, "\tBytecode index = {0}, inlineDepth = {1}, PC offset = {2}", UDATA.cast(walkState.bytecodePCOffset).longValue(), walkState.inlineDepth, walkState.pc.sub(UDATA.cast(walkState.method.extra())).getHexAddress());
        }

        private void jitWalkRegisterMap(WalkState walkState, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas) throws CorruptDataException {
            UDATA registerMap = new UDATA(MethodMetaData.getJitRegisterMap(walkState.jitInfo, stackMap).bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK));
            StackWalkerUtils.swPrintf(walkState, 200, "\tIn jitWalkRegisterMap. stackMap={0}, gcStackAtlas={1}", Long.toHexString(stackMap.getAddress()), Long.toHexString(gcStackAtlas.getAddress()));
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-RegisterMap = {0}", registerMap);
            if (gcStackAtlas.internalPointerMap().notNull()) {
                registerMap = registerMap.bitAnd(new UDATA(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK).bitNot());
            }
            if (!registerMap.eq(0L)) {
                int count = (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS;
                int mapCursor = 0;
                mapCursor = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? 0 : (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - 1;
                walkState.slotType = (int)J9StackWalkState.J9_STACKWALK_SLOT_TYPE_JIT_REGISTER_MAP;
                walkState.slotIndex = 0;
                while (count != 0) {
                    if (registerMap.anyBitsIn(1L)) {
                        J9ObjectPointer newObject;
                        PointerPointer targetObject = PointerPointer.cast(walkState.registerEAs[mapCursor]);
                        J9ObjectPointer oldObject = targetObject.isNull() ? J9ObjectPointer.NULL : J9ObjectPointer.cast(targetObject.at(0L));
                        StackWalkerUtils.swPrintf(walkState, 4, "\t\tJIT-RegisterMap-O-Slot[{0}] = {1} ({2})", targetObject.getHexAddress(), oldObject.getHexAddress(), JITRegMap.jitRegisterNames[mapCursor]);
                        walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, targetObject, VoidPointer.cast(targetObject));
                        J9ObjectPointer j9ObjectPointer = newObject = targetObject.isNull() ? J9ObjectPointer.NULL : J9ObjectPointer.cast(targetObject.at(0L));
                        if (!oldObject.eq(newObject)) {
                            StackWalkerUtils.swPrintf(walkState, 4, "\t\t\t-> {0}\n", newObject);
                        }
                    } else {
                        UDATAPointer targetSlot = walkState.registerEAs[mapCursor];
                        if (targetSlot.notNull()) {
                            StackWalkerUtils.swPrintf(walkState, 5, "\t\tJIT-RegisterMap-I-Slot[{0}] = {1} ({2})", targetSlot.getHexAddress(), targetSlot.at(0L), JITRegMap.jitRegisterNames[mapCursor]);
                        }
                    }
                    ++walkState.slotIndex;
                    --count;
                    registerMap = registerMap.rightShift(1);
                    if (J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH) {
                        ++mapCursor;
                        continue;
                    }
                    --mapCursor;
                }
            }
        }

        private J9OSRFramePointer jitWalkOSRFrame(WalkState walkState, J9OSRFramePointer osrFrame) throws CorruptDataException {
            J9MethodPointer method = osrFrame.method();
            UDATA offsetPC = osrFrame.bytecodePCOffset();
            UDATA numberOfLocals = osrFrame.numberOfLocals();
            UDATA maxStack = osrFrame.maxStack();
            UDATA pendingStackHeight = osrFrame.pendingStackHeight();
            U8Pointer bytecodePC = method.bytecodes().add(offsetPC);
            UDATAPointer localSlots = UDATAPointer.cast(osrFrame.add(1L)).add(maxStack);
            UDATAPointer nextFrame = localSlots.add(numberOfLocals);
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-OSRFrame = {0}, bytecodePC = {1}, numberOfLocals = {2}, maxStack = {3}, pendingStackHeight = {4}", osrFrame.getHexAddress(), bytecodePC.getHexAddress(), numberOfLocals, maxStack, pendingStackHeight);
            StackWalkerUtils.swPrintMethod(walkState, method);
            StackWalker.walkBytecodeFrameSlots(walkState, method, offsetPC, localSlots.sub(1L), pendingStackHeight, nextFrame.sub(1L), numberOfLocals);
            return J9OSRFramePointer.cast(nextFrame);
        }

        private void jitWalkOSRBuffer(WalkState walkState, J9OSRBufferPointer osrBuffer) throws CorruptDataException {
            long numberOfFrames = osrBuffer.numberOfFrames().longValue();
            J9OSRFramePointer currentFrame = J9OSRFramePointer.cast(osrBuffer.add(1L));
            StackWalkerUtils.swPrintf(walkState, 3, "\tJIT-OSRBuffer = {0}, numberOfFrames = {1}", osrBuffer.getHexAddress(), numberOfFrames);
            do {
                currentFrame = this.jitWalkOSRFrame(walkState, currentFrame);
            } while (0L != --numberOfFrames);
        }
    }

    private static interface IJITStackWalker
    extends IAlgorithm {
        public FrameCallbackResult jitWalkStackFrames(WalkState var1) throws CorruptDataException;

        public void jitPrintRegisterMapArray(WalkState var1, String var2) throws CorruptDataException;

        public J9JITExceptionTablePointer jitGetExceptionTableFromPC(J9VMThreadPointer var1, U8Pointer var2) throws CorruptDataException;
    }
}

