/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCFreeListIteratorAggregatedCellList;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolAggregatedCellListPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;

public class GCMemoryPoolAggregatedCellList
extends GCMemoryPool {
    protected MM_MemoryPoolAggregatedCellListPointer _memoryPool = null;

    protected GCMemoryPoolAggregatedCellList(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        super(region, memoryPool);
        this.init(region);
    }

    private void init(GCHeapRegionDescriptor region) throws CorruptDataException {
        this._region = region;
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.SEGREGATED;
        this._memoryPool = MM_MemoryPoolAggregatedCellListPointer.cast(region.getMemoryPool());
    }

    public GCHeapLinkedFreeHeader getFirstFreeEntry() throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(this._memoryPool._freeListHead());
    }

    public GCFreeListHeapIterator freeListIterator() throws CorruptDataException {
        return new GCFreeListIteratorAggregatedCellList(this);
    }

    @Override
    public void checkFreeListsImpl() {
        try {
            GCFreeListHeapIterator freeEntryIterator = this.freeListIterator();
            GCHeapLinkedFreeHeader previousFreeEntry = null;
            while (freeEntryIterator.hasNext()) {
                GCHeapLinkedFreeHeader freeListEntry = freeEntryIterator.next();
                try {
                    this.freeEntryCheck(freeListEntry, previousFreeEntry);
                    previousFreeEntry = freeListEntry;
                }
                catch (CorruptFreeEntryException e) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", e, false);
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in free entry", e, false);
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", e, false);
        }
    }

    private void freeEntryCheck(GCHeapLinkedFreeHeader freeListEntry, GCHeapLinkedFreeHeader previousFreeEntry) throws CorruptFreeEntryException, CorruptDataException {
        this.freeEntryCheckGeneric(freeListEntry);
        if (previousFreeEntry != null && previousFreeEntry.getHeader().lte(freeListEntry.getHeader())) {
            throw new CorruptFreeEntryException("invalidOrdering", freeListEntry.getHeader());
        }
    }
}

