/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.ArrayList;
import java.util.LinkedList;

public class ObjectFieldInfo {
    J9ROMClassPointer romClass;
    int superclassFieldsSize;
    boolean objectCanUseBackfill;
    public static final int fj9object_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
    public static final int j9objectmonitor_t_SizeOf;
    int instanceObjectCount = 0;
    int instanceSingleCount = 0;
    int instanceDoubleCount = 0;
    int totalObjectCount = 0;
    int totalSingleCount = 0;
    int totalDoubleCount = 0;
    boolean instanceFieldBackfillEligible;
    int hiddenFieldCount = 0;
    int superclassBackfillOffset;
    int myBackfillOffset;
    int subclassBackfillOffset;
    public static final int NO_BACKFILL_AVAILABLE = -1;
    public static final int BACKFILL_SIZE = 4;
    public static final int LOCKWORD_SIZE;
    public static final int FINALIZE_LINK_SIZE;

    ObjectFieldInfo(J9ROMClassPointer romClass) {
        this.romClass = romClass;
        this.superclassFieldsSize = -1;
        this.superclassBackfillOffset = -1;
        this.myBackfillOffset = -1;
        this.subclassBackfillOffset = -1;
        this.objectCanUseBackfill = fj9object_t_SizeOf == 4;
        this.instanceFieldBackfillEligible = false;
    }

    int getTotalDoubleCount() {
        return this.totalDoubleCount;
    }

    int getTotalObjectCount() {
        return this.totalObjectCount;
    }

    int getTotalSingleCount() {
        return this.totalSingleCount;
    }

    int getNonBackfilledObjectCount() {
        int nonBackfilledObjects = this.totalObjectCount;
        if (this.isBackfillSuitableObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledSingleCount() {
        int nonBackfilledSingle = this.totalSingleCount;
        if (this.isBackfillSuitableSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getNonBackfilledInstanceObjectCount() {
        int nonBackfilledObjects = this.instanceObjectCount;
        if (this.isBackfillSuitableInstanceObjectAvailable() && !this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledObjects;
        }
        return nonBackfilledObjects;
    }

    int getNonBackfilledInstanceSingleCount() {
        int nonBackfilledSingle = this.instanceSingleCount;
        if (this.isBackfillSuitableInstanceSingleAvailable() && this.isMyBackfillSlotAvailable()) {
            --nonBackfilledSingle;
        }
        return nonBackfilledSingle;
    }

    int getInstanceDoubleCount() {
        return this.instanceDoubleCount;
    }

    int getInstanceObjectCount() {
        return this.instanceObjectCount;
    }

    int getInstanceSingleCount() {
        return this.instanceSingleCount;
    }

    int getHiddenFieldCount() {
        return this.hiddenFieldCount;
    }

    boolean isBackfillSuitableSingleAvailable() {
        return 0 != this.getTotalSingleCount();
    }

    boolean isBackfillSuitableObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getTotalObjectCount();
    }

    boolean isBackfillSuitableInstanceSingleAvailable() {
        return 0 != this.getInstanceSingleCount();
    }

    boolean isBackfillSuitableInstanceObjectAvailable() {
        return this.objectCanUseBackfill && 0 != this.getInstanceObjectCount();
    }

    boolean isBackfillSuitableFieldAvailable() {
        return this.isBackfillSuitableSingleAvailable() || this.isBackfillSuitableObjectAvailable();
    }

    UDATA getMyBackfillOffsetForHiddenField() {
        return new UDATA((long)this.myBackfillOffset + J9Object.SIZEOF);
    }

    int getSuperclassFieldsSize() {
        return this.superclassFieldsSize;
    }

    long getSuperclassObjectSize() {
        return (long)this.superclassFieldsSize + J9Object.SIZEOF;
    }

    void setSuperclassFieldsSize(int i) {
        this.superclassFieldsSize = i;
    }

    boolean isMyBackfillSlotAvailable() {
        return this.myBackfillOffset >= 0;
    }

    boolean isSuperclassBackfillSlotAvailable() {
        return this.superclassBackfillOffset >= 0;
    }

    int calculateFieldDataStart() {
        int fieldDataStart = this.getSuperclassFieldsSize();
        if (this.getSuperclassObjectSize() % ObjectModel.getObjectAlignmentInBytes() != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
            fieldDataStart += 4;
        }
        return fieldDataStart;
    }

    int addDoublesArea(int start) {
        return start + this.totalDoubleCount * 8;
    }

    int addObjectsArea(int start) {
        int nonBackfilledObjects = this.getNonBackfilledObjectCount();
        return start + nonBackfilledObjects * fj9object_t_SizeOf;
    }

    int getMyBackfillOffset() {
        return this.myBackfillOffset;
    }

    int getSubclassBackfillOffset() {
        return this.subclassBackfillOffset;
    }

    void setSuperclassBackfillOffset(int superclassBackfillOffset) {
        this.superclassBackfillOffset = superclassBackfillOffset;
    }

    int getSuperclassBackfillOffset() {
        return this.superclassBackfillOffset;
    }

    boolean isInstanceFieldBackfillEligible() {
        return this.instanceFieldBackfillEligible;
    }

    void countInstanceFields() throws CorruptDataException {
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
        for (J9ROMFieldShapePointer f : fields) {
            U32 modifiers = f.modifiers();
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.instanceObjectCount;
                ++this.totalObjectCount;
                continue;
            }
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.instanceDoubleCount;
                ++this.totalDoubleCount;
                continue;
            }
            ++this.instanceSingleCount;
            ++this.totalSingleCount;
        }
        this.instanceFieldBackfillEligible = this.instanceSingleCount > 0 || this.objectCanUseBackfill && this.instanceSingleCount > 0;
    }

    int countAndCopyHiddenFields(LinkedList<HiddenInstanceField> hiddenFieldList, ArrayList<HiddenInstanceField> hiddenFieldArray) throws CorruptDataException {
        String className = J9UTF8Helper.stringValue(this.romClass.className());
        this.hiddenFieldCount = 0;
        for (HiddenInstanceField hiddenField : hiddenFieldList) {
            if (hiddenField.className() != null && !className.equals(hiddenField.className())) continue;
            U32 modifiers = hiddenField.shape().modifiers();
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                ++this.totalObjectCount;
            } else if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                ++this.totalDoubleCount;
            } else {
                ++this.totalSingleCount;
            }
            hiddenFieldArray.add(hiddenField);
            ++this.hiddenFieldCount;
        }
        return this.hiddenFieldCount;
    }

    int calculateTotalFieldsSizeAndBackfill() {
        long accumulator = (long)this.superclassFieldsSize + (long)this.totalObjectCount * J9Object.SIZEOF + (long)(this.totalSingleCount * 4) + (long)(this.totalDoubleCount * 8);
        if (this.getSuperclassObjectSize() % ObjectModel.getObjectAlignmentInBytes() != 0L && (this.totalDoubleCount > 0 || !this.objectCanUseBackfill && this.totalObjectCount > 0)) {
            this.superclassBackfillOffset = this.getSuperclassFieldsSize();
            accumulator += 4L;
        }
        if (this.isSuperclassBackfillSlotAvailable() && this.isBackfillSuitableFieldAvailable()) {
            accumulator -= 4L;
            this.myBackfillOffset = this.superclassBackfillOffset;
            this.superclassBackfillOffset = -1;
        }
        if ((accumulator + J9Object.SIZEOF) % ObjectModel.getObjectAlignmentInBytes() != 0L) {
            this.subclassBackfillOffset = (int)accumulator;
            accumulator += 4L;
        } else {
            this.subclassBackfillOffset = this.superclassBackfillOffset;
        }
        return (int)accumulator;
    }

    static {
        LOCKWORD_SIZE = j9objectmonitor_t_SizeOf = J9BuildFlags.interp_smallMonitorSlot ? 4 : UDATA.SIZEOF;
        FINALIZE_LINK_SIZE = fj9object_t_SizeOf;
    }
}

