/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.HiddenInstanceField;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm29.j9.ObjectFieldInfo;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9HiddenInstanceFieldPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class J9ObjectFieldOffsetIterator_V1
extends J9ObjectFieldOffsetIterator {
    private J9JavaVMPointer vm;
    private J9ROMClassPointer romClass;
    private J9ClassPointer superClazz;
    private Iterator romFieldsShapeIterator;
    private J9ClassPointer instanceClass;
    private U32 doubleSeen = new U32(0L);
    private U32 doubleStaticsSeen = new U32(0L);
    private UDATA firstDoubleOffset = new UDATA(0L);
    private UDATA firstSingleOffset = new UDATA(0L);
    private UDATA firstObjectOffset = new UDATA(0L);
    private U32 objectsSeen = new U32(0L);
    private U32 objectStaticsSeen = new U32(0L);
    private U32 singlesSeen = new U32(0L);
    private U32 singleStaticsSeen = new U32(0L);
    private U32 walkFlags = new U32(0L);
    private J9ROMFieldShapePointer field;
    private UDATA index = new UDATA(0L);
    private UDATA offset = new UDATA(0L);
    private IDATA backfillOffsetToUse = new IDATA(-1L);
    private UDATA lockwordNeeded = new UDATA(0L);
    private UDATA lockOffset = new UDATA(0L);
    private boolean isHidden;
    private UDATA finalizeLinkOffset = new UDATA(0L);
    private int hiddenInstanceFieldWalkIndex = -1;
    private ArrayList<HiddenInstanceField> hiddenInstanceFieldList = new ArrayList();
    private static final UDATA NO_LOCKWORD_NEEDED = new UDATA(-1L);
    private static final UDATA LOCKWORD_NEEDED = new UDATA(-2L);
    private J9ObjectFieldOffset next;
    static PrintStream err = System.err;

    protected J9ObjectFieldOffsetIterator_V1(J9JavaVMPointer vm, J9ROMClassPointer romClass, J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        this.vm = vm;
        this.romClass = romClass;
        this.instanceClass = clazz;
        this.superClazz = superClazz;
        this.walkFlags = flags;
    }

    private void init() throws CorruptDataException {
        this.calculateInstanceSize(this.romClass, this.superClazz);
        this.romFieldsShapeIterator = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
    }

    private void nextField() throws CorruptDataException {
        boolean walkHiddenFields = false;
        this.isHidden = false;
        this.field = null;
        if (this.hiddenInstanceFieldWalkIndex == -1) {
            this.fieldOffsetsFindNext();
            if (this.field == null && this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_HIDDEN)) {
                walkHiddenFields = true;
                this.hiddenInstanceFieldWalkIndex = this.hiddenInstanceFieldList.size();
            }
        } else {
            walkHiddenFields = true;
        }
        if (walkHiddenFields && this.hiddenInstanceFieldWalkIndex != 0) {
            HiddenInstanceField hiddenField = this.hiddenInstanceFieldList.get(--this.hiddenInstanceFieldWalkIndex);
            this.field = hiddenField.shape();
            this.isHidden = true;
            this.offset = new UDATA((long)hiddenField.fieldOffset().intValue() - J9Object.SIZEOF);
            this.index = new UDATA(-1L);
        }
    }

    private void fieldOffsetsFindNext() throws CorruptDataException {
        while (this.romFieldsShapeIterator.hasNext()) {
            J9ROMFieldShapePointer localField = (J9ROMFieldShapePointer)this.romFieldsShapeIterator.next();
            U32 modifiers = localField.modifiers();
            this.index = this.index.add(1L);
            if (modifiers.anyBitsIn(J9JavaAccessFlags.J9AccStatic)) {
                if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    this.offset = new UDATA(this.objectStaticsSeen.mult(UDATA.SIZEOF));
                    this.objectStaticsSeen = this.objectStaticsSeen.add(1);
                    this.field = localField;
                    break;
                }
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
                if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    UDATA doubleSlots = J9BuildFlags.env_data64 ? new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount())) : new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount()).add(1)).rightShift(1);
                    this.offset = doubleSlots.mult(8).add(this.doubleStaticsSeen.mult(8));
                    this.doubleStaticsSeen = this.doubleStaticsSeen.add(1);
                } else {
                    this.offset = new UDATA(this.romClass.objectStaticCount().mult(UDATA.SIZEOF).add(this.singleStaticsSeen.mult(UDATA.SIZEOF)));
                    this.singleStaticsSeen = this.singleStaticsSeen.add(1);
                }
                this.field = localField;
                break;
            }
            if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD)) {
                    this.offset = new UDATA(this.backfillOffsetToUse);
                    this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD).bitNot()));
                } else {
                    this.offset = this.firstObjectOffset.add(this.objectsSeen.mult(ObjectFieldInfo.fj9object_t_SizeOf));
                    this.objectsSeen = this.objectsSeen.add(1);
                }
                this.field = localField;
                break;
            }
            if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS)) continue;
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.offset = this.firstDoubleOffset.add(this.doubleSeen.mult(8));
                this.doubleSeen = this.doubleSeen.add(1);
            } else if (this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                this.offset = new UDATA(this.backfillOffsetToUse);
                this.walkFlags = this.walkFlags.bitAnd(new U32(new UDATA(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD).bitNot()));
            } else {
                this.offset = this.firstSingleOffset.add(this.singlesSeen.mult(4));
                this.singlesSeen = this.singlesSeen.add(1);
            }
            this.field = localField;
            break;
        }
    }

    private LinkedList<HiddenInstanceField> copyHiddenInstanceFieldsList(J9JavaVMPointer vm) throws CorruptDataException {
        LinkedList<HiddenInstanceField> list = new LinkedList<HiddenInstanceField>();
        J9HiddenInstanceFieldPointer fieldPointer = vm.hiddenInstanceFields();
        while (!fieldPointer.isNull()) {
            list.add(new HiddenInstanceField(fieldPointer));
            fieldPointer = fieldPointer.next();
        }
        return list;
    }

    private void calculateInstanceSize(J9ROMClassPointer romClass, J9ClassPointer superClazz) throws CorruptDataException {
        this.lockwordNeeded = NO_LOCKWORD_NEEDED;
        if (!this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_CALCULATE_INSTANCE_SIZE)) {
            return;
        }
        ObjectFieldInfo fieldInfo = new ObjectFieldInfo(romClass);
        if (superClazz.notNull()) {
            fieldInfo.setSuperclassFieldsSize(superClazz.totalInstanceSize().intValue());
            if (!superClazz.backfillOffset().eq(superClazz.totalInstanceSize().add(J9Object.SIZEOF))) {
                fieldInfo.setSuperclassBackfillOffset(superClazz.backfillOffset().sub(J9Object.SIZEOF).intValue());
            }
        } else {
            fieldInfo.setSuperclassFieldsSize(0);
        }
        this.lockwordNeeded = this.checkLockwordNeeded(romClass, superClazz, this.instanceClass);
        if ((LOCKWORD_NEEDED.equals(this.lockwordNeeded) || NO_LOCKWORD_NEEDED.equals(this.lockwordNeeded)) && superClazz.notNull() && !superClazz.lockOffset().eq(new UDATA(-1L)) && J9ClassHelper.classDepth(superClazz).isZero()) {
            int newSuperSize = fieldInfo.getSuperclassFieldsSize() - ObjectFieldInfo.LOCKWORD_SIZE;
            if (fieldInfo.isSuperclassBackfillSlotAvailable()) {
                newSuperSize -= 4;
                fieldInfo.setSuperclassBackfillOffset(-1);
            }
            fieldInfo.setSuperclassFieldsSize(newSuperSize);
        }
        LinkedList<HiddenInstanceField> extraHiddenFields = this.copyHiddenInstanceFieldsList(this.vm);
        this.finalizeLinkOffset = new UDATA(0L);
        if (!superClazz.isNull() && !superClazz.finalizeLinkOffset().isZero()) {
            this.finalizeLinkOffset = superClazz.finalizeLinkOffset();
        } else if (J9ROMClassHelper.finalizeNeeded(romClass)) {
            extraHiddenFields.addFirst(new HiddenInstanceField(this.vm.hiddenFinalizeLinkFieldShape()));
        }
        this.lockOffset = new UDATA(this.lockwordNeeded);
        if (this.lockOffset.eq(LOCKWORD_NEEDED)) {
            extraHiddenFields.addFirst(new HiddenInstanceField(this.vm.hiddenLockwordFieldShape()));
        }
        fieldInfo.countInstanceFields();
        fieldInfo.countAndCopyHiddenFields(extraHiddenFields, this.hiddenInstanceFieldList);
        new UDATA(fieldInfo.calculateTotalFieldsSizeAndBackfill());
        this.firstDoubleOffset = new UDATA(fieldInfo.calculateFieldDataStart());
        this.firstObjectOffset = new UDATA(fieldInfo.addDoublesArea(this.firstDoubleOffset.intValue()));
        this.firstSingleOffset = new UDATA(fieldInfo.addObjectsArea(this.firstObjectOffset.intValue()));
        if (fieldInfo.isMyBackfillSlotAvailable() && fieldInfo.isBackfillSuitableFieldAvailable()) {
            if (fieldInfo.isBackfillSuitableInstanceSingleAvailable()) {
                this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD);
            } else if (fieldInfo.isBackfillSuitableInstanceObjectAvailable()) {
                this.walkFlags = this.walkFlags.bitOr(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD);
            }
        }
        if (!this.hiddenInstanceFieldList.isEmpty()) {
            UDATA hiddenSingleOffset = this.firstSingleOffset.add(J9Object.SIZEOF + (long)(fieldInfo.getNonBackfilledInstanceSingleCount() * 4));
            UDATA hiddenDoubleOffset = this.firstDoubleOffset.add(J9Object.SIZEOF + (long)(fieldInfo.getInstanceDoubleCount() * 8));
            UDATA hiddenObjectOffset = this.firstObjectOffset.add(J9Object.SIZEOF + (long)(fieldInfo.getNonBackfilledInstanceObjectCount() * ObjectFieldInfo.fj9object_t_SizeOf));
            boolean useBackfillForObject = false;
            boolean useBackfillForSingle = false;
            if (fieldInfo.isMyBackfillSlotAvailable() && !this.walkFlags.anyBitsIn(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_OBJECT_FIELD | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_BACKFILL_SINGLE_FIELD)) {
                if (fieldInfo.isBackfillSuitableSingleAvailable()) {
                    useBackfillForSingle = true;
                } else if (fieldInfo.isBackfillSuitableObjectAvailable()) {
                    useBackfillForObject = true;
                }
            }
            for (HiddenInstanceField hiddenField : this.hiddenInstanceFieldList) {
                U32 modifiers = hiddenField.shape().modifiers();
                if (modifiers.allBitsIn(J9FieldFlags.J9FieldFlagObject)) {
                    if (useBackfillForObject) {
                        hiddenField.setFieldOffset(fieldInfo.getMyBackfillOffsetForHiddenField());
                        useBackfillForObject = false;
                        continue;
                    }
                    hiddenField.setFieldOffset(hiddenObjectOffset);
                    hiddenObjectOffset = hiddenObjectOffset.add(ObjectFieldInfo.fj9object_t_SizeOf);
                    continue;
                }
                if (modifiers.allBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                    hiddenField.setFieldOffset(hiddenDoubleOffset);
                    hiddenDoubleOffset = hiddenDoubleOffset.add(8L);
                    continue;
                }
                if (useBackfillForSingle) {
                    hiddenField.setFieldOffset(fieldInfo.getMyBackfillOffsetForHiddenField());
                    useBackfillForSingle = false;
                    continue;
                }
                hiddenField.setFieldOffset(hiddenSingleOffset);
                hiddenSingleOffset = hiddenSingleOffset.add(4L);
            }
        }
        this.backfillOffsetToUse = new IDATA(fieldInfo.getMyBackfillOffset());
    }

    private UDATA checkLockwordNeeded(J9ROMClassPointer romClass, J9ClassPointer ramSuperClass, J9ClassPointer instanceClass) throws CorruptDataException {
        if (!J9BuildFlags.thr_lockNursery) {
            return NO_LOCKWORD_NEEDED;
        }
        J9ClassPointer ramClassForRomClass = instanceClass;
        while (!ramClassForRomClass.isNull() && !romClass.equals(ramClassForRomClass.romClass())) {
            ramClassForRomClass = J9ClassHelper.superclass(ramClassForRomClass);
        }
        if (ramClassForRomClass.lockOffset().eq(NO_LOCKWORD_NEEDED)) {
            return NO_LOCKWORD_NEEDED;
        }
        if (ramSuperClass != null && !ramSuperClass.isNull() && ramClassForRomClass.lockOffset().eq(ramSuperClass.lockOffset())) {
            return ramSuperClass.lockOffset();
        }
        return LOCKWORD_NEEDED;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.getNext();
        return this.next != null;
    }

    private J9ObjectFieldOffset getNext() {
        if (this.romFieldsShapeIterator == null) {
            try {
                this.init();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("CorruptDataException in com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator_V1.init()", e, false);
                return null;
            }
        }
        try {
            this.nextField();
            if (this.field == null) {
                return null;
            }
            return new J9ObjectFieldOffset(this.field, this.offset, this.isHidden);
        }
        catch (AddressedCorruptDataException e) {
            EventManager.raiseCorruptDataEvent("AddressedCorruptDataException getting next field offset.", e, false);
            return null;
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("CorruptDataException getting next field offset.", e, false);
            return null;
        }
    }

    @Override
    public J9ObjectFieldOffset next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        J9ObjectFieldOffset toReturn = this.next;
        this.next = null;
        return toReturn;
    }
}

