/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Iterator;

public class ConstantPoolHelpers {
    private static J9ObjectFieldOffset vmRefOffset = null;

    private ConstantPoolHelpers() {
    }

    public static UDATAPointer J9_AFTER_CLASS(J9ClassPointer clazz) {
        return UDATAPointer.cast(clazz.add(1L));
    }

    public static J9ConstantPoolPointer J9_CP_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return J9ConstantPoolPointer.cast(UDATA.cast(method.constantPool())).untag(J9Consts.J9_STARTPC_STATUS);
    }

    public static J9ConstantPoolPointer J9_CP_FROM_CLASS(J9ClassPointer clazz) throws CorruptDataException {
        return J9ConstantPoolPointer.cast(clazz.ramMethods().add(clazz.romClass().romMethodCount()));
    }

    public static J9ClassPointer J9_CLASS_FROM_CP(J9ConstantPoolPointer cp) throws CorruptDataException {
        return cp.ramClass();
    }

    public static J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return ConstantPoolHelpers.J9_CLASS_FROM_CP(ConstantPoolHelpers.J9_CP_FROM_METHOD(method));
    }

    public static J9ROMConstantPoolItemPointer J9_ROM_CP_FROM_CP(J9ConstantPoolPointer cp) throws CorruptDataException {
        return cp.romConstantPool();
    }

    public static J9ROMConstantPoolItemPointer J9_ROM_CP_FROM_ROM_CLASS(J9ROMClassPointer romClass) throws CorruptDataException {
        return J9ROMConstantPoolItemPointer.cast(romClass.add(1L));
    }

    public static boolean J9_IS_CLASS_OBSOLETE(J9ClassPointer clazz) throws CorruptDataException {
        if (J9BuildFlags.interp_hotCodeReplacement) {
            return J9ClassHelper.isSwappedOut(clazz);
        }
        return false;
    }

    public static J9ClassPointer J9_CURRENT_CLASS(J9ClassPointer clazz) throws CorruptDataException {
        if (ConstantPoolHelpers.J9_IS_CLASS_OBSOLETE(clazz)) {
            return clazz.arrayClass();
        }
        return clazz;
    }

    public static J9ClassPointer J9VM_J9CLASS_FROM_HEAPCLASS(J9ObjectPointer clazzObject) throws CorruptDataException {
        if (clazzObject.isNull()) {
            return J9ClassPointer.NULL;
        }
        if (vmRefOffset == null) {
            Iterator<J9ObjectFieldOffset> fieldIterator = J9ClassHelper.getFieldOffsets(J9ObjectHelper.clazz(clazzObject));
            while (fieldIterator.hasNext()) {
                J9ObjectFieldOffset offset;
                J9ObjectFieldOffset nextField = fieldIterator.next();
                if (!(nextField instanceof J9ObjectFieldOffset) || !"vmRef".equals((offset = nextField).getName())) continue;
                vmRefOffset = offset;
                break;
            }
        }
        if (vmRefOffset != null) {
            long address = J9ObjectHelper.getLongField(clazzObject, vmRefOffset);
            return J9ClassPointer.cast(address);
        }
        throw new CorruptDataException("Unable to find field offset for the 'vmRef' field");
    }

    public static J9ObjectPointer J9VM_J9CLASS_TO_HEAPCLASS(J9ClassPointer clazz) throws CorruptDataException {
        if (clazz.isNull()) {
            return J9ObjectPointer.NULL;
        }
        return J9ObjectPointer.cast(clazz.classObject());
    }

    public static long J9_CP_TYPE(U32Pointer cpShapeDescription, int index) throws CorruptDataException {
        U32 cpDescription = cpShapeDescription.at((long)index / J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32);
        long shapeDesc = cpDescription.rightShift((int)((long)index % J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32 * J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION)).bitAnd(J9ConstantPool.J9_CP_DESCRIPTION_MASK).longValue();
        return shapeDesc;
    }
}

