/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaRuntimeHelper;
import com.ibm.j9ddr.vm28.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm28.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm28.j9.ObjectModel;
import com.ibm.j9ddr.vm28.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm28.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm28.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm28.structure.J9Object;
import com.ibm.j9ddr.vm28.types.UDATA;
import com.ibm.j9ddr.vm28.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaNestedPackedObject;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaRuntime;
import com.ibm.j9ddr.vm28.view.dtfj.java.corrupt.CorruptJavaObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DTFJJavaObject
implements JavaObject {
    private static final Class<?>[] whitelist = new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, IllegalArgumentException.class};
    protected final J9ObjectPointer object;
    protected DTFJJavaHeap heap;
    protected J9ArrayClassPointer arrayptr = null;
    private boolean hasDeferredData = true;
    private com.ibm.dtfj.image.CorruptDataException corruptException = null;
    private long size = 0L;
    boolean objectIsArray = false;
    private int arraySize = 0;
    private String label = null;
    private List<Object> references;

    public DTFJJavaObject(DTFJJavaHeap heap, J9ObjectPointer object) {
        this.object = object;
        this.heap = heap;
    }

    public DTFJJavaObject(J9ObjectPointer object) {
        this(null, object);
    }

    J9ObjectPointer getJ9ObjectPointer() {
        return this.object;
    }

    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        this.fetchDeferredData();
        if (!this.objectIsArray) {
            throw new IllegalArgumentException("Object is not an array");
        }
        J9IndexableObjectPointer array = J9IndexableObjectPointer.cast(this.object);
        try {
            DTFJJavaObject.validateArrayCopyParameters(array, srcStart, dst, dstStart, length);
            String className = J9IndexableObjectHelper.getClassName(array);
            if (null == className || className.length() < 2) {
                J9DDRCorruptData cd = new J9DDRCorruptData(DTFJContext.getProcess(), "The class name for this object could not be determined", this.object.getAddress());
                throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)cd);
            }
            if (className.charAt(1) == 'L' || className.charAt(1) == '[') {
                if (!dst.getClass().equals(Object[].class) && !(dst instanceof JavaObject[])) {
                    throw new IllegalArgumentException("Type of dst object (" + dst.getClass().getName() + ") incompatible with Object array. Should be JavaObject[] or Object[]");
                }
                J9ObjectPointer[] intermediateArray = new J9ObjectPointer[length];
                Object[] castedDst = (Object[])dst;
                if ((long)dstStart + (long)length > (long)castedDst.length) {
                    throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + ((long)dstStart + (long)length) + ", was " + castedDst.length);
                }
                J9IndexableObjectHelper.getData(array, intermediateArray, srcStart, length, 0);
                for (int i = 0; i < length; ++i) {
                    castedDst[dstStart + i] = intermediateArray[i].isNull() ? null : new DTFJJavaObject(intermediateArray[i]);
                }
            } else if (this.isPacked() && className.endsWith("$Array")) {
                Object[] castedDst = (Object[])dst;
                J9ClassPointer arrayClazz = J9ObjectHelper.clazz(J9ObjectPointer.cast(array));
                J9ClassPointer componentClazz = J9ArrayClassPointer.cast(arrayClazz).componentType();
                DTFJJavaClass componentClass = new DTFJJavaClass(componentClazz);
                J9ObjectPointer targetObject = ObjectModel.getTargetObject(J9ObjectPointer.cast(array));
                UDATA targetOffset = ObjectModel.getTargetOffset(J9ObjectPointer.cast(array));
                long packedArrayStart = targetObject.addOffset(targetOffset).longValue();
                for (int i = 0; i < length; ++i) {
                    long packedElementAddress = packedArrayStart + (long)(srcStart + i) * ObjectModel.getPackedDataSize(componentClazz).longValue();
                    castedDst[dstStart + i] = new DTFJJavaNestedPackedObject(componentClass, packedElementAddress);
                }
            } else {
                J9IndexableObjectHelper.getData(array, dst, srcStart, length, dstStart);
            }
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    private static void validateArrayCopyParameters(J9IndexableObjectPointer array, int srcStart, Object dst, int dstStart, int length) throws CorruptDataException {
        if (dst == null) {
            throw new NullPointerException("Destination array is null");
        }
        if (srcStart < 0) {
            throw new ArrayIndexOutOfBoundsException("Source copy start is out of range: " + srcStart);
        }
        if (dstStart < 0) {
            throw new ArrayIndexOutOfBoundsException("Destination copy start is out of range: " + dstStart);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("Copy length is out of range: " + length);
        }
        long size = J9IndexableObjectHelper.size(array).longValue();
        if ((long)srcStart + (long)length > size) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + ((long)srcStart + (long)length));
        }
        if (!dst.getClass().isArray()) {
            throw new IllegalArgumentException("Destination object of type " + dst.getClass().getName() + " is not an array");
        }
    }

    public int getArraySize() throws com.ibm.dtfj.image.CorruptDataException {
        this.fetchDeferredData();
        if (this.objectIsArray) {
            return this.arraySize;
        }
        throw new IllegalArgumentException("This object is not an array");
    }

    public long getHashcode() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            return ObjectAccessBarrier.getObjectHashCode(this.object).longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButDataUnavailAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public JavaHeap getHeap() throws com.ibm.dtfj.image.CorruptDataException, DataUnavailable {
        try {
            if (this.heap == null) {
                DTFJJavaRuntime runtime = DTFJContext.getRuntime();
                this.heap = runtime.getHeapFromAddress(DTFJContext.getImagePointer(this.object.getAddress()));
                if (this.heap == null) {
                    throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)new CorruptJavaObject(null, this.object));
                }
            }
            return this.heap;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public ImagePointer getID() {
        return DTFJContext.getImagePointer(this.object.getAddress());
    }

    public JavaClass getJavaClass() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9ClassPointer ptr = J9ObjectHelper.clazz(this.object);
            return new DTFJJavaClass(ptr);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public long getPersistentHashcode() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        try {
            if (ObjectModel.hasBeenHashed(this.object)) {
                return this.getHashcode();
            }
            throw new DataUnavailable("Object has never been hashed and therefore has no persistent hash code");
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButDataUnavailAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public Iterator getReferences() {
        boolean isClass = false;
        boolean isClassLoader = false;
        boolean isWeakReference = false;
        boolean isSoftReference = false;
        boolean isPhantomReference = false;
        if (null == this.references) {
            this.references = new LinkedList<Object>();
            try {
                JavaClass jClass = this.getJavaClass();
                if (null != jClass) {
                    DTFJJavaReference ref = new DTFJJavaReference(this, jClass, "Class", 1, 0, 1);
                    this.references.add(ref);
                }
                if (this.isPacked()) {
                    if (!this.isNativePacked() && !this.isNestedPacked()) {
                        if (this.isDerivedObject()) {
                            DTFJJavaObject target = new DTFJJavaObject(null, ObjectModel.getTargetObject(this.object));
                            this.references.add(new DTFJJavaReference(this, target, "Derived object header reference to target object", 14, 0, 1));
                        } else {
                            boolean first = true;
                            GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(this.object, false);
                            while (fieldIterator.hasNext()) {
                                J9ObjectPointer field = fieldIterator.next();
                                if (field.isNull()) continue;
                                if (first) {
                                    first = false;
                                    this.references.add(new DTFJJavaReference(this, this, "Java packed object header reference to self", 14, 0, 1));
                                    continue;
                                }
                                DTFJJavaObject obj = new DTFJJavaObject(field);
                                this.references.add(new DTFJJavaReference(this, obj, "Object Reference", 2, 0, 1));
                            }
                        }
                    }
                } else if (this.isArray()) {
                    if (this.isObjectArray()) {
                        this.addObjectArrayReferences();
                    }
                } else {
                    isClass = jClass != null && jClass.getName().equals("java/lang/Class");
                    LinkedList<JavaClass> superClasses = new LinkedList<JavaClass>();
                    while (jClass != null) {
                        String className = jClass.getName();
                        isClassLoader |= className.equals("java/lang/ClassLoader");
                        isWeakReference |= className.equals("java/lang/ref/WeakReference");
                        isSoftReference |= className.equals("java/lang/ref/SoftReference");
                        isPhantomReference |= className.equals("java/lang/ref/PhantomReference");
                        superClasses.add(jClass);
                        jClass = jClass.getSuperclass();
                    }
                    int reachability = isWeakReference ? 3 : (isSoftReference ? 2 : (isPhantomReference ? 4 : 1));
                    for (JavaClass clazz : superClasses) {
                        this.addFieldReferences(clazz, reachability);
                    }
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                this.references.add(e.getCorruptData());
            }
            catch (Throwable t) {
                CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                this.references.add(cd);
            }
            if (isClassLoader) {
                try {
                    JavaClassLoader associatedClassLoader = this.getAssociatedClassLoader();
                    if (associatedClassLoader != null) {
                        Iterator classes = associatedClassLoader.getDefinedClasses();
                        while (classes.hasNext()) {
                            Object potentialClass = classes.next();
                            if (!(potentialClass instanceof JavaClass)) continue;
                            JavaClass currentClass = (JavaClass)potentialClass;
                            DTFJJavaReference ref = new DTFJJavaReference(this, currentClass, "Loaded class", 11, 0, 1);
                            this.references.add(ref);
                        }
                    } else {
                        this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find associated JavaClassLoader for classloader object " + this));
                    }
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    this.references.add(cd);
                }
            }
            if (isClass) {
                try {
                    JavaClass associatedClass = this.getAssociatedClass();
                    if (associatedClass != null) {
                        DTFJJavaReference ref = new DTFJJavaReference(this, associatedClass, "Associated class", 13, 0, 1);
                        this.references.add(ref);
                    } else {
                        J9ClassPointer j9Class = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(this.object);
                        if (!J9ClassHelper.isAnonymousClass(j9Class)) {
                            this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find associated JavaClass for Class object " + this));
                        }
                    }
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    this.references.add(cd);
                }
            }
        }
        return this.references.iterator();
    }

    private JavaClassLoader getAssociatedClassLoader() {
        Iterator classloaderIt = DTFJContext.getRuntime().getJavaClassLoaders();
        while (classloaderIt.hasNext()) {
            Object clObj = classloaderIt.next();
            if (!(clObj instanceof JavaClassLoader)) continue;
            JavaClassLoader loader = (JavaClassLoader)clObj;
            try {
                if (!loader.getObject().equals((Object)this)) continue;
                return loader;
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    private JavaClass getAssociatedClass() {
        JavaObject targetClassLoaderObject = null;
        try {
            JavaClass javaLangClass = this.getJavaClass();
            Iterator fields = javaLangClass.getDeclaredFields();
            while (fields.hasNext()) {
                JavaField field;
                Object o = fields.next();
                if (!(o instanceof JavaField) || !"classLoader".equals((field = (JavaField)o).getName())) continue;
                targetClassLoaderObject = (JavaObject)field.get((JavaObject)this);
                break;
            }
        }
        catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return this.getAssociatedClass(targetClassLoaderObject);
    }

    private JavaClass getAssociatedClass(JavaObject targetClassLoaderObject) {
        Iterator classloaderIt = DTFJContext.getRuntime().getJavaClassLoaders();
        while (classloaderIt.hasNext()) {
            Object clObj = classloaderIt.next();
            if (!(clObj instanceof JavaClassLoader)) continue;
            JavaClassLoader loader = (JavaClassLoader)clObj;
            try {
                if (targetClassLoaderObject != null && !loader.getObject().equals((Object)targetClassLoaderObject)) {
                    continue;
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                // empty catch block
            }
            Iterator classesIt = loader.getDefinedClasses();
            while (classesIt.hasNext()) {
                Object classObj = classesIt.next();
                if (!(classObj instanceof JavaClass)) continue;
                JavaClass clazz = (JavaClass)classObj;
                try {
                    if (!clazz.getObject().equals((Object)this)) continue;
                    return clazz;
                }
                catch (com.ibm.dtfj.image.CorruptDataException corruptDataException) {
                }
            }
        }
        return null;
    }

    private void addFieldReferences(JavaClass jClass, int referentReachabilityType) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        Iterator fieldIt = jClass.getDeclaredFields();
        while (fieldIt.hasNext()) {
            Object fieldObj = fieldIt.next();
            if (fieldObj instanceof JavaField) {
                Object targetObj;
                String signature;
                JavaField thisField = (JavaField)fieldObj;
                if ((thisField.getModifiers() & 8) != 0 || !(signature = thisField.getSignature()).startsWith("L") && !signature.startsWith("[") || (targetObj = thisField.get((JavaObject)this)) == null || thisField.isNestedPacked()) continue;
                if (targetObj instanceof JavaObject) {
                    String fieldName = thisField.getName();
                    String declaringClassName = null;
                    try {
                        declaringClassName = thisField.getDeclaringClass().getName();
                    }
                    catch (DataUnavailable dataUnavailable) {
                        // empty catch block
                    }
                    String description = "Object Reference [field name:" + fieldName + "]";
                    if (fieldName.equals("referent") && "java/lang/ref/Reference".equals(declaringClassName)) {
                        this.references.add(new DTFJJavaReference(this, targetObj, description, 2, 0, referentReachabilityType));
                        continue;
                    }
                    this.references.add(new DTFJJavaReference(this, targetObj, description, 2, 0, 1));
                    continue;
                }
                if (targetObj instanceof CorruptData) {
                    this.references.add(targetObj);
                    continue;
                }
                this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unexpected type from field get: " + targetObj + ", class=" + targetObj.getClass().getName()));
                continue;
            }
            if (fieldObj instanceof CorruptData) {
                this.references.add(fieldObj);
                continue;
            }
            this.references.add(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Unexpected type from field iteration: " + fieldObj + ", class=" + fieldObj.getClass().getName()));
        }
    }

    private void addObjectArrayReferences() throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        int arraySize = this.getArraySize();
        long lowestPossibleSizeOfThisArray = (long)arraySize * J9Object.SIZEOF;
        if (lowestPossibleSizeOfThisArray > DTFJJavaRuntimeHelper.getTotalHeapSize(DTFJContext.getRuntime(), DTFJContext.getProcess()) || lowestPossibleSizeOfThisArray < 0L) {
            throw new com.ibm.dtfj.image.CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Array longer than available heap"));
        }
        int ARRAY_SIZE_SAFETY_LIMIT = 1000000;
        if (arraySize > 1000000) {
            this.addObjectArrayReferencesWithLimitCheck(1000000);
        } else {
            this.addAllObjectArrayReferences();
        }
    }

    private void addObjectArrayReferencesWithLimitCheck(int safetyLimit) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        JavaObject thisObj;
        int i;
        JavaObject[] elements = new JavaObject[this.arraySize];
        JavaObject[] limitedElements = new JavaObject[safetyLimit];
        this.arraycopy(0, limitedElements, 0, safetyLimit);
        elements = new JavaObject[this.getArraySize() - safetyLimit];
        this.arraycopy(safetyLimit, elements, 0, this.getArraySize() - safetyLimit);
        for (i = 0; i != limitedElements.length; ++i) {
            thisObj = limitedElements[i];
            if (thisObj == null) continue;
            this.references.add(new DTFJJavaReference(this, thisObj, "Array Reference [" + i + "]", 3, 0, 1));
        }
        for (i = 0; i != elements.length; ++i) {
            thisObj = elements[i];
            if (thisObj == null) continue;
            this.references.add(new DTFJJavaReference(this, thisObj, "Array Reference [" + i + "]", 3, 0, 1));
        }
    }

    private void addAllObjectArrayReferences() throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        this.getReferences();
        JavaObject[] elements = new JavaObject[this.arraySize];
        this.arraycopy(0, elements, 0, this.arraySize);
        for (int i = 0; i != elements.length; ++i) {
            JavaObject thisObj = elements[i];
            if (thisObj == null || thisObj instanceof DTFJJavaNestedPackedObject) continue;
            this.references.add(new DTFJJavaReference(this, thisObj, "Array Reference [" + i + "]", 3, 0, 1));
        }
    }

    private boolean isObjectArray() throws com.ibm.dtfj.image.CorruptDataException, CorruptDataException {
        return ((DTFJJavaClass)this.getJavaClass()).isObjectArray();
    }

    public Iterator getSections() {
        try {
            this.fetchDeferredData();
            LinkedList<J9DDRImageSection> sections = new LinkedList<J9DDRImageSection>();
            long mainSectionSize = ObjectModel.getConsumedSizeInBytesWithHeader(this.object).longValue();
            String name = this.getSectionName(mainSectionSize);
            J9DDRImageSection section = DTFJContext.getImageSection(this.object.getAddress(), name);
            section.setSize(mainSectionSize);
            sections.add(section);
            return sections.iterator();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return J9DDRDTFJUtils.corruptIterator(e.getCorruptData());
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    private String getSectionName(long mainSectionSize) {
        StringBuilder name = new StringBuilder();
        name.append("In-memory Object section at 0x");
        name.append(Long.toHexString(this.object.getAddress()));
        name.append(" (0x");
        name.append(Long.toHexString(mainSectionSize));
        name.append(" bytes)");
        return name.toString();
    }

    public long getSize() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.fetchDeferredData();
            return this.size;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public boolean isArray() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            this.fetchDeferredData();
            return this.objectIsArray;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private void fetchDeferredData() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.corruptException != null) {
            throw this.corruptException;
        }
        if (this.hasDeferredData) {
            this.hasDeferredData = false;
            try {
                this.objectIsArray = ObjectModel.isIndexable(this.object);
                if (this.objectIsArray) {
                    this.arrayptr = J9ArrayClassPointer.cast(this.object.clazz());
                    this.arraySize = ObjectModel.getSizeInElements(this.object).intValue();
                    long headerSize = ObjectModel.getHeaderSize(this.object).longValue();
                    long dataSize = ObjectModel.getDataSizeInBytes(J9IndexableObjectPointer.cast(this.object)).longValue();
                    this.size = headerSize + dataSize;
                } else {
                    this.size = ObjectModel.getConsumedSizeInBytesWithHeader(this.object).longValue();
                }
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
    }

    public String toString() {
        if (this.label == null) {
            try {
                StringBuilder text = new StringBuilder();
                text.append("Instance of ");
                String name = J9ObjectHelper.getClassName(this.object);
                text.append(name);
                if (this.objectIsArray && name.endsWith("L")) {
                    text.append(J9ClassHelper.getName(this.arrayptr.leafComponentType())).append(";");
                }
                text.append(" @ 0x");
                text.append(Long.toHexString(this.object.getAddress()));
                this.label = text.toString();
            }
            catch (Throwable t) {
                J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                this.label = super.toString();
            }
        }
        return this.label;
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof DTFJJavaObject) {
                DTFJJavaObject local = (DTFJJavaObject)obj;
                return this.object.equals(local.object);
            }
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return false;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean isPacked() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            return J9ObjectHelper.isPacked(this.object);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public boolean isNativePacked() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isPacked()) {
            try {
                return ObjectModel.isPackedObjectHeader(this.object) && ObjectModel.getTargetObject(this.object).isNull();
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return false;
    }

    public long getNativePackedDataPointer() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isPacked()) {
            if (this.isNativePacked()) {
                try {
                    return ObjectModel.getTargetOffset(this.object).longValue();
                }
                catch (Throwable t) {
                    throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                }
            }
            return 0L;
        }
        return 0L;
    }

    public boolean isDerivedObject() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isPacked()) {
            try {
                return ObjectModel.isPackedObjectHeader(this.object) && !ObjectModel.getTargetObject(this.object).isNull();
            }
            catch (Throwable t) {
                throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
            }
        }
        return false;
    }

    public JavaObject getTargetJavaObject() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isPacked()) {
            if (this.isDerivedObject()) {
                try {
                    return new DTFJJavaObject(ObjectModel.getTargetObject(this.object));
                }
                catch (Throwable t) {
                    throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                }
            }
            return null;
        }
        return null;
    }

    public long getTargetOffset() throws com.ibm.dtfj.image.CorruptDataException {
        if (this.isPacked()) {
            if (this.isDerivedObject()) {
                try {
                    return ObjectModel.getTargetOffset(this.object).longValue();
                }
                catch (Throwable t) {
                    throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
                }
            }
            return 0L;
        }
        return 0L;
    }

    public boolean isNestedPacked() {
        return false;
    }
}

