/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.view.dtfj.java;

import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.vm28.j9.ObjectModel;
import com.ibm.j9ddr.vm28.pointer.NestedPackedObjectDataPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm28.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm28.view.dtfj.java.DTFJJavaObject;

public class DTFJJavaNestedPackedObject
extends DTFJJavaObject {
    private static final Class<?>[] whitelist = new Class[]{NullPointerException.class, ArrayIndexOutOfBoundsException.class, IllegalArgumentException.class};
    protected final JavaClass jc;
    protected int packedLengthAnnotationValue = 0;

    public DTFJJavaNestedPackedObject(JavaClass jc, long packedDataAddress) {
        super(new NestedPackedObjectDataPointer(packedDataAddress));
        this.jc = jc;
    }

    public DTFJJavaNestedPackedObject(JavaClass jc, long address, int packedLengthAnnotationValue) {
        this(jc, address);
        this.packedLengthAnnotationValue = packedLengthAnnotationValue;
    }

    @Override
    public JavaClass getJavaClass() throws com.ibm.dtfj.image.CorruptDataException {
        return this.jc;
    }

    @Override
    public boolean isArray() throws com.ibm.dtfj.image.CorruptDataException {
        if (((DTFJJavaClass)this.jc).isPackedArray()) {
            return true;
        }
        return this.jc.isArray();
    }

    @Override
    public boolean isPacked() throws com.ibm.dtfj.image.CorruptDataException {
        return true;
    }

    @Override
    public boolean isNestedPacked() {
        return true;
    }

    @Override
    public boolean isNativePacked() {
        return false;
    }

    @Override
    public boolean isDerivedObject() {
        return false;
    }

    @Override
    public long getSize() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9ClassPointer clazz = ((DTFJJavaClass)this.jc).getJ9Class();
            return ObjectModel.getPackedDataSize(clazz).longValue();
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    @Override
    public int getArraySize() throws com.ibm.dtfj.image.CorruptDataException {
        return this.packedLengthAnnotationValue;
    }

    @Override
    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (!this.isArray()) {
            throw new IllegalArgumentException("Object is not an array");
        }
        try {
            this.validateArrayCopyParameters(srcStart, dst, dstStart, length);
            if (!dst.getClass().equals(Object[].class) && !(dst instanceof JavaObject[])) {
                throw new IllegalArgumentException("Type of dst object (" + dst.getClass().getName() + ") incompatible with Object array. Should be JavaObject[] or Object[]");
            }
            Object[] castedDst = (Object[])dst;
            if (dstStart + length > castedDst.length) {
                throw new ArrayIndexOutOfBoundsException("Supplied destination array too small. Requires: " + dstStart + length + ", was " + castedDst.length);
            }
            J9ClassPointer arrayClazz = ((DTFJJavaClass)this.jc).getJ9Class();
            J9ClassPointer componentClazz = J9ArrayClassPointer.cast(arrayClazz).componentType();
            DTFJJavaClass componentClass = new DTFJJavaClass(componentClazz);
            long packedArrayStart = this.object.getAddress();
            for (int i = 0; i < length; ++i) {
                long packedElementAddress = packedArrayStart + (long)(srcStart + i) * ObjectModel.getPackedDataSize(componentClazz).longValue();
                castedDst[dstStart + i] = new DTFJJavaNestedPackedObject(componentClass, packedElementAddress);
            }
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    private void validateArrayCopyParameters(int srcStart, Object dst, int dstStart, int length) throws CorruptDataException {
        if (dst == null) {
            throw new NullPointerException("Destination array is null");
        }
        if (srcStart < 0) {
            throw new ArrayIndexOutOfBoundsException("Source copy start is out of range: " + srcStart);
        }
        if (dstStart < 0) {
            throw new ArrayIndexOutOfBoundsException("Destination copy start is out of range: " + dstStart);
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("Copy length is out of range: " + length);
        }
        int size = this.packedLengthAnnotationValue;
        if (srcStart + length > size) {
            throw new ArrayIndexOutOfBoundsException("source array index out of range: " + (srcStart + length));
        }
        if (!dst.getClass().isArray()) {
            throw new IllegalArgumentException("Destination object of type " + dst.getClass().getName() + " is not an array");
        }
    }
}

