/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.j9.Pool;
import com.ibm.j9ddr.vm28.j9.SlotIterator;
import com.ibm.j9ddr.vm28.pointer.VoidPointer;
import com.ibm.j9ddr.vm28.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm28.pointer.generated.J9PoolPointer;
import java.io.PrintStream;

public class WalkJ9PoolCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public WalkJ9PoolCommand() {
        this.addCommand("walkj9pool", "<address>", "Walks the elements of J9Pool");
    }

    private void printUsage(PrintStream out) {
        out.println("walkj9pool <address> - Walks the elements of J9Pool");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (0 == args.length || 1 < args.length) {
            this.printUsage(out);
        }
        long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
        out.append("J9Pool at 0x" + CommandUtils.longToBigInteger(address).toString(16) + "\n{\n");
        this.walkJ9Pool(address, out);
        out.append("}\n");
    }

    private void walkJ9Pool(long address, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9PoolPointer j9pool = J9PoolPointer.cast(address);
            Pool<VoidPointer> pool = Pool.fromJ9Pool(j9pool, VoidPointer.class);
            SlotIterator<VoidPointer> poolIterator = pool.iterator();
            int i = 0;
            while (poolIterator.hasNext()) {
                VoidPointer currentElement = (VoidPointer)poolIterator.next();
                out.println(String.format("\t[%d]\t=\t%s", i++, currentElement.getHexAddress()));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException("Either address is not a valid pool address or pool itself is corrupted.");
        }
    }
}

