/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm28.j9.DataType;
import com.ibm.j9ddr.vm28.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm28.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm28.structure.J9MemorySegment;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.commands.SegmentsUtil;
import java.io.PrintStream;

public class FindOverlappingSegmentsCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    private static void printHelp(PrintStream out) {
        out.append("!findoverlappingsegments         -- Search for overlaps between all J9MemorySegments except the SHARED_META segment.");
        out.append(nl);
        out.append("!findoverlappingsegments all     -- Search for overlaps between all J9MemorySegments.");
        out.append(nl);
        out.append("!findoverlappingsegments virtual -- Search for overlaps between virtual J9MemorySegments.");
        out.append(nl);
        out.append("!findoverlappingsegments help    -- Print this help message.");
        out.append(nl);
    }

    public FindOverlappingSegmentsCommand() {
        this.addCommand("findoverlappingsegments", "[all|virtual|help]", "find overlapping J9MemorySegments");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        int segmentType = 0xFFFFFFFF & ~((int)J9MemorySegment.MEMORY_TYPE_SHARED_META);
        if (args.length != 0) {
            String argument = args[0];
            if (argument.equalsIgnoreCase("help")) {
                FindOverlappingSegmentsCommand.printHelp(out);
                return;
            }
            if (argument.equalsIgnoreCase("all")) {
                segmentType = -1;
            } else if (argument.equalsIgnoreCase("virtual")) {
                segmentType = (int)J9MemorySegment.MEMORY_TYPE_VIRTUAL;
            }
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            SegmentsUtil.checkSegmentsForOverlap(out, vm, segmentType);
            out.append(nl);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

