/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm28.tools.ddrinteractive;

import com.ibm.j9ddr.vm28.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm28.tools.ddrinteractive.LinearDumper;
import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ClassSummaryHelper {
    private final Map<String, Long> sizeStat = new HashMap<String, Long>();
    private int numberOfClasses = 0;
    private String[] preferredOrder;

    public ClassSummaryHelper(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    public void addRegionsForClass(LinearDumper.J9ClassRegionNode allRegionsNode) {
        ++this.numberOfClasses;
        this.appendSizeStat(this.sizeStat, allRegionsNode, "");
    }

    public void printStatistics(PrintStream out) {
        TreeMap<String, Long> data = new TreeMap<String, Long>(new StringCompare(this.preferredOrder));
        data.putAll(this.sizeStat);
        long totalSize = 0L;
        for (Map.Entry entry : data.entrySet()) {
            if (this.getLevel((String)entry.getKey()) != 1) continue;
            totalSize += ((Long)entry.getValue()).longValue();
        }
        out.println(String.format("%d classes, using: %d bytes or %d kB", this.numberOfClasses, totalSize, totalSize / 1024L));
        out.println(String.format("%-40s%-8s %-8s %-6s", "Section", "Byte", "kB", "%"));
        for (Map.Entry entry : data.entrySet()) {
            out.println(this.printSize((String)entry.getKey(), (Long)entry.getValue(), totalSize));
        }
    }

    private void appendSizeStat(Map<String, Long> sizeStat, LinearDumper.J9ClassRegionNode regionNode, String parentName) {
        String section = parentName;
        LinearDumper.J9ClassRegion nodeValue = regionNode.getNodeValue();
        if (nodeValue != null && (nodeValue.getType() == IClassWalkCallbacks.SlotType.J9_SECTION_START || nodeValue.getType() == IClassWalkCallbacks.SlotType.J9_Padding)) {
            if (sizeStat.containsKey(section = section + "/" + nodeValue.getName())) {
                sizeStat.put(section, new Long(sizeStat.get(section) + nodeValue.getLength()));
            } else {
                sizeStat.put(section, new Long(nodeValue.getLength()));
            }
        }
        for (LinearDumper.J9ClassRegionNode classRegionNode : regionNode.getChildren()) {
            this.appendSizeStat(sizeStat, classRegionNode, section);
        }
    }

    private String printSize(String key, Long size, Long totalSize) {
        long sizeByte = size;
        double sizekB = (double)sizeByte / 1024.0;
        String[] parts = key.split("/");
        String section = parts[parts.length - 1];
        for (int i = 0; i < this.getLevel(key); ++i) {
            section = "  " + section;
        }
        double percent = (double)sizeByte / (double)totalSize.longValue() * 100.0;
        return String.format("%-40s%-8d %-8.2f %-6.2f", section, sizeByte, sizekB, percent);
    }

    private int getLevel(String key) {
        return key.split("/").length - 1;
    }

    private class StringCompare
    implements Comparator<String> {
        private final Map<String, Integer> preferredOrderMap = new HashMap<String, Integer>();

        public StringCompare(String[] preferredOrder) {
            for (int i = 0; i < preferredOrder.length; ++i) {
                this.preferredOrderMap.put(preferredOrder[i], i);
            }
        }

        private int find(String key) {
            if (this.preferredOrderMap.containsKey(key.trim())) {
                return this.preferredOrderMap.get(key.trim());
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(String o1, String o2) {
            int ordero2;
            String[] partso1 = o1.split("/");
            String[] partso2 = o2.split("/");
            int ordero1 = this.find(partso1[1]);
            if (ordero1 != (ordero2 = this.find(partso2[1]))) {
                return ordero1 - ordero2;
            }
            return o1.compareTo(o2);
        }
    }
}

