/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.I64Pointer;
import com.ibm.j9ddr.vm27.pointer.NestedPackedObjectDataPointer;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm27.structure.J9Consts;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectHelper {
    private static int cacheSize = 32;
    private static J9ObjectPointer[] keys;
    private static J9ClassPointer[] values;
    private static int[] counts;
    private static long probes;
    private static long hits;

    public static boolean isPacked(J9ObjectPointer objectPtr) throws CorruptDataException {
        return J9ClassHelper.isPacked(J9ObjectHelper.clazz(objectPtr));
    }

    public static boolean isPacked(J9IndexableObjectPointer objectPtr) throws CorruptDataException {
        return J9ObjectHelper.isPacked(J9ObjectPointer.cast(objectPtr));
    }

    public static boolean isIndexable(J9ObjectPointer objPointer) throws CorruptDataException {
        return ObjectModel.isIndexable(objPointer);
    }

    public static U32 flags(J9ObjectPointer objPointer) throws CorruptDataException {
        if (J9BuildFlags.interp_flagsInClassSlot) {
            long bitmask = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L;
            J9ClassPointer clazz = objPointer.clazz();
            return new U32(UDATA.cast(clazz).bitAnd(bitmask));
        }
        throw new UnsupportedOperationException("Only builds with interp_flagsInClassSlot currently supported.");
    }

    public static J9ClassPointer clazz(J9ObjectPointer objPointer) throws CorruptDataException {
        J9ClassPointer classPointer = J9ObjectHelper.checkClassCache(objPointer);
        if (null == classPointer) {
            if (J9BuildFlags.interp_flagsInClassSlot) {
                long bitmask = J9Consts.J9_REQUIRED_CLASS_ALIGNMENT - 1L ^ 0xFFFFFFFFFFFFFFFFL;
                UDATA clazz = UDATA.cast(objPointer.clazz());
                classPointer = J9ClassPointer.cast(clazz.bitAnd(bitmask));
            } else {
                classPointer = objPointer.clazz();
            }
            J9ObjectHelper.setClassCache(objPointer, classPointer);
        }
        return classPointer;
    }

    public static UDATA monitor(J9ObjectPointer objPointer) throws CorruptDataException {
        if (J9BuildFlags.thr_lockNursery) {
            throw new UnsupportedOperationException("lockNursery not supported yet");
        }
        throw new UnsupportedOperationException("need a non-lockNursery blob");
    }

    public static String getClassName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getName(J9ObjectHelper.clazz(objPointer));
    }

    public static String getJavaName(J9ObjectPointer objPointer) throws CorruptDataException {
        return J9ClassHelper.getJavaName(J9ObjectHelper.clazz(objPointer));
    }

    public static String stringValue(J9ObjectPointer objPointer) throws CorruptDataException {
        if (!J9ObjectHelper.getClassName(objPointer).equals("java/lang/String")) {
            throw new IllegalArgumentException();
        }
        J9ObjectPointer charsObject = J9ObjectHelper.getObjectField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "value", "[C"));
        if (charsObject.isNull()) {
            return "<Uninitialized String>";
        }
        J9IndexableObjectPointer charsArray = J9IndexableObjectPointer.cast(charsObject);
        char[] value = (char[])J9IndexableObjectHelper.getData(charsArray);
        int offset = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "offset", "I"));
        int count = J9ObjectHelper.getIntField(objPointer, J9ObjectHelper.getFieldOffset(objPointer, "count", "I"));
        return new String(value, offset, count);
    }

    public static String getStringField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        J9ObjectPointer stringObject = J9ObjectHelper.getObjectField(objPointer, offset);
        if (stringObject.isNull()) {
            return null;
        }
        return J9ObjectHelper.stringValue(stringObject);
    }

    public static int getIntField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I32Pointer pointer = offset.isStatic() ? I32Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : (objPointer instanceof NestedPackedObjectDataPointer ? I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress())) : (J9ObjectHelper.isPacked(objPointer) ? (ObjectModel.isPackedObjectHeader(objPointer) ? (ObjectModel.getTargetObject(objPointer).isNull() ? I32Pointer.cast(ObjectModel.getTargetOffset(objPointer).add(offset.getOffsetOrAddress())) : I32Pointer.cast(ObjectModel.getTargetObject(objPointer).addOffset(ObjectModel.getTargetOffset(objPointer).add(offset.getOffsetOrAddress())))) : I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)))) : I32Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)))));
        return pointer.at(0L).intValue();
    }

    public static short getShortField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (short)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static float getFloatField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        int data = J9ObjectHelper.getIntField(objPointer, offset);
        return Float.intBitsToFloat(data);
    }

    public static double getDoubleField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        long data = J9ObjectHelper.getLongField(objPointer, offset);
        return Double.longBitsToDouble(data);
    }

    public static char getCharField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (char)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFFFF);
    }

    public static byte getByteField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return (byte)(J9ObjectHelper.getIntField(objPointer, offset) & 0xFF);
    }

    public static boolean getBooleanField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        return J9ObjectHelper.getIntField(objPointer, offset) != 0;
    }

    public static long getLongField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        I64Pointer pointer = offset.isStatic() ? I64Pointer.cast(J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress())) : (objPointer instanceof NestedPackedObjectDataPointer ? I64Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress())) : (J9ObjectHelper.isPacked(objPointer) ? (ObjectModel.getTargetObject(objPointer).isNull() ? I64Pointer.cast(ObjectModel.getTargetOffset(objPointer).add(offset.getOffsetOrAddress())) : I64Pointer.cast(ObjectModel.getTargetObject(objPointer).addOffset(ObjectModel.getTargetOffset(objPointer)).addOffset(offset.getOffsetOrAddress()))) : I64Pointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)))));
        return pointer.at(0L).longValue();
    }

    public static J9ObjectPointer getObjectField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        if (offset.isStatic()) {
            UDATAPointer pointer = J9ObjectHelper.clazz(objPointer).ramStatics().addOffset(offset.getOffsetOrAddress());
            return J9ObjectPointer.cast(pointer.at(0L));
        }
        if (objPointer instanceof NestedPackedObjectDataPointer) {
            return ObjectReferencePointer.cast(objPointer.addOffset(offset.getOffsetOrAddress())).at(0L);
        }
        if (J9ObjectHelper.isPacked(objPointer)) {
            if (ObjectModel.isPackedObjectHeader(objPointer)) {
                if (ObjectModel.getTargetObject(objPointer).isNull()) {
                    return ObjectReferencePointer.cast(ObjectModel.getTargetOffset(objPointer).add(offset.getOffsetOrAddress())).at(0L);
                }
                return ObjectReferencePointer.cast(ObjectModel.getTargetObject(objPointer).addOffset(ObjectModel.getTargetOffset(objPointer)).addOffset(offset.getOffsetOrAddress())).at(0L);
            }
            return ObjectReferencePointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer))).at(0L);
        }
        return ObjectReferencePointer.cast(objPointer.addOffset(ObjectModel.getHeaderSize(objPointer)).addOffset(offset.getOffsetOrAddress())).at(0L);
    }

    public static NestedPackedObjectDataPointer getNestedPackedObjectField(J9ObjectPointer objPointer, J9ObjectFieldOffset offset) throws CorruptDataException {
        UDATAPointer pointer;
        if (offset.isStatic()) {
            throw new IllegalArgumentException("A static field cannot be a nested packed field.");
        }
        if (objPointer instanceof NestedPackedObjectDataPointer) {
            pointer = UDATAPointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()));
        } else if (J9ObjectHelper.isPacked(objPointer)) {
            pointer = ObjectModel.isPackedObjectHeader(objPointer) ? (ObjectModel.getTargetObject(objPointer).isNull() ? UDATAPointer.cast(ObjectModel.getTargetOffset(objPointer).add(offset.getOffsetOrAddress())) : UDATAPointer.cast(ObjectModel.getTargetObject(objPointer).addOffset(ObjectModel.getTargetOffset(objPointer)).addOffset(offset.getOffsetOrAddress()))) : UDATAPointer.cast(objPointer.addOffset(offset.getOffsetOrAddress()).addOffset(ObjectModel.getHeaderSize(objPointer)));
        } else {
            throw new IllegalArgumentException("Cannot get a nested packed field from a object that is not packed.");
        }
        return NestedPackedObjectDataPointer.cast(pointer);
    }

    private static J9ObjectFieldOffset getFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ObjectFieldOffset result = J9ClassHelper.checkFieldOffsetCache(J9ObjectHelper.clazz(objPointer), name, signature);
        if (result == null) {
            result = J9ObjectHelper.readFieldOffset(objPointer, name, signature);
            J9ClassHelper.setFieldOffsetCache(J9ObjectHelper.clazz(objPointer), result, name, signature);
        }
        return result;
    }

    private static J9ObjectFieldOffset readFieldOffset(J9ObjectPointer objPointer, String name, String signature) throws CorruptDataException {
        J9ClassPointer currentClass = J9ObjectHelper.clazz(objPointer);
        while (currentClass.notNull()) {
            Iterator<J9ObjectFieldOffset> fields = J9ClassHelper.getFieldOffsets(currentClass);
            while (fields.hasNext()) {
                J9ObjectFieldOffset field = fields.next();
                if (!field.getName().equals(name) || !field.getSignature().equals(signature)) continue;
                return field;
            }
            currentClass = J9ClassHelper.superclass(currentClass);
        }
        throw new NoSuchElementException(String.format("No field named %s with signature %s in %s", name, signature, J9ObjectHelper.getClassName(objPointer)));
    }

    private static J9ClassPointer checkClassCache(J9ObjectPointer objPointer) {
        ++probes;
        for (int i = 0; i < cacheSize; ++i) {
            if (!keys[i].equals(objPointer)) continue;
            ++hits;
            int n = i;
            counts[n] = counts[n] + 1;
            return values[i];
        }
        return null;
    }

    private static void setClassCache(J9ObjectPointer objPointer, J9ClassPointer classPointer) {
        int min = counts[0];
        int minIndex = 0;
        for (int i = 1; i < cacheSize; ++i) {
            if (counts[i] >= min) continue;
            min = counts[i];
            minIndex = i;
        }
        J9ObjectHelper.keys[minIndex] = objPointer;
        J9ObjectHelper.values[minIndex] = classPointer;
        J9ObjectHelper.counts[minIndex] = 1;
    }

    private static void initializeCache() {
        keys = new J9ObjectPointer[cacheSize];
        values = new J9ClassPointer[cacheSize];
        counts = new int[cacheSize];
        probes = 0L;
        hits = 0L;
        for (int i = 0; i < cacheSize; ++i) {
            J9ObjectHelper.keys[i] = J9ObjectPointer.NULL;
        }
    }

    public static void reportClassCacheStats() {
        double hitRate = (double)hits / (double)probes * 100.0;
        System.out.println("J9ObjectHelper probes: " + probes + " hit rate: " + hitRate + "%");
        J9ObjectHelper.initializeCache();
    }

    static {
        J9ObjectHelper.initializeCache();
    }
}

