/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.structure.JNINativeMethod;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=JNINativeMethod.class)
public class JNINativeMethodPointer
extends StructurePointer {
    public static final JNINativeMethodPointer NULL = new JNINativeMethodPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected JNINativeMethodPointer(long address) {
        super(address);
    }

    public static JNINativeMethodPointer cast(AbstractPointer structure) {
        return JNINativeMethodPointer.cast(structure.getAddress());
    }

    public static JNINativeMethodPointer cast(UDATA udata) {
        return JNINativeMethodPointer.cast(udata.longValue());
    }

    public static JNINativeMethodPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new JNINativeMethodPointer(address);
    }

    @Override
    public JNINativeMethodPointer add(long count) {
        return JNINativeMethodPointer.cast(this.address + JNINativeMethod.SIZEOF * count);
    }

    @Override
    public JNINativeMethodPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public JNINativeMethodPointer addOffset(long offset) {
        return JNINativeMethodPointer.cast(this.address + offset);
    }

    @Override
    public JNINativeMethodPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public JNINativeMethodPointer sub(long count) {
        return JNINativeMethodPointer.cast(this.address - JNINativeMethod.SIZEOF * count);
    }

    @Override
    public JNINativeMethodPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public JNINativeMethodPointer subOffset(long offset) {
        return JNINativeMethodPointer.cast(this.address - offset);
    }

    @Override
    public JNINativeMethodPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public JNINativeMethodPointer untag(long mask) {
        return JNINativeMethodPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public JNINativeMethodPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return JNINativeMethod.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_fnPtrOffset_", declaredType="void*")
    public VoidPointer fnPtr() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(JNINativeMethod._fnPtrOffset_));
    }

    public PointerPointer fnPtrEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)JNINativeMethod._fnPtrOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="char*")
    public U8Pointer name() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(JNINativeMethod._nameOffset_));
    }

    public PointerPointer nameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)JNINativeMethod._nameOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_signatureOffset_", declaredType="char*")
    public U8Pointer signature() throws CorruptDataException {
        return U8Pointer.cast(this.getPointerAtOffset(JNINativeMethod._signatureOffset_));
    }

    public PointerPointer signatureEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)JNINativeMethod._signatureOffset_);
    }
}

