/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U16Pointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.structure.AttachedDataWrapper;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.U16;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=AttachedDataWrapper.class)
public class AttachedDataWrapperPointer
extends StructurePointer {
    public static final AttachedDataWrapperPointer NULL = new AttachedDataWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected AttachedDataWrapperPointer(long address) {
        super(address);
    }

    public static AttachedDataWrapperPointer cast(AbstractPointer structure) {
        return AttachedDataWrapperPointer.cast(structure.getAddress());
    }

    public static AttachedDataWrapperPointer cast(UDATA udata) {
        return AttachedDataWrapperPointer.cast(udata.longValue());
    }

    public static AttachedDataWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new AttachedDataWrapperPointer(address);
    }

    @Override
    public AttachedDataWrapperPointer add(long count) {
        return AttachedDataWrapperPointer.cast(this.address + AttachedDataWrapper.SIZEOF * count);
    }

    @Override
    public AttachedDataWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public AttachedDataWrapperPointer addOffset(long offset) {
        return AttachedDataWrapperPointer.cast(this.address + offset);
    }

    @Override
    public AttachedDataWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public AttachedDataWrapperPointer sub(long count) {
        return AttachedDataWrapperPointer.cast(this.address - AttachedDataWrapper.SIZEOF * count);
    }

    @Override
    public AttachedDataWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public AttachedDataWrapperPointer subOffset(long offset) {
        return AttachedDataWrapperPointer.cast(this.address - offset);
    }

    @Override
    public AttachedDataWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public AttachedDataWrapperPointer untag(long mask) {
        return AttachedDataWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public AttachedDataWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return AttachedDataWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_cacheOffsetOffset_", declaredType="J9SRP")
    public VoidPointer cacheOffset() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long nextAddress = this.getIntAtOffset(AttachedDataWrapper._cacheOffsetOffset_);
        if (nextAddress == 0L) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.address + ((long)AttachedDataWrapper._cacheOffsetOffset_ + nextAddress));
    }

    public SelfRelativePointer cacheOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return SelfRelativePointer.cast(this.address + (long)AttachedDataWrapper._cacheOffsetOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_corruptOffset_", declaredType="I32")
    public I32 corrupt() throws CorruptDataException {
        return new I32(this.getIntAtOffset(AttachedDataWrapper._corruptOffset_));
    }

    public I32Pointer corruptEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)AttachedDataWrapper._corruptOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
    public U32 dataLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(AttachedDataWrapper._dataLengthOffset_));
    }

    public U32Pointer dataLengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)AttachedDataWrapper._dataLengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_typeOffset_", declaredType="U16")
    public U16 type() throws CorruptDataException {
        return new U16(this.getShortAtOffset(AttachedDataWrapper._typeOffset_));
    }

    public U16Pointer typeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)AttachedDataWrapper._typeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_updateCountOffset_", declaredType="U16")
    public U16 updateCount() throws CorruptDataException {
        return new U16(this.getShortAtOffset(AttachedDataWrapper._updateCountOffset_));
    }

    public U16Pointer updateCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)AttachedDataWrapper._updateCountOffset_);
    }
}

