/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.NoSuchElementException;

public class GCClassSuperclassesIterator
extends GCIterator {
    protected PointerPointer superclasses;
    protected UDATA classDepth;
    protected UDATA index;

    protected GCClassSuperclassesIterator(J9ClassPointer clazz) throws CorruptDataException {
        this.superclasses = clazz.superclasses();
        this.classDepth = J9ClassHelper.classDepth(clazz);
        this.index = new UDATA(0L);
    }

    public static GCClassSuperclassesIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassSuperclassesIterator(clazz);
    }

    @Override
    public boolean hasNext() {
        if (this.classDepth.eq(0L)) {
            return false;
        }
        return this.index.lt(this.classDepth);
    }

    @Override
    public J9ClassPointer next() {
        if (this.hasNext()) {
            try {
                J9ClassPointer next = J9ClassPointer.cast(this.superclasses.at(this.index));
                this.index = this.index.add(1L);
                return next;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                return null;
            }
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            VoidPointer next = VoidPointer.cast(this.superclasses.add(this.index));
            this.index = this.index.add(1L);
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

