/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.walkers.ROMClassesIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.RomClassWalker;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class AnalyseRomClassUTF8Command
extends Command {
    public AnalyseRomClassUTF8Command() {
        this.addCommand("analyseromClassutf8", "[WeightList] [maxDistribution%]", "Analyze ROM Class UTF8 distribution (max defaults to 85)");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            boolean printUTF8WeightList = false;
            int maxDistributionPercent = 85;
            if (args.length >= 1 && args[0].equals("UTF8WeightList")) {
                printUTF8WeightList = true;
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].endsWith("%")) continue;
                try {
                    maxDistributionPercent = DecimalFormat.getInstance().parse(args[i]).intValue();
                    continue;
                }
                catch (ParseException e) {
                    out.println("Usage: !analyseromClassutf8 [UTF8WeightList] [maxDistribution%]\t\tmaxDistribution defaults to 85%");
                }
            }
            Statistics statistics = new Statistics();
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            ROMClassesIterator classSegmentIterator = new ROMClassesIterator(out, vm.classMemorySegments());
            J9ObjectPointer bootstraploader = vm.systemClassLoader().classLoaderObject();
            while (classSegmentIterator.hasNext()) {
                J9ROMClassPointer classPointer = classSegmentIterator.next();
                RomClassWalker classWalker = new RomClassWalker(classPointer, context);
                LinearDumper linearDumper = new LinearDumper();
                LinearDumper.J9ClassRegionNode allRegionsNode = linearDumper.getAllRegions(classWalker);
                statistics.add(allRegionsNode, classSegmentIterator, bootstraploader);
            }
            statistics.getResult(printUTF8WeightList, maxDistributionPercent, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private class Statistics {
        LinkedHashMap<String, Long[]> utf8global = new LinkedHashMap();
        LinkedHashMap<String, Long[]> utf8classloader = new LinkedHashMap();
        LinkedHashMap<String, Long[]> utf8bootstraploader = new LinkedHashMap();

        private Statistics() {
        }

        void add(LinearDumper.J9ClassRegionNode allRegionsNode, ROMClassesIterator classSegmentIterator, J9ObjectPointer bootstraploader) throws CorruptDataException {
            this.addRecursive(allRegionsNode, classSegmentIterator, bootstraploader, null);
        }

        void addRecursive(LinearDumper.J9ClassRegionNode allRegionsNode, ROMClassesIterator classSegmentIterator, J9ObjectPointer bootstraploader, String parent) throws CorruptDataException {
            LinearDumper.J9ClassRegion nodeValue = allRegionsNode.getNodeValue();
            String name = null;
            if (nodeValue != null) {
                name = nodeValue.getName();
                if (nodeValue.getType() == IClassWalkCallbacks.SlotType.J9_ROM_UTF8 && parent != null && parent.equals("UTF8")) {
                    long length = nodeValue.getLength();
                    String csectionName = J9UTF8Helper.stringValue(J9UTF8Pointer.cast(nodeValue.getSlotPtr()));
                    Long[] cpsavedSize = this.utf8global.get(csectionName);
                    long sizet = 0L;
                    long dup = 1L;
                    if (cpsavedSize == null) {
                        sizet = new Long(length);
                    } else {
                        sizet = new Long(length) + cpsavedSize[0];
                        dup += cpsavedSize[1].longValue();
                    }
                    this.utf8global.put(csectionName, new Long[]{sizet, dup});
                    J9ClassLoaderPointer cloader = classSegmentIterator.getMemorySegmentPointer().classLoader();
                    if (!cloader.classLoaderObject().equals(bootstraploader)) {
                        dup = 1L;
                        String key = csectionName + "-" + cloader;
                        cpsavedSize = this.utf8classloader.get(key);
                        if (cpsavedSize == null) {
                            sizet = new Long(length);
                        } else {
                            sizet = new Long(length) + cpsavedSize[0];
                            dup += cpsavedSize[1].longValue();
                        }
                        this.utf8classloader.put(key, new Long[]{sizet, dup});
                    } else {
                        dup = 1L;
                        cpsavedSize = this.utf8bootstraploader.get(csectionName);
                        if (cpsavedSize == null) {
                            sizet = new Long(length);
                        } else {
                            sizet = new Long(length) + cpsavedSize[0];
                            dup += cpsavedSize[1].longValue();
                        }
                        this.utf8bootstraploader.put(csectionName, new Long[]{sizet, dup});
                    }
                }
            }
            for (LinearDumper.J9ClassRegionNode classRegionNode : allRegionsNode.getChildren()) {
                String childName = classRegionNode.getNodeValue().getName();
                if (nodeValue != null && (name == null || !name.equals("UTF8")) && (childName == null || !childName.equals("UTF8"))) continue;
                this.addRecursive(classRegionNode, classSegmentIterator, bootstraploader, name);
            }
        }

        public void getResult(boolean printUTF8WeightList, int maxDistributionPercent, PrintStream out) {
            long l;
            long ucount;
            long usize;
            long dcount;
            long dsize;
            TreeMap<Long, TreeSet<String>> outputmap;
            TreeMap<Long, Long[]> distrmap;
            if (!this.utf8global.isEmpty()) {
                out.println();
                distrmap = new TreeMap<Long, Long[]>();
                outputmap = new TreeMap<Long, TreeSet<String>>();
                dsize = 0L;
                dcount = 0L;
                usize = 0L;
                ucount = 0L;
                for (Map.Entry<String, Long[]> entry : this.utf8global.entrySet()) {
                    if (entry.getValue()[1] == 1L) {
                        ++ucount;
                        usize += entry.getValue()[0].longValue();
                        continue;
                    }
                    ++dcount;
                    dsize += entry.getValue()[0].longValue();
                    l = entry.getValue()[1];
                    Long[] nodecountsize = (Long[])distrmap.get(l);
                    long l2 = 0L;
                    long nodecount = 1L;
                    if (nodecountsize == null) {
                        l2 = new Long(entry.getValue()[0]);
                    } else {
                        l2 = new Long(entry.getValue()[0]) + (Long)nodecountsize[1];
                        nodecount += ((Long)nodecountsize[0]).longValue();
                    }
                    distrmap.put(l, new Long[]{nodecount, l2});
                    TreeSet<String> cu = (TreeSet<String>)outputmap.get(l);
                    if (cu != null) {
                        cu.add(entry.getKey());
                    } else {
                        cu = new TreeSet<String>();
                        cu.add(entry.getKey());
                    }
                    outputmap.put(l, cu);
                }
                out.println("<Global Unique UTF-8 (count, total size)>");
                out.println(ucount + ", " + usize / 1024L + "K");
                out.println("\n<Global Duplicated UTF-8 (count, total size)>");
                out.println(dcount + ", " + dsize / 1024L + "K");
                out.println();
                out.println("<Distribution of Global Duplicated UTF-8>");
                out.println("(duplicated times, # UTF-8s, total size)");
                long listshowsize = 0L;
                l = 0L;
                for (Map.Entry entry : distrmap.entrySet()) {
                    out.println(entry.getKey() + ", " + ((Long[])entry.getValue())[0] + ", " + (((Long[])entry.getValue())[1] == 0L ? "0K" : (((Long[])entry.getValue())[1] / 1024L < 1L ? "<1K" : ((Long[])entry.getValue())[1] / 1024L + "K")));
                    listshowsize += ((Long[])entry.getValue())[1].longValue();
                    l += ((Long[])entry.getValue())[0].longValue();
                    if (!((double)listshowsize / (double)dsize * 100.0 > (double)maxDistributionPercent)) continue;
                    out.println((Long)entry.getKey() + 1L + "+, " + (dcount - l) + ", " + (dsize - listshowsize) / 1024L + "K");
                    break;
                }
                if (printUTF8WeightList) {
                    out.println("<Global Duplicated UTF-8s>");
                    out.println("      times");
                    out.println("id    duplicated  weight string");
                    for (Map.Entry entry : outputmap.entrySet()) {
                        Long timesDuplicated = (Long)entry.getKey();
                        int count = 0;
                        for (String string : (TreeSet)entry.getValue()) {
                            long weight = (timesDuplicated - 1L) * (long)string.length();
                            out.println(String.format("%-5d %-11d %-5d \"%s\"", count++, timesDuplicated, weight, string));
                        }
                    }
                }
            }
            if (!this.utf8classloader.isEmpty()) {
                long diskey;
                out.println();
                distrmap = new TreeMap();
                outputmap = new TreeMap();
                dsize = 0L;
                dcount = 0L;
                usize = 0L;
                ucount = 0L;
                Iterator<Map.Entry<String, Long[]>> it = this.utf8classloader.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Long[]> entry = it.next();
                    l = entry.getValue()[1];
                    long allsize = entry.getValue()[0];
                    String utf8 = entry.getKey().split("-")[0];
                    Long[] bootstraputf8 = this.utf8bootstraploader.get(utf8);
                    if (bootstraputf8 == null) continue;
                    Object object = bootstraputf8;
                    Long.valueOf(object[0] + allsize);
                    object = bootstraputf8;
                    Long.valueOf(object[1] + l);
                    it.remove();
                }
                for (Map.Entry<String, Long[]> entry : this.utf8bootstraploader.entrySet()) {
                    if (entry.getValue()[1] == 1L) {
                        ++ucount;
                        usize += entry.getValue()[0].longValue();
                        continue;
                    }
                    ++dcount;
                    dsize += entry.getValue()[0].longValue();
                    diskey = entry.getValue()[1];
                    Long[] longArray = (Long[])distrmap.get(diskey);
                    long nodesize = 0L;
                    long nodecount = 1L;
                    if (longArray == null) {
                        nodesize = new Long(entry.getValue()[0]);
                    } else {
                        nodesize = new Long(entry.getValue()[0]) + longArray[1];
                        nodecount += longArray[0].longValue();
                    }
                    distrmap.put(diskey, new Long[]{nodecount, nodesize});
                    TreeSet<String> cu = (TreeSet<String>)outputmap.get(diskey);
                    if (cu != null) {
                        cu.add(entry.getKey());
                    } else {
                        cu = new TreeSet<String>();
                        cu.add(entry.getKey());
                    }
                    outputmap.put(diskey, cu);
                }
                for (Map.Entry<String, Long[]> entry : this.utf8classloader.entrySet()) {
                    if (entry.getValue()[1] == 1L) {
                        ++ucount;
                        usize += entry.getValue()[0].longValue();
                        continue;
                    }
                    ++dcount;
                    dsize += entry.getValue()[0].longValue();
                    diskey = entry.getValue()[1];
                    Long[] longArray = (Long[])distrmap.get(diskey);
                    long nodesize = 0L;
                    long nodecount = 1L;
                    if (longArray == null) {
                        nodesize = new Long(entry.getValue()[0]);
                    } else {
                        nodesize = new Long(entry.getValue()[0]) + longArray[1];
                        nodecount += longArray[0].longValue();
                    }
                    distrmap.put(diskey, new Long[]{nodecount, nodesize});
                    TreeSet<String> cu = (TreeSet<String>)outputmap.get(diskey);
                    if (cu != null) {
                        cu.add(entry.getKey());
                    } else {
                        cu = new TreeSet<String>();
                        cu.add(entry.getKey());
                    }
                    outputmap.put(diskey, cu);
                }
                out.println("<Classloader Unique UTF-8 (count, total size)>");
                out.println(ucount + ", " + usize / 1024L + "K");
                out.println("\n<Classloader Duplicated UTF-8 (count, total size)>");
                out.println(dcount + ", " + dsize / 1024L + "K");
                out.println();
                out.println("<Distribution of Classloader Duplicated UTF-8>");
                out.println("(duplicated times, # UTF-8s, total size)");
                long l3 = 0L;
                long listshowcount = 0L;
                for (Map.Entry entry : distrmap.entrySet()) {
                    out.println(entry.getKey() + ", " + ((Long[])entry.getValue())[0] + ", " + (((Long[])entry.getValue())[1] == 0L ? "0K" : (((Long[])entry.getValue())[1] / 1024L < 1L ? "<1K" : ((Long[])entry.getValue())[1] / 1024L + "K")));
                    l3 += ((Long[])entry.getValue())[1].longValue();
                    listshowcount += ((Long[])entry.getValue())[0].longValue();
                    if (!((double)l3 / (double)dsize * 100.0 > (double)maxDistributionPercent)) continue;
                    out.println((Long)entry.getKey() + 1L + "+, " + (dcount - listshowcount) + ", " + (dsize - l3) / 1024L + "K");
                    break;
                }
                if (printUTF8WeightList) {
                    out.println("<Duplicated UTF-8s by Classloader>");
                    out.println("      times");
                    out.println("id    duplicated  weight string");
                    for (Map.Entry entry : outputmap.entrySet()) {
                        Long timesDuplicated = (Long)entry.getKey();
                        int count = 0;
                        for (String string : (TreeSet)entry.getValue()) {
                            long weight = (timesDuplicated - 1L) * (long)string.length();
                            out.println(String.format("%-5d %-11d %-5d \"%s\"", count++, timesDuplicated, weight, string));
                        }
                    }
                }
            }
        }
    }
}

