/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.ObjectClassReferencePointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.structure.J9Object;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=J9Object.class)
public class J9ObjectPointer
extends StructurePointer {
    public static final J9ObjectPointer NULL = new J9ObjectPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9ObjectPointer(long address) {
        super(address);
    }

    public static J9ObjectPointer cast(AbstractPointer structure) {
        return J9ObjectPointer.cast(structure.getAddress());
    }

    public static J9ObjectPointer cast(UDATA udata) {
        return J9ObjectPointer.cast(udata.longValue());
    }

    public static J9ObjectPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ObjectPointer(address);
    }

    @Override
    public J9ObjectPointer add(long count) {
        return J9ObjectPointer.cast(this.address + J9Object.SIZEOF * count);
    }

    @Override
    public J9ObjectPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9ObjectPointer addOffset(long offset) {
        return J9ObjectPointer.cast(this.address + offset);
    }

    @Override
    public J9ObjectPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ObjectPointer sub(long count) {
        return J9ObjectPointer.cast(this.address - J9Object.SIZEOF * count);
    }

    @Override
    public J9ObjectPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9ObjectPointer subOffset(long offset) {
        return J9ObjectPointer.cast(this.address - offset);
    }

    @Override
    public J9ObjectPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9ObjectPointer untag(long mask) {
        return J9ObjectPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9ObjectPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Object.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_clazzOffset_", declaredType="j9objectclass_t")
    public J9ClassPointer clazz() throws CorruptDataException {
        return this.getObjectClassAtOffset(J9Object._clazzOffset_);
    }

    public ObjectClassReferencePointer clazzEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return ObjectClassReferencePointer.cast(this.address + (long)J9Object._clazzOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
    public U32 flags() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Object._flagsOffset_));
    }

    public U32Pointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9Object._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_lastSamplePhaseOffset_", declaredType="U32")
    public U32 lastSamplePhase() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Object._lastSamplePhaseOffset_));
    }

    public U32Pointer lastSamplePhaseEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9Object._lastSamplePhaseOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_paddingOffset_", declaredType="U32")
    public U32 padding() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Object._paddingOffset_));
    }

    public U32Pointer paddingEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9Object._paddingOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_popularityCountOffset_", declaredType="U32")
    public U32 popularityCount() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9Object._popularityCountOffset_));
    }

    public U32Pointer popularityCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9Object._popularityCountOffset_);
    }
}

