/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.pointer.UDATAPointer;
import com.ibm.j9ddr.vm26.structure.J9Component;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=J9Component.class)
public class J9ComponentPointer
extends StructurePointer {
    public static final J9ComponentPointer NULL = new J9ComponentPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9ComponentPointer(long address) {
        super(address);
    }

    public static J9ComponentPointer cast(AbstractPointer structure) {
        return J9ComponentPointer.cast(structure.getAddress());
    }

    public static J9ComponentPointer cast(UDATA udata) {
        return J9ComponentPointer.cast(udata.longValue());
    }

    public static J9ComponentPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ComponentPointer(address);
    }

    @Override
    public J9ComponentPointer add(long count) {
        return J9ComponentPointer.cast(this.address + J9Component.SIZEOF * count);
    }

    @Override
    public J9ComponentPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9ComponentPointer addOffset(long offset) {
        return J9ComponentPointer.cast(this.address + offset);
    }

    @Override
    public J9ComponentPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9ComponentPointer sub(long count) {
        return J9ComponentPointer.cast(this.address - J9Component.SIZEOF * count);
    }

    @Override
    public J9ComponentPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9ComponentPointer subOffset(long offset) {
        return J9ComponentPointer.cast(this.address - offset);
    }

    @Override
    public J9ComponentPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9ComponentPointer untag(long mask) {
        return J9ComponentPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9ComponentPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9Component.SIZEOF;
    }

    public U8Pointer nameEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)J9Component._nameOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_relocationCountOffset_", declaredType="UDATA")
    public UDATA relocationCount() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Component._relocationCountOffset_));
    }

    public UDATAPointer relocationCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Component._relocationCountOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_reserved1Offset_", declaredType="UDATA")
    public UDATA reserved1() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Component._reserved1Offset_));
    }

    public UDATAPointer reserved1EA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Component._reserved1Offset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_segmentCountOffset_", declaredType="UDATA")
    public UDATA segmentCount() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Component._segmentCountOffset_));
    }

    public UDATAPointer segmentCountEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Component._segmentCountOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_timeStampOffset_", declaredType="UDATA")
    public UDATA timeStamp() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9Component._timeStampOffset_));
    }

    public UDATAPointer timeStampEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9Component._timeStampOffset_);
    }
}

