/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.I32Pointer;
import com.ibm.j9ddr.vm26.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.structure.CharArrayWrapper;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=CharArrayWrapper.class)
public class CharArrayWrapperPointer
extends StructurePointer {
    public static final CharArrayWrapperPointer NULL = new CharArrayWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected CharArrayWrapperPointer(long address) {
        super(address);
    }

    public static CharArrayWrapperPointer cast(AbstractPointer structure) {
        return CharArrayWrapperPointer.cast(structure.getAddress());
    }

    public static CharArrayWrapperPointer cast(UDATA udata) {
        return CharArrayWrapperPointer.cast(udata.longValue());
    }

    public static CharArrayWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new CharArrayWrapperPointer(address);
    }

    @Override
    public CharArrayWrapperPointer add(long count) {
        return CharArrayWrapperPointer.cast(this.address + CharArrayWrapper.SIZEOF * count);
    }

    @Override
    public CharArrayWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public CharArrayWrapperPointer addOffset(long offset) {
        return CharArrayWrapperPointer.cast(this.address + offset);
    }

    @Override
    public CharArrayWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public CharArrayWrapperPointer sub(long count) {
        return CharArrayWrapperPointer.cast(this.address - CharArrayWrapper.SIZEOF * count);
    }

    @Override
    public CharArrayWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public CharArrayWrapperPointer subOffset(long offset) {
        return CharArrayWrapperPointer.cast(this.address - offset);
    }

    @Override
    public CharArrayWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public CharArrayWrapperPointer untag(long mask) {
        return CharArrayWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public CharArrayWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return CharArrayWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_objectSizeOffset_", declaredType="U32")
    public U32 objectSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(CharArrayWrapper._objectSizeOffset_));
    }

    public U32Pointer objectSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)CharArrayWrapper._objectSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romStringOffsetOffset_", declaredType="I32")
    public I32 romStringOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(CharArrayWrapper._romStringOffsetOffset_));
    }

    public I32Pointer romStringOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)CharArrayWrapper._romStringOffsetOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_romStringOffsetOffset_", declaredType="J9SRP")
    public VoidPointer romStringOffset_v1() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long nextAddress = this.getIntAtOffset(CharArrayWrapper._romStringOffsetOffset_);
        if (nextAddress == 0L) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.address + ((long)CharArrayWrapper._romStringOffsetOffset_ + nextAddress));
    }

    public SelfRelativePointer romStringOffset_v1EA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return SelfRelativePointer.cast(this.address + (long)CharArrayWrapper._romStringOffsetOffset_);
    }
}

