/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.walkers;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<StructType extends DataType>
implements Iterator<StructType> {
    private final int total;
    private int current = 0;
    private PointerPointer node = null;
    protected Class<StructType> structType;
    private long address = 0L;

    public <T extends DataType> ArrayIterator(Class<T> structType, int total, PointerPointer nodes) throws CorruptDataException {
        this.structType = structType;
        this.total = total;
        if (total > 0) {
            this.node = nodes;
            this.address = this.node.at(0L).getAddress();
            this.setNextItem();
        }
    }

    public Iterator<StructType> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.total;
    }

    @Override
    public StructType next() {
        if (this.hasNext()) {
            try {
                DataType ptr = (DataType)DataType.getStructure(this.structType, this.address);
                this.address = 0L;
                this.setNextItem();
                return (StructType)ptr;
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next item", e, true);
                return null;
            }
        }
        throw new NoSuchElementException();
    }

    private void setNextItem() throws CorruptDataException {
        while (this.current < this.total && this.address == 0L) {
            this.node = this.node.add(1L);
            ++this.current;
            this.address = this.node.at(0L).getAddress();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

