/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm26.j9.gc.GCIterator;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.GC_FinalizeListManagerPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import java.util.NoSuchElementException;

public class GCFinalizableObjectIterator
extends GCIterator {
    public static final int state_start = 0;
    public static final int state_system = 1;
    public static final int state_default = 2;
    public static final int state_reference = 3;
    public static final int state_end = 4;
    protected int _state = 0;
    protected J9ObjectPointer _currentSystemObject;
    protected J9ObjectPointer _currentDefaultObject;
    protected J9ObjectPointer _currentReferenceObject;

    protected GCFinalizableObjectIterator(GC_FinalizeListManagerPointer manager) throws CorruptDataException {
        this._currentSystemObject = manager._systemFinalizableObjects();
        this._currentDefaultObject = manager._defaultFinalizableObjects();
        this._currentReferenceObject = manager._referenceObjects();
    }

    public static GCFinalizableObjectIterator from() throws CorruptDataException {
        return new GCFinalizableObjectIterator(GCFinalizableObjectIterator.getExtensions().finalizeListManager());
    }

    @Override
    public boolean hasNext() {
        if (this._state == 4) {
            return false;
        }
        switch (this._state) {
            case 0: {
                ++this._state;
            }
            case 1: {
                if (this._currentSystemObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 2: {
                if (this._currentDefaultObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
            case 3: {
                if (this._currentReferenceObject.notNull()) {
                    return true;
                }
                ++this._state;
            }
        }
        return false;
    }

    @Override
    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                J9ObjectPointer result = J9ObjectPointer.NULL;
                switch (this._state) {
                    case 1: {
                        result = this._currentSystemObject;
                        this._currentSystemObject = ObjectAccessBarrier.getFinalizeLink(this._currentSystemObject);
                        break;
                    }
                    case 2: {
                        result = this._currentDefaultObject;
                        this._currentDefaultObject = ObjectAccessBarrier.getFinalizeLink(this._currentDefaultObject);
                        break;
                    }
                    case 3: {
                        result = this._currentReferenceObject;
                        this._currentReferenceObject = ObjectAccessBarrier.getReferenceLink(this._currentReferenceObject);
                    }
                }
                return result;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            if (this._state < 4) {
                ++this._state;
            }
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }

    public int getState() {
        return this._state;
    }
}

