/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.view.dtfj.java;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.DTFJCorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm24.events.EventManager;
import com.ibm.j9ddr.vm24.j9.Pool;
import com.ibm.j9ddr.vm24.j9.RootScanner;
import com.ibm.j9ddr.vm24.j9.SlotIterator;
import com.ibm.j9ddr.vm24.j9.walkers.ClassLoaderIterator;
import com.ibm.j9ddr.vm24.j9.walkers.ThreadListIterator;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.GC_FinalizerJobPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9DebuggerReferencePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JITConfigPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySpacePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9JITConfig;
import com.ibm.j9ddr.vm24.structure.J9JavaVM;
import com.ibm.j9ddr.vm24.types.UDATA;
import com.ibm.j9ddr.vm24.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaClassloader;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaHeap;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaReference;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaThread;
import com.ibm.j9ddr.vm24.view.dtfj.java.DTFJJavaVMInitArgs;
import com.ibm.j9ddr.vm24.view.dtfj.java.corrupt.AddCorruptionToListListener;
import com.ibm.j9ddr.vm24.view.dtfj.java.j9.DTFJMonitorIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class DTFJJavaRuntime
implements JavaRuntime {
    private Properties systemProperties;
    private List<Object> references;
    private LinkedList<Object> classLoaders = null;
    private final DTFJJavaVMInitArgs vminitargs = new DTFJJavaVMInitArgs();
    private List<Object> compiledMethods = null;

    public boolean equals(Object other) {
        if (!(other instanceof JavaRuntime)) {
            return false;
        }
        try {
            return this.getJavaVM().equals((Object)((JavaRuntime)other).getJavaVM());
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getJavaVM().hashCode();
        }
        catch (com.ibm.dtfj.image.CorruptDataException e) {
            return 0;
        }
    }

    public Iterator getCompiledMethods() {
        if (this.compiledMethods == null) {
            this.compiledMethods = new ArrayList<Object>();
            Iterator classLoaderIterators = this.getJavaClassLoaders();
            while (classLoaderIterators.hasNext()) {
                Object classLoaderObj = classLoaderIterators.next();
                if (classLoaderObj instanceof CorruptData) {
                    this.compiledMethods.add(classLoaderObj);
                    continue;
                }
                Iterator classesIterator = ((JavaClassLoader)classLoaderObj).getDefinedClasses();
                while (classesIterator.hasNext()) {
                    Object classObject = classesIterator.next();
                    if (classObject instanceof CorruptData) {
                        this.compiledMethods.add(classObject);
                        continue;
                    }
                    Iterator methodsIterator = ((JavaClass)classObject).getDeclaredMethods();
                    while (methodsIterator.hasNext()) {
                        Object methodObj = methodsIterator.next();
                        if (methodObj instanceof CorruptData) {
                            this.compiledMethods.add(methodObj);
                        }
                        if (!((JavaMethod)methodObj).getCompiledSections().hasNext()) continue;
                        this.compiledMethods.add(methodObj);
                    }
                }
            }
        }
        return this.compiledMethods.iterator();
    }

    public Iterator getHeapRoots() {
        if (null == this.references) {
            this.scanReferences();
        }
        return this.references.iterator();
    }

    public boolean isJITEnabled() throws com.ibm.dtfj.image.CorruptDataException {
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            return jitConfig.notNull() && jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    public Properties getJITProperties() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        Properties properties = new Properties();
        try {
            J9JITConfigPointer jitConfig = DTFJContext.getVm().jitConfig();
            if (jitConfig.notNull()) {
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_JIT_ATTACHED)) {
                    properties.setProperty("JIT", "enabled");
                } else {
                    properties.setProperty("JIT", "disabled");
                }
                if (jitConfig.runtimeFlags().allBitsIn(J9JITConfig.J9JIT_AOT_ATTACHED)) {
                    properties.setProperty("AOT", "enabled");
                } else {
                    properties.setProperty("AOT", "disabled");
                }
                if (!jitConfig.fsdEnabled().eq(new UDATA(0L))) {
                    properties.setProperty("FSD", "enabled");
                } else {
                    properties.setProperty("FSD", "disabled");
                }
                if (DTFJContext.getVm().requiredDebugAttributes().allBitsIn(J9JavaVM.J9VM_DEBUG_ATTRIBUTE_CAN_REDEFINE_CLASSES)) {
                    properties.setProperty("HCR", "enabled");
                } else {
                    properties.setProperty("HCR", "disabled");
                }
            } else {
                throw new DataUnavailable("JIT not enabled");
            }
            return properties;
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
    }

    private void scanReferences() {
        this.references = new LinkedList<Object>();
        try {
            DTFJRootScanner scanner = new DTFJRootScanner();
            scanner.scanAllSlots();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.references.add(cd);
        }
    }

    public Iterator getHeaps() {
        try {
            LinkedList<DTFJJavaHeap> heaps = new LinkedList<DTFJJavaHeap>();
            J9MemorySpacePointer defaultJ9MemorySpace = DTFJContext.getVm().defaultMemorySpace();
            if (J9BuildFlags.ive_memorySpaceHelpers) {
                SlotIterator<J9MemorySpacePointer> memorySpaceIterator = Pool.fromJ9Pool(DTFJContext.getVm().memorySpaceList(), J9MemorySpacePointer.class).iterator();
                while (memorySpaceIterator.hasNext()) {
                    J9MemorySpacePointer j9MemorySpace = (J9MemorySpacePointer)memorySpaceIterator.next();
                    if (j9MemorySpace.equals(defaultJ9MemorySpace)) {
                        heaps.add(new DTFJJavaHeap(j9MemorySpace, "Default"));
                        continue;
                    }
                    heaps.add(new DTFJJavaHeap(j9MemorySpace, "Other"));
                }
            } else {
                heaps.add(new DTFJJavaHeap(defaultJ9MemorySpace, "Default"));
            }
            if (J9BuildFlags.opt_sharedClasses && J9BuildFlags.opt_zero && DTFJContext.getVm().sharedClassConfig().notNull() && DTFJContext.getVm().zeroOptions().anyBitsIn(J9JavaVM.J9VM_ZERO_SHARESTRINGS)) {
                throw new UnsupportedOperationException("no support for string sharing yet");
            }
            return heaps.iterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public Iterator getJavaClassLoaders() {
        if (this.classLoaders != null) {
            return this.classLoaders.iterator();
        }
        this.classLoaders = new LinkedList();
        try {
            ClassLoaderIterator classLoaderIterator = ClassLoaderIterator.from();
            while (classLoaderIterator.hasNext()) {
                this.classLoaders.add(new DTFJJavaClassloader(classLoaderIterator.next()));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            this.classLoaders.add(cd);
        }
        return this.classLoaders.iterator();
    }

    public ImagePointer getJavaVM() throws com.ibm.dtfj.image.CorruptDataException {
        return DTFJContext.getImagePointer(DTFJContext.getVm().getAddress());
    }

    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        return this.vminitargs;
    }

    public Iterator getMonitors() {
        try {
            return new DTFJMonitorIterator();
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            return J9DDRDTFJUtils.corruptIterator(cd);
        }
    }

    public JavaObject getObjectAtAddress(ImagePointer address) throws com.ibm.dtfj.image.CorruptDataException, IllegalArgumentException, MemoryAccessException, DataUnavailable {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(address.getAddress());
            if (object.anyBitsIn(J9Consts.J9_GC_OBJECT_ALIGNMENT_IN_BYTES - 1L)) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + address);
            }
            DTFJJavaHeap heap = this.getHeapFromAddress(address);
            if (null != heap) {
                return new DTFJJavaObject(heap, object);
            }
            throw new IllegalArgumentException("Object address " + address + " is not in any heap");
        }
        catch (Throwable t) {
            Class[] whitelist = new Class[]{IllegalArgumentException.class};
            throw J9DDRDTFJUtils.handleAllButMemAccExAndDataUnavailAsCorruptDataException(DTFJContext.getProcess(), t, whitelist);
        }
    }

    public DTFJJavaHeap getHeapFromAddress(ImagePointer address) {
        try {
            VoidPointer pointer = VoidPointer.cast(address.getAddress());
            Iterator heapsIterator = this.getHeaps();
            while (heapsIterator.hasNext()) {
                DTFJJavaHeap heap = (DTFJJavaHeap)heapsIterator.next();
                Iterator sectionsIterator = heap.getSections();
                while (sectionsIterator.hasNext()) {
                    ImageSection section = (ImageSection)sectionsIterator.next();
                    VoidPointer base = VoidPointer.cast(section.getBaseAddress().getAddress());
                    VoidPointer top = base.addOffset(section.getSize());
                    if (!pointer.gte(base) || !pointer.lt(top)) continue;
                    return heap;
                }
            }
        }
        catch (Throwable t) {
            J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        return null;
    }

    public Iterator getThreads() {
        LinkedList<Object> toIterate = new LinkedList<Object>();
        AddCorruptionToListListener listener = new AddCorruptionToListListener(toIterate);
        EventManager.register(listener);
        try {
            ThreadListIterator threadIterator = ThreadListIterator.from();
            while (threadIterator.hasNext() && !listener.fatalCorruption()) {
                toIterate.add(new DTFJJavaThread(threadIterator.next()));
            }
        }
        catch (Throwable t) {
            CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
            toIterate.add(cd);
        }
        EventManager.unregister(listener);
        return toIterate.iterator();
    }

    public Object getTraceBuffer(String bufferName, boolean formatted) throws com.ibm.dtfj.image.CorruptDataException {
        return new J9DDRCorruptData(DTFJContext.getProcess(), "Trace buffers are not available");
    }

    public String getFullVersion() throws com.ibm.dtfj.image.CorruptDataException {
        return this.getVersion();
    }

    public String getVersion() throws com.ibm.dtfj.image.CorruptDataException {
        String javaFullVersion = this.getRequiredSystemProperty("java.fullversion");
        String javaRuntimeVersion = this.getRequiredSystemProperty("java.runtime.version");
        String javaRuntimeName = this.getRequiredSystemProperty("java.runtime.name");
        String javaVMName = this.getRequiredSystemProperty("java.vm.name");
        String version = javaRuntimeName + "(build " + javaRuntimeVersion + ")\n";
        version = version + javaVMName + "(" + javaFullVersion + ")";
        return version;
    }

    public String toString() {
        return "Java Runtime 0x" + Long.toHexString(DTFJContext.getVm().getAddress());
    }

    private String getRequiredSystemProperty(String name) throws com.ibm.dtfj.image.CorruptDataException {
        String value = null;
        try {
            value = this.getSystemProperties().getProperty(name);
        }
        catch (Throwable t) {
            throw J9DDRDTFJUtils.handleAsCorruptDataException(DTFJContext.getProcess(), t);
        }
        if (value != null) {
            return value;
        }
        throw new DTFJCorruptDataException(J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), "Couldn't find required system property " + name));
    }

    private Properties getSystemProperties() throws CorruptDataException {
        if (this.systemProperties == null) {
            this.systemProperties = J9JavaVMHelper.getSystemProperties(DTFJContext.getVm());
        }
        return this.systemProperties;
    }

    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("Memory categories are not available");
    }

    public Iterator getMemorySections(boolean includeFreed) throws DataUnavailable {
        throw new DataUnavailable("Memory sections are not available");
    }

    public JavaObject getNestedPackedObject(JavaClass jc, ImagePointer packedDataAddress) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public JavaObject getNestedPackedArrayObject(JavaClass jc, ImagePointer i, int arrayLength) throws DataUnavailable {
        throw new DataUnavailable("Not implemented");
    }

    public long getStartTime() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        throw new DataUnavailable("Dump start time (millisecs) not available in 2.4 JVMs");
    }

    public long getStartTimeNanos() throws DataUnavailable, com.ibm.dtfj.image.CorruptDataException {
        throw new DataUnavailable("Dump start time (nanosecs) not available in 2.4 JVMs");
    }

    public class DTFJRootScanner
    extends RootScanner {
        private int getReachabilityCode() {
            switch (this.getReachability()) {
                case STRONG: {
                    return 1;
                }
                case WEAK: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown reachability: " + (Object)((Object)this.getReachability()) + " found");
        }

        @Override
        protected void doClassLoader(J9ClassLoaderPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClassloader(slot).getObject(), "ClassLoader", 0, 10, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "Class", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doFinalizableSlot(GC_FinalizerJobPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(slot._element())), "FinalizableObject", 0, 8, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJNIGlobalReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJNIWeakGlobalReference(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JNIWeakGlobalReference", 0, 1, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doJVMTIObjectTagSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "JVMTIObjectTagTable", 0, 0, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doMonitorReference(J9ObjectMonitorPointer slot) {
            if (slot.notNull()) {
                try {
                    J9ThreadAbstractMonitorPointer monitor = J9ThreadAbstractMonitorPointer.cast(slot.monitor());
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(J9ObjectPointer.cast(monitor.userData())), "MonitorReference", 0, 3, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doPhantomReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "PhantomReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doRememberedSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "RememberedSlot", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doSoftReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "SoftReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doStringTableSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "StringTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doStringCacheTableSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "StringCacheTable", 0, 11, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doUnfinalizedSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "UnfinalizedObject", 0, 9, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMClassSlot(J9ClassPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(slot), "VMClassSlot", 0, 2, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadJNISlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadMonitorRecordSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doVMThreadSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "Thread", 0, 6, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doWeakReferenceSlot(J9ObjectPointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot), "WeakReferenceObject", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doClass(J9ClassPointer clazz) {
            this.doClassSlot(clazz);
        }

        @Override
        protected void doDebuggerClassReference(J9DebuggerReferencePointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaClass(J9ClassPointer.cast(slot.object())), "DebuggerClassReference", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }

        @Override
        protected void doDebuggerReference(J9DebuggerReferencePointer slot) {
            if (slot.notNull()) {
                try {
                    DTFJJavaRuntime.this.references.add(new DTFJJavaReference(DTFJJavaRuntime.this, new DTFJJavaObject(slot.object()), "DebuggerReference", 0, 7, this.getReachabilityCode()));
                }
                catch (Throwable t) {
                    CorruptData cd = J9DDRDTFJUtils.handleAsCorruptData(DTFJContext.getProcess(), t);
                    DTFJJavaRuntime.this.references.add(cd);
                }
            }
        }
    }
}

