/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.pointer.IDATAPointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ByteDataWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.CharArrayWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ClasspathEntryItemMirrorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ClasspathItemMirrorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ClasspathWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.CompiledMethodWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SharedCacheHeaderPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ShrDbgCacheMapPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ShrDbgCompositeCachePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ShrDbgOSCachePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ShrDbgSharedClassCachePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm24.pointer.generated.OrphanWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ROMClassWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ScopedROMClassWrapperPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ShcItemHdrPointer;
import com.ibm.j9ddr.vm24.pointer.generated.ShcItemPointer;
import com.ibm.j9ddr.vm24.pointer.helper.ByteDataWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.CharArrayWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ClasspathEntryItemHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ClasspathItemHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ClasspathWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.CompiledMethodWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.pointer.helper.OrphanWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ROMClassWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ScopedROMClassWrapperHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ShcItemHdrHelper;
import com.ibm.j9ddr.vm24.pointer.helper.ShcItemHelper;
import com.ibm.j9ddr.vm24.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm24.structure.CharArrayWrapper;
import com.ibm.j9ddr.vm24.structure.CompiledMethodWrapper;
import com.ibm.j9ddr.vm24.structure.J9SharedCacheHeader;
import com.ibm.j9ddr.vm24.structure.J9SharedClassConfig;
import com.ibm.j9ddr.vm24.structure.J9UTF8;
import com.ibm.j9ddr.vm24.structure.OrphanWrapper;
import com.ibm.j9ddr.vm24.structure.ROMClassWrapper;
import com.ibm.j9ddr.vm24.structure.ScopedROMClassWrapper;
import com.ibm.j9ddr.vm24.structure.ShcItem;
import com.ibm.j9ddr.vm24.structure.ShcItemHdr;
import com.ibm.j9ddr.vm24.structure.ShcdatatypesConstants;
import com.ibm.j9ddr.vm24.types.I16;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U16;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class ShrCCommand
extends Command {
    private static final long ORPHAN_STATS = 1L;
    private static final long ROMCLASS_STATS = 2L;
    private static final long CLASSPATH_STATS = 4L;
    private static final long AOT_STATS = 8L;
    private static final long SCOPE_STATS = 16L;
    private static final long BYTE_STATS = 32L;
    private static final long UNINDEXED_BYTE_STATS = 64L;
    private static final long CHARARRAY_STATS = 128L;
    private static final long CACHELET_STATS = 256L;
    private static final long FIND_METHOD = 4096L;
    private static final long ALL_STATS = 4095L;

    public ShrCCommand() {
        this.addCommand("shrc", "[command]", "shared class cache operations");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (!J9BuildFlags.opt_sharedClasses) {
                CommandUtils.dbgPrint(out, "no shared cache\n");
                return;
            }
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            J9SharedClassConfigPointer sharedClassConfig = vm.sharedClassConfig();
            CommandUtils.dbgPrint(out, "!j9sharedclassconfig %s\n\n", sharedClassConfig.getHexAddress());
            if (args.length == 0) {
                this.printHelp(out);
            } else if (sharedClassConfig.notNull()) {
                if (args[0].equals("allstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 4095L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("rcstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 2L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("cpstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 4L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("aotstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 8L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("orphanstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 1L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("scopestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 16L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("bytestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 32L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("ubytestats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 64L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("charstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 128L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("clstats")) {
                    this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 256L, null, false, VoidPointer.NULL, false);
                } else if (args[0].equals("classpath")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc classpath <address>\n");
                    } else {
                        long address = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintClasspath(out, ClasspathWrapperPointer.cast(address));
                    }
                } else if (args[0].equals("findclass")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findclass <name>\n");
                    } else {
                        String className = args[1];
                        CommandUtils.dbgPrint(out, "Looking for class \"%s\"\n", className);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 3L, className, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findclassp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findclassp <name>\n");
                    } else {
                        String className = args[1];
                        CommandUtils.dbgPrint(out, "Looking for class prefix \"%s\"\n", className);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 3L, className, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findaot")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findaot <name>\n");
                    } else {
                        String methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for AOT method \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 8L, methodName, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("findaotp")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc findaot <name>\n");
                    } else {
                        String methodName = args[1];
                        CommandUtils.dbgPrint(out, "Looking for AOT method prefix \"%s\"\n", methodName);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 8L, methodName, true, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("aotfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc aotfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 8L, null, true, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("rcfor")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc rcfor <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 3L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("incache")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc incache <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.cast(addr));
                    }
                } else if (args[0].equals("stats")) {
                    if (sharedClassConfig.notNull()) {
                        this.dbgShrcInCache(out, vm, sharedClassConfig, VoidPointer.NULL);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 0L, null, false, VoidPointer.NULL, false);
                    }
                } else if (args[0].equals("method")) {
                    if (args.length != 2) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc method <address>\n");
                    } else {
                        long addr = CommandUtils.parsePointer(args[1], J9BuildFlags.env_data64);
                        this.dbgShrcPrintAllStats(out, vm, sharedClassConfig, 4096L, null, false, VoidPointer.cast(addr), false);
                    }
                } else if (args[0].equals("rtflags")) {
                    if (sharedClassConfig.notNull()) {
                        UDATA runtimeFlags = sharedClassConfig.runtimeFlags();
                        CommandUtils.dbgPrint(out, "Printing the shared classes runtime flags %s\n", runtimeFlags.getHexValue());
                        this.printShCFlags(out, runtimeFlags, "RUNTIMEFLAG");
                    }
                } else if (args[0].equals("write")) {
                    if (args.length != 2 && args.length != 3) {
                        CommandUtils.dbgPrint(out, "Usage: !shrc write <cachedir> [<cachename>]\n");
                    } else {
                        String cacheDir = args[1];
                        String cacheName = args.length == 3 ? args[2] : null;
                        this.dbgShrcWriteCache(out, sharedClassConfig, cacheDir, cacheName);
                    }
                } else if (args[0].equals("name")) {
                    this.dbgShrcCacheName(out, sharedClassConfig);
                } else {
                    CommandUtils.dbgPrint(out, "Unknown arg(s) : ");
                    for (int i = 0; i < args.length; ++i) {
                        CommandUtils.dbgPrint(out, args[i] + " ");
                    }
                    CommandUtils.dbgPrint(out, "\nType !shrc to see all the valid options.\n");
                }
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void printShCFlags(PrintStream out, UDATA flags, String type2) {
        Field[] ShCFlagsfields;
        for (Field field : ShCFlagsfields = J9SharedClassConfig.class.getFields()) {
            String flagName = field.getName();
            try {
                Long flagValue;
                if (!flagName.contains(type2) || !flags.anyBitsIn(flagValue = (Long)field.get(null))) continue;
                CommandUtils.dbgPrint(out, "%-65s 0x%08X\n", flagName, flagValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dbgShrcCacheName(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        J9ShrDbgOSCachePointer osCache = this.getOSCache(out, sharedClassConfig);
        if (osCache.notNull()) {
            U8Pointer cacheNamePointer = osCache.cacheNameWithVGen();
            U8Pointer cachePathNamePointer = osCache.cachePathName();
            if (cacheNamePointer.notNull()) {
                String cacheNameString = cacheNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache name is %s\n", cacheNameString);
            }
            if (cachePathNamePointer.notNull()) {
                String cachePathNameString = cachePathNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache path is %s\n", cachePathNameString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbgShrcWriteCache(PrintStream out, J9SharedClassConfigPointer sharedClassConfig, String cacheDir, String cacheName) throws CorruptDataException {
        J9ShrDbgOSCachePointer osCache = this.getOSCache(out, sharedClassConfig);
        if (osCache.notNull()) {
            String cacheNameString = "default";
            U8Pointer cacheNamePointer = osCache.cacheNameWithVGen();
            if (cacheNamePointer.notNull()) {
                cacheNameString = cacheNamePointer.getCStringAtOffset(0L);
                CommandUtils.dbgPrint(out, "Cache name is %s\n", cacheNameString);
            }
            if (cacheName != null) {
                cacheNameString = cacheName;
            }
            VoidPointer headerStart = osCache.headerStart();
            UDATA cacheSize = osCache.cacheSize();
            CommandUtils.dbgPrint(out, "Cache start 0x%x size %d\n", headerStart.getAddress(), cacheSize.longValue());
            File outFile = new File(cacheDir, cacheNameString);
            CommandUtils.dbgPrint(out, "Writing cache to %s\n", outFile.getAbsolutePath());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                CommandUtils.dbgPrint(out, "Could not create %s: %s", outFile.getAbsolutePath(), e.getMessage());
                return;
            }
            try {
                int offset = 0;
                long size = cacheSize.longValue();
                byte[] buffer = new byte[4096];
                while ((long)offset < size) {
                    if (size - (long)offset < (long)buffer.length) {
                        buffer = new byte[(int)(size - (long)offset)];
                    }
                    headerStart.getBytesAtOffset(offset, buffer);
                    fout.write(buffer);
                    offset += buffer.length;
                }
            }
            catch (IOException e) {
                CommandUtils.dbgPrint(out, "Error writing %s: %s", outFile.getAbsolutePath(), e.getMessage());
                return;
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private J9ShrDbgOSCachePointer getOSCache(PrintStream out, J9SharedClassConfigPointer sharedClassConfig) throws CorruptDataException {
        if (sharedClassConfig.notNull()) {
            J9ShrDbgSharedClassCachePointer scc = sharedClassConfig.sharedClassCache();
            if (scc.notNull()) {
                J9ShrDbgCacheMapPointer cacheMap = scc.shc();
                if (cacheMap.notNull()) {
                    J9ShrDbgCompositeCachePointer compositeCache = cacheMap.cc();
                    if (compositeCache.notNull()) {
                        J9ShrDbgOSCachePointer osCache = compositeCache.oscache();
                        if (osCache.notNull()) {
                            return osCache;
                        }
                        CommandUtils.dbgPrint(out, "SH_OSCache is NULL\n");
                    } else {
                        CommandUtils.dbgPrint(out, "SH_CompositeCacheImpl is NULL\n");
                    }
                } else {
                    CommandUtils.dbgPrint(out, "SH_CacheMap is NULL\n");
                }
            } else {
                CommandUtils.dbgPrint(out, "SH_SharedClassCache is NULL\n");
            }
        } else {
            CommandUtils.dbgPrint(out, "J9SharedClassConfig is NULL\n");
        }
        return null;
    }

    private void printHelp(PrintStream out) {
        CommandUtils.dbgPrint(out, "!shrc stats                   -- Print cache stats\n");
        CommandUtils.dbgPrint(out, "!shrc allstats                -- Print all cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc rcstats                 -- Print romclass cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc cpstats                 -- Print classpath cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc aotstats                -- Print aot cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc orphanstats             -- Print orphan cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc scopestats              -- Print scope cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc bytestats               -- Print byte data cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc ubytestats              -- Print unindexed byte data cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc charstats               -- Print char array cache contents\n");
        CommandUtils.dbgPrint(out, "!shrc classpath <address>     -- Print classpath at address\n");
        CommandUtils.dbgPrint(out, "!shrc findclass <name>        -- Find named class\n");
        CommandUtils.dbgPrint(out, "!shrc findclassp <name>       -- Find named class prefix\n");
        CommandUtils.dbgPrint(out, "!shrc findaot <name>          -- Find AOT for named method\n");
        CommandUtils.dbgPrint(out, "!shrc findaotp <name>         -- Find AOT for named method prefix\n");
        CommandUtils.dbgPrint(out, "!shrc aotfor <address>        -- Find AOT for rom method\n");
        CommandUtils.dbgPrint(out, "!shrc rcfor <address>         -- Find romclass metadata from romclass address\n");
        CommandUtils.dbgPrint(out, "!shrc method <address>        -- Lookup rom method in cache\n");
        CommandUtils.dbgPrint(out, "!shrc incache <address>       -- Lookup address in cache\n");
        CommandUtils.dbgPrint(out, "!shrc rtflags                 -- Display shared classes runtime flags\n");
        CommandUtils.dbgPrint(out, "!shrc write <dir> [<name>]    -- Write the shared cache to the given directory\n");
        CommandUtils.dbgPrint(out, "!shrc name                    -- Display the name of the shared cache\n");
        out.flush();
    }

    private void dbgShrcPrintAllStats(PrintStream out, J9JavaVMPointer vm, J9SharedClassConfigPointer sharedClassConfig, long statTypes, String searchName, boolean prefix, VoidPointer searchAddress, boolean findCorrupt) throws CorruptDataException {
        ArrayList<J9ROMClassPointer> romClassList = new ArrayList<J9ROMClassPointer>();
        boolean entryFound = false;
        long J9SHR_DATA_TYPE_MAX = J9SharedClassConfig.J9SHR_DATA_TYPE_ROMSTRING;
        int numRC = 0;
        int numOrphans = 0;
        int numStale = 0;
        int numCP = 0;
        int numURL = 0;
        int numToken = 0;
        int numAOT = 0;
        int numScope = 0;
        int numByte = 0;
        int numUnindexed = 0;
        int numChararray = 0;
        int[] numByteOfType = new int[(int)J9SHR_DATA_TYPE_MAX + 1];
        int aotDataLen = 0;
        int aotCodeLen = 0;
        int aotMetaLen = 0;
        int rcMetaLen = 0;
        int scopeMetaLen = 0;
        int scopeDataLen = 0;
        int byteMetaLen = 0;
        int byteDataLen = 0;
        int byteDataRWLen = 0;
        int unindexedByteMetaLen = 0;
        int unindexedByteDataLen = 0;
        int chararrayMetaLen = 0;
        int chararrayDataLen = 0;
        long totalROMClassBytes = 0L;
        ShrcConfig config = this.dbgShrcReadConfig(sharedClassConfig, out);
        J9SharedCacheHeaderPointer cacheHeader = config.getCacheStartAddress();
        UDATA romclassStartAddress = config.getRomclassStartAddress();
        UDATA segmentPtr = config.getSegmentPtr();
        int i = 0;
        while ((long)i <= J9SHR_DATA_TYPE_MAX) {
            numByteOfType[i] = 0;
            ++i;
        }
        SharedClassMetadataIterator iterator = new SharedClassMetadataIterator(vm, 0L, true, out);
        while (iterator.hasNext()) {
            UDATA len;
            J9UTF8Pointer utf8;
            UDATA cpiType;
            ClasspathItemMirrorPointer cpi;
            ClasspathWrapperPointer cpw;
            String className;
            J9UTF8Pointer romClassName;
            J9ROMClassPointer romClass;
            ShcItemPointer it = iterator.next();
            U16 itemType = it.dataType();
            J9UTF8Pointer rcPartition = J9UTF8Pointer.NULL;
            J9UTF8Pointer rcModContext = J9UTF8Pointer.NULL;
            if (itemType.eq(ShcdatatypesConstants.TYPE_ORPHAN)) {
                rcMetaLen = (int)((long)rcMetaLen + (OrphanWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                romClass = OrphanWrapperHelper.romClass(OrphanWrapperPointer.cast(ShcItemHelper.ITEMDATA(it)));
                romClassName = romClass.className();
                if (romClassName.isNull()) {
                    CommandUtils.dbgPrint(out, "-- could not read SRP, OW ShcItem %s romClass %s --\n", it.getHexAddress(), romClass.getHexAddress());
                    return;
                }
                romClassList.add(romClass);
                if ((searchAddress.isNull() || romClass.eq(searchAddress)) && (statTypes & 1L) != 0L && this.matchClassName(searchName, className = J9UTF8Helper.stringValue(romClassName), prefix)) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s ORPHAN: %s at !j9romclass %s\n", it.jvmID().longValue(), UDATA.cast(it).getHexValue(), className, romClass.getHexAddress());
                }
                ++numOrphans;
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_ROMCLASS) || itemType.eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                ROMClassWrapperPointer rcw = ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                rcMetaLen = (int)((long)rcMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if (itemType.eq(ShcdatatypesConstants.TYPE_ROMCLASS)) {
                    rcMetaLen = (int)((long)rcMetaLen + ROMClassWrapper.SIZEOF);
                } else {
                    rcMetaLen = (int)((long)rcMetaLen + ScopedROMClassWrapper.SIZEOF);
                    ScopedROMClassWrapperPointer srcw = ScopedROMClassWrapperPointer.cast(rcw);
                    rcPartition = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWPARTITION(srcw));
                    rcModContext = J9UTF8Pointer.cast(ScopedROMClassWrapperHelper.RCWMODCONTEXT(srcw));
                }
                romClass = J9ROMClassPointer.cast(ROMClassWrapperHelper.RCWROMCLASS(rcw));
                romClassName = romClass.className();
                if (romClassName.isNull()) {
                    CommandUtils.dbgPrint(out, "-- could not read SRP, RC ShcItem %s romClass %s --\n", it.getHexAddress(), romClass.getHexAddress());
                    return;
                }
                romClassList.add(romClass);
                if (searchAddress.isNull() || romClass.eq(searchAddress)) {
                    cpw = ClasspathWrapperPointer.cast(ROMClassWrapperHelper.RCWCLASSPATH(ROMClassWrapperPointer.cast(ShcItemHelper.ITEMDATA(it))));
                    if ((statTypes & 2L) != 0L && this.matchClassName(searchName, className = J9UTF8Helper.stringValue(romClassName), prefix)) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s ROMCLASS: %s at !j9romclass %s ", it.jvmID().longValue(), it.getHexAddress(), className, romClass.getHexAddress());
                        if (ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it)))) {
                            CommandUtils.dbgPrint(out, "!STALE!");
                        }
                        CommandUtils.dbgPrint(out, "\n");
                        cpi = ClasspathItemMirrorPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
                        cpiType = new UDATA(cpi.type());
                        if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_CLASSPATH)) {
                            CommandUtils.dbgPrint(out, "\tIndex %d in !shrc classpath %s\n", rcw.cpeIndex().longValue(), cpw.getHexAddress());
                        } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_URL)) {
                            CommandUtils.dbgPrint(out, "\tURL !shrc classpath %s\n", cpw.getHexAddress());
                        } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_TOKEN)) {
                            CommandUtils.dbgPrint(out, "\tToken !shrc classpath %s\n", cpw.getHexAddress());
                        }
                        if (itemType.eq(ShcdatatypesConstants.TYPE_SCOPED_ROMCLASS)) {
                            if (rcPartition.notNull() && rcModContext.isNull()) {
                                CommandUtils.dbgPrint(out, "\tPartition !j9utf8 %s %s\n", rcPartition.getHexAddress(), this.dbgShrcPrintableString(rcPartition));
                            } else if (rcModContext.notNull() && rcPartition.isNull()) {
                                CommandUtils.dbgPrint(out, "\tModContext !j9utf8 %s %s\n", rcModContext.getHexAddress(), this.dbgShrcPrintableString(rcModContext));
                            } else if (rcModContext.notNull() && rcPartition.notNull()) {
                                CommandUtils.dbgPrint(out, "\tPartition !j9utf8 %s %s in ModContext !j9utf8 %s %s\n", rcPartition.getHexAddress(), this.dbgShrcPrintableString(rcPartition), rcModContext.getHexAddress(), this.dbgShrcPrintableString(rcModContext));
                            }
                        }
                    }
                }
                ++numRC;
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_CLASSPATH)) {
                cpw = ClasspathWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                cpi = ClasspathItemMirrorPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
                if ((statTypes & 4L) != 0L) {
                    entryFound = true;
                    this.dbgShrcPrintClasspath(out, cpw);
                }
                if ((cpiType = new UDATA(cpi.type())).eq(ShcdatatypesConstants.CP_TYPE_CLASSPATH)) {
                    ++numCP;
                } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_URL)) {
                    ++numURL;
                } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_TOKEN)) {
                    ++numToken;
                }
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_COMPILED_METHOD)) {
                CompiledMethodWrapperPointer cmw = CompiledMethodWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                J9ROMMethodPointer romMethod = J9ROMMethodPointer.cast(CompiledMethodWrapperHelper.CMWROMMETHOD(cmw));
                UDATA dataLen = new UDATA(cmw.dataLength());
                UDATA codeLen = new UDATA(cmw.codeLength());
                aotDataLen = (int)((long)aotDataLen + dataLen.longValue());
                aotCodeLen = (int)((long)aotCodeLen + codeLen.longValue());
                aotMetaLen = (int)((long)aotMetaLen + (CompiledMethodWrapper.SIZEOF + ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                if ((statTypes & 8L) != 0L && (searchAddress.isNull() || romMethod.eq(searchAddress))) {
                    String methodName = J9ROMMethodHelper.getName(romMethod) + J9ROMMethodHelper.getSignature(romMethod);
                    if (this.matchRomMethodName(searchName, J9ROMMethodHelper.getName(romMethod), J9ROMMethodHelper.getSignature(romMethod), prefix)) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: AOT data !j9x %s,%s code !j9x %s,%s ", it.jvmID().longValue(), CompiledMethodWrapperHelper.CMWDATA(cmw).getHexAddress(), dataLen.getHexValue(), CompiledMethodWrapperHelper.CMWCODE(cmw).getHexAddress(), codeLen.getHexValue());
                        if (ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it)))) {
                            CommandUtils.dbgPrint(out, "!STALE!");
                        }
                        CommandUtils.dbgPrint(out, "\n\t%s !j9rommethod %s\n", methodName, romMethod.getHexAddress());
                        ListIterator iter = romClassList.listIterator(romClassList.size());
                        while (iter.hasPrevious()) {
                            J9ROMClassPointer lastRomClass = (J9ROMClassPointer)iter.previous();
                            if (!romMethod.gt(lastRomClass) || !romMethod.lt(lastRomClass.addOffset(lastRomClass.romSize()))) continue;
                            CommandUtils.dbgPrint(out, "\t%s !j9romclass %s\n", J9UTF8Helper.stringValue(lastRomClass.className()), lastRomClass.getHexAddress());
                            break;
                        }
                    }
                }
                ++numAOT;
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_SCOPE)) {
                utf8 = J9UTF8Pointer.cast(ShcItemHelper.ITEMDATA(it));
                scopeMetaLen = (int)((long)scopeMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                scopeDataLen = (int)((long)scopeDataLen + (J9UTF8.SIZEOF + utf8.length().longValue()));
                if ((statTypes & 0x10L) != 0L) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s SCOPE !j9utf8 %s %s\n", it.jvmID().longValue(), it.getHexAddress(), utf8.getHexAddress(), J9UTF8Helper.stringValue(utf8));
                }
                ++numScope;
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_BYTE_DATA)) {
                ByteDataWrapperPointer bdw = ByteDataWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                byteMetaLen = (int)((long)byteMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF + ByteDataWrapper.SIZEOF));
                UDATA rwOffset = new UDATA(ByteDataWrapperHelper.BDWEXTBLOCK(bdw));
                len = new UDATA(ByteDataWrapperHelper.BDWLEN(bdw));
                UDATA byteDataType = new UDATA(ByteDataWrapperHelper.BDWTYPE(bdw));
                if (byteDataType.longValue() <= J9SHR_DATA_TYPE_MAX) {
                    int n = (int)byteDataType.longValue();
                    numByteOfType[n] = (int)((long)numByteOfType[n] + len.longValue());
                } else {
                    numByteOfType[0] = (int)((long)numByteOfType[0] + len.longValue());
                }
                if (rwOffset.eq(0L)) {
                    byteDataLen = (int)((long)byteDataLen + len.longValue());
                    if ((statTypes & 0x20L) != 0L) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s %s BYTEDATA !j9x %s,%s", it.jvmID().longValue(), it.getHexAddress(), this.getType(byteDataType), ByteDataWrapperHelper.BDWDATA(bdw).getHexAddress(), len.getHexValue());
                    }
                } else {
                    byteDataRWLen = (int)((long)byteDataRWLen + len.longValue());
                    if ((statTypes & 0x20L) != 0L) {
                        entryFound = true;
                        CommandUtils.dbgPrint(out, "%d: %s BYTEDATA RW !j9x %s,%s", it.jvmID().longValue(), it.getHexAddress(), ByteDataWrapperHelper.BDWDATA(bdw).getHexAddress(), len.getHexValue());
                    }
                }
                if ((statTypes & 0x20L) != 0L) {
                    if (ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it)))) {
                        CommandUtils.dbgPrint(out, "!STALE!");
                    }
                    UDATA inPrivateUse = new UDATA(ByteDataWrapperHelper.BDWINPRIVATEUSE(bdw));
                    UDATA privateOwnerID = new UDATA(ByteDataWrapperHelper.BDWPRIVATEOWNERID(bdw));
                    utf8 = J9UTF8Pointer.cast(ByteDataWrapperHelper.BDWTOKEN(bdw));
                    if (utf8.notNull()) {
                        CommandUtils.dbgPrint(out, "\n\tkey: !j9utf8 %s %s\n", utf8.getHexAddress(), J9UTF8Helper.stringValue(utf8));
                    }
                    if (!inPrivateUse.eq(0L) || !privateOwnerID.eq(0L)) {
                        CommandUtils.dbgPrint(out, "\n\tinPrivateUse %d privateOwnerID %d\n", inPrivateUse.longValue(), privateOwnerID.longValue());
                    }
                }
                ++numByte;
            } else if (itemType.eq(ShcdatatypesConstants.TYPE_UNINDEXED_BYTE_DATA)) {
                len = new UDATA(it.dataLen());
                unindexedByteMetaLen = (int)((long)unindexedByteMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF));
                unindexedByteDataLen = (int)((long)unindexedByteDataLen + len.longValue());
                if ((statTypes & 0x40L) != 0L) {
                    entryFound = true;
                    CommandUtils.dbgPrint(out, "%d: %s UNINDEXEDBYTEDATA !j9x %s,%s\n", it.jvmID().longValue(), it.getHexAddress(), ShcItemHelper.ITEMDATA(it).getHexAddress(), len.getHexValue());
                }
                ++numUnindexed;
            } else {
                if (!itemType.eq(ShcdatatypesConstants.TYPE_CHAR_ARRAY)) continue;
                CharArrayWrapperPointer caw = CharArrayWrapperPointer.cast(ShcItemHelper.ITEMDATA(it));
                chararrayMetaLen = (int)((long)chararrayMetaLen + (ShcItem.SIZEOF + ShcItemHdr.SIZEOF + CharArrayWrapper.SIZEOF));
                len = new UDATA(caw.objectSize());
                chararrayDataLen = (int)((long)chararrayDataLen + len.longValue());
                if ((statTypes & 0x80L) != 0L) {
                    entryFound = true;
                    utf8 = J9UTF8Pointer.cast(CharArrayWrapperHelper.CAWROMSTRING(caw).sub(2L));
                    CommandUtils.dbgPrint(out, "FIX ME : Char array wrapper now takes void*");
                    CommandUtils.dbgPrint(out, "%d: %s CHARARRAY !j9object %s\n", it.jvmID().longValue(), it.getHexAddress(), CharArrayWrapperHelper.CAWDATA(caw).getHexAddress());
                    CommandUtils.dbgPrint(out, "\tkey: !j9utf8 %s %s\n", utf8.getHexAddress(), J9UTF8Helper.stringValue(utf8));
                }
                ++numChararray;
            }
            if (!ShcItemHdrHelper.CCITEMSTALE(ShcItemHdrPointer.cast(ShcItemHelper.ITEMEND(it)))) continue;
            ++numStale;
        }
        if ((statTypes & 0x1000L) != 0L) {
            Iterator lastRomClassIterator = romClassList.iterator();
            J9ROMClassPointer lastRomClass = J9ROMClassPointer.NULL;
            while (lastRomClassIterator.hasNext()) {
                lastRomClass = (J9ROMClassPointer)lastRomClassIterator.next();
                if (!searchAddress.gt(lastRomClass) || !searchAddress.lt(lastRomClass.addOffset(lastRomClass.romSize()))) continue;
                entryFound = true;
                break;
            }
            if (!entryFound) {
                CommandUtils.dbgPrint(out, "!j9rommethod %s not found in cache\n", J9ROMMethodPointer.cast(searchAddress).getHexAddress());
                if (searchAddress.lt(VoidPointer.cast(romclassStartAddress))) {
                    CommandUtils.dbgPrint(out, "\taddress is < cache romclassStartAddress %s\n", romclassStartAddress.getHexValue());
                }
                if (searchAddress.gt(VoidPointer.cast(segmentPtr))) {
                    CommandUtils.dbgPrint(out, "\taddress is > cache romclass segment %s\n", segmentPtr.getHexValue());
                }
            } else {
                CommandUtils.dbgPrint(out, "!j9rommethod %s found in %s !j9romclass %s\n", J9ROMMethodPointer.cast(searchAddress).getHexAddress(), J9UTF8Helper.stringValue(lastRomClass.className()), lastRomClass.getHexAddress());
            }
        } else if (!entryFound) {
            CommandUtils.dbgPrint(out, "No entry found in the cache\n");
        }
        if (searchAddress.isNull() && searchName == null) {
            CommandUtils.dbgPrint(out, "\nCache contains %d classes, %d orphans, %d classpaths, %d URLs, %d tokens\n", numRC, numOrphans, numCP, numURL, numToken);
            CommandUtils.dbgPrint(out, "%d AOT, %d SCOPES, %d BYTE data, %d UNINDEXED DATA, %d CHARARRAY, %d stale\n", numAOT, numScope, numByte, numUnindexed, numChararray, numStale);
            CommandUtils.dbgPrint(out, "AOT data length %d code length %d metadata %d total %d\n", aotDataLen, aotCodeLen, aotMetaLen, aotDataLen + aotCodeLen, aotMetaLen);
            totalROMClassBytes = segmentPtr.sub(romclassStartAddress).longValue();
            CommandUtils.dbgPrint(out, "ROMClass data %d metadata %d\n", totalROMClassBytes, rcMetaLen);
            CommandUtils.dbgPrint(out, "SCOPE data %d metadata %d total %d\n", scopeDataLen, scopeMetaLen, scopeMetaLen + scopeDataLen);
            CommandUtils.dbgPrint(out, "BYTE data %d metadata %d rwarea %d\n", byteDataLen, byteMetaLen, byteDataRWLen);
            CommandUtils.dbgPrint(out, "UNINDEXEDBYTE data %d metadata %d\n", unindexedByteDataLen, unindexedByteMetaLen);
            CommandUtils.dbgPrint(out, "CHARARRAY data %d metadata %d\n", chararrayDataLen, chararrayMetaLen);
            CommandUtils.dbgPrint(out, "BYTEDATA Summary\n");
            CommandUtils.dbgPrint(out, "\tUNKNOWN %d  HELPER %d  POOL %d  JIT %d\n", numByteOfType[0], numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_HELPER], numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_POOL], numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_JIT]);
            CommandUtils.dbgPrint(out, "\tJCL %d  VM %d  ROMSTRING %d\n", numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_JCL], numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_VM], numByteOfType[(int)J9SharedClassConfig.J9SHR_DATA_TYPE_ROMSTRING]);
        }
    }

    ShrcConfig dbgShrcReadConfig(J9SharedClassConfigPointer sharedClassConfig, PrintStream out) throws CorruptDataException {
        UDATA segmentSRP;
        J9ShrDbgOSCachePointer osCache;
        J9ShrDbgCompositeCachePointer compositeCacheImpl;
        J9ShrDbgCacheMapPointer cacheMap;
        J9ShrDbgSharedClassCachePointer scc;
        J9SharedCacheHeaderPointer cacheStartAddress = null;
        UDATA romclassStartAddress = null;
        Scalar segmentPtr = null;
        cacheStartAddress = sharedClassConfig.cacheStartAddress();
        if (cacheStartAddress.isNull() && (scc = sharedClassConfig.sharedClassCache()).notNull() && (cacheMap = scc.shc()).notNull() && (compositeCacheImpl = cacheMap.cc()).notNull() && (cacheStartAddress = compositeCacheImpl.theca()).isNull() && (osCache = compositeCacheImpl.oscache()).notNull()) {
            cacheStartAddress = J9SharedCacheHeaderPointer.cast(osCache.dataStart().longValue());
        }
        if (cacheStartAddress.isNull()) {
            CommandUtils.dbgPrint(out, "cacheStartAddress is zero");
            return null;
        }
        romclassStartAddress = UDATA.cast(sharedClassConfig.romclassStartAddress());
        if (0L == romclassStartAddress.longValue() && 0L != cacheStartAddress.readWriteBytes().longValue()) {
            romclassStartAddress = new UDATA(cacheStartAddress.addOffset(cacheStartAddress.readWriteBytes()).longValue());
        }
        if (0L == romclassStartAddress.longValue()) {
            CommandUtils.dbgPrint(out, "romclassStartAddress is zero");
        }
        if (0L != (segmentSRP = cacheStartAddress.segmentSRP()).longValue()) {
            segmentPtr = UDATA.cast(cacheStartAddress).add(segmentSRP);
        }
        if (0L == segmentPtr.longValue()) {
            CommandUtils.dbgPrint(out, "segmentPtr is zero");
        }
        return new ShrcConfig(cacheStartAddress, romclassStartAddress, (UDATA)segmentPtr);
    }

    SharedCacheMetadata dbgReadSharedCacheMetadata(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        J9SharedClassConfigPointer sharedConfig = vm.sharedClassConfig();
        U8Pointer heapTop = null;
        U8Pointer heapBase = null;
        if (sharedConfig.isNull()) {
            CommandUtils.dbgPrint(out, "SharedClassConfig can not be found.");
            return null;
        }
        J9MemorySegmentPointer metadataMemorySegment = sharedConfig.metadataMemorySegment();
        if (metadataMemorySegment.notNull()) {
            heapTop = metadataMemorySegment.heapTop();
            heapBase = metadataMemorySegment.heapBase();
        } else {
            J9ShrDbgCompositeCachePointer compositeCacheImpl;
            J9ShrDbgCacheMapPointer cacheMap;
            J9SharedCacheHeaderPointer cacheStartAddress = null;
            J9ShrDbgSharedClassCachePointer scc = sharedConfig.sharedClassCache();
            if (scc.notNull() && (cacheMap = scc.shc()).notNull() && (compositeCacheImpl = cacheMap.cc()).notNull()) {
                cacheStartAddress = compositeCacheImpl.theca();
                if (cacheStartAddress.notNull()) {
                    heapTop = U8Pointer.cast(cacheStartAddress.getAddress() + cacheStartAddress.totalBytes().longValue());
                    heapBase = U8Pointer.cast(cacheStartAddress.getAddress() + cacheStartAddress.updateSRP().longValue());
                } else {
                    J9ShrDbgOSCachePointer oscache = compositeCacheImpl.oscache();
                    if (oscache.notNull()) {
                        cacheStartAddress = J9SharedCacheHeaderPointer.cast(oscache.dataStart());
                        heapTop = U8Pointer.cast(cacheStartAddress.getAddress() + cacheStartAddress.totalBytes().longValue());
                        heapBase = U8Pointer.cast(cacheStartAddress.getAddress() + cacheStartAddress.updateSRP().longValue());
                    }
                }
            }
        }
        if (heapTop.isNull() || heapBase.isNull()) {
            CommandUtils.dbgPrint(out, "SharedCache is not initialized enough to find the metadata area of the cache");
            return null;
        }
        SharedCacheMetadata metadata = new SharedCacheMetadata(heapBase, heapTop);
        if (metadata.getLength().lt(0)) {
            return null;
        }
        return metadata;
    }

    private String getType(UDATA byteDataType) {
        long type2 = byteDataType.longValue();
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_HELPER) {
            return "HELPER";
        }
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_POOL) {
            return "POOL";
        }
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_JIT) {
            return "JIT";
        }
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_JCL) {
            return "JCL";
        }
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_VM) {
            return "VM";
        }
        if (type2 == J9SharedClassConfig.J9SHR_DATA_TYPE_ROMSTRING) {
            return "ROMSTRING";
        }
        return "UNKNOWN(" + type2 + ")";
    }

    private String dbgShrcPrintableString(J9UTF8Pointer utf8) throws CorruptDataException {
        String stringData = J9UTF8Helper.stringValue(utf8);
        return stringData;
    }

    private boolean matchClassName(String searchName, String className, boolean prefix) {
        if (searchName == null || className == null) {
            return true;
        }
        if (prefix) {
            return className.startsWith(searchName);
        }
        return searchName.equals(className);
    }

    private boolean matchRomMethodName(String searchName, String methodName, String methodSignature, boolean prefix) {
        if (searchName == null || methodName == null || methodSignature == null) {
            return true;
        }
        String methodNameAndSig = methodName + methodSignature;
        if (prefix) {
            return methodNameAndSig.startsWith(searchName);
        }
        if (searchName.equals(methodName)) {
            return true;
        }
        return searchName.equals(methodNameAndSig);
    }

    private Touple<Boolean, Long> dbgShrcHeaderOperations(PrintStream out, J9SharedCacheHeaderPointer header, VoidPointer address) throws CorruptDataException {
        long freeBytes = 0L;
        U32 totalBytes = header.totalBytes();
        U32 readWriteBytes = header.readWriteBytes();
        UDATA segmentSRP = header.segmentSRP();
        UDATA segmentPtr = UDATA.cast(header).add(segmentSRP);
        UDATA updateSRP = header.updateSRP();
        UDATA updatePtr = UDATA.cast(header).add(updateSRP);
        UDATA readWriteSRP = header.readWriteSRP();
        UDATA readWritePtr = UDATA.cast(header).add(readWriteSRP);
        UDATA readWriteStartAddress = UDATA.cast(header).add(J9SharedCacheHeader.SIZEOF);
        UDATA romclassStartAddress = UDATA.cast(header).add(readWriteBytes);
        UDATA metadataStartAddress = UDATA.cast(header).add(totalBytes);
        freeBytes = updatePtr.sub(segmentPtr).longValue();
        CommandUtils.dbgPrint(out, "!j9sharedcacheheader %s\n", header.getHexAddress());
        CommandUtils.dbgPrint(out, "cache size       : %d\n", totalBytes.sub(readWriteBytes).longValue());
        CommandUtils.dbgPrint(out, "free bytes       : %d\n", updatePtr.sub(segmentPtr).longValue());
        CommandUtils.dbgPrint(out, "read write area  : %s - %s size %d used %d\n", readWriteStartAddress.getHexValue(), readWritePtr.getHexValue(), readWriteBytes.longValue(), readWritePtr.sub(readWriteStartAddress).longValue());
        CommandUtils.dbgPrint(out, "segment area     : %s - %s size %d\n", romclassStartAddress.getHexValue(), segmentPtr.getHexValue(), segmentPtr.sub(romclassStartAddress).longValue());
        CommandUtils.dbgPrint(out, "metadata area    : %s - %s size %d\n", updatePtr.getHexValue(), metadataStartAddress.getHexValue(), metadataStartAddress.sub(updatePtr).longValue());
        if (address.isNull()) {
            return new Touple<Boolean, Long>(false, freeBytes);
        }
        if (address.gte(VoidPointer.cast(header)) && address.lt(VoidPointer.cast(header).addOffset(J9SharedCacheHeader.SIZEOF))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the cache header", address.getAddress());
        } else if (address.gte(VoidPointer.cast(readWriteStartAddress)) && address.lt(VoidPointer.cast(readWritePtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the read write area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(readWritePtr)) && address.lt(VoidPointer.cast(romclassStartAddress))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the unused part of the read write area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(romclassStartAddress)) && address.lt(VoidPointer.cast(segmentPtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the rom class segment area", address.getAddress());
        } else if (address.gte(VoidPointer.cast(segmentPtr)) && address.lt(VoidPointer.cast(updatePtr))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in unused area between class segments and metadata", address.getAddress());
        } else if (address.gte(VoidPointer.cast(updatePtr)) && address.lt(VoidPointer.cast(metadataStartAddress))) {
            CommandUtils.dbgPrint(out, "\n0x%x is in the metadata area", address.getAddress());
        } else {
            return new Touple<Boolean, Long>(false, freeBytes);
        }
        CommandUtils.dbgPrint(out, "\n");
        return new Touple<Boolean, Long>(true, freeBytes);
    }

    private void dbgShrcPrintClasspath(PrintStream out, ClasspathWrapperPointer cpw) throws CorruptDataException {
        ClasspathItemMirrorPointer cpi = ClasspathItemMirrorPointer.cast(ClasspathWrapperHelper.CPWDATA(cpw));
        UDATA cpiType = new UDATA(cpi.type());
        ShcItemPointer item = ShcItemPointer.cast(UDATA.cast(cpw).sub(ShcItem.SIZEOF));
        U16 jvmID = item.jvmID();
        I16 staleFromIndex = cpw.staleFromIndex();
        CommandUtils.dbgPrint(out, "%d: ", jvmID.longValue());
        if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_CLASSPATH)) {
            CommandUtils.dbgPrint(out, "%s CLASSPATH", UDATA.cast(cpw).getHexValue());
        } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_URL)) {
            CommandUtils.dbgPrint(out, "%s URL", UDATA.cast(cpw).getHexValue());
        } else if (cpiType.eq(ShcdatatypesConstants.CP_TYPE_TOKEN)) {
            CommandUtils.dbgPrint(out, "%s TOKEN", UDATA.cast(cpw).getHexValue());
        }
        if (!staleFromIndex.eq(ShcdatatypesConstants.CPW_NOT_STALE)) {
            CommandUtils.dbgPrint(out, " staleFromIndex %d", staleFromIndex.longValue());
        }
        CommandUtils.dbgPrint(out, "\n");
        IDATA itemsAdded = cpi.itemsAdded();
        IDATAPointer cpeiArrayPtr = ClasspathItemHelper.CPEI_ARRAY_PTR_FROM_CPI(cpi);
        int i = 0;
        while (itemsAdded.gt(i)) {
            ClasspathEntryItemMirrorPointer cpei = ClasspathEntryItemMirrorPointer.cast(UDATA.cast(cpi).add(cpeiArrayPtr.at(i)));
            UDATA cpeiPathLen = cpei.pathLen();
            U8Pointer cpeiPathPointer = ClasspathEntryItemHelper.CPEIPATH(cpei);
            String cpeiPath = cpeiPathPointer.getCStringAtOffset(0L, cpeiPathLen.longValue());
            CommandUtils.dbgPrint(out, "   %d:\t%s\n", i, cpeiPath);
            ++i;
        }
    }

    private void dbgShrcInCache(PrintStream out, J9JavaVMPointer vm, J9SharedClassConfigPointer sharedClassConfig, VoidPointer address) throws CorruptDataException {
        boolean found = false;
        ShrcConfig dbgShrcReadConfig = this.dbgShrcReadConfig(sharedClassConfig, out);
        J9SharedCacheHeaderPointer cacheStartAddress = dbgShrcReadConfig.getCacheStartAddress();
        found = this.dbgShrcHeaderOperations(out, cacheStartAddress, address).getV1();
        if (address.isNull()) {
            return;
        }
        if (!found) {
            CommandUtils.dbgPrint(out, "\n%s is not in the shared cache\n", U8Pointer.cast(address).getHexAddress());
        }
    }

    class SharedClassMetadataIterator
    implements Iterator<ShcItemPointer> {
        private ShcItemPointer next;
        private U8Pointer metaStart;
        private U8Pointer savedMetaStart;
        private ShcItemHdrPointer entry;
        private ShcItemHdrPointer savedEntry;
        private U16 limitDataType;
        private boolean includeStale;
        private PrintStream out;

        public SharedClassMetadataIterator(J9JavaVMPointer vm, long limitDataType, boolean includeStale, PrintStream out) throws CorruptDataException {
            SharedCacheMetadata cacheMetadata = ShrCCommand.this.dbgReadSharedCacheMetadata(vm, out);
            this.next = ShcItemPointer.NULL;
            this.metaStart = cacheMetadata.getHeapBase();
            this.savedMetaStart = cacheMetadata.getHeapBase();
            this.entry = cacheMetadata.getFirstEntry();
            this.savedEntry = ShcItemHdrPointer.NULL;
            this.limitDataType = new U16(limitDataType);
            this.includeStale = includeStale;
            this.out = out;
        }

        @Override
        public boolean hasNext() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            return this.next.notNull();
        }

        @Override
        public ShcItemPointer next() {
            if (this.entry.notNull() && this.next.isNull()) {
                this.next = this.internalNext();
            }
            ShcItemPointer returnValue = this.next;
            this.next = ShcItemPointer.NULL;
            return returnValue;
        }

        private ShcItemPointer internalNext() {
            try {
                ShcItemPointer current = ShcItemPointer.NULL;
                ShcItemHdrPointer nextEntry = this.entry;
                do {
                    this.entry = nextEntry;
                    long itemLen = ShcItemHdrHelper.CCITEMLEN(this.entry).longValue();
                    if (itemLen == 0L) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen is 0\n", this.entry.getHexAddress());
                        nextEntry = ShcItemHdrPointer.NULL;
                        break;
                    }
                    nextEntry = ShcItemHdrHelper.CCITEMNEXT(this.entry);
                    if (UDATA.cast(nextEntry).lt(UDATA.cast(this.metaStart.sub(ShcItemHdr.SIZEOF)))) {
                        CommandUtils.dbgPrint(this.out, "\nCache header !shcitemhdr %s is corrupt because itemLen %d is bigger than size of metadata area\n", this.entry.getHexAddress(), itemLen);
                        nextEntry = ShcItemHdrPointer.NULL;
                        break;
                    }
                    if (UDATA.cast(nextEntry).lte(UDATA.cast(this.metaStart))) {
                        if (this.savedEntry.notNull()) {
                            this.metaStart = this.savedMetaStart;
                            nextEntry = this.savedEntry;
                            this.savedEntry = ShcItemHdrPointer.NULL;
                            if (UDATA.cast(nextEntry).lte(UDATA.cast(this.metaStart))) {
                                nextEntry = ShcItemHdrPointer.NULL;
                            }
                        } else {
                            nextEntry = ShcItemHdrPointer.NULL;
                        }
                    }
                    ShcItemPointer walk = ShcItemPointer.cast(ShcItemHdrHelper.CCITEM(this.entry));
                    U16 type2 = walk.dataType();
                    if (!this.limitDataType.eq(0L) && (!type2.eq(this.limitDataType) || !this.includeStale && ShcItemHdrHelper.CCITEMSTALE(this.entry))) continue;
                    current = walk;
                    break;
                } while (nextEntry.notNull());
                this.entry = nextEntry;
                return current;
            }
            catch (CorruptDataException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }

    class SharedCacheMetadata {
        private final U8Pointer heapBase;
        private final U8Pointer heapTop;
        private final UDATA length;

        public SharedCacheMetadata(U8Pointer heapBase, U8Pointer heapTop) {
            this.heapBase = heapBase;
            this.heapTop = heapTop;
            this.length = new UDATA(heapTop.sub(heapBase));
        }

        public U8Pointer getHeapBase() {
            return this.heapBase;
        }

        public U8Pointer getHeapTop() {
            return this.heapTop;
        }

        public UDATA getLength() {
            return this.length;
        }

        public ShcItemHdrPointer getFirstEntry() {
            return ShcItemHdrPointer.cast(this.heapTop.getAddress() - ShcItemHdr.SIZEOF);
        }
    }

    class Touple<V1, V2> {
        V1 v1;
        V2 v2;

        public Touple(V1 v1, V2 v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        public V1 getV1() {
            return this.v1;
        }

        public V2 getV2() {
            return this.v2;
        }
    }

    class ShrcConfig {
        private final J9SharedCacheHeaderPointer cacheStartAddress;
        private final UDATA romclassStartAddress;
        private final UDATA segmentPtr;

        public ShrcConfig(J9SharedCacheHeaderPointer cacheStartAddress, UDATA romclassStartAddress, UDATA segmentPtr) {
            this.cacheStartAddress = cacheStartAddress;
            this.romclassStartAddress = romclassStartAddress;
            this.segmentPtr = segmentPtr;
        }

        public J9SharedCacheHeaderPointer getCacheStartAddress() {
            return this.cacheStartAddress;
        }

        public UDATA getRomclassStartAddress() {
            return this.romclassStartAddress;
        }

        public UDATA getSegmentPtr() {
            return this.segmentPtr;
        }
    }
}

