/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.structure.J9MemorySpace;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=J9MemorySpace.class)
public class J9MemorySpacePointer
extends StructurePointer {
    public static final J9MemorySpacePointer NULL = new J9MemorySpacePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9MemorySpacePointer(long address) {
        super(address);
    }

    public static J9MemorySpacePointer cast(AbstractPointer structure) {
        return J9MemorySpacePointer.cast(structure.getAddress());
    }

    public static J9MemorySpacePointer cast(UDATA udata) {
        return J9MemorySpacePointer.cast(udata.longValue());
    }

    public static J9MemorySpacePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9MemorySpacePointer(address);
    }

    @Override
    public J9MemorySpacePointer add(long count) {
        return J9MemorySpacePointer.cast(this.address + J9MemorySpace.SIZEOF * count);
    }

    @Override
    public J9MemorySpacePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9MemorySpacePointer addOffset(long offset) {
        return J9MemorySpacePointer.cast(this.address + offset);
    }

    @Override
    public J9MemorySpacePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9MemorySpacePointer sub(long count) {
        return J9MemorySpacePointer.cast(this.address - J9MemorySpace.SIZEOF * count);
    }

    @Override
    public J9MemorySpacePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9MemorySpacePointer subOffset(long offset) {
        return J9MemorySpacePointer.cast(this.address - offset);
    }

    @Override
    public J9MemorySpacePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9MemorySpacePointer untag(long mask) {
        return J9MemorySpacePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9MemorySpacePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9MemorySpace.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_allocateSegmentOffset_", declaredType="struct J9MemorySegment*")
    public J9MemorySegmentPointer allocateSegment() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9MemorySpace._allocateSegmentOffset_);
        return J9MemorySegmentPointer.cast(pointer);
    }

    public PointerPointer allocateSegmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._allocateSegmentOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="UDATA")
    public UDATA flags() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(J9MemorySpace._flagsOffset_));
    }

    public UDATAPointer flagsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9MemorySpace._flagsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_gcExtensionsOffset_", declaredType="void*")
    public VoidPointer gcExtensions() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9MemorySpace._gcExtensionsOffset_));
    }

    public PointerPointer gcExtensionsEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._gcExtensionsOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_gcTaskListOffset_", declaredType="void*")
    public VoidPointer gcTaskList() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9MemorySpace._gcTaskListOffset_));
    }

    public PointerPointer gcTaskListEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._gcTaskListOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_gcTenureCandidateOffset_", declaredType="struct J9MemorySegment*")
    public J9MemorySegmentPointer gcTenureCandidate() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9MemorySpace._gcTenureCandidateOffset_);
        return J9MemorySegmentPointer.cast(pointer);
    }

    public PointerPointer gcTenureCandidateEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._gcTenureCandidateOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_survivorSegmentOffset_", declaredType="struct J9MemorySegment*")
    public J9MemorySegmentPointer survivorSegment() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9MemorySpace._survivorSegmentOffset_);
        return J9MemorySegmentPointer.cast(pointer);
    }

    public PointerPointer survivorSegmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._survivorSegmentOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tenureSegmentOffset_", declaredType="struct J9MemorySegment*")
    public J9MemorySegmentPointer tenureSegment() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(J9MemorySpace._tenureSegmentOffset_);
        return J9MemorySegmentPointer.cast(pointer);
    }

    public PointerPointer tenureSegmentEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9MemorySpace._tenureSegmentOffset_);
    }
}

