/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.j9.ObjectAccessBarrier;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U64;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class AbstractPointer
extends DataType {
    protected final long address;

    protected AbstractPointer(long address) {
        this.address = 4 == DataType.getProcess().bytesPerPointer() ? 0xFFFFFFFFL & address : address;
    }

    public abstract AbstractPointer add(long var1);

    public abstract AbstractPointer add(Scalar var1);

    public abstract AbstractPointer addOffset(long var1);

    public abstract AbstractPointer addOffset(Scalar var1);

    public abstract AbstractPointer sub(long var1);

    public abstract AbstractPointer sub(Scalar var1);

    public abstract AbstractPointer subOffset(long var1);

    public abstract AbstractPointer subOffset(Scalar var1);

    public abstract AbstractPointer untag(long var1);

    public abstract AbstractPointer untag();

    @Deprecated
    public boolean isTagged(long mask) {
        return 0L != (this.address & mask);
    }

    public boolean allBitsIn(long bitmask) {
        return bitmask == (this.address & bitmask);
    }

    public boolean anyBitsIn(long bitmask) {
        return 0L != (this.address & bitmask);
    }

    @Override
    public long longValue() throws CorruptDataException {
        return this.address;
    }

    public abstract DataType at(long var1) throws CorruptDataException;

    public abstract DataType at(Scalar var1) throws CorruptDataException;

    @Deprecated
    public long longAt(long index) throws CorruptDataException {
        return this.at(index).longValue();
    }

    @Deprecated
    public long longAt(Scalar index) throws CorruptDataException {
        return this.longAt(index.longValue());
    }

    @Deprecated
    public float floatAt(long index) throws CorruptDataException {
        return this.longAt(index);
    }

    @Deprecated
    public float floatAt(Scalar index) throws CorruptDataException {
        return this.floatAt(index.longValue());
    }

    @Deprecated
    public double doubleAt(long index) throws CorruptDataException {
        return this.longAt(index);
    }

    @Deprecated
    public double doubleAt(Scalar index) throws CorruptDataException {
        return this.doubleAt(index.longValue());
    }

    @Deprecated
    public boolean boolAt(long index) throws CorruptDataException {
        return this.longAt(index) != 0L;
    }

    @Deprecated
    public boolean boolAt(Scalar index) throws CorruptDataException {
        return this.boolAt(index.longValue());
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public boolean notNull() {
        return this.address != 0L;
    }

    public boolean eq(Object obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractPointer)) {
            return false;
        }
        return this.address == ((AbstractPointer)obj).address;
    }

    public int hashCode() {
        return (int)(0xFFFFFFFFL & this.address ^ (0xFFFFFFFF00000000L & this.address) >> 32);
    }

    public long getAddress() {
        return this.address;
    }

    public String getHexAddress() {
        return String.format("0x%0" + UDATA.SIZEOF * 2 + "X", this.address);
    }

    public String hexAt(long index) throws CorruptDataException {
        String result = "0x";
        int bufferSize = this instanceof StructurePointer ? UDATA.SIZEOF : (int)this.sizeOfBaseType();
        byte[] buffer = new byte[bufferSize];
        this.getBytesAtOffset(index, buffer);
        for (int i = 0; i < buffer.length; ++i) {
            result = result + String.format("%02X", buffer[i]);
        }
        return result;
    }

    public String hexAt(Scalar index) throws CorruptDataException {
        return this.hexAt(index.longValue());
    }

    protected static IProcess getAddressSpace() {
        return process;
    }

    public boolean lt(AbstractPointer pointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).lt(new U64(pointer.address));
        }
        return this.address < pointer.address;
    }

    public boolean lte(AbstractPointer pointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).lte(new U64(pointer.address));
        }
        return this.address <= pointer.address;
    }

    public boolean gt(AbstractPointer pointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).gt(new U64(pointer.address));
        }
        return this.address > pointer.address;
    }

    public boolean gte(AbstractPointer pointer) {
        if (J9BuildFlags.env_data64) {
            return new U64(this.address).gte(new U64(pointer.address));
        }
        return this.address >= pointer.address;
    }

    public IDATA sub(AbstractPointer pointer) {
        if (this.getClass() != pointer.getClass()) {
            throw new UnsupportedOperationException("Cannot subtract different pointer types. This type = " + this.getClass() + ", parameter type = " + pointer.getClass());
        }
        IDATA diff = new IDATA(this.address).sub(new IDATA(pointer.address));
        return new IDATA(diff.longValue() / this.sizeOfBaseType());
    }

    protected abstract long sizeOfBaseType();

    public int compare(AbstractPointer pointer) {
        return this.address == pointer.address ? 0 : (this.lt(pointer) ? -1 : 1);
    }

    public String toString() {
        String pointerType = this.getClass().getName();
        try {
            if (this instanceof J9ObjectPointer || this instanceof J9IndexableObjectPointer) {
                pointerType = J9ObjectHelper.getClassName(J9ObjectPointer.cast(this));
            }
            if (this.address == 0L) {
                return String.format("%s @ 00000", pointerType);
            }
            return String.format("%s @ 0x%08X %n%s", pointerType, this.address, this.getMemString(16));
        }
        catch (CorruptDataException e) {
            return super.toString();
        }
    }

    private String getMemString(int words) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(bos);
        this.dumpHex(words, stream);
        return bos.toString();
    }

    private void dumpHex(int words, PrintStream stream) {
        if (this.isNull()) {
            return;
        }
        stream.println();
        for (int i = 0; i < words; ++i) {
            try {
                int word = AbstractPointer.getAddressSpace().getIntAt(this.address + (long)(i * 4));
                if (i % 4 == 0) {
                    stream.print(String.format("%08X : ", this.getAddress() + (long)(i * 4)));
                }
                stream.print(String.format("%08X ", word));
                if (i % 4 != 3) continue;
                stream.println();
                continue;
            }
            catch (CorruptDataException e) {
                stream.print(" FAULT ");
            }
        }
        stream.println();
    }

    protected long getPointerAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getPointerAt(this.address + offset);
    }

    protected int getIntAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getIntAt(this.address + offset);
    }

    protected double getDoubleAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        long bits = AbstractPointer.getAddressSpace().getLongAt(this.address + offset);
        return Double.longBitsToDouble(bits);
    }

    protected float getFloatAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        int bits = AbstractPointer.getAddressSpace().getIntAt(this.address + offset);
        return Float.intBitsToFloat(bits);
    }

    protected boolean getBoolAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        switch (SIZEOF_BOOL) {
            case 1: {
                return 0 != AbstractPointer.getAddressSpace().getByteAt(this.address + offset);
            }
            case 2: {
                return 0 != AbstractPointer.getAddressSpace().getShortAt(this.address + offset);
            }
            case 4: {
                return 0 != AbstractPointer.getAddressSpace().getIntAt(this.address + offset);
            }
            case 8: {
                return 0L != AbstractPointer.getAddressSpace().getLongAt(this.address + offset);
            }
        }
        byte[] buffer = new byte[SIZEOF_BOOL];
        AbstractPointer.getAddressSpace().getBytesAt(this.address + offset, buffer);
        for (int i = 0; i < SIZEOF_BOOL; ++i) {
            if (0 == buffer[i]) continue;
            return true;
        }
        return false;
    }

    protected UDATA getUDATAAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.env_data64) {
            return new UDATA(AbstractPointer.getAddressSpace().getLongAt(this.address + offset));
        }
        return new UDATA(AbstractPointer.getAddressSpace().getIntAt(this.address + offset));
    }

    protected IDATA getIDATAAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.env_data64) {
            return new IDATA(AbstractPointer.getAddressSpace().getLongAt(this.address + offset));
        }
        return new IDATA(AbstractPointer.getAddressSpace().getIntAt(this.address + offset));
    }

    protected short getShortAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getShortAt(this.address + offset);
    }

    protected byte getByteAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getByteAt(this.address + offset);
    }

    public int getBytesAtOffset(long offset, byte[] data) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getBytesAt(this.address + offset, data);
    }

    protected char getBaseCharAtOffset(long offset) throws CorruptDataException {
        return (char)(this.getShortAtOffset(offset) & 0xFFFF);
    }

    protected long getLongAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return AbstractPointer.getAddressSpace().getLongAt(this.address + offset);
    }

    protected J9ObjectPointer getObjectReferenceAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.gc_compressedPointers) {
            return ObjectAccessBarrier.convertPointerFromToken(AbstractPointer.getAddressSpace().getIntAt(this.address + offset));
        }
        return J9ObjectPointer.cast(AbstractPointer.getAddressSpace().getPointerAt(this.address + offset));
    }

    protected J9ClassPointer getObjectClassAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.interp_compressedObjectHeader) {
            return J9ClassPointer.cast(0xFFFFFFFFL & (long)AbstractPointer.getAddressSpace().getIntAt(this.address + offset));
        }
        return J9ClassPointer.cast(AbstractPointer.getAddressSpace().getPointerAt(this.address + offset));
    }

    protected J9ObjectMonitorPointer getObjectMonitorAtOffset(long offset) throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        if (J9BuildFlags.interp_smallMonitorSlot) {
            return J9ObjectMonitorPointer.cast(0xFFFFFFFFL & (long)AbstractPointer.getAddressSpace().getIntAt(this.address + offset));
        }
        return J9ObjectMonitorPointer.cast(AbstractPointer.getAddressSpace().getPointerAt(this.address + offset));
    }

    public String formatFullInteractive() {
        return this.toString();
    }

    public String getTargetName() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Pointer")) {
            name = name.substring(0, name.length() - "Pointer".length());
        }
        return name;
    }

    @Override
    public String formatShortInteractive() {
        String name = this.getTargetName();
        name = name.toLowerCase();
        return "!" + name + " 0x" + Long.toHexString(this.getAddress());
    }
}

