/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.view.dtfj.java.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.image.J9DDRCorruptData;
import com.ibm.j9ddr.vm23.events.EventManager;
import com.ibm.j9ddr.vm23.j9.walkers.ConstantPoolIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm23.view.dtfj.java.DTFJJavaObject;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DTFJConstantPoolIterator
implements Iterator,
IEventListener {
    private final ConstantPoolIterator pool;
    private J9DDRCorruptData cdata = null;
    private boolean EOI = false;

    public DTFJConstantPoolIterator(J9ClassPointer ptr) {
        try {
            EventManager.register(this);
            this.pool = new ConstantPoolIterator(ptr);
            this.EOI = !this.pool.hasNext();
        }
        finally {
            EventManager.unregister(this);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.EOI || this.cdata != null;
    }

    public Object next() {
        if (this.hasNext()) {
            Object retval = null;
            if (!this.EOI) {
                try {
                    EventManager.register(this);
                    retval = new DTFJJavaObject(this.pool.next());
                    this.EOI = !this.pool.hasNext();
                }
                finally {
                    EventManager.unregister(this);
                }
                return retval;
            }
            if (this.cdata != null) {
                retval = this.cdata;
                this.cdata = null;
            }
            return retval;
        }
        throw new NoSuchElementException("There are no more elements in this iterator");
    }

    @Override
    public void remove() {
        this.pool.remove();
    }

    @Override
    public void corruptData(String message2, CorruptDataException e, boolean fatal) {
        this.EOI = true;
        this.cdata = J9DDRDTFJUtils.newCorruptData(DTFJContext.getProcess(), e);
    }
}

